/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.evcache.EVCacheKey;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.pool.ChunkTranscoder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheValue;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheClientUtil {
    private static final Logger log = LoggerFactory.getLogger(EVCacheClientUtil.class);
    private final ChunkTranscoder ct = new ChunkTranscoder();
    private final String _appName;
    private final long _operationTimeout;
    private static final int MAX_KEY_BYTES = 250;
    private static final IllegalArgumentException KEY_TOO_LONG_EXCEPTION = new IllegalArgumentException("Key is too long (maxlen = 250)");
    private static final IllegalArgumentException KEY_EMPTY_EXCEPTION = new IllegalArgumentException("Key must contain at least one character.");

    public EVCacheClientUtil(String appName, long operationTimeout) {
        this._appName = appName;
        this._operationTimeout = operationTimeout;
    }

    public EVCacheLatch add(EVCacheKey evcKey, CachedData cd, Transcoder evcacheValueTranscoder, int timeToLive, EVCacheLatch.Policy policy, EVCacheClient[] clients, int latchCount, boolean fixMissing, boolean bypassAddOpt, boolean fixupAsFail) throws Exception {
        if (cd == null) {
            return null;
        }
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy, latchCount, this._appName);
        CachedData cdHashed = null;
        Boolean firstStatus = null;
        for (EVCacheClient client : clients) {
            CachedData cd1;
            if (evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxDigestBytes(), client.getMaxHashLength(), client.getBaseEncoder()) != null) {
                if (cdHashed == null) {
                    EVCacheValue val = new EVCacheValue(evcKey.getCanonicalKey(client.isDuetClient()), cd.getData(), cd.getFlags(), timeToLive, System.currentTimeMillis());
                    cdHashed = evcacheValueTranscoder.encode((Object)val);
                }
                cd1 = cdHashed;
            } else {
                cd1 = cd;
            }
            String key = evcKey.getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxDigestBytes(), client.getMaxHashLength(), client.getBaseEncoder());
            Future<Boolean> f = client.add(key, timeToLive, cd1, latch);
            if (log.isDebugEnabled()) {
                log.debug("ADD : Op Submitted : APP " + this._appName + ", key " + key + "; future : " + f + "; client : " + client);
            }
            if (!fixMissing) continue;
            boolean status = f.get();
            if (!status) {
                if (firstStatus == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Add failed at first client. key: " + key + ", client : " + client);
                    }
                    if (!bypassAddOpt) {
                        if (log.isDebugEnabled()) {
                            log.debug("Short circuiting due to optimization!!");
                        }
                        for (int i = 0; i < clients.length; ++i) {
                            latch.countDown();
                        }
                        return latch;
                    }
                    return this.fixup(client, clients, evcKey, timeToLive, policy, latch, fixupAsFail);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Add failed after first client. key: " + key + ", client : " + client);
                }
                return this.fixup(client, clients, evcKey, timeToLive, policy, latch, fixupAsFail);
            }
            if (firstStatus != null) continue;
            firstStatus = status;
        }
        return latch;
    }

    private EVCacheLatch fixup(EVCacheClient sourceClient, EVCacheClient[] destClients, EVCacheKey evcKey, int timeToLive, EVCacheLatch.Policy policy, EVCacheLatchImpl prevLatch, boolean fixupAsFail) {
        if (log.isDebugEnabled()) {
            log.debug("Trying to fix up!! destClient count = " + destClients.length);
        }
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy, destClients.length, this._appName);
        try {
            CachedData readData = sourceClient.get(evcKey.getDerivedKey(sourceClient.isDuetClient(), sourceClient.getHashingAlgorithm(), sourceClient.shouldEncodeHashKey(), sourceClient.getMaxDigestBytes(), sourceClient.getMaxHashLength(), sourceClient.getBaseEncoder()), this.ct, false, false);
            if (readData != null) {
                sourceClient.touch(evcKey.getDerivedKey(sourceClient.isDuetClient(), sourceClient.getHashingAlgorithm(), sourceClient.shouldEncodeHashKey(), sourceClient.getMaxDigestBytes(), sourceClient.getMaxHashLength(), sourceClient.getBaseEncoder()), timeToLive);
                for (EVCacheClient destClient : destClients) {
                    destClient.set(evcKey.getDerivedKey(destClient.isDuetClient(), destClient.getHashingAlgorithm(), destClient.shouldEncodeHashKey(), destClient.getMaxDigestBytes(), destClient.getMaxHashLength(), destClient.getBaseEncoder()), readData, timeToLive, (EVCacheLatch)latch);
                }
            }
            latch.await(this._operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("Error fixing up the data.", (Throwable)e);
        }
        if (fixupAsFail) {
            for (int i = 0; i < destClients.length; ++i) {
                prevLatch.countDown();
            }
            if (log.isDebugEnabled()) {
                log.debug("Fixup treated as fail. latchSuccess = " + prevLatch.getSuccessCount() + ", latchExpected = " + prevLatch.getExpectedSuccessCount());
            }
            return prevLatch;
        }
        return latch;
    }

    public static void validateKey(String key, boolean binary) {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        int keyLength = keyBytes.length;
        if (keyLength > 250) {
            throw KEY_TOO_LONG_EXCEPTION;
        }
        if (keyLength == 0) {
            throw KEY_EMPTY_EXCEPTION;
        }
        if (!binary) {
            for (byte b : keyBytes) {
                if (b != 32 && b != 10 && b != 13 && b != 0) continue;
                throw new IllegalArgumentException("Key contains invalid characters:  ``" + key + "''");
            }
        }
    }
}

