/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class CircularIterator<T> {
    private Entry<T> entry;
    private int size = 0;

    public CircularIterator(Collection<T> allReplicaSets) {
        if (allReplicaSets == null || allReplicaSets.isEmpty()) {
            return;
        }
        Entry<T> pEntry = null;
        Iterator<T> itr = allReplicaSets.iterator();
        while (itr.hasNext()) {
            ++this.size;
            T rSet = itr.next();
            Entry<T> newEntry = new Entry<T>(rSet, pEntry);
            if (this.entry == null) {
                this.entry = newEntry;
            }
            pEntry = newEntry;
        }
        if (pEntry != null) {
            ((Entry)this.entry).next = (Entry)pEntry;
        }
    }

    public T next() {
        if (this.entry == null) {
            return null;
        }
        this.entry = ((Entry)this.entry).next;
        return (T)((Entry)this.entry).element;
    }

    public T next(T ignoreReplicaSet) {
        if (this.entry == null) {
            return null;
        }
        this.entry = ((Entry)this.entry).next;
        if (((Entry)this.entry).element.equals(ignoreReplicaSet)) {
            return (T)((Entry)this.entry).next.element;
        }
        return (T)((Entry)this.entry).element;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        StringBuilder current = new StringBuilder();
        if (this.entry != null) {
            int i;
            Entry<T> startEntry = this.entry;
            if (((Entry)startEntry).element.getClass().isArray()) {
                for (i = 0; i < Array.getLength(((Entry)startEntry).element); ++i) {
                    if (i > 0) {
                        current.append(",");
                    }
                    current.append("[").append(i).append(", ").append(Array.get(((Entry)startEntry).element, i).toString()).append("]");
                }
            } else {
                current.append(((Entry)startEntry).element);
            }
            while (!((Entry)this.entry).next.equals(startEntry)) {
                if (((Entry)this.entry).next.element.getClass().isArray()) {
                    for (i = 0; i < Array.getLength(((Entry)this.entry).next.element); ++i) {
                        if (i > 0) {
                            current.append(",");
                        }
                        current.append("[").append(i).append(", ").append(Array.get(((Entry)this.entry).next.element, i).toString()).append("]");
                    }
                } else {
                    current.append(",[").append(((Entry)this.entry).next.element).append("]");
                }
                this.entry = ((Entry)this.entry).next;
            }
        }
        return "Server Group Iterator : { size=" + this.getSize() + "; Server Group=" + current.toString() + "}";
    }

    static class Entry<E> {
        private E element;
        private Entry<E> next;

        Entry(E element, Entry<E> next) {
            this.element = element;
            this.next = next;
        }
    }
}

