/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.evcache.EVCacheKey;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.pool.ChunkTranscoder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheValue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheClientUtil {
    private static final Logger log = LoggerFactory.getLogger(EVCacheClientUtil.class);
    private final ChunkTranscoder ct = new ChunkTranscoder();
    private final String _appName;
    private final long _operationTimeout;

    public EVCacheClientUtil(String appName, long operationTimeout) {
        this._appName = appName;
        this._operationTimeout = operationTimeout;
    }

    public EVCacheLatch add(EVCacheKey evcKey, CachedData cd, Transcoder evcacheValueTranscoder, int timeToLive, EVCacheLatch.Policy policy, EVCacheClient[] clients, int latchCount) throws Exception {
        if (cd == null) {
            return null;
        }
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy, latchCount, this._appName);
        Boolean firstStatus = null;
        for (EVCacheClient client : clients) {
            boolean status;
            CachedData cd1 = null;
            if (evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()) != null) {
                EVCacheValue val = new EVCacheValue(evcKey.getCanonicalKey(client.isDuetClient()), cd.getData(), cd.getFlags(), timeToLive, System.currentTimeMillis());
                cd1 = evcacheValueTranscoder.encode((Object)val);
            } else {
                cd1 = cd;
            }
            String key = evcKey.getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes());
            Future<Boolean> f = client.add(key, timeToLive, cd1, latch);
            if (log.isDebugEnabled()) {
                log.debug("ADD : Op Submitted : APP " + this._appName + ", key " + key + "; future : " + f + "; client : " + client);
            }
            if (!(status = f.get().booleanValue())) {
                if (firstStatus == null) {
                    for (int i = 0; i < clients.length; ++i) {
                        latch.countDown();
                    }
                    return latch;
                }
                return this.fixup(client, clients, evcKey, timeToLive, policy);
            }
            if (firstStatus != null) continue;
            firstStatus = status;
        }
        return latch;
    }

    private EVCacheLatch fixup(EVCacheClient sourceClient, EVCacheClient[] destClients, EVCacheKey evcKey, int timeToLive, EVCacheLatch.Policy policy) {
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy, destClients.length, this._appName);
        try {
            CachedData readData = sourceClient.get(evcKey.getDerivedKey(sourceClient.isDuetClient(), sourceClient.getHashingAlgorithm(), sourceClient.shouldEncodeHashKey(), sourceClient.getMaxHashingBytes()), this.ct, false, false);
            if (readData != null) {
                sourceClient.touch(evcKey.getDerivedKey(sourceClient.isDuetClient(), sourceClient.getHashingAlgorithm(), sourceClient.shouldEncodeHashKey(), sourceClient.getMaxHashingBytes()), timeToLive);
                for (EVCacheClient destClient : destClients) {
                    destClient.set(evcKey.getDerivedKey(destClient.isDuetClient(), destClient.getHashingAlgorithm(), destClient.shouldEncodeHashKey(), destClient.getMaxHashingBytes()), readData, timeToLive, (EVCacheLatch)latch);
                }
            }
            latch.await(this._operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("Error reading the data", (Throwable)e);
        }
        return latch;
    }
}

