/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.archaius.api.PropertyRepository;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheImpl;
import com.netflix.evcache.EVCacheInternal;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.operation.EVCacheItem;
import com.netflix.evcache.operation.EVCacheItemMetaData;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.ServerGroup;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;

public class EVCacheInternalImpl
extends EVCacheImpl
implements EVCacheInternal {
    @Override
    public EVCacheItem<CachedData> metaGet(String key, Transcoder<CachedData> tc, boolean isOriginalKeyHashed) throws EVCacheException {
        return this.metaGetInternal(key, tc, isOriginalKeyHashed);
    }

    @Override
    public EVCacheItemMetaData metaDebug(String key, boolean isOriginalKeyHashed) throws EVCacheException {
        return this.metaDebugInternal(key, isOriginalKeyHashed);
    }

    @Override
    public Future<Boolean>[] delete(String key, boolean isOriginalKeyHashed) throws EVCacheException {
        return this.deleteInternal(key, isOriginalKeyHashed);
    }

    public EVCacheInternalImpl(String appName, String cacheName, int timeToLive, Transcoder<?> transcoder, boolean enableZoneFallback, boolean throwException, EVCacheClientPoolManager poolManager) {
        super(appName, cacheName, timeToLive, transcoder, enableZoneFallback, throwException, poolManager);
    }

    @Override
    public EVCacheLatch addOrSetToWriteOnly(boolean replaceItem, String key, CachedData value, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        EVCacheClient[] clients = this._pool.getWriteOnlyEVCacheClients();
        if (replaceItem) {
            return this.set(key, value, null, timeToLive, policy, clients, clients.length);
        }
        return this.add(key, value, null, timeToLive, policy, clients, clients.length);
    }

    @Override
    public EVCacheLatch addOrSet(boolean replaceItem, String key, CachedData value, int timeToLive, EVCacheLatch.Policy policy, List<String> serverGroups) throws EVCacheException {
        return this.addOrSet(replaceItem, key, value, timeToLive, policy, serverGroups, null);
    }

    @Override
    public EVCacheLatch addOrSet(boolean replaceItem, String key, CachedData value, int timeToLive, EVCacheLatch.Policy policy, String serverGroupName) throws EVCacheException {
        return this.addOrSet(replaceItem, key, value, timeToLive, policy, serverGroupName, null);
    }

    @Override
    public EVCacheLatch addOrSet(boolean replaceItem, String key, CachedData value, int timeToLive, EVCacheLatch.Policy policy, String serverGroupName, String destinationIp) throws EVCacheException {
        ArrayList<String> serverGroups = new ArrayList<String>();
        serverGroups.add(serverGroupName);
        return this.addOrSet(replaceItem, key, value, timeToLive, policy, serverGroups, destinationIp);
    }

    private EVCacheLatch addOrSet(boolean replaceItem, String key, CachedData value, int timeToLive, EVCacheLatch.Policy policy, List<String> serverGroups, String destinationIp) throws EVCacheException {
        Map<ServerGroup, List<EVCacheClient>> clientsByServerGroup = this._pool.getAllInstancesByZone();
        List<EVCacheClient> evCacheClients = clientsByServerGroup.entrySet().stream().filter(entry -> serverGroups.contains(((ServerGroup)entry.getKey()).getName())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        if (null != destinationIp && !destinationIp.isEmpty()) {
            evCacheClients = evCacheClients.stream().filter(client -> ((InetSocketAddress)client.getNodeLocator().getPrimary(this.getEVCacheKey(key).getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes())).getSocketAddress()).getAddress().getHostAddress().equals(destinationIp)).collect(Collectors.toList());
        }
        EVCacheClient[] evCacheClientsArray = new EVCacheClient[evCacheClients.size()];
        evCacheClients.toArray(evCacheClientsArray);
        if (replaceItem) {
            return this.set(key, value, null, timeToLive, policy, evCacheClientsArray, evCacheClientsArray.length);
        }
        return this.add(key, value, null, timeToLive, policy, evCacheClientsArray, evCacheClientsArray.length);
    }

    @Override
    public EVCacheInternal.KeyHashedState isKeyHashed(String appName, String serverGroup) {
        PropertyRepository propertyRepository = this._poolManager.getEVCacheConfig().getPropertyRepository();
        boolean isKeyHashedAtAppOrAsg = (Boolean)propertyRepository.get(serverGroup + ".hash.key", Boolean.class).orElseGet(appName + ".hash.key").orElse((Object)false).get();
        if (isKeyHashedAtAppOrAsg) {
            return EVCacheInternal.KeyHashedState.YES;
        }
        if (((Boolean)propertyRepository.get(appName + ".auto.hash.keys", Boolean.class).orElseGet("evcache.auto.hash.keys").orElse((Object)false).get()).booleanValue()) {
            return EVCacheInternal.KeyHashedState.MAYBE;
        }
        return EVCacheInternal.KeyHashedState.NO;
    }
}

