/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import java.io.Serializable;
import java.util.Arrays;

public class EVCacheValue
implements Serializable {
    private static final long serialVersionUID = 3182483105524224448L;
    private final String key;
    private final byte[] value;
    private final int flags;
    private final long ttl;
    private final long createTime;

    public EVCacheValue(String key, byte[] value, int flags, long ttl, long createTime) {
        this.key = key;
        this.value = value;
        this.flags = flags;
        this.ttl = ttl;
        this.createTime = createTime;
    }

    public String getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getTTL() {
        return this.ttl;
    }

    public long getCreateTimeUTC() {
        return this.createTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.createTime ^ this.createTime >>> 32);
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (int)(this.ttl ^ this.ttl >>> 32);
        result = 31 * result + this.flags;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EVCacheValue other = (EVCacheValue)obj;
        if (this.createTime != other.createTime) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.ttl != other.ttl) {
            return false;
        }
        return Arrays.equals(this.value, other.value);
    }

    public String toString() {
        return "EVCacheValue [key=" + this.key + ", value=" + Arrays.toString(this.value) + ", flags=" + this.flags + ", ttl=" + this.ttl + ", createTime=" + this.createTime + "]";
    }
}

