/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.archaius.api.PropertyRepository;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheImpl;
import com.netflix.evcache.EVCacheInternal;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.ServerGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.spy.memcached.transcoders.Transcoder;

public class EVCacheInternalImpl
extends EVCacheImpl
implements EVCacheInternal {
    public EVCacheInternalImpl(String appName, String cacheName, int timeToLive, Transcoder<?> transcoder, boolean enableZoneFallback, boolean throwException, EVCacheClientPoolManager poolManager) {
        super(appName, cacheName, timeToLive, transcoder, enableZoneFallback, throwException, poolManager);
    }

    @Override
    public <T> EVCacheLatch addOrSetToWriteOnly(boolean replaceItem, String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        EVCacheClient[] clients = this._pool.getWriteOnlyEVCacheClients();
        if (replaceItem) {
            return this.set(key, value, tc, timeToLive, policy, clients, clients.length);
        }
        return this.add(key, value, tc, timeToLive, policy, clients, clients.length);
    }

    @Override
    public <T> EVCacheLatch addOrSet(boolean replaceItem, String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy, List<String> serverGroups) throws EVCacheException {
        Map<ServerGroup, List<EVCacheClient>> clientsByServerGroup = this._pool.getAllInstancesByServerGroup();
        List<EVCacheClient> evCacheClients = clientsByServerGroup.entrySet().stream().filter(entry -> serverGroups.contains(((ServerGroup)entry.getKey()).getName())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        EVCacheClient[] evCacheClientsArray = new EVCacheClient[evCacheClients.size()];
        evCacheClients.toArray(evCacheClientsArray);
        if (replaceItem) {
            return this.set(key, value, tc, timeToLive, policy, evCacheClientsArray, evCacheClientsArray.length);
        }
        return this.add(key, value, tc, timeToLive, policy, evCacheClientsArray, evCacheClientsArray.length);
    }

    @Override
    public <T> EVCacheLatch addOrSet(boolean replaceItem, String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy, String serverGroup) throws EVCacheException {
        ArrayList<String> serverGroups = new ArrayList<String>();
        serverGroups.add(serverGroup);
        return this.addOrSet(replaceItem, key, value, tc, timeToLive, policy, serverGroups);
    }

    @Override
    public <T> EVCacheLatch addOrSet(boolean replaceItem, String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy, String serverGroupName, String destinationIp) throws EVCacheException {
        Map<ServerGroup, List<EVCacheClient>> clientsByServerGroup = this._pool.getAllInstancesByServerGroup();
        List<EVCacheClient> evCacheClients = clientsByServerGroup.entrySet().stream().filter(entry -> serverGroupName.equalsIgnoreCase(((ServerGroup)entry.getKey()).getName())).map(Map.Entry::getValue).flatMap(Collection::stream).filter(client -> client.getMemcachedNodesInZone().stream().anyMatch(inetSocketAddress -> inetSocketAddress.getAddress().getHostAddress().equals(destinationIp))).collect(Collectors.toList());
        EVCacheClient[] evCacheClientsArray = new EVCacheClient[evCacheClients.size()];
        evCacheClients.toArray(evCacheClientsArray);
        if (replaceItem) {
            return this.set(key, value, tc, timeToLive, policy, evCacheClientsArray, evCacheClientsArray.length);
        }
        return this.add(key, value, tc, timeToLive, policy, evCacheClientsArray, evCacheClientsArray.length);
    }

    @Override
    public boolean isKeyHashed(String appName, String serverGroup) {
        PropertyRepository propertyRepository = this._poolManager.getEVCacheConfig().getPropertyRepository();
        return (Boolean)propertyRepository.get(serverGroup + ".hash.key", Boolean.class).orElseGet(appName + ".hash.key").orElse((Object)false).get();
    }
}

