/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.evcache.EVCache;
import com.netflix.evcache.EVCacheClientPoolConfigurationProperties;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheInternalImpl;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EVCacheInternal
extends EVCache {
    public <T> EVCacheLatch addOrSetToWriteOnly(boolean var1, String var2, T var3, Transcoder<T> var4, int var5, EVCacheLatch.Policy var6) throws EVCacheException;

    public <T> EVCacheLatch addOrSet(boolean var1, String var2, T var3, Transcoder<T> var4, int var5, EVCacheLatch.Policy var6, List<String> var7) throws EVCacheException;

    public <T> EVCacheLatch addOrSet(boolean var1, String var2, T var3, Transcoder<T> var4, int var5, EVCacheLatch.Policy var6, String var7) throws EVCacheException;

    public <T> EVCacheLatch addOrSet(boolean var1, String var2, T var3, Transcoder<T> var4, int var5, EVCacheLatch.Policy var6, String var7, String var8) throws EVCacheException;

    public boolean isKeyHashed(String var1, String var2);

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(EVCacheInternalImpl.class);
        private String _appName;
        private String _cachePrefix = null;
        private int _ttl = 900;
        private Transcoder<?> _transcoder = null;
        private boolean _serverGroupRetry = true;
        private boolean _enableExceptionThrowing = false;
        private List<Customizer> _customizers = new ArrayList<Customizer>();
        @Inject
        private EVCacheClientPoolManager _poolManager;

        public static Builder forApp(String appName) {
            return new Builder().setAppName(appName);
        }

        public Builder withConfigurationProperties(EVCacheClientPoolConfigurationProperties configurationProperties) {
            return this.setCachePrefix(configurationProperties.getKeyPrefix()).setDefaultTTL(configurationProperties.getTimeToLive()).setRetry(configurationProperties.getRetryEnabled()).setExceptionThrowing(configurationProperties.getExceptionThrowingEnabled());
        }

        public Builder setAppName(String appName) {
            if (appName == null) {
                throw new IllegalArgumentException("param appName cannot be null.");
            }
            this._appName = appName.toUpperCase(Locale.US);
            if (!this._appName.startsWith("EVCACHE")) {
                logger.warn("Make sure the app you are connecting to is EVCache App");
            }
            return this;
        }

        public Builder setCachePrefix(String cachePrefix) {
            if (this._cachePrefix != null && this._cachePrefix.indexOf(58) != -1) {
                throw new IllegalArgumentException("param cacheName cannot contain ':' character.");
            }
            this._cachePrefix = cachePrefix;
            return this;
        }

        public Builder setCacheName(String cacheName) {
            return this.setCachePrefix(cacheName);
        }

        public Builder setDefaultTTL(int ttl) {
            if (ttl < 0) {
                throw new IllegalArgumentException("Time to Live cannot be less than 0.");
            }
            this._ttl = ttl;
            return this;
        }

        public Builder setDefaultTTL(@Nullable Duration ttl) {
            if (ttl == null) {
                return this;
            }
            return this.setDefaultTTL((int)ttl.getSeconds());
        }

        @VisibleForTesting
        Transcoder<?> getTranscoder() {
            return this._transcoder;
        }

        public <T> Builder setTranscoder(Transcoder<T> transcoder) {
            this._transcoder = transcoder;
            return this;
        }

        public <T> Builder enableZoneFallback() {
            this._serverGroupRetry = true;
            return this;
        }

        public Builder setRetry(boolean enableRetry) {
            this._serverGroupRetry = enableRetry;
            return this;
        }

        public <T> Builder enableRetry() {
            this._serverGroupRetry = true;
            return this;
        }

        public <T> Builder disableRetry() {
            this._serverGroupRetry = false;
            return this;
        }

        public <T> Builder disableZoneFallback() {
            this._serverGroupRetry = false;
            return this;
        }

        public Builder setExceptionThrowing(boolean enableExceptionThrowing) {
            this._enableExceptionThrowing = enableExceptionThrowing;
            return this;
        }

        public <T> Builder enableExceptionPropagation() {
            this._enableExceptionThrowing = true;
            return this;
        }

        public Builder addCustomizers(@Nullable List<Customizer> customizers) {
            this._customizers.addAll(customizers);
            return this;
        }

        public Builder customize() {
            this._customizers.forEach(customizer -> this.customizeWith((Customizer)customizer));
            return this;
        }

        public Builder customizeWith(Customizer customizer) {
            customizer.customize(this._appName, this);
            return this;
        }

        public EVCacheInternal build() {
            if (this._poolManager == null) {
                this._poolManager = EVCacheClientPoolManager.getInstance();
                if (logger.isDebugEnabled()) {
                    logger.debug("_poolManager - " + this._poolManager + " through getInstance");
                }
            }
            if (this._appName == null) {
                throw new IllegalArgumentException("param appName cannot be null.");
            }
            if (this._cachePrefix != null) {
                for (int i = 0; i < this._cachePrefix.length(); ++i) {
                    if (!Character.isWhitespace(this._cachePrefix.charAt(i))) continue;
                    throw new IllegalArgumentException("Cache Prefix ``" + this._cachePrefix + "`` contains invalid character at position " + i);
                }
            }
            this.customize();
            return new EVCacheInternalImpl(this._appName, this._cachePrefix, this._ttl, this._transcoder, this._serverGroupRetry, this._enableExceptionThrowing, this._poolManager);
        }

        public static class Factory {
            public Builder createInstance(String appName) {
                return Builder.forApp(appName);
            }
        }

        @FunctionalInterface
        public static interface Customizer {
            public void customize(String var1, Builder var2);
        }
    }
}

