/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.evcache.EVCache;
import com.netflix.evcache.EVCacheConnectException;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheImplMBean;
import com.netflix.evcache.EVCacheInMemoryCache;
import com.netflix.evcache.EVCacheKey;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.EVCacheReadQueueException;
import com.netflix.evcache.EVCacheTranscoder;
import com.netflix.evcache.event.EVCacheEvent;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheFuture;
import com.netflix.evcache.operation.EVCacheItem;
import com.netflix.evcache.operation.EVCacheItemMetaData;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.EVCacheClientUtil;
import com.netflix.evcache.pool.EVCacheValue;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.KeyHasher;
import com.netflix.evcache.util.Sneaky;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.CachedData;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.Single;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "WMI_WRONG_MAP_ITERATOR", "DB_DUPLICATE_BRANCHES", "REC_CATCH_EXCEPTION", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
public final class EVCacheImpl
implements EVCache,
EVCacheImplMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheImpl.class);
    private final String _appName;
    private final String _cacheName;
    private final String _metricPrefix;
    private final Transcoder<?> _transcoder;
    private final boolean _zoneFallback;
    private final boolean _throwException;
    private final int _timeToLive;
    private EVCacheClientPool _pool;
    private final Property<Boolean> _throwExceptionFP;
    private final Property<Boolean> _zoneFallbackFP;
    private final Property<Boolean> _useInMemoryCache;
    private final Property<Boolean> _bulkZoneFallbackFP;
    private final Property<Boolean> _bulkPartialZoneFallbackFP;
    private final List<Tag> tags;
    private EVCacheInMemoryCache<?> cache;
    private EVCacheClientUtil clientUtil = null;
    private final Property<Boolean> ignoreTouch;
    private final Property<Boolean> hashKey;
    private final Property<String> hashingAlgo;
    private final Property<Boolean> shouldEncodeHashKey;
    private final Property<Integer> maxHashingBytes;
    private final EVCacheTranscoder evcacheValueTranscoder;
    private final Property<Integer> maxReadDuration;
    private final Property<Integer> maxWriteDuration;
    private final EVCacheClientPoolManager _poolManager;
    private final Map<String, Timer> timerMap = new ConcurrentHashMap<String, Timer>();
    private final Map<String, DistributionSummary> distributionSummaryMap = new ConcurrentHashMap<String, DistributionSummary>();
    private final Map<String, Counter> counterMap = new ConcurrentHashMap<String, Counter>();
    private final Property<Boolean> _eventsUsingLatchFP;
    private final Property<Boolean> autoHashKeys;
    private DistributionSummary bulkKeysSize = null;
    private final Property<Integer> maxKeyLength;
    private final Property<String> alias;
    private final int MAX_IN_SEC = 2592000;

    EVCacheImpl(String appName, String cacheName, int timeToLive, Transcoder<?> transcoder, boolean enableZoneFallback, boolean throwException, EVCacheClientPoolManager poolManager) {
        this._appName = appName;
        this._cacheName = cacheName;
        if (this._cacheName != null && this._cacheName.length() > 0) {
            for (int i2 = 0; i2 < cacheName.length(); ++i2) {
                if (!Character.isWhitespace(cacheName.charAt(i2))) continue;
                throw new IllegalArgumentException("Cache Prefix ``" + cacheName + "`` contains invalid character at position " + i2);
            }
        }
        this._timeToLive = timeToLive;
        this._transcoder = transcoder;
        this._zoneFallback = enableZoneFallback;
        this._throwException = throwException;
        this.tags = new ArrayList<Tag>(3);
        EVCacheMetricsFactory.getInstance().addAppNameTags(this.tags, this._appName);
        if (this._cacheName != null && this._cacheName.length() > 0) {
            this.tags.add((Tag)new BasicTag("evc.prefix", this._cacheName));
        }
        String _metricName = this._cacheName == null ? this._appName : this._appName + "." + this._cacheName;
        this._metricPrefix = this._appName + "-";
        this._poolManager = poolManager;
        this._pool = poolManager.getEVCacheClientPool(this._appName);
        PropertyRepository propertyRepository = poolManager.getEVCacheConfig().getPropertyRepository();
        this._throwExceptionFP = propertyRepository.get(_metricName + ".throw.exception", Boolean.class).orElseGet(this._appName + ".throw.exception").orElse((Object)false);
        this._zoneFallbackFP = propertyRepository.get(_metricName + ".fallback.zone", Boolean.class).orElseGet(this._appName + ".fallback.zone").orElse((Object)true);
        this._bulkZoneFallbackFP = propertyRepository.get(this._appName + ".bulk.fallback.zone", Boolean.class).orElse((Object)true);
        this._bulkPartialZoneFallbackFP = propertyRepository.get(this._appName + ".bulk.partial.fallback.zone", Boolean.class).orElse((Object)true);
        this._useInMemoryCache = this._cacheName == null ? propertyRepository.get(this._appName + ".use.inmemory.cache", Boolean.class).orElseGet("evcache.use.inmemory.cache").orElse((Object)false) : propertyRepository.get(this._appName + "." + this._cacheName + ".use.inmemory.cache", Boolean.class).orElseGet(this._appName + ".use.inmemory.cache").orElseGet("evcache.use.inmemory.cache").orElse((Object)false);
        this._eventsUsingLatchFP = propertyRepository.get(this._appName + ".events.using.latch", Boolean.class).orElseGet("evcache.events.using.latch").orElse((Object)false);
        this.maxReadDuration = propertyRepository.get(this._appName + ".max.read.duration.metric", Integer.class).orElseGet("evcache.max.write.duration.metric").orElse((Object)20);
        this.maxWriteDuration = propertyRepository.get(this._appName + ".max.write.duration.metric", Integer.class).orElseGet("evcache.max.write.duration.metric").orElse((Object)50);
        this.ignoreTouch = propertyRepository.get(appName + ".ignore.touch", Boolean.class).orElse((Object)false);
        this.hashKey = propertyRepository.get(appName + ".hash.key", Boolean.class).orElse((Object)false);
        this.hashingAlgo = propertyRepository.get(appName + ".hash.algo", String.class).orElse((Object)"siphash24");
        this.shouldEncodeHashKey = propertyRepository.get(appName + ".hash.encode", Boolean.class).orElse((Object)true);
        this.maxHashingBytes = propertyRepository.get(appName + ".hash.max.bytes", Integer.class).orElse((Object)-1);
        this.autoHashKeys = propertyRepository.get(this._appName + ".auto.hash.keys", Boolean.class).orElseGet("evcache.auto.hash.keys").orElse((Object)false);
        this.evcacheValueTranscoder = new EVCacheTranscoder();
        this.evcacheValueTranscoder.setCompressionThreshold(Integer.MAX_VALUE);
        this.maxKeyLength = propertyRepository.get(this._appName + ".max.key.length", Integer.class).orElseGet("evcache.max.key.length").orElse((Object)200);
        this.alias = propertyRepository.get("EVCacheClientPoolManager." + appName + ".alias", String.class);
        this.alias.subscribe(i -> {
            this._pool = poolManager.getEVCacheClientPool(this._appName);
        });
        this._pool.pingServers();
        this.setupMonitoring();
    }

    private void setupMonitoring() {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this._appName + ",SubGroup=Impl");
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                mbeanServer.registerMBean(this, mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception", (Throwable)e);
            }
        }
    }

    EVCacheKey getEVCacheKey(String key) {
        String canonicalKey;
        if (key == null || key.length() == 0) {
            throw new NullPointerException("Key cannot be null or empty");
        }
        for (int i = 0; i < key.length(); ++i) {
            if (!Character.isWhitespace(key.charAt(i))) continue;
            throw new IllegalArgumentException("key ``" + key + "`` contains invalid character at position " + i);
        }
        if (this._cacheName == null) {
            canonicalKey = key;
        } else {
            int keyLength = this._cacheName.length() + 1 + key.length();
            canonicalKey = new StringBuilder(keyLength).append(this._cacheName).append(':').append(key).toString();
        }
        if (canonicalKey.length() > (Integer)this.maxKeyLength.get() && !((Boolean)this.hashKey.get()).booleanValue() && !((Boolean)this.autoHashKeys.get()).booleanValue()) {
            throw new IllegalArgumentException("Key is too long (maxlen = " + this.maxKeyLength.get() + ')');
        }
        boolean shouldHashKeyAtAppLevel = (Boolean)this.hashKey.get() != false || canonicalKey.length() > (Integer)this.maxKeyLength.get() && (Boolean)this.autoHashKeys.get() != false;
        EVCacheKey evcKey = new EVCacheKey(this._appName, key, canonicalKey, shouldHashKeyAtAppLevel ? KeyHasher.getHashingAlgorithmFromString((String)this.hashingAlgo.get()) : null, this.shouldEncodeHashKey, this.maxHashingBytes);
        if (log.isDebugEnabled() && this.shouldLog()) {
            log.debug("Key : " + key + "; EVCacheKey : " + evcKey);
        }
        return evcKey;
    }

    private boolean hasZoneFallbackForBulk() {
        if (!this._pool.supportsFallback()) {
            return false;
        }
        if (!((Boolean)this._bulkZoneFallbackFP.get()).booleanValue()) {
            return false;
        }
        return this._zoneFallback;
    }

    private boolean hasZoneFallback() {
        if (!this._pool.supportsFallback()) {
            return false;
        }
        if (!((Boolean)this._zoneFallbackFP.get()).booleanValue()) {
            return false;
        }
        return this._zoneFallback;
    }

    private boolean shouldLog() {
        return this._poolManager.shouldLog(this._appName);
    }

    private boolean doThrowException() {
        return this._throwException || (Boolean)this._throwExceptionFP.get() != false;
    }

    private List<EVCacheEventListener> getEVCacheEventListeners() {
        return this._poolManager.getEVCacheEventListeners();
    }

    private EVCacheEvent createEVCacheEvent(Collection<EVCacheClient> clients, EVCache.Call call) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        if (evcacheEventListenerList == null || evcacheEventListenerList.size() == 0) {
            return null;
        }
        EVCacheEvent event = new EVCacheEvent(call, this._appName, this._cacheName, this._pool);
        event.setClients(clients);
        return event;
    }

    private boolean shouldThrottle(EVCacheEvent event) throws EVCacheException {
        for (EVCacheEventListener evcacheEventListener : this.getEVCacheEventListeners()) {
            try {
                if (!evcacheEventListener.onThrottle(event)) continue;
                return true;
            }
            catch (Exception e) {
                this.incrementEventFailure("throttle", event.getCall(), evcacheEventListener.getClass().getName());
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("Exception executing throttle event on listener " + evcacheEventListener + " for event " + event, (Throwable)e);
            }
        }
        return false;
    }

    private void startEvent(EVCacheEvent event) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
            try {
                evcacheEventListener.onStart(event);
            }
            catch (Exception e) {
                this.incrementEventFailure("start", event.getCall(), evcacheEventListener.getClass().getName());
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("Exception executing start event on listener " + evcacheEventListener + " for event " + event, (Throwable)e);
            }
        }
    }

    private void endEvent(EVCacheEvent event) {
        event.setEndTime(System.currentTimeMillis());
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
            try {
                evcacheEventListener.onComplete(event);
            }
            catch (Exception e) {
                this.incrementEventFailure("end", event.getCall(), evcacheEventListener.getClass().getName());
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("Exception executing end event on listener " + evcacheEventListener + " for event " + event, (Throwable)e);
            }
        }
    }

    private void eventError(EVCacheEvent event, Throwable t) {
        event.setEndTime(System.currentTimeMillis());
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
            try {
                evcacheEventListener.onError(event, t);
            }
            catch (Exception e) {
                this.incrementEventFailure("error", event.getCall(), evcacheEventListener.getClass().getName());
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("Exception executing error event on listener " + evcacheEventListener + " for event " + event, (Throwable)e);
            }
        }
    }

    private <T> EVCacheInMemoryCache<T> getInMemoryCache(Transcoder<T> tc) {
        if (this.cache == null) {
            this.cache = this._poolManager.createInMemoryCache(tc, this);
        }
        return this.cache;
    }

    @Override
    public <T> T get(String key) throws EVCacheException {
        return (T)this.get(key, this._transcoder);
    }

    private void incrementFastFail(String metric, EVCache.Call call) {
        String name = metric + call.name();
        Counter counter = this.counterMap.get(name);
        if (counter == null) {
            ArrayList<Tag> tagList = new ArrayList<Tag>(this.tags.size() + 3);
            tagList.addAll(this.tags);
            if (call != null) {
                String operationType;
                String operation = call.name();
                switch (call) {
                    case GET: 
                    case GET_AND_TOUCH: 
                    case GETL: 
                    case BULK: 
                    case ASYNC_GET: {
                        operationType = "read";
                        break;
                    }
                    default: {
                        operationType = "write";
                    }
                }
                if (operation != null) {
                    tagList.add((Tag)new BasicTag("evc.call", operation));
                }
                if (operationType != null) {
                    tagList.add((Tag)new BasicTag("evc.call.type", operationType));
                }
            }
            tagList.add((Tag)new BasicTag("evc.fail.reason", metric));
            counter = EVCacheMetricsFactory.getInstance().getCounter("internal.evc.client.fastfail", tagList);
            this.counterMap.put(name, counter);
        }
        counter.increment();
    }

    private void incrementEventFailure(String metric, EVCache.Call call, String event) {
        String name = metric + call.name() + event;
        Counter counter = this.counterMap.get(name);
        if (counter == null) {
            ArrayList<Tag> tagList = new ArrayList<Tag>(this.tags.size() + 3);
            tagList.addAll(this.tags);
            if (call != null) {
                String operationType;
                String operation = call.name();
                switch (call) {
                    case GET: 
                    case GET_AND_TOUCH: 
                    case GETL: 
                    case BULK: 
                    case ASYNC_GET: {
                        operationType = "read";
                        break;
                    }
                    default: {
                        operationType = "write";
                    }
                }
                if (operation != null) {
                    tagList.add((Tag)new BasicTag("evc.call", operation));
                }
                if (operationType != null) {
                    tagList.add((Tag)new BasicTag("evc.call.type", operationType));
                }
            }
            tagList.add((Tag)new BasicTag("evc.event.stage", metric));
            tagList.add((Tag)new BasicTag("evc.event", event));
            counter = EVCacheMetricsFactory.getInstance().getCounter("internal.evc.client.event.fail", tagList);
            this.counterMap.put(name, counter);
        }
        counter.increment();
    }

    private void incrementFailure(String metric, String operation, String operationType) {
        String name = metric + operation;
        Counter counter = this.counterMap.get(name);
        if (counter == null) {
            ArrayList<Tag> tagList = new ArrayList<Tag>(this.tags.size() + 3);
            tagList.addAll(this.tags);
            if (operation != null) {
                tagList.add((Tag)new BasicTag("evc.call", operation));
            }
            if (operationType != null) {
                tagList.add((Tag)new BasicTag("evc.call.type", operationType));
            }
            tagList.add((Tag)new BasicTag("evc.fail.reason", metric));
            counter = EVCacheMetricsFactory.getInstance().getCounter("internal.evc.client.fail", tagList);
            this.counterMap.put(name, counter);
        }
        counter.increment();
    }

    @Override
    public <T> T get(String key, Transcoder<T> tc) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        if (((Boolean)this._useInMemoryCache.get()).booleanValue()) {
            T value;
            block11: {
                value = null;
                try {
                    Transcoder<T> transcoder = tc == null ? (this._transcoder == null ? this._pool.getEVCacheClientForRead().getTranscoder() : this._transcoder) : tc;
                    value = this.getInMemoryCache(transcoder).get(evcKey);
                }
                catch (ExecutionException e) {
                    boolean throwExc = this.doThrowException();
                    if (!throwExc) break block11;
                    if (e.getCause() instanceof EVCacheInMemoryCache.DataNotFoundException) {
                        return null;
                    }
                    if (e.getCause() instanceof EVCacheException) {
                        if (log.isDebugEnabled() && this.shouldLog()) {
                            log.debug("ExecutionException while getting data from InMemory Cache", (Throwable)e);
                        }
                        throw (EVCacheException)e.getCause();
                    }
                    throw new EVCacheException("ExecutionException", e);
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Value retrieved from inmemory cache for APP " + this._appName + ", key : " + evcKey + (log.isTraceEnabled() ? "; value : " + value : ""));
            }
            if (value != null) {
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("Value retrieved from inmemory cache for APP " + this._appName + ", key : " + evcKey + (log.isTraceEnabled() ? "; value : " + value : ""));
                }
                return value;
            }
            if (log.isInfoEnabled() && this.shouldLog()) {
                log.info("Value not_found in inmemory cache for APP " + this._appName + ", key : " + evcKey + "; value : " + value);
            }
        }
        return this.doGet(evcKey, tc);
    }

    <T> T doGet(EVCacheKey evcKey, Transcoder<T> tc) throws EVCacheException {
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient", EVCache.Call.GET);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get the data APP " + this._appName);
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), EVCache.Call.GET);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.GET);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + evcKey);
                    }
                    return null;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.GET);
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        String cacheOperation = "yes";
        int tries = 1;
        try {
            List<EVCacheClient> fbClients;
            boolean hasZF = this.hasZoneFallback();
            boolean throwEx = hasZF ? false : throwExc;
            T data = this.getData(client, evcKey, tc, throwEx, hasZF);
            if (data == null && hasZF && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                for (int i = 0; i < fbClients.size(); ++i) {
                    EVCacheClient fbClient;
                    block39: {
                        fbClient = fbClients.get(i);
                        if (i >= fbClients.size() - 1) {
                            throwEx = throwExc;
                        }
                        if (event != null) {
                            T t;
                            try {
                                if (!this.shouldThrottle(event)) break block39;
                                status = "throttled";
                                if (throwExc) {
                                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + evcKey);
                                }
                                t = null;
                            }
                            catch (EVCacheException ex) {
                                if (throwExc) {
                                    throw ex;
                                }
                                status = "throttled";
                                T t2 = null;
                                return t2;
                            }
                            return t;
                        }
                    }
                    ++tries;
                    data = this.getData(fbClient, evcKey, tc, throwEx, i < fbClients.size() - 1);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("Retry for APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + fbClient.getServerGroup());
                    }
                    if (data == null) continue;
                    client = fbClient;
                    break;
                }
            }
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "GHIT");
                }
            } else {
                cacheOperation = "no";
                if (event != null) {
                    event.setAttribute("status", "GMISS");
                }
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET : APP " + this._appName + " ; cache miss for key : " + evcKey);
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
            }
            if (event != null) {
                this.endEvent(event);
            }
            T t = data;
            return t;
        }
        catch (CheckedOperationTimeoutException ex) {
            status = "timeout";
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("CheckedOperationTimeoutException getting data for APP " + this._appName + ", key = " + evcKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            status = "error";
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("Exception getting data for APP " + this._appName + ", key = " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.GET.name(), "read", cacheOperation, status, tries, ((Integer)this.maxReadDuration.get()).intValue(), client.getServerGroup()).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", Took " + duration + " milliSec.");
            }
        }
    }

    @Override
    public EVCacheItemMetaData metaDebug(String key) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient", EVCache.Call.META_DEBUG);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get the metadata for APP " + this._appName);
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), EVCache.Call.META_DEBUG);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.META_DEBUG);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + evcKey);
                    }
                    return null;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.META_DEBUG);
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        String cacheOperation = "yes";
        int tries = 1;
        try {
            List<EVCacheClient> fbClients;
            boolean hasZF = this.hasZoneFallback();
            boolean throwEx = hasZF ? false : throwExc;
            EVCacheItemMetaData data = this.getEVCacheItemMetaData(client, evcKey, throwEx, hasZF);
            if (data == null && hasZF && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                for (int i = 0; i < fbClients.size(); ++i) {
                    EVCacheClient fbClient = fbClients.get(i);
                    if (i >= fbClients.size() - 1) {
                        throwEx = throwExc;
                    }
                    if (event != null) {
                        try {
                            if (this.shouldThrottle(event)) {
                                status = "throttled";
                                if (throwExc) {
                                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + evcKey);
                                }
                                EVCacheItemMetaData eVCacheItemMetaData = null;
                                return eVCacheItemMetaData;
                            }
                        }
                        catch (EVCacheException ex) {
                            if (throwExc) {
                                throw ex;
                            }
                            status = "throttled";
                            EVCacheItemMetaData eVCacheItemMetaData = null;
                            return eVCacheItemMetaData;
                        }
                    }
                    ++tries;
                    data = this.getEVCacheItemMetaData(fbClient, evcKey, throwEx, i < fbClients.size() - 1);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("Retry for APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + fbClient.getServerGroup());
                    }
                    if (data == null) continue;
                    client = fbClient;
                    break;
                }
            }
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "MDHIT");
                }
            } else {
                cacheOperation = "no";
                if (event != null) {
                    event.setAttribute("status", "MDMISS");
                }
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("META_DEBUG : APP " + this._appName + " ; cache miss for key : " + evcKey);
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("META_DEBUG : APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
            }
            if (event != null) {
                this.endEvent(event);
            }
            EVCacheItemMetaData eVCacheItemMetaData = data;
            return eVCacheItemMetaData;
        }
        catch (CheckedOperationTimeoutException ex) {
            status = "timeout";
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheItemMetaData eVCacheItemMetaData = null;
                return eVCacheItemMetaData;
            }
            throw new EVCacheException("CheckedOperationTimeoutException getting with meta data for APP " + this._appName + ", key = " + evcKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            status = "error";
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheItemMetaData eVCacheItemMetaData = null;
                return eVCacheItemMetaData;
            }
            throw new EVCacheException("Exception getting with metadata for APP " + this._appName + ", key = " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.META_DEBUG.name(), "read", cacheOperation, status, tries, ((Integer)this.maxReadDuration.get()).intValue(), client.getServerGroup()).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("META_DEBUG : APP " + this._appName + ", Took " + duration + " milliSec.");
            }
        }
    }

    @Override
    public <T> EVCacheItem<T> metaGet(String key, Transcoder<T> tc) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient", EVCache.Call.META_GET);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get the data APP " + this._appName);
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), EVCache.Call.META_GET);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.META_GET);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + evcKey);
                    }
                    return null;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.META_GET);
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        String cacheOperation = "yes";
        int tries = 1;
        try {
            List<EVCacheClient> fbClients;
            boolean hasZF = this.hasZoneFallback();
            boolean throwEx = hasZF ? false : throwExc;
            EVCacheItem<T> data = this.getEVCacheItem(client, evcKey, tc, throwEx, hasZF);
            if (data == null && hasZF && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                for (int i = 0; i < fbClients.size(); ++i) {
                    EVCacheClient fbClient = fbClients.get(i);
                    if (i >= fbClients.size() - 1) {
                        throwEx = throwExc;
                    }
                    if (event != null) {
                        try {
                            if (this.shouldThrottle(event)) {
                                status = "throttled";
                                if (throwExc) {
                                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + evcKey);
                                }
                                EVCacheItem<T> eVCacheItem = null;
                                return eVCacheItem;
                            }
                        }
                        catch (EVCacheException ex) {
                            if (throwExc) {
                                throw ex;
                            }
                            status = "throttled";
                            EVCacheItem<T> eVCacheItem = null;
                            return eVCacheItem;
                        }
                    }
                    ++tries;
                    data = this.getEVCacheItem(fbClient, evcKey, tc, throwEx, i < fbClients.size() - 1);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("Retry for APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + fbClient.getServerGroup());
                    }
                    if (data == null) continue;
                    client = fbClient;
                    break;
                }
            }
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "MGHIT");
                }
            } else {
                cacheOperation = "no";
                if (event != null) {
                    event.setAttribute("status", "MGMISS");
                }
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("META_GET : APP " + this._appName + " ; cache miss for key : " + evcKey);
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("META_GET : APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
            }
            if (event != null) {
                this.endEvent(event);
            }
            EVCacheItem<T> eVCacheItem = data;
            return eVCacheItem;
        }
        catch (CheckedOperationTimeoutException ex) {
            status = "timeout";
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheItem<T> eVCacheItem = null;
                return eVCacheItem;
            }
            throw new EVCacheException("CheckedOperationTimeoutException getting with meta data for APP " + this._appName + ", key = " + evcKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            status = "error";
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheItem<T> eVCacheItem = null;
                return eVCacheItem;
            }
            throw new EVCacheException("Exception getting with meta data for APP " + this._appName + ", key = " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.META_GET.name(), "read", cacheOperation, status, tries, ((Integer)this.maxReadDuration.get()).intValue(), client.getServerGroup()).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("META_GET : APP " + this._appName + ", Took " + duration + " milliSec.");
            }
        }
    }

    private int policyToCount(EVCacheLatch.Policy policy, int count) {
        if (policy == null) {
            return 0;
        }
        switch (policy) {
            case NONE: {
                return 0;
            }
            case ONE: {
                return 1;
            }
            case QUORUM: {
                if (count == 0) {
                    return 0;
                }
                if (count <= 2) {
                    return count;
                }
                return count / 2 + 1;
            }
            case ALL_MINUS_1: {
                if (count == 0) {
                    return 0;
                }
                if (count <= 2) {
                    return 1;
                }
                return count - 1;
            }
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T get(String key, Transcoder<T> tc, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.GET);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to asynchronously get the data");
            }
            return null;
        }
        int expectedSuccessCount = this.policyToCount(policy, clients.length);
        if (expectedSuccessCount <= 1) {
            return this.get(key, tc);
        }
        long startTime = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        String cacheOperation = "yes";
        int tries = 1;
        try {
            void var17_19;
            ArrayList<Future<T>> futureList = new ArrayList<Future<T>>(clients.length);
            long endTime = startTime + (long)((Integer)this._pool.getReadTimeout().get()).intValue();
            EVCacheClient[] eVCacheClientArray = clients;
            int n = eVCacheClientArray.length;
            boolean bl = false;
            while (var17_19 < n) {
                EVCacheClient client = eVCacheClientArray[var17_19];
                Future<T> future = this.getGetFuture(client, key, tc, throwExc);
                futureList.add(future);
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("GET : CONSISTENT : APP " + this._appName + ", Future " + future + " for key : " + key + " with policy : " + (Object)((Object)policy) + " for client : " + client);
                }
                ++var17_19;
            }
            HashMap<Object, List> evcacheClientMap = new HashMap<Object, List>();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : CONSISTENT : Total Requests " + clients.length + "; Expected Success Count : " + expectedSuccessCount);
            }
            for (Future iterator : futureList) {
                try {
                    if (!(iterator instanceof EVCacheOperationFuture)) continue;
                    EVCacheOperationFuture evcacheOperationFuture = (EVCacheOperationFuture)((Object)iterator);
                    long duration = endTime - System.currentTimeMillis();
                    if (duration < 20L) {
                        duration = 20L;
                    }
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("GET : CONSISTENT : block duration : " + duration);
                    }
                    Object t = evcacheOperationFuture.get(duration, TimeUnit.MILLISECONDS, throwExc, false);
                    if (log.isTraceEnabled() && this.shouldLog()) {
                        log.trace("GET : CONSISTENT : value : " + t);
                    }
                    if (t == null) continue;
                    List cList = evcacheClientMap.computeIfAbsent(t, k -> new ArrayList(clients.length));
                    cList.add(evcacheOperationFuture.getEVCacheClient());
                    if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                    log.debug("GET : CONSISTENT : Added Client to ArrayList " + cList);
                }
                catch (Exception e) {
                    log.error("Exception", (Throwable)e);
                }
            }
            T retVal = null;
            for (Map.Entry entry : evcacheClientMap.entrySet()) {
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("GET : CONSISTENT : Existing Count for Value : " + ((List)entry.getValue()).size() + "; expectedSuccessCount : " + expectedSuccessCount);
                }
                if (((List)entry.getValue()).size() >= expectedSuccessCount) {
                    retVal = (T)entry.getKey();
                    continue;
                }
                for (EVCacheClient client : (List)entry.getValue()) {
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("GET : CONSISTENT : Delete in-consistent vale from : " + client);
                    }
                    client.delete(key);
                }
            }
            if (retVal != null) {
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("GET : CONSISTENT : policy : " + (Object)((Object)policy) + " was met. Will return the value. Total Duration : " + (System.currentTimeMillis() - startTime) + " milli Seconds.");
                }
                T t = retVal;
                return t;
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : CONSISTENT : policy : " + (Object)((Object)policy) + " was NOT met. Will return NULL. Total Duration : " + (System.currentTimeMillis() - startTime) + " milli Seconds.");
            }
            T t = null;
            return t;
        }
        catch (Exception ex) {
            status = "error";
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("Exception getting data for APP " + this._appName + ", key = " + key, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - startTime;
            this.getTimer(EVCache.Call.GET_ALL.name(), "read", cacheOperation, status, tries, ((Integer)this.maxReadDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : CONSISTENT : APP " + this._appName + ", Took " + duration + " milliSec.");
            }
        }
    }

    @Override
    public <T> Single<T> get(String key, Scheduler scheduler) {
        return this.get(key, this._transcoder, scheduler);
    }

    @Override
    public <T> Single<T> get(String key, Transcoder<T> tc, Scheduler scheduler) {
        if (null == key) {
            return Single.error((Throwable)new IllegalArgumentException("Key cannot be null"));
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient", EVCache.Call.GET);
            return Single.error((Throwable)new EVCacheException("Could not find a client to get the data APP " + this._appName));
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), EVCache.Call.GET);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.GET);
                    return Single.error((Throwable)new EVCacheException("Request Throttled for app " + this._appName + " & key " + key));
                }
            }
            catch (EVCacheException ex2) {
                throw Sneaky.sneakyThrow(ex2);
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        boolean hasZF = this.hasZoneFallback();
        boolean throwEx = hasZF ? false : throwExc;
        return this.getData(client, evcKey, tc, throwEx, hasZF, scheduler).flatMap(data -> {
            List<EVCacheClient> fbClients;
            if (data == null && hasZF && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                return Observable.concat((Observable)Observable.from(fbClients).map(fbClient -> this.getData(fbClients.indexOf(fbClient), fbClients.size(), (EVCacheClient)fbClient, evcKey, tc, throwEx, throwExc, false, scheduler).toObservable())).firstOrDefault(null, fbData -> fbData != null).toSingle();
            }
            return Single.just((Object)data);
        }).map(data -> {
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "GHIT");
                }
            } else {
                if (event != null) {
                    event.setAttribute("status", "GMISS");
                }
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET : APP " + this._appName + " ; cache miss for key : " + evcKey);
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
            }
            if (event != null) {
                this.endEvent(event);
            }
            return data;
        }).onErrorReturn(ex -> {
            if (ex instanceof CheckedOperationTimeoutException) {
                if (event != null) {
                    event.setStatus("timeout");
                    this.eventError(event, (Throwable)ex);
                }
                if (!throwExc) {
                    return null;
                }
                throw Sneaky.sneakyThrow(new EVCacheException("CheckedOperationTimeoutException getting data for APP " + this._appName + ", key = " + evcKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", (Throwable)ex));
            }
            if (event != null) {
                event.setStatus("error");
                this.eventError(event, (Throwable)ex);
            }
            if (!throwExc) {
                return null;
            }
            throw Sneaky.sneakyThrow(new EVCacheException("Exception getting data for APP " + this._appName + ", key = " + evcKey, (Throwable)ex));
        }).doAfterTerminate(() -> {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.GET_AND_TOUCH.name(), "read", null, "success", 1, ((Integer)this.maxReadDuration.get()).intValue(), client.getServerGroup()).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", Took " + duration + " milliSec.");
            }
        });
    }

    private <T> T getData(EVCacheClient client, EVCacheKey evcKey, Transcoder<T> tc, boolean throwException, boolean hasZF) throws Exception {
        if (client == null) {
            return null;
        }
        Transcoder<T> transcoder = tc == null ? (this._transcoder == null ? client.getTranscoder() : this._transcoder) : tc;
        try {
            String hashKey = evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes());
            String canonicalKey = evcKey.getCanonicalKey(client.isDuetClient());
            if (hashKey != null) {
                Object obj = client.get(hashKey, this.evcacheValueTranscoder, throwException, hasZF);
                if (obj != null && obj instanceof EVCacheValue) {
                    EVCacheValue val = (EVCacheValue)obj;
                    if (!val.getKey().equals(canonicalKey)) {
                        this.incrementFailure("KeyHashCollision", EVCache.Call.GET.name(), "read");
                        return null;
                    }
                    CachedData cd = new CachedData(val.getFlags(), val.getValue(), 0x1400000);
                    return (T)transcoder.decode(cd);
                }
                return null;
            }
            return client.get(canonicalKey, transcoder, throwException, hasZF);
        }
        catch (EVCacheConnectException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheConnectException while getting data for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheReadQueueException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheReadQueueException while getting data for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheException while getting data for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting data for APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
    }

    private EVCacheItemMetaData getEVCacheItemMetaData(EVCacheClient client, EVCacheKey evcKey, boolean throwException, boolean hasZF) throws Exception {
        if (client == null) {
            return null;
        }
        try {
            return client.metaDebug(evcKey.getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()));
        }
        catch (EVCacheConnectException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheConnectException while getting with metadata for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheReadQueueException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheReadQueueException while getting with metadata for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheException while getting with metadata for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting with metadata for APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
    }

    private <T> EVCacheItem<T> getEVCacheItem(EVCacheClient client, EVCacheKey evcKey, Transcoder<T> tc, boolean throwException, boolean hasZF) throws Exception {
        if (client == null) {
            return null;
        }
        Transcoder<T> transcoder = tc == null ? (this._transcoder == null ? client.getTranscoder() : this._transcoder) : tc;
        try {
            String hashKey = evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes());
            String canonicalKey = evcKey.getCanonicalKey(client.isDuetClient());
            if (hashKey != null) {
                EVCacheItem<Object> obj = client.metaGet(hashKey, this.evcacheValueTranscoder, throwException, hasZF);
                if (obj.getData() instanceof EVCacheValue) {
                    EVCacheValue val = (EVCacheValue)obj.getData();
                    if (null == val) {
                        return null;
                    }
                    if (!val.getKey().equals(canonicalKey)) {
                        this.incrementFailure("KeyHashCollision", EVCache.Call.META_GET.name(), "M_GET");
                        return null;
                    }
                    CachedData cd = new CachedData(val.getFlags(), val.getValue(), 0x1400000);
                    Object t = transcoder.decode(cd);
                    obj.setData(t);
                    obj.setFlag(val.getFlags());
                    return obj;
                }
                return null;
            }
            return client.metaGet(canonicalKey, transcoder, throwException, hasZF);
        }
        catch (EVCacheConnectException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheConnectException while getting with meta data for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheReadQueueException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheReadQueueException while getting with meta data for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheException while getting with meta data for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting with meta data for APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
    }

    private <T> Single<T> getData(int index, int size, EVCacheClient client, EVCacheKey canonicalKey, Transcoder<T> tc, boolean throwEx, boolean throwExc, boolean hasZF, Scheduler scheduler) {
        if (index >= size - 1) {
            throwEx = throwExc;
        }
        return this.getData(client, canonicalKey, tc, throwEx, hasZF, scheduler);
    }

    private <T> Single<T> getData(EVCacheClient client, EVCacheKey evcKey, Transcoder<T> tc, boolean throwException, boolean hasZF, Scheduler scheduler) {
        if (client == null) {
            return Single.error((Throwable)new IllegalArgumentException("Client cannot be null"));
        }
        if (evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()) != null) {
            return Single.error((Throwable)new IllegalArgumentException("Not supported"));
        }
        Transcoder<T> transcoder = tc == null ? (this._transcoder == null ? client.getTranscoder() : this._transcoder) : tc;
        return client.get(evcKey.getCanonicalKey(client.isDuetClient()), transcoder, throwException, hasZF, scheduler).onErrorReturn(ex -> {
            if (ex instanceof EVCacheReadQueueException) {
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("EVCacheReadQueueException while getting data for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, ex);
                }
                if (!throwException || hasZF) {
                    return null;
                }
                throw Sneaky.sneakyThrow(ex);
            }
            if (ex instanceof EVCacheException) {
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("EVCacheException while getting data for APP " + this._appName + ", key : " + evcKey + "; hasZF : " + hasZF, ex);
                }
                if (!throwException || hasZF) {
                    return null;
                }
                throw Sneaky.sneakyThrow(ex);
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting data for APP " + this._appName + ", key : " + evcKey, ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw Sneaky.sneakyThrow(ex);
        });
    }

    private void checkTTL(int timeToLive, EVCache.Call call) throws IllegalArgumentException {
        try {
            if (timeToLive < 0) {
                throw new IllegalArgumentException("Time to Live ( " + timeToLive + ") must be great than or equal to 0.");
            }
            long currentTimeInMillis = System.currentTimeMillis();
            if ((long)timeToLive > currentTimeInMillis) {
                throw new IllegalArgumentException("Time to Live ( " + timeToLive + ") must be in seconds.");
            }
            if (timeToLive > 2592000 && (long)timeToLive < currentTimeInMillis / 1000L) {
                throw new IllegalArgumentException("If providing Time to Live ( " + timeToLive + ") in seconds as epoc value, it should be greater than current time " + currentTimeInMillis / 1000L);
            }
        }
        catch (IllegalArgumentException iae) {
            this.incrementFastFail("invalidTTL", call);
            throw iae;
        }
    }

    @Override
    public <T> T getAndTouch(String key, int timeToLive) throws EVCacheException {
        return (T)this.getAndTouch(key, timeToLive, this._transcoder);
    }

    @Override
    public <T> Single<T> getAndTouch(String key, int timeToLive, Scheduler scheduler) {
        return this.getAndTouch(key, timeToLive, this._transcoder, scheduler);
    }

    @Override
    public <T> Single<T> getAndTouch(String key, int timeToLive, Transcoder<T> tc, Scheduler scheduler) {
        if (null == key) {
            return Single.error((Throwable)new IllegalArgumentException("Key cannot be null"));
        }
        this.checkTTL(timeToLive, EVCache.Call.GET_AND_TOUCH);
        if (((Boolean)this.hashKey.get()).booleanValue()) {
            return Single.error((Throwable)new IllegalArgumentException("Not supported"));
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient", EVCache.Call.GET_AND_TOUCH);
            return Single.error((Throwable)new EVCacheException("Could not find a client to get and touch the data for APP " + this._appName));
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), EVCache.Call.GET_AND_TOUCH);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.GET_AND_TOUCH);
                    return Single.error((Throwable)new EVCacheException("Request Throttled for app " + this._appName + " & key " + key));
                }
            }
            catch (EVCacheException ex2) {
                throw Sneaky.sneakyThrow(ex2);
            }
            event.setTTL(timeToLive);
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        boolean hasZF = this.hasZoneFallback();
        boolean throwEx = hasZF ? false : throwExc;
        return this.getData(client, evcKey, tc, throwEx, hasZF, scheduler).flatMap(data -> {
            List<EVCacheClient> fbClients;
            if (data == null && hasZF && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                return Observable.concat((Observable)Observable.from(fbClients).map(fbClient -> this.getData(fbClients.indexOf(fbClient), fbClients.size(), (EVCacheClient)fbClient, evcKey, tc, throwEx, throwExc, false, scheduler).doOnSuccess(fbData -> {}).toObservable())).firstOrDefault(null, fbData -> fbData != null).toSingle();
            }
            return Single.just((Object)data);
        }).map(data -> {
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "THIT");
                }
                try {
                    this.touchData(evcKey, timeToLive);
                }
                catch (Exception e) {
                    throw Sneaky.sneakyThrow(new EVCacheException("Exception performing touch for APP " + this._appName + ", key = " + evcKey, e));
                }
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("GET_AND_TOUCH : APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
                }
            } else {
                if (event != null) {
                    event.setAttribute("status", "TMISS");
                }
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET_AND_TOUCH : APP " + this._appName + " ; cache miss for key : " + evcKey);
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            return data;
        }).onErrorReturn(ex -> {
            if (ex instanceof CheckedOperationTimeoutException) {
                if (event != null) {
                    event.setStatus("timeout");
                    this.eventError(event, (Throwable)ex);
                }
                if (!throwExc) {
                    return null;
                }
                throw Sneaky.sneakyThrow(new EVCacheException("CheckedOperationTimeoutException executing getAndTouch APP " + this._appName + ", key = " + evcKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", (Throwable)ex));
            }
            if (event != null) {
                event.setStatus("error");
                this.eventError(event, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, (Throwable)ex);
            }
            if (!throwExc) {
                return null;
            }
            throw Sneaky.sneakyThrow(new EVCacheException("Exception executing getAndTouch APP " + this._appName + ", key = " + evcKey, (Throwable)ex));
        }).doAfterTerminate(() -> {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.GET_AND_TOUCH.name(), "read", null, "success", 1, ((Integer)this.maxReadDuration.get()).intValue(), client.getServerGroup()).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET_AND_TOUCH : APP " + this._appName + ", Took " + duration + " milliSec.");
            }
        });
    }

    @Override
    public <T> T getAndTouch(String key, int timeToLive, Transcoder<T> tc) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.checkTTL(timeToLive, EVCache.Call.GET_AND_TOUCH);
        EVCacheKey evcKey = this.getEVCacheKey(key);
        if (((Boolean)this._useInMemoryCache.get()).booleanValue()) {
            T value;
            boolean throwExc;
            block11: {
                throwExc = this.doThrowException();
                value = null;
                try {
                    Transcoder<T> transcoder = tc == null ? (this._transcoder == null ? this._pool.getEVCacheClientForRead().getTranscoder() : this._transcoder) : tc;
                    value = this.getInMemoryCache(transcoder).get(evcKey);
                }
                catch (ExecutionException e) {
                    if (!throwExc) break block11;
                    if (e.getCause() instanceof EVCacheInMemoryCache.DataNotFoundException) {
                        return null;
                    }
                    if (e.getCause() instanceof EVCacheException) {
                        if (log.isDebugEnabled() && this.shouldLog()) {
                            log.debug("ExecutionException while getting data from InMemory Cache", (Throwable)e);
                        }
                        throw (EVCacheException)e.getCause();
                    }
                    throw new EVCacheException("ExecutionException", e);
                }
            }
            if (value != null) {
                block12: {
                    try {
                        this.touchData(evcKey, timeToLive);
                    }
                    catch (Exception e) {
                        if (!throwExc) break block12;
                        throw new EVCacheException("Exception executing getAndTouch APP " + this._appName + ", key = " + evcKey, e);
                    }
                }
                return value;
            }
        }
        if (((Boolean)this.ignoreTouch.get()).booleanValue()) {
            return this.doGet(evcKey, tc);
        }
        return this.doGetAndTouch(evcKey, timeToLive, tc);
    }

    <T> T doGetAndTouch(EVCacheKey evcKey, int timeToLive, Transcoder<T> tc) throws EVCacheException {
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient", EVCache.Call.GET_AND_TOUCH);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get and touch the data for App " + this._appName);
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), EVCache.Call.GET_AND_TOUCH);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.GET_AND_TOUCH);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + evcKey);
                    }
                    return null;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.GET_AND_TOUCH);
                return null;
            }
            event.setTTL(timeToLive);
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String cacheOperation = "yes";
        int tries = 1;
        String status = "success";
        try {
            boolean hasZF = this.hasZoneFallback();
            boolean throwEx = hasZF ? false : throwExc;
            T data = this.getData(client, evcKey, tc, throwEx, hasZF);
            if (data == null && hasZF) {
                List<EVCacheClient> fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup());
                for (int i = 0; i < fbClients.size(); ++i) {
                    EVCacheClient fbClient;
                    block41: {
                        fbClient = fbClients.get(i);
                        if (i >= fbClients.size() - 1) {
                            throwEx = throwExc;
                        }
                        if (event != null) {
                            T t;
                            try {
                                if (!this.shouldThrottle(event)) break block41;
                                status = "throttled";
                                if (throwExc) {
                                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + evcKey);
                                }
                                t = null;
                            }
                            catch (EVCacheException ex) {
                                if (throwExc) {
                                    throw ex;
                                }
                                status = "throttled";
                                T t2 = null;
                                return t2;
                            }
                            return t;
                        }
                    }
                    ++tries;
                    data = this.getData(fbClient, evcKey, tc, throwEx, i < fbClients.size() - 1);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("GetAndTouch Retry for APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + fbClient.getServerGroup());
                    }
                    if (data == null) continue;
                    client = fbClient;
                    break;
                }
            }
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "THIT");
                }
                this.touchData(evcKey, timeToLive);
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("GET_AND_TOUCH : APP " + this._appName + ", key [" + evcKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
                }
            } else {
                cacheOperation = "no";
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET_AND_TOUCH : APP " + this._appName + " ; cache miss for key : " + evcKey);
                }
                if (event != null) {
                    event.setAttribute("status", "TMISS");
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            T t = data;
            return t;
        }
        catch (CheckedOperationTimeoutException ex) {
            status = "timeout";
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("CheckedOperationTimeoutException executing getAndTouch APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("CheckedOperationTimeoutException executing getAndTouch APP " + this._appName + ", key  = " + evcKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception executing getAndTouch APP " + this._appName + ", key = " + evcKey, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("Exception executing getAndTouch APP " + this._appName + ", key = " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.GET_AND_TOUCH.name(), "read", cacheOperation, status, tries, ((Integer)this.maxReadDuration.get()).intValue(), client.getServerGroup()).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Took " + duration + " milliSec to get&Touch the value for APP " + this._appName + ", key " + evcKey);
            }
        }
    }

    @Override
    public Future<Boolean>[] touch(String key, int timeToLive) throws EVCacheException {
        this.checkTTL(timeToLive, EVCache.Call.TOUCH);
        EVCacheLatch latch = this.touch(key, timeToLive, null);
        if (latch == null) {
            return new EVCacheFuture[0];
        }
        List<Future<Boolean>> futures = latch.getAllFutures();
        if (futures == null || futures.isEmpty()) {
            return new EVCacheFuture[0];
        }
        EVCacheFuture[] eFutures = new EVCacheFuture[futures.size()];
        for (int i = 0; i < futures.size(); ++i) {
            Future<Boolean> future = futures.get(i);
            if (future instanceof EVCacheFuture) {
                eFutures[i] = (EVCacheFuture)future;
                continue;
            }
            if (future instanceof EVCacheOperationFuture) {
                EVCacheOperationFuture evfuture = (EVCacheOperationFuture)((Object)future);
                eFutures[i] = new EVCacheFuture(future, key, this._appName, evfuture.getServerGroup(), evfuture.getEVCacheClient());
                continue;
            }
            eFutures[i] = new EVCacheFuture(future, key, this._appName, null);
        }
        return eFutures;
    }

    @Override
    public <T> EVCacheLatch touch(String key, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException();
        }
        this.checkTTL(timeToLive, EVCache.Call.TOUCH);
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.TOUCH);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), EVCache.Call.TOUCH);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.TOUCH);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.TOUCH);
                return null;
            }
            this.startEvent(event);
        }
        String status = "success";
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        try {
            EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
            this.touchData(evcKey, timeToLive, clients, latch);
            if (event != null) {
                event.setTTL(timeToLive);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception touching the data for APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTTLDistributionSummary(EVCache.Call.TOUCH.name(), "write", "evc.ttl").record((long)timeToLive);
            this.getTimer(EVCache.Call.TOUCH.name(), "write", null, status, 1, ((Integer)this.maxWriteDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("TOUCH : APP " + this._appName + " for key : " + evcKey + " with timeToLive : " + timeToLive);
            }
        }
    }

    private void touchData(EVCacheKey evcKey, int timeToLive) throws Exception {
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        this.touchData(evcKey, timeToLive, clients);
    }

    private void touchData(EVCacheKey evcKey, int timeToLive, EVCacheClient[] clients) throws Exception {
        this.touchData(evcKey, timeToLive, clients, null);
    }

    private void touchData(EVCacheKey evcKey, int timeToLive, EVCacheClient[] clients, EVCacheLatch latch) throws Exception {
        this.checkTTL(timeToLive, EVCache.Call.TOUCH);
        for (EVCacheClient client : clients) {
            client.touch(evcKey.getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()), timeToLive, latch);
        }
    }

    @Override
    public <T> Future<T> getAsynchronous(String key) throws EVCacheException {
        return this.getAsynchronous(key, this._transcoder);
    }

    @Override
    public <T> Future<T> getAsynchronous(String key, Transcoder<T> tc) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key is null.");
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient", EVCache.Call.ASYNC_GET);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to asynchronously get the data");
            }
            return null;
        }
        return this.getGetFuture(client, key, tc, throwExc);
    }

    private <T> Future<T> getGetFuture(final EVCacheClient client, String key, final Transcoder<T> tc, boolean throwExc) throws EVCacheException {
        Future r;
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), EVCache.Call.ASYNC_GET);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.ASYNC_GET);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return null;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.ASYNC_GET);
                return null;
            }
            this.startEvent(event);
        }
        String status = "success";
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        try {
            String hashKey = evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes());
            final String canonicalKey = evcKey.getCanonicalKey(client.isDuetClient());
            if (hashKey != null) {
                final Future objFuture = client.asyncGet(hashKey, this.evcacheValueTranscoder, throwExc, false);
                r = new Future<T>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return objFuture.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public boolean isCancelled() {
                        return objFuture.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return objFuture.isDone();
                    }

                    @Override
                    public T get() throws InterruptedException, ExecutionException {
                        return this.getFromObj(objFuture.get());
                    }

                    private T getFromObj(Object obj) {
                        if (obj != null && obj instanceof EVCacheValue) {
                            EVCacheValue val = (EVCacheValue)obj;
                            if (!val.getKey().equals(canonicalKey)) {
                                EVCacheImpl.this.incrementFailure("KeyHashCollision", EVCache.Call.ASYNC_GET.name(), "read");
                                return null;
                            }
                            CachedData cd = new CachedData(val.getFlags(), val.getValue(), 0x1400000);
                            Transcoder transcoder = tc == null ? (EVCacheImpl.this._transcoder == null ? client.getTranscoder() : EVCacheImpl.this._transcoder) : tc;
                            return transcoder.decode(cd);
                        }
                        return null;
                    }

                    @Override
                    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return this.getFromObj(objFuture.get(timeout, unit));
                    }
                };
            } else {
                Transcoder<T> transcoder = tc == null ? (this._transcoder == null ? client.getTranscoder() : this._transcoder) : tc;
                r = client.asyncGet(canonicalKey, transcoder, throwExc, false);
            }
            if (event != null) {
                this.endEvent(event);
            }
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting data for keys Asynchronously APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                Future<T> future = null;
                return future;
            }
            throw new EVCacheException("Exception getting data for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.ASYNC_GET.name(), "read", null, status, 1, ((Integer)this.maxReadDuration.get()).intValue(), client.getServerGroup()).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Took " + duration + " milliSec to execute AsyncGet the value for APP " + this._appName + ", key " + key);
            }
        }
        return r;
    }

    private <T> Map<EVCacheKey, T> getBulkData(EVCacheClient client, Collection<EVCacheKey> evcacheKeys, Transcoder<T> tc, boolean throwException, boolean hasZF) throws Exception {
        try {
            HashMap<EVCacheKey, Object> retMap;
            Map objMap;
            boolean hasHashedKey = false;
            HashMap<String, EVCacheKey> keyMap = new HashMap<String, EVCacheKey>(evcacheKeys.size() * 2);
            for (EVCacheKey evcKey : evcacheKeys) {
                String key = evcKey.getCanonicalKey(client.isDuetClient());
                String hashKey = evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes());
                if (hashKey != null) {
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("APP " + this._appName + ", key [" + key + "], has been hashed [" + hashKey + "]");
                    }
                    key = hashKey;
                    hasHashedKey = true;
                }
                keyMap.put(key, evcKey);
            }
            if (hasHashedKey) {
                objMap = client.getBulk((Collection<String>)keyMap.keySet(), this.evcacheValueTranscoder, throwException, hasZF);
                retMap = new HashMap<EVCacheKey, Object>((int)((double)objMap.size() / 0.75) + 1);
                for (Map.Entry i : objMap.entrySet()) {
                    Object obj = i.getValue();
                    if (obj instanceof EVCacheValue) {
                        if (log.isDebugEnabled() && this.shouldLog()) {
                            log.debug("APP " + this._appName + ", The value for key [" + i.getKey() + "] is EVCache Value");
                        }
                        EVCacheValue val = (EVCacheValue)obj;
                        CachedData cd = new CachedData(val.getFlags(), val.getValue(), 0x1400000);
                        Object tVal = tc == null ? client.getTranscoder().decode(cd) : tc.decode(cd);
                        EVCacheKey evcKey = (EVCacheKey)keyMap.get(i.getKey());
                        if (evcKey.getCanonicalKey(client.isDuetClient()).equals(val.getKey())) {
                            if (log.isDebugEnabled() && this.shouldLog()) {
                                log.debug("APP " + this._appName + ", key [" + i.getKey() + "] EVCacheKey " + evcKey);
                            }
                            retMap.put(evcKey, tVal);
                            continue;
                        }
                        if (log.isDebugEnabled() && this.shouldLog()) {
                            log.debug("CACHE COLLISION : APP " + this._appName + ", key [" + i.getKey() + "] EVCacheKey " + evcKey);
                        }
                        this.incrementFailure("KeyHashCollision", EVCache.Call.BULK.name(), "read");
                        continue;
                    }
                    EVCacheKey evcKey = (EVCacheKey)keyMap.get(i.getKey());
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("APP " + this._appName + ", key [" + i.getKey() + "] EVCacheKey " + evcKey);
                    }
                    retMap.put(evcKey, obj);
                }
                return retMap;
            }
            if (tc == null && this._transcoder != null) {
                tc = this._transcoder;
            }
            objMap = client.getBulk((Collection<String>)keyMap.keySet(), tc, throwException, hasZF);
            retMap = new HashMap((int)((double)objMap.size() / 0.75) + 1);
            for (Map.Entry i : objMap.entrySet()) {
                EVCacheKey evcKey = (EVCacheKey)keyMap.get(i.getKey());
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("APP " + this._appName + ", key [" + i.getKey() + "] EVCacheKey " + evcKey);
                }
                retMap.put(evcKey, i.getValue());
            }
            return retMap;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getBulk data for APP " + this._appName + ", key : " + evcacheKeys, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public <T> Map<String, T> getBulk(Collection<String> keys, Transcoder<T> tc) throws EVCacheException {
        return this.getBulk(keys, tc, false, 0);
    }

    @Override
    public <T> Map<String, T> getBulkAndTouch(Collection<String> keys, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        return this.getBulk(keys, tc, true, timeToLive);
    }

    private <T> Map<String, T> getBulk(Collection<String> keys, Transcoder<T> tc, boolean touch, int timeToLive) throws EVCacheException {
        if (null == keys) {
            throw new IllegalArgumentException();
        }
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        this.checkTTL(timeToLive, EVCache.Call.BULK);
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient", EVCache.Call.BULK);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get the data in bulk");
            }
            return Collections.emptyMap();
        }
        HashMap<String, T> decanonicalR = new HashMap<String, T>(keys.size() * 4 / 3 + 1);
        ArrayList<EVCacheKey> evcKeys = new ArrayList<EVCacheKey>();
        for (String k : keys) {
            EVCacheKey evcKey = this.getEVCacheKey(k);
            Object value = null;
            if (((Boolean)this._useInMemoryCache.get()).booleanValue()) {
                try {
                    Transcoder<T> transcoder = tc == null ? (this._transcoder == null ? this._pool.getEVCacheClientForRead().getTranscoder() : this._transcoder) : tc;
                    value = this.getInMemoryCache(transcoder).get(evcKey);
                    if (value == null && log.isInfoEnabled() && this.shouldLog()) {
                        log.info("Value not_found in inmemory cache for APP " + this._appName + ", key : " + evcKey + "; value : " + value);
                    }
                }
                catch (ExecutionException e) {
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("ExecutionException while getting data from InMemory Cache", (Throwable)e);
                    }
                    throw new EVCacheException("ExecutionException", e);
                }
            }
            if (value == null) {
                evcKeys.add(evcKey);
                continue;
            }
            decanonicalR.put(evcKey.getKey(), value);
            if (!log.isDebugEnabled() || !this.shouldLog()) continue;
            log.debug("Value retrieved from inmemory cache for APP " + this._appName + ", key : " + evcKey + (log.isTraceEnabled() ? "; value : " + value : ""));
        }
        if (evcKeys.size() == 0 && decanonicalR.size() == keys.size()) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("All Values retrieved from inmemory cache for APP " + this._appName + ", keys : " + keys + (log.isTraceEnabled() ? "; value : " + decanonicalR : ""));
            }
            return decanonicalR;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), EVCache.Call.BULK);
        if (event != null) {
            event.setEVCacheKeys(evcKeys);
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.BULK);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & keys " + keys);
                    }
                    return Collections.emptyMap();
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.BULK);
                return null;
            }
            event.setTTL(timeToLive);
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String cacheOperation = "yes";
        int tries = 1;
        String status = "success";
        try {
            ArrayList<EVCacheKey> retryEVCacheKeys;
            boolean hasZF = this.hasZoneFallbackForBulk();
            boolean throwEx = hasZF ? false : throwExc;
            Map<EVCacheKey, T> retMap = this.getBulkData(client, evcKeys, tc, throwEx, hasZF);
            List<EVCacheClient> fbClients = null;
            if (hasZF) {
                if (retMap == null || retMap.isEmpty()) {
                    fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup());
                    if (fbClients != null && !fbClients.isEmpty()) {
                        for (int i = 0; i < fbClients.size(); ++i) {
                            EVCacheClient fbClient = fbClients.get(i);
                            if (i >= fbClients.size() - 1) {
                                throwEx = throwExc;
                            }
                            if (event != null) {
                                try {
                                    if (this.shouldThrottle(event)) {
                                        status = "throttled";
                                        if (throwExc) {
                                            throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + evcKeys);
                                        }
                                        Map<String, T> map = null;
                                        return map;
                                    }
                                }
                                catch (EVCacheException ex) {
                                    if (throwExc) {
                                        throw ex;
                                    }
                                    status = "throttled";
                                    Map<String, T> duration = null;
                                    return duration;
                                }
                            }
                            ++tries;
                            retMap = this.getBulkData(fbClient, evcKeys, tc, throwEx, i < fbClients.size() - 1);
                            if (log.isDebugEnabled() && this.shouldLog()) {
                                log.debug("Fallback for APP " + this._appName + ", key [" + evcKeys + (log.isTraceEnabled() ? "], Value [" + retMap : "") + "], zone : " + fbClient.getZone());
                            }
                            if (retMap == null || retMap.isEmpty()) {
                                continue;
                            }
                            break;
                        }
                    }
                } else if (retMap != null && keys.size() > retMap.size() && ((Boolean)this._bulkPartialZoneFallbackFP.get()).booleanValue()) {
                    int initRetrySize = keys.size() - retMap.size();
                    retryEVCacheKeys = new ArrayList<EVCacheKey>(initRetrySize);
                    for (EVCacheKey key : evcKeys) {
                        if (retMap.containsKey(key)) continue;
                        retryEVCacheKeys.add(key);
                    }
                    fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup());
                    if (fbClients != null && !fbClients.isEmpty()) {
                        for (int ind = 0; ind < fbClients.size(); ++ind) {
                            EVCacheClient fbClient = fbClients.get(ind);
                            if (event != null) {
                                try {
                                    if (this.shouldThrottle(event)) {
                                        status = "throttled";
                                        if (throwExc) {
                                            throw new EVCacheException("Request Throttled for app " + this._appName + " & keys " + retryEVCacheKeys);
                                        }
                                        Map<String, T> duration = null;
                                        return duration;
                                    }
                                }
                                catch (EVCacheException ex) {
                                    status = "throttled";
                                    if (throwExc) {
                                        throw ex;
                                    }
                                    Iterator<Map.Entry<EVCacheKey, T>> duration = null;
                                    return duration;
                                }
                            }
                            ++tries;
                            Map<EVCacheKey, T> fbRetMap = this.getBulkData(fbClient, retryEVCacheKeys, tc, false, hasZF);
                            if (log.isDebugEnabled() && this.shouldLog()) {
                                log.debug("Fallback for APP " + this._appName + ", key [" + retryEVCacheKeys + "], Fallback Server Group : " + fbClient.getServerGroup().getName());
                            }
                            for (Map.Entry<EVCacheKey, T> i : fbRetMap.entrySet()) {
                                retMap.put(i.getKey(), i.getValue());
                                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                                log.debug("Fallback for APP " + this._appName + ", key [" + i.getKey() + (log.isTraceEnabled() ? "], Value [" + i.getValue() : "]"));
                            }
                            if (retryEVCacheKeys.size() == fbRetMap.size()) break;
                            if (ind >= fbClients.size()) continue;
                            retryEVCacheKeys = new ArrayList(keys.size() - retMap.size());
                            for (EVCacheKey key : evcKeys) {
                                if (retMap.containsKey(key)) continue;
                                retryEVCacheKeys.add(key);
                            }
                        }
                    }
                    if (log.isDebugEnabled() && this.shouldLog() && retMap.size() == keys.size()) {
                        log.debug("Fallback SUCCESS for APP " + this._appName + ",  retMap [" + retMap + "]");
                    }
                }
            }
            if (decanonicalR.isEmpty() && (retMap == null || retMap.isEmpty())) {
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("BULK : APP " + this._appName + " ; Full cache miss for keys : " + keys);
                }
                if (event != null) {
                    event.setAttribute("status", "BMISS_ALL");
                }
                HashMap<String, Object> returnMap = new HashMap<String, Object>();
                if (retMap != null && retMap.isEmpty()) {
                    for (String k : keys) {
                        returnMap.put(k, null);
                    }
                }
                cacheOperation = "no";
                if (event != null) {
                    this.endEvent(event);
                }
                retryEVCacheKeys = returnMap;
                return retryEVCacheKeys;
            }
            boolean partialHit = false;
            ArrayList<String> decanonicalHitKeys = new ArrayList<String>(retMap.size());
            for (EVCacheKey key : evcKeys) {
                String deCanKey = key.getKey();
                T value = retMap.get(key);
                if (value != null) {
                    decanonicalR.put(deCanKey, value);
                    if (touch) {
                        this.touchData(key, timeToLive);
                    }
                    decanonicalHitKeys.add(deCanKey);
                    continue;
                }
                partialHit = true;
                decanonicalR.put(deCanKey, null);
            }
            if (!decanonicalR.isEmpty()) {
                if (!partialHit) {
                    if (event != null) {
                        event.setAttribute("status", "BHIT");
                    }
                } else {
                    if (event != null) {
                        event.setAttribute("status", "BHIT_PARTIAL");
                        event.setAttribute("BHIT_PARTIAL_KEYS", decanonicalHitKeys);
                    }
                    cacheOperation = "partial";
                    if (log.isInfoEnabled() && this.shouldLog()) {
                        log.info("BULK_HIT_PARTIAL for APP " + this._appName + ", keys in cache [" + decanonicalR + "], all keys [" + keys + "]");
                    }
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("APP " + this._appName + ", BULK : Data [" + decanonicalR + "]");
            }
            if (event != null) {
                this.endEvent(event);
            }
            HashMap<String, T> hashMap = decanonicalR;
            return hashMap;
        }
        catch (CheckedOperationTimeoutException ex) {
            status = "timeout";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("CheckedOperationTimeoutException getting bulk data for APP " + this._appName + ", keys : " + evcKeys, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                Map<String, T> map = null;
                return map;
            }
            throw new EVCacheException("CheckedOperationTimeoutException getting bulk data for APP " + this._appName + ", keys = " + evcKeys + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.bulkReadTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception getting bulk data for APP " + this._appName + ", keys = " + evcKeys, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                Map<String, T> map = null;
                return map;
            }
            throw new EVCacheException("Exception getting bulk data for APP " + this._appName + ", keys = " + evcKeys, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            if (this.bulkKeysSize == null) {
                ArrayList<Tag> tagList = new ArrayList<Tag>(4);
                tagList.addAll(this.tags);
                tagList.add((Tag)new BasicTag("evc.call", "BULK"));
                tagList.add((Tag)new BasicTag("evc.call.type", "read"));
                this.bulkKeysSize = EVCacheMetricsFactory.getInstance().getDistributionSummary("evcache.client.call.keys.size", tagList);
            }
            this.bulkKeysSize.record((long)keys.size());
            this.getTimer(EVCache.Call.BULK.name(), "read", cacheOperation, status, tries, ((Integer)this.maxReadDuration.get()).intValue(), client.getServerGroup()).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("BULK : APP " + this._appName + " Took " + duration + " milliSec to get the value for key " + evcKeys);
            }
        }
    }

    @Override
    public <T> Map<String, T> getBulk(Collection<String> keys) throws EVCacheException {
        return this.getBulk(keys, this._transcoder);
    }

    @Override
    public <T> Map<String, T> getBulk(String ... keys) throws EVCacheException {
        return this.getBulk(Arrays.asList(keys), this._transcoder);
    }

    @Override
    public <T> Map<String, T> getBulk(Transcoder<T> tc, String ... keys) throws EVCacheException {
        return this.getBulk(Arrays.asList(keys), tc);
    }

    public <T> EVCacheFuture[] set(String key, T value, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        EVCacheLatch latch = this.set(key, value, tc, timeToLive, null);
        if (latch == null) {
            return new EVCacheFuture[0];
        }
        List<Future<Boolean>> futures = latch.getAllFutures();
        if (futures == null || futures.isEmpty()) {
            return new EVCacheFuture[0];
        }
        EVCacheFuture[] eFutures = new EVCacheFuture[futures.size()];
        for (int i = 0; i < futures.size(); ++i) {
            Future<Boolean> future = futures.get(i);
            eFutures[i] = future instanceof EVCacheFuture ? (EVCacheFuture)future : (future instanceof EVCacheOperationFuture ? new EVCacheFuture(futures.get(i), key, this._appName, ((EVCacheOperationFuture)((Object)futures.get(i))).getServerGroup()) : new EVCacheFuture(future, key, this._appName, null));
        }
        return eFutures;
    }

    @Override
    public <T> EVCacheLatch set(String key, T value, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.set(key, value, this._transcoder, this._timeToLive, policy);
    }

    @Override
    public <T> EVCacheLatch set(String key, T value, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.set(key, value, this._transcoder, timeToLive, policy);
    }

    @Override
    public <T> EVCacheLatch set(String key, T value, Transcoder<T> tc, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.set(key, value, tc, this._timeToLive, policy);
    }

    @Override
    public <T> EVCacheLatch set(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        this.checkTTL(timeToLive, EVCache.Call.SET);
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.SET);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), EVCache.Call.SET);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.SET);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.SET);
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        try {
            CachedData cd = null;
            for (EVCacheClient client : clients) {
                String canonicalKey = evcKey.getCanonicalKey(client.isDuetClient());
                String hashKey = evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes());
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : client.getTranscoder().encode(value));
                    if (hashKey != null) {
                        EVCacheValue val = new EVCacheValue(canonicalKey, cd.getData(), cd.getFlags(), timeToLive, System.currentTimeMillis());
                        cd = this.evcacheValueTranscoder.encode(val);
                    }
                }
                Future<Boolean> future = client.set(hashKey == null ? canonicalKey : hashKey, cd, timeToLive, (EVCacheLatch)latch);
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("SET : APP " + this._appName + ", Future " + future + " for key : " + evcKey);
            }
            if (event != null) {
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception setting the data for APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (event != null) {
                this.endEvent(event);
            }
            status = "error";
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTTLDistributionSummary(EVCache.Call.SET.name(), "write", "evc.ttl").record((long)timeToLive);
            this.getTimer(EVCache.Call.SET.name(), "write", null, status, 1, ((Integer)this.maxWriteDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("SET : APP " + this._appName + ", Took " + duration + " milliSec for key : " + evcKey);
            }
        }
    }

    public <T> EVCacheFuture[] append(String key, T value, int timeToLive) throws EVCacheException {
        return this.append(key, value, (Transcoder<T>)null, timeToLive);
    }

    public <T> EVCacheFuture[] append(String key, T value, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        this.checkTTL(timeToLive, EVCache.Call.APPEND);
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.APPEND);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheFuture[0];
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), EVCache.Call.APPEND);
        EVCacheKey evcKey = this.getEVCacheKey(key);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.APPEND);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheFuture[0];
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.APPEND);
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        try {
            EVCacheFuture[] futures = new EVCacheFuture[clients.length];
            CachedData cd = null;
            int index = 0;
            for (EVCacheClient client : clients) {
                if (evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()) != null) {
                    throw new IllegalArgumentException("append is not supported when key hashing is enabled.");
                }
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : client.getTranscoder().encode(value));
                }
                Future<Boolean> future = client.append(evcKey.getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()), cd);
                futures[index++] = new EVCacheFuture(future, key, this._appName, client.getServerGroup());
            }
            if (event != null) {
                event.setCachedData(cd);
                event.setTTL(timeToLive);
                this.endEvent(event);
            }
            this.touchData(evcKey, timeToLive, clients);
            Object[] objectArray = futures;
            return objectArray;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception setting the data for APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheFuture[] eVCacheFutureArray = new EVCacheFuture[]{};
                return eVCacheFutureArray;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.APPEND.name(), "write", null, status, 1, ((Integer)this.maxWriteDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("APPEND : APP " + this._appName + ", Took " + duration + " milliSec for key : " + evcKey);
            }
        }
    }

    public <T> EVCacheFuture[] set(String key, T value, Transcoder<T> tc) throws EVCacheException {
        return this.set(key, value, tc, this._timeToLive);
    }

    public <T> EVCacheFuture[] set(String key, T value, int timeToLive) throws EVCacheException {
        return this.set(key, value, (Transcoder<T>)this._transcoder, timeToLive);
    }

    public <T> EVCacheFuture[] set(String key, T value) throws EVCacheException {
        return this.set(key, value, (Transcoder<T>)this._transcoder, this._timeToLive);
    }

    public EVCacheFuture[] delete(String key) throws EVCacheException {
        EVCacheLatch latch = this.delete(key, null);
        if (latch == null) {
            return new EVCacheFuture[0];
        }
        List<Future<Boolean>> futures = latch.getAllFutures();
        if (futures == null || futures.isEmpty()) {
            return new EVCacheFuture[0];
        }
        EVCacheFuture[] eFutures = new EVCacheFuture[futures.size()];
        for (int i = 0; i < futures.size(); ++i) {
            Future<Boolean> future = futures.get(i);
            if (future instanceof EVCacheFuture) {
                eFutures[i] = (EVCacheFuture)future;
                continue;
            }
            if (future instanceof EVCacheOperationFuture) {
                EVCacheOperationFuture evfuture = (EVCacheOperationFuture)((Object)future);
                eFutures[i] = new EVCacheFuture(future, key, this._appName, evfuture.getServerGroup(), evfuture.getEVCacheClient());
                continue;
            }
            eFutures[i] = new EVCacheFuture(future, key, this._appName, null);
        }
        return eFutures;
    }

    @Override
    public <T> EVCacheLatch delete(String key, EVCacheLatch.Policy policy) throws EVCacheException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.DELETE);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to delete the keyAPP " + this._appName + ", Key " + key);
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), EVCache.Call.DELETE);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.DELETE);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.DELETE);
                return null;
            }
            this.startEvent(event);
        }
        String status = "success";
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        try {
            for (int i = 0; i < clients.length; ++i) {
                Future<Boolean> future = clients[i].delete(evcKey.getDerivedKey(clients[i].isDuetClient(), clients[i].getHashingAlgorithm(), clients[i].shouldEncodeHashKey(), clients[i].getMaxHashingBytes()), latch);
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("DELETE : APP " + this._appName + ", Future " + future + " for key : " + evcKey);
            }
            if (event != null) {
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl i = latch;
            return i;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while deleting the data for APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            status = "error";
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception while deleting the data for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.DELETE.name(), "write", null, status, 1, ((Integer)this.maxWriteDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("DELETE : APP " + this._appName + " Took " + duration + " milliSec for key : " + key);
            }
        }
    }

    public int getDefaultTTL() {
        return this._timeToLive;
    }

    @Override
    public long incr(String key, long by, long defaultVal, int timeToLive) throws EVCacheException {
        if (null == key || by < 0L || defaultVal < 0L || timeToLive < 0) {
            throw new IllegalArgumentException();
        }
        this.checkTTL(timeToLive, EVCache.Call.INCR);
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.INCR);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("INCR : " + this._metricPrefix + ":NULL_CLIENT");
            }
            if (throwExc) {
                throw new EVCacheException("Could not find a client to incr the data");
            }
            return -1L;
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), EVCache.Call.INCR);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.INCR);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return -1L;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.INCR);
                return -1L;
            }
            this.startEvent(event);
        }
        String status = "success";
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        long currentValue = -1L;
        try {
            long[] vals = new long[clients.length];
            int index = 0;
            for (EVCacheClient client : clients) {
                vals[index] = client.incr(evcKey.getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()), by, defaultVal, timeToLive);
                if (vals[index] != -1L && currentValue < vals[index]) {
                    currentValue = vals[index];
                    if (log.isDebugEnabled()) {
                        log.debug("INCR : APP " + this._appName + " current value = " + currentValue + " for key : " + key + " from client : " + client);
                    }
                }
                ++index;
            }
            if (currentValue != -1L) {
                CachedData cd = null;
                if (log.isDebugEnabled()) {
                    log.debug("INCR : APP " + this._appName + " current value = " + currentValue + " for key : " + key);
                }
                for (int i = 0; i < vals.length; ++i) {
                    if (vals[i] == -1L && currentValue > -1L) {
                        if (log.isDebugEnabled()) {
                            log.debug("INCR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value = -1 so setting it to current value = " + currentValue + " for key : " + key);
                        }
                        clients[i].incr(evcKey.getDerivedKey(clients[i].isDuetClient(), clients[i].getHashingAlgorithm(), clients[i].shouldEncodeHashKey(), clients[i].getMaxHashingBytes()), 0L, currentValue, timeToLive);
                        continue;
                    }
                    if (vals[i] == currentValue) continue;
                    if (cd == null) {
                        cd = clients[i].getTranscoder().encode((Object)String.valueOf(currentValue));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("INCR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value of " + vals[i] + " so setting it to current value = " + currentValue + " for key : " + key);
                    }
                    clients[i].set(evcKey.getDerivedKey(clients[i].isDuetClient(), clients[i].getHashingAlgorithm(), clients[i].shouldEncodeHashKey(), clients[i].getMaxHashingBytes()), cd, timeToLive);
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            if (log.isDebugEnabled()) {
                log.debug("INCR : APP " + this._appName + " returning value = " + currentValue + " for key : " + key);
            }
            long l = currentValue;
            return l;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception incrementing the value for APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                long l = -1L;
                return l;
            }
            throw new EVCacheException("Exception incrementing value for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.INCR.name(), "write", null, status, 1, ((Integer)this.maxWriteDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("INCR : APP " + this._appName + ", Took " + duration + " milliSec for key : " + key + " with value as " + currentValue);
            }
        }
    }

    @Override
    public long decr(String key, long by, long defaultVal, int timeToLive) throws EVCacheException {
        if (null == key || by < 0L || defaultVal < 0L || timeToLive < 0) {
            throw new IllegalArgumentException();
        }
        this.checkTTL(timeToLive, EVCache.Call.DECR);
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.DECR);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("DECR : " + this._metricPrefix + ":NULL_CLIENT");
            }
            if (throwExc) {
                throw new EVCacheException("Could not find a client to decr the data");
            }
            return -1L;
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), EVCache.Call.DECR);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.DECR);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return -1L;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.DECR);
                return -1L;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        long currentValue = -1L;
        try {
            long[] vals = new long[clients.length];
            int index = 0;
            for (EVCacheClient client : clients) {
                vals[index] = client.decr(evcKey.getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()), by, defaultVal, timeToLive);
                if (vals[index] != -1L && currentValue < vals[index]) {
                    currentValue = vals[index];
                    if (log.isDebugEnabled()) {
                        log.debug("DECR : APP " + this._appName + " current value = " + currentValue + " for key : " + key + " from client : " + client);
                    }
                }
                ++index;
            }
            if (currentValue != -1L) {
                CachedData cd = null;
                if (log.isDebugEnabled()) {
                    log.debug("DECR : APP " + this._appName + " current value = " + currentValue + " for key : " + key);
                }
                for (int i = 0; i < vals.length; ++i) {
                    if (vals[i] == -1L && currentValue > -1L) {
                        if (log.isDebugEnabled()) {
                            log.debug("DECR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value = -1 so setting it to current value = " + currentValue + " for key : " + key);
                        }
                        clients[i].decr(evcKey.getDerivedKey(clients[i].isDuetClient(), clients[i].getHashingAlgorithm(), clients[i].shouldEncodeHashKey(), clients[i].getMaxHashingBytes()), 0L, currentValue, timeToLive);
                        continue;
                    }
                    if (vals[i] == currentValue) continue;
                    if (cd == null) {
                        cd = clients[i].getTranscoder().encode((Object)currentValue);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("DECR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value of " + vals[i] + " so setting it to current value = " + currentValue + " for key : " + key);
                    }
                    clients[i].set(evcKey.getDerivedKey(clients[i].isDuetClient(), clients[i].getHashingAlgorithm(), clients[i].shouldEncodeHashKey(), clients[i].getMaxHashingBytes()), cd, timeToLive);
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            if (log.isDebugEnabled()) {
                log.debug("DECR : APP " + this._appName + " returning value = " + currentValue + " for key : " + key);
            }
            long l = currentValue;
            return l;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception decrementing the value for APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                long l = -1L;
                return l;
            }
            throw new EVCacheException("Exception decrementing value for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.DECR.name(), "write", null, status, 1, ((Integer)this.maxWriteDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("DECR : APP " + this._appName + ", Took " + duration + " milliSec for key : " + key + " with value as " + currentValue);
            }
        }
    }

    @Override
    public <T> EVCacheLatch replace(String key, T value, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.replace(key, value, this._transcoder, policy);
    }

    @Override
    public <T> EVCacheLatch replace(String key, T value, Transcoder<T> tc, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.replace(key, value, this._transcoder, this._timeToLive, policy);
    }

    public <T> EVCacheLatch replace(String key, T value, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.replace(key, value, this._transcoder, timeToLive, policy);
    }

    @Override
    public <T> EVCacheLatch replace(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        this.checkTTL(timeToLive, EVCache.Call.REPLACE);
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.REPLACE);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), EVCache.Call.REPLACE);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.REPLACE);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.REPLACE);
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        try {
            EVCacheFuture[] futures = new EVCacheFuture[clients.length];
            CachedData cd = null;
            int index = 0;
            for (EVCacheClient client : clients) {
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : client.getTranscoder().encode(value));
                    if (evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()) != null) {
                        EVCacheValue val = new EVCacheValue(evcKey.getCanonicalKey(client.isDuetClient()), cd.getData(), cd.getFlags(), timeToLive, System.currentTimeMillis());
                        cd = this.evcacheValueTranscoder.encode(val);
                    }
                }
                Future<Boolean> future = client.replace(evcKey.getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()), cd, timeToLive, (EVCacheLatch)latch);
                futures[index++] = new EVCacheFuture(future, key, this._appName, client.getServerGroup());
            }
            if (event != null) {
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception setting the data for APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.REPLACE.name(), "write", null, status, 1, ((Integer)this.maxWriteDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("REPLACE : APP " + this._appName + ", Took " + duration + " milliSec for key : " + evcKey);
            }
        }
    }

    @Override
    public String getCachePrefix() {
        return this._cacheName;
    }

    @Override
    public String getAppName() {
        return this._appName;
    }

    public String getCacheName() {
        return this._cacheName;
    }

    @Override
    public <T> EVCacheLatch appendOrAdd(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        this.checkTTL(timeToLive, EVCache.Call.APPEND_OR_ADD);
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.APPEND_OR_ADD);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to appendOrAdd the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), EVCache.Call.APPEND_OR_ADD);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.APPEND_OR_ADD);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.APPEND_OR_ADD);
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        String status = "success";
        try {
            CachedData cd = null;
            for (EVCacheClient client : clients) {
                if (evcKey.getHashKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()) != null) {
                    throw new IllegalArgumentException("appendOrAdd is not supported when key hashing is enabled.");
                }
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : client.getTranscoder().encode(value));
                }
                Future<Boolean> future = client.appendOrAdd(evcKey.getDerivedKey(client.isDuetClient(), client.getHashingAlgorithm(), client.shouldEncodeHashKey(), client.getMaxHashingBytes()), cd, timeToLive, latch);
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("APPEND_OR_ADD : APP " + this._appName + ", Future " + future + " for key : " + evcKey);
            }
            if (event != null) {
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while appendOrAdd the data for APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception while appendOrAdd data for APP " + this._appName + ", key : " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.APPEND_OR_ADD.name(), "write", null, status, 1, ((Integer)this.maxWriteDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("APPEND_OR_ADD : APP " + this._appName + ", Took " + duration + " milliSec for key : " + evcKey);
            }
        }
    }

    @Override
    public <T> Future<Boolean>[] appendOrAdd(String key, T value, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        EVCacheLatch latch = this.appendOrAdd(key, value, tc, timeToLive, EVCacheLatch.Policy.ALL_MINUS_1);
        if (latch != null) {
            return latch.getAllFutures().toArray(new Future[latch.getAllFutures().size()]);
        }
        return new EVCacheFuture[0];
    }

    @Override
    public <T> boolean add(String key, T value, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        EVCacheLatch latch = this.add(key, value, tc, timeToLive, EVCacheLatch.Policy.NONE);
        try {
            latch.await(((Integer)this._pool.getOperationTimeout().get()).intValue(), TimeUnit.MILLISECONDS);
            List<Future<Boolean>> allFutures = latch.getAllFutures();
            for (Future<Boolean> future : allFutures) {
                if (future.get().booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            boolean throwExc;
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception adding the data for APP " + this._appName + ", key : " + key, (Throwable)e);
            }
            if (throwExc = this.doThrowException()) {
                throw new EVCacheException("Exception add data for APP " + this._appName + ", key : " + key, e);
            }
            return false;
        }
        catch (ExecutionException e) {
            boolean throwExc;
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception adding the data for APP " + this._appName + ", key : " + key, (Throwable)e);
            }
            if (throwExc = this.doThrowException()) {
                throw new EVCacheException("Exception add data for APP " + this._appName + ", key : " + key, e);
            }
            return false;
        }
    }

    @Override
    public <T> EVCacheLatch add(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        this.checkTTL(timeToLive, EVCache.Call.ADD);
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient", EVCache.Call.ADD);
            if (throwExc) {
                throw new EVCacheException("Could not find a client to Add the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheKey evcKey = this.getEVCacheKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), EVCache.Call.ADD);
        if (event != null) {
            event.setEVCacheKeys(Arrays.asList(evcKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled", EVCache.Call.ADD);
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled", EVCache.Call.ADD);
                return new EVCacheLatchImpl(policy, 0, this._appName);
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        EVCacheLatch latch = null;
        try {
            CachedData cd = null;
            if (cd == null) {
                cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : this._pool.getEVCacheClientForRead().getTranscoder().encode(value));
            }
            if (this.clientUtil == null) {
                this.clientUtil = new EVCacheClientUtil(this._pool);
            }
            latch = this.clientUtil.add(evcKey, cd, (Transcoder)this.evcacheValueTranscoder, timeToLive, policy);
            if (event != null) {
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    if (latch instanceof EVCacheLatchImpl) {
                        ((EVCacheLatchImpl)latch).scheduledFutureValidation();
                    }
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatch eVCacheLatch = latch;
            return eVCacheLatch;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception adding the data for APP " + this._appName + ", key : " + evcKey, (Throwable)ex);
            }
            if (event != null) {
                event.setStatus(status);
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception adding data for APP " + this._appName + ", key : " + evcKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.ADD.name(), "write", null, status, 1, ((Integer)this.maxWriteDuration.get()).intValue(), null).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("ADD : APP " + this._appName + ", Took " + duration + " milliSec for key : " + evcKey);
            }
        }
    }

    private DistributionSummary getTTLDistributionSummary(String operation, String type, String metric) {
        DistributionSummary distributionSummary = this.distributionSummaryMap.get(operation);
        if (distributionSummary != null) {
            return distributionSummary;
        }
        ArrayList<Tag> tagList = new ArrayList<Tag>(6);
        tagList.addAll(this.tags);
        tagList.add((Tag)new BasicTag("evc.call", operation));
        tagList.add((Tag)new BasicTag("evc.call.type", type));
        distributionSummary = EVCacheMetricsFactory.getInstance().getDistributionSummary(metric, tagList);
        this.distributionSummaryMap.put(operation, distributionSummary);
        return distributionSummary;
    }

    private Timer getTimer(String operation, String operationType, String hit, String status, int tries, long duration, ServerGroup serverGroup) {
        Timer timer;
        String name;
        String string = name = hit != null ? operation + hit : operation;
        if (status != null) {
            name = name + status;
        }
        if (tries >= 0) {
            name = name + tries;
        }
        if (serverGroup != null) {
            name = name + serverGroup.getName();
        }
        if ((timer = this.timerMap.get(name)) != null) {
            return timer;
        }
        ArrayList<Tag> tagList = new ArrayList<Tag>(7);
        tagList.addAll(this.tags);
        if (operation != null) {
            tagList.add((Tag)new BasicTag("evc.call", operation));
        }
        if (operationType != null) {
            tagList.add((Tag)new BasicTag("evc.call.type", operationType));
        }
        if (status != null) {
            tagList.add((Tag)new BasicTag("ipc.result", status));
        }
        if (hit != null) {
            tagList.add((Tag)new BasicTag("evc.cache.hit", hit));
        }
        switch (tries) {
            case 0: 
            case 1: {
                tagList.add((Tag)new BasicTag("ipc.attempt", "initial"));
                break;
            }
            case 2: {
                tagList.add((Tag)new BasicTag("ipc.attempt", "second"));
                break;
            }
            default: {
                tagList.add((Tag)new BasicTag("ipc.attempt", "third_up"));
            }
        }
        if (serverGroup != null) {
            tagList.add((Tag)new BasicTag("ipc.server.asg", serverGroup.getName()));
            tagList.add((Tag)new BasicTag("ipc.server.zone", serverGroup.getZone()));
        }
        timer = EVCacheMetricsFactory.getInstance().getPercentileTimer("evcache.client.call", tagList, Duration.ofMillis(duration));
        this.timerMap.put(name, timer);
        return timer;
    }

    protected List<Tag> getTags() {
        return this.tags;
    }
}

