/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.archaius.api.Property;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPoolMBean;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.EVCacheServerGroupConfig;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.pool.observer.EVCacheConnectionObserver;
import com.netflix.evcache.util.CircularIterator;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.evcache.util.ServerGroupCircularIterator;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Tag;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.EVCacheNode;
import net.spy.memcached.MemcachedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "REC_CATCH_EXCEPTION", "MDM_THREAD_YIELD"})
public class EVCacheClientPool
implements Runnable,
EVCacheClientPoolMBean {
    private static Logger log = LoggerFactory.getLogger(EVCacheClientPool.class);
    private final String _appName;
    private final String _zone;
    private final EVCacheClientPoolManager manager;
    private ServerGroupCircularIterator localServerGroupIterator = null;
    private final Property<Integer> _poolSize;
    private final Property<Integer> _readTimeout;
    private final Property<Integer> _bulkReadTimeout;
    public static final String DEFAULT_PORT = "11211";
    private final Property<Boolean> _retryAcrossAllReplicas;
    private long lastReconcileTime = 0L;
    private final Property<Integer> logOperations;
    private final Property<Set<String>> logOperationCalls;
    private final Property<Set<String>> cloneWrite;
    private final Property<String> duet;
    private EVCacheClientPool duetClientPool;
    private boolean isDuet;
    private final Property<Integer> _opQueueMaxBlockTime;
    private final Property<Integer> _operationTimeout;
    private final Property<Integer> _maxReadQueueSize;
    private final Property<Integer> reconcileInterval;
    private final Property<Integer> _maxRetries;
    private final Property<Boolean> _pingServers;
    private final Property<Boolean> refreshConnectionOnReadQueueFull;
    private final Property<Integer> refreshConnectionOnReadQueueFullSize;
    private final ThreadPoolExecutor asyncRefreshExecutor;
    private final Property<Boolean> _disableAsyncRefresh;
    private final List<Tag> tagList;
    private final Map<String, Gauge> gaugeMap = new ConcurrentHashMap<String, Gauge>();
    private final ReentrantLock refreshLock = new ReentrantLock();
    private final Map<ServerGroup, Property<Boolean>> writeOnlyFastPropertyMap = new ConcurrentHashMap<ServerGroup, Property<Boolean>>(){

        @Override
        public Property<Boolean> get(Object _serverGroup) {
            ServerGroup serverGroup = (ServerGroup)ServerGroup.class.cast(_serverGroup);
            Property isServerGroupInWriteOnlyMode = (Property)super.get(serverGroup);
            if (isServerGroupInWriteOnlyMode != null) {
                return isServerGroupInWriteOnlyMode;
            }
            isServerGroupInWriteOnlyMode = EVCacheConfig.getInstance().getPropertyRepository().get(EVCacheClientPool.this._appName + "." + serverGroup.getName() + ".EVCacheClientPool.writeOnly", Boolean.class).orElseGet(EVCacheClientPool.this._appName + "." + serverGroup.getZone() + ".EVCacheClientPool.writeOnly").orElse((Object)false);
            this.put(serverGroup, isServerGroupInWriteOnlyMode);
            return isServerGroupInWriteOnlyMode;
        }
    };
    private final AtomicLong numberOfModOps = new AtomicLong(0L);
    private boolean _shutdown = false;
    private Map<ServerGroup, List<EVCacheClient>> memcachedInstancesByServerGroup = new ConcurrentHashMap<ServerGroup, List<EVCacheClient>>();
    private Map<ServerGroup, List<EVCacheClient>> memcachedReadInstancesByServerGroup = new ConcurrentHashMap<ServerGroup, List<EVCacheClient>>();
    private Map<ServerGroup, List<EVCacheClient>> memcachedWriteInstancesByServerGroup = new ConcurrentSkipListMap<ServerGroup, List<EVCacheClient>>();
    private final Map<InetSocketAddress, Long> evCacheDiscoveryConnectionLostSet = new ConcurrentHashMap<InetSocketAddress, Long>();
    private Map<String, ServerGroupCircularIterator> readServerGroupByZone = new ConcurrentHashMap<String, ServerGroupCircularIterator>();
    private ServerGroupCircularIterator memcachedFallbackReadInstances = new ServerGroupCircularIterator(Collections.emptySet());
    private CircularIterator<EVCacheClient[]> allEVCacheWriteClients = new CircularIterator(Collections.emptyList());
    private final EVCacheNodeList provider;

    EVCacheClientPool(String appName, EVCacheNodeList provider, ThreadPoolExecutor asyncRefreshExecutor, EVCacheClientPoolManager manager, boolean isDuet) {
        this._appName = appName;
        this.provider = provider;
        this.asyncRefreshExecutor = asyncRefreshExecutor;
        this.manager = manager;
        this.isDuet = isDuet;
        String ec2Zone = System.getenv("EC2_AVAILABILITY_ZONE");
        if (ec2Zone == null) {
            ec2Zone = System.getProperty("EC2_AVAILABILITY_ZONE");
        }
        this._zone = ec2Zone == null ? "GLOBAL" : ec2Zone;
        EVCacheConfig config = EVCacheConfig.getInstance();
        Consumer<Integer> callback = t -> {
            this.clearState();
            this.refreshPool(true, true);
        };
        this._poolSize = config.getPropertyRepository().get(appName + ".EVCacheClientPool.poolSize", Integer.class).orElse((Object)1);
        this._poolSize.subscribe(callback);
        this._readTimeout = config.getPropertyRepository().get(appName + ".EVCacheClientPool.readTimeout", Integer.class).orElse(manager.getDefaultReadTimeout().get());
        this._readTimeout.subscribe(callback);
        this._bulkReadTimeout = config.getPropertyRepository().get(appName + ".EVCacheClientPool.bulkReadTimeout", Integer.class).orElse(this._readTimeout.get());
        this._bulkReadTimeout.subscribe(callback);
        this.refreshConnectionOnReadQueueFull = config.getPropertyRepository().get(appName + ".EVCacheClientPool.refresh.connection.on.readQueueFull", Boolean.class).orElseGet("EVCacheClientPool.refresh.connection.on.readQueueFull").orElse((Object)false);
        this.refreshConnectionOnReadQueueFullSize = config.getPropertyRepository().get(appName + ".EVCacheClientPool.refresh.connection.on.readQueueFull.size", Integer.class).orElseGet("EVCacheClientPool.refresh.connection.on.readQueueFull.size").orElse((Object)100);
        this._opQueueMaxBlockTime = config.getPropertyRepository().get(appName + ".operation.QueueMaxBlockTime", Integer.class).orElse((Object)10);
        this._opQueueMaxBlockTime.subscribe(callback);
        this._operationTimeout = config.getPropertyRepository().get(appName + ".operation.timeout", Integer.class).orElse((Object)2500);
        this._operationTimeout.subscribe(callback);
        this._maxReadQueueSize = config.getPropertyRepository().get(appName + ".max.read.queue.length", Integer.class).orElse((Object)50);
        this._retryAcrossAllReplicas = config.getPropertyRepository().get(this._appName + ".retry.all.copies", Boolean.class).orElse((Object)false);
        this._disableAsyncRefresh = config.getPropertyRepository().get(this._appName + ".disable.async.refresh", Boolean.class).orElse((Object)false);
        this._maxRetries = config.getPropertyRepository().get(this._appName + ".max.retry.count", Integer.class).orElse((Object)1);
        Function<String, Set> splitSet = t -> Arrays.stream(t.split(",")).collect(Collectors.toSet());
        this.logOperations = config.getPropertyRepository().get(appName + ".log.operation", Integer.class).orElse((Object)0);
        this.logOperationCalls = config.getPropertyRepository().get(appName + ".log.operation.calls", String.class).orElse((Object)"SET,DELETE,GMISS,TMISS,BMISS_ALL,TOUCH,REPLACE").map(splitSet);
        this.reconcileInterval = config.getPropertyRepository().get(appName + ".reconcile.interval", Integer.class).orElse((Object)600000);
        this.cloneWrite = config.getPropertyRepository().get(appName + ".clone.writes.to", String.class).map(splitSet).orElse(Collections.emptySet());
        this.cloneWrite.subscribe(i -> this.setupClones());
        this.duet = config.getPropertyRepository().get(appName + ".duet", String.class).orElse((Object)"");
        this.duet.subscribe(i -> this.setupDuet());
        this.tagList = new ArrayList<Tag>(2);
        EVCacheMetricsFactory.getInstance().addAppNameTags(this.tagList, this._appName);
        this._pingServers = config.getPropertyRepository().get(appName + ".ping.servers", Boolean.class).orElseGet("evcache.ping.servers").orElse((Object)false);
        this.setupMonitoring();
        this.refreshPool(false, true);
        if (log.isInfoEnabled()) {
            log.info(this.toString());
        }
    }

    private void setupClones() {
        for (String cloneApp : (Set)this.cloneWrite.get()) {
            this.manager.initEVCache(cloneApp);
        }
    }

    private void setupDuet() {
        this.duetClientPool = this.manager.initEVCache((String)this.duet.get(), true);
    }

    private void clearState() {
        this.cleanupMemcachedInstances(true);
        this.memcachedInstancesByServerGroup.clear();
        this.memcachedReadInstancesByServerGroup.clear();
        this.memcachedWriteInstancesByServerGroup.clear();
        this.readServerGroupByZone.clear();
        this.memcachedFallbackReadInstances = new ServerGroupCircularIterator(Collections.emptySet());
    }

    private EVCacheClient getEVCacheClientForReadInternal() {
        if (this.memcachedReadInstancesByServerGroup == null || this.memcachedReadInstancesByServerGroup.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("memcachedReadInstancesByServerGroup : " + this.memcachedReadInstancesByServerGroup);
            }
            if (this.asyncRefreshExecutor.getQueue().isEmpty()) {
                this.refreshPool(true, true);
            }
            return null;
        }
        try {
            List<EVCacheClient> clients = null;
            if (this.localServerGroupIterator != null) {
                clients = this.memcachedReadInstancesByServerGroup.get(this.localServerGroupIterator.next());
            }
            if (clients == null) {
                ServerGroup fallbackServerGroup = this.memcachedFallbackReadInstances.next();
                if (fallbackServerGroup == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("fallbackServerGroup is null.");
                    }
                    return null;
                }
                clients = this.memcachedReadInstancesByServerGroup.get(fallbackServerGroup);
            }
            return this.selectClient(clients);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for zone {}", (Object)this._zone, (Object)t);
            return null;
        }
    }

    public EVCacheClient getEVCacheClientForRead() {
        EVCacheClient evCacheClient = this.getEVCacheClientForReadInternal();
        if (evCacheClient != null) {
            return evCacheClient;
        }
        return this.duetClientPool != null ? this.duetClientPool.getEVCacheClientForRead() : null;
    }

    private List<EVCacheClient> getAllEVCacheClientForReadInternal() {
        if (this.memcachedReadInstancesByServerGroup == null || this.memcachedReadInstancesByServerGroup.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("memcachedReadInstancesByServerGroup : " + this.memcachedReadInstancesByServerGroup);
            }
            if (this.asyncRefreshExecutor.getQueue().isEmpty()) {
                this.refreshPool(true, true);
            }
            return Collections.emptyList();
        }
        try {
            List<EVCacheClient> clients = null;
            if (this.localServerGroupIterator != null) {
                clients = this.memcachedReadInstancesByServerGroup.get(this.localServerGroupIterator.next());
            }
            if (clients == null) {
                ServerGroup fallbackServerGroup = this.memcachedFallbackReadInstances.next();
                if (fallbackServerGroup == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("fallbackServerGroup is null.");
                    }
                    return Collections.emptyList();
                }
                clients = this.memcachedReadInstancesByServerGroup.get(fallbackServerGroup);
            }
            return clients;
        }
        catch (Throwable t) {
            log.error("Exception trying to get readable EVCache Instances for zone ", t);
            return Collections.emptyList();
        }
    }

    public List<EVCacheClient> getAllEVCacheClientForRead() {
        List<EVCacheClient> evCacheClients = this.getAllEVCacheClientForReadInternal();
        if (this.duetClientPool != null) {
            List<EVCacheClient> duetEVCacheClients = this.duetClientPool.getAllEVCacheClientForRead();
            if (null == evCacheClients) {
                return duetEVCacheClients;
            }
            if (null == duetEVCacheClients) {
                return evCacheClients;
            }
            evCacheClients.addAll(this.duetClientPool.getAllEVCacheClientForRead());
        }
        return evCacheClients;
    }

    private EVCacheClient selectClient(List<EVCacheClient> clients) {
        if (clients == null || clients.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("clients is null returning null and forcing pool refresh!!!");
            }
            if (this.asyncRefreshExecutor.getQueue().isEmpty()) {
                this.refreshPool(true, true);
            }
            return null;
        }
        if (clients.size() == 1) {
            return clients.get(0);
        }
        long currentVal = this.numberOfModOps.incrementAndGet();
        int index = Math.abs((int)(currentVal % (long)clients.size()));
        return clients.get(index);
    }

    private EVCacheClient getEVCacheClientForReadExcludeInternal(ServerGroup rsetUsed) {
        if (this.memcachedReadInstancesByServerGroup == null || this.memcachedReadInstancesByServerGroup.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("memcachedReadInstancesByServerGroup : " + this.memcachedReadInstancesByServerGroup);
            }
            if (this.asyncRefreshExecutor.getQueue().isEmpty()) {
                this.refreshPool(true, true);
            }
            return null;
        }
        try {
            ServerGroup fallbackServerGroup = this.memcachedFallbackReadInstances.next(rsetUsed);
            if (fallbackServerGroup == null || fallbackServerGroup.equals(rsetUsed)) {
                return null;
            }
            List<EVCacheClient> clients = this.memcachedReadInstancesByServerGroup.get(fallbackServerGroup);
            return this.selectClient(clients);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for zone {}", (Object)rsetUsed, (Object)t);
            return null;
        }
    }

    public EVCacheClient getEVCacheClientForReadExclude(ServerGroup rsetUsed) {
        EVCacheClient evCacheClient = this.getEVCacheClientForReadExcludeInternal(rsetUsed);
        if (evCacheClient != null) {
            return evCacheClient;
        }
        return this.duetClientPool != null ? this.duetClientPool.getEVCacheClientForReadExclude(rsetUsed) : null;
    }

    private EVCacheClient getEVCacheClientInternal(ServerGroup serverGroup) {
        if (this.memcachedReadInstancesByServerGroup == null || this.memcachedReadInstancesByServerGroup.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("memcachedReadInstancesByServerGroup : " + this.memcachedReadInstancesByServerGroup);
            }
            if (this.asyncRefreshExecutor.getQueue().isEmpty()) {
                this.refreshPool(true, true);
            }
            return null;
        }
        try {
            List<EVCacheClient> clients = this.memcachedReadInstancesByServerGroup.get(serverGroup);
            if (clients == null) {
                ServerGroup fallbackServerGroup = this.memcachedFallbackReadInstances.next();
                if (fallbackServerGroup == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("fallbackServerGroup is null.");
                    }
                    return null;
                }
                clients = this.memcachedReadInstancesByServerGroup.get(fallbackServerGroup);
            }
            return this.selectClient(clients);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for ServerGroup {}", (Object)serverGroup, (Object)t);
            return null;
        }
    }

    public EVCacheClient getEVCacheClient(ServerGroup serverGroup) {
        EVCacheClient evCacheClient = this.getEVCacheClientInternal(serverGroup);
        if (evCacheClient != null) {
            return evCacheClient;
        }
        return this.duetClientPool != null ? this.duetClientPool.getEVCacheClient(serverGroup) : null;
    }

    private List<EVCacheClient> getEVCacheClientsForReadExcludingInternal(ServerGroup serverGroupToExclude) {
        block12: {
            if (this.memcachedReadInstancesByServerGroup == null || this.memcachedReadInstancesByServerGroup.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("memcachedReadInstancesByServerGroup : " + this.memcachedReadInstancesByServerGroup);
                }
                if (this.asyncRefreshExecutor.getQueue().isEmpty()) {
                    this.refreshPool(true, true);
                }
                return Collections.emptyList();
            }
            try {
                if (((Boolean)this._retryAcrossAllReplicas.get()).booleanValue()) {
                    ArrayList<EVCacheClient> clients = new ArrayList<EVCacheClient>(this.memcachedReadInstancesByServerGroup.size() - 1);
                    for (ServerGroup serverGroup : this.memcachedReadInstancesByServerGroup.keySet()) {
                        List<EVCacheClient> clientList;
                        EVCacheClient client;
                        if (serverGroup.equals(serverGroupToExclude) || (client = this.selectClient(clientList = this.memcachedReadInstancesByServerGroup.get(serverGroup))) == null) continue;
                        clients.add(client);
                    }
                    return clients;
                }
                if ((Integer)this._maxRetries.get() == 1) {
                    EVCacheClient client = this.getEVCacheClientForReadExclude(serverGroupToExclude);
                    if (client != null) {
                        return Collections.singletonList(client);
                    }
                    break block12;
                }
                int maxNumberOfPossibleRetries = this.memcachedReadInstancesByServerGroup.size() - 1;
                if (maxNumberOfPossibleRetries > (Integer)this._maxRetries.get()) {
                    maxNumberOfPossibleRetries = (Integer)this._maxRetries.get();
                }
                ArrayList<EVCacheClient> clients = new ArrayList<EVCacheClient>((Integer)this._maxRetries.get());
                for (int i = 0; i < maxNumberOfPossibleRetries; ++i) {
                    ServerGroup fallbackServerGroup = this.memcachedFallbackReadInstances.next(serverGroupToExclude);
                    if (fallbackServerGroup == null) {
                        return clients;
                    }
                    List<EVCacheClient> clientList = this.memcachedReadInstancesByServerGroup.get(fallbackServerGroup);
                    EVCacheClient client = this.selectClient(clientList);
                    if (client == null) continue;
                    clients.add(client);
                }
                return clients;
            }
            catch (Throwable t) {
                log.error("Exception trying to get an readable EVCache Instances for zone {}", (Object)serverGroupToExclude, (Object)t);
            }
        }
        return Collections.emptyList();
    }

    public List<EVCacheClient> getEVCacheClientsForReadExcluding(ServerGroup serverGroupToExclude) {
        List<EVCacheClient> evCacheClients = this.getEVCacheClientsForReadExcludingInternal(serverGroupToExclude);
        if (this.duetClientPool != null) {
            List<EVCacheClient> duetEVCacheClients = this.duetClientPool.getEVCacheClientsForReadExcluding(serverGroupToExclude);
            if (null == evCacheClients) {
                return duetEVCacheClients;
            }
            if (null == duetEVCacheClients) {
                return evCacheClients;
            }
            evCacheClients.addAll(this.duetClientPool.getEVCacheClientsForReadExcluding(serverGroupToExclude));
        }
        return evCacheClients;
    }

    public boolean isInWriteOnly(ServerGroup serverGroup) {
        if (this.memcachedReadInstancesByServerGroup.containsKey(serverGroup)) {
            return false;
        }
        return this.memcachedWriteInstancesByServerGroup.containsKey(serverGroup);
    }

    private EVCacheClient[] getWriteOnlyEVCacheClientsInternal() {
        try {
            Object clients;
            if (((Set)this.cloneWrite.get()).size() == 0) {
                int size = this.memcachedWriteInstancesByServerGroup.size() - this.memcachedReadInstancesByServerGroup.size();
                if (size == 0) {
                    return new EVCacheClient[0];
                }
                EVCacheClient[] clientArr = new EVCacheClient[size];
                for (ServerGroup serverGroup : this.memcachedWriteInstancesByServerGroup.keySet()) {
                    if (this.memcachedReadInstancesByServerGroup.containsKey(serverGroup) || size <= 0) continue;
                    List<EVCacheClient> clients2 = this.memcachedWriteInstancesByServerGroup.get(serverGroup);
                    if (clients2.size() == 1) {
                        clientArr[--size] = clients2.get(0);
                        continue;
                    }
                    long currentVal = this.numberOfModOps.incrementAndGet();
                    int index = (int)(currentVal % (long)clients2.size());
                    clientArr[--size] = index < 0 ? clients2.get(0) : clients2.get(index);
                }
                return clientArr;
            }
            ArrayList<EVCacheClient> evcacheClientList = new ArrayList<EVCacheClient>();
            for (String cloneApp : (Set)this.cloneWrite.get()) {
                clients = this.manager.getEVCacheClientPool(cloneApp).getWriteOnlyEVCacheClients();
                if (clients == null || ((EVCacheClient[])clients).length == 0) continue;
                for (int i = 0; i < ((EVCacheClient[])clients).length; ++i) {
                    evcacheClientList.add(clients[i]);
                }
            }
            for (ServerGroup serverGroup : this.memcachedWriteInstancesByServerGroup.keySet()) {
                if (this.memcachedReadInstancesByServerGroup.containsKey(serverGroup)) continue;
                clients = this.memcachedWriteInstancesByServerGroup.get(serverGroup);
                if (clients.size() == 1) {
                    evcacheClientList.add((EVCacheClient)clients.get(0));
                    continue;
                }
                long currentVal = this.numberOfModOps.incrementAndGet();
                int index = (int)(currentVal % (long)clients.size());
                evcacheClientList.add(index < 0 ? (EVCacheClient)clients.get(0) : (EVCacheClient)clients.get(index));
            }
            return evcacheClientList.toArray(new EVCacheClient[0]);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an array of writable EVCache Instances", t);
            return new EVCacheClient[0];
        }
    }

    public EVCacheClient[] getWriteOnlyEVCacheClients() {
        EVCacheClient[] evCacheClients = this.getWriteOnlyEVCacheClientsInternal();
        if (this.duetClientPool != null) {
            EVCacheClient[] duetEVCacheClients = this.duetClientPool.getWriteOnlyEVCacheClients();
            if (null == evCacheClients || evCacheClients.length == 0) {
                return duetEVCacheClients;
            }
            if (null != duetEVCacheClients && duetEVCacheClients.length > 0) {
                EVCacheClient[] allEVCacheClients = Arrays.copyOf(evCacheClients, evCacheClients.length + duetEVCacheClients.length);
                System.arraycopy(duetEVCacheClients, 0, allEVCacheClients, evCacheClients.length, duetEVCacheClients.length);
                return allEVCacheClients;
            }
        }
        return evCacheClients;
    }

    EVCacheClient[] getAllWriteClients() {
        try {
            if (this.allEVCacheWriteClients != null) {
                EVCacheClient[] clientArray = this.allEVCacheWriteClients.next();
                if (clientArray == null || clientArray.length == 0) {
                    if (log.isInfoEnabled()) {
                        log.info("Refreshing the write client array.");
                    }
                    try {
                        this.refreshLock.lock();
                        clientArray = this.allEVCacheWriteClients.next();
                        if (clientArray == null || clientArray.length == 0) {
                            this.refreshPool(false, true);
                            clientArray = this.allEVCacheWriteClients.next();
                        }
                    }
                    finally {
                        this.refreshLock.unlock();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("clientArray : " + clientArray);
                }
                return clientArray;
            }
            EVCacheClient[] clientArr = new EVCacheClient[this.memcachedWriteInstancesByServerGroup.size()];
            int i = 0;
            for (ServerGroup serverGroup : this.memcachedWriteInstancesByServerGroup.keySet()) {
                List<EVCacheClient> clients = this.memcachedWriteInstancesByServerGroup.get(serverGroup);
                if (clients.size() == 1) {
                    clientArr[i++] = clients.get(0);
                    continue;
                }
                long currentVal = this.numberOfModOps.incrementAndGet();
                int index = (int)(currentVal % (long)clients.size());
                clientArr[i++] = index < 0 ? clients.get(0) : clients.get(index);
            }
            return clientArr;
        }
        catch (Throwable t) {
            log.error("Exception trying to get an array of writable EVCache Instances", t);
            return new EVCacheClient[0];
        }
    }

    private EVCacheClient[] getEVCacheClientForWriteInternal() {
        try {
            if (((Set)this.cloneWrite.get()).size() == 0) {
                return this.getAllWriteClients();
            }
            ArrayList<EVCacheClient> evcacheClientList = new ArrayList<EVCacheClient>();
            EVCacheClient[] clientArr = this.getAllWriteClients();
            for (EVCacheClient client : clientArr) {
                evcacheClientList.add(client);
            }
            for (String cloneApp : (Set)this.cloneWrite.get()) {
                EVCacheClient[] cloneWriteArray = this.manager.getEVCacheClientPool(cloneApp).getAllWriteClients();
                for (int j = 0; j < cloneWriteArray.length; ++j) {
                    evcacheClientList.add(cloneWriteArray[j]);
                }
            }
            return evcacheClientList.toArray(new EVCacheClient[0]);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an array of writable EVCache Instances", t);
            return new EVCacheClient[0];
        }
    }

    public EVCacheClient[] getEVCacheClientForWrite() {
        EVCacheClient[] evCacheClients = this.getEVCacheClientForWriteInternal();
        if (this.duetClientPool != null) {
            EVCacheClient[] duetEVCacheClients = this.duetClientPool.getEVCacheClientForWrite();
            if (null == evCacheClients || evCacheClients.length == 0) {
                return duetEVCacheClients;
            }
            if (null != duetEVCacheClients && duetEVCacheClients.length > 0) {
                EVCacheClient[] allEVCacheClients = Arrays.copyOf(evCacheClients, evCacheClients.length + duetEVCacheClients.length);
                System.arraycopy(duetEVCacheClients, 0, allEVCacheClients, evCacheClients.length, duetEVCacheClients.length);
                return allEVCacheClients;
            }
        }
        return evCacheClients;
    }

    private void refresh() throws IOException {
        this.refresh(false);
    }

    protected boolean haveInstancesInServerGroupChanged(ServerGroup serverGroup, Set<InetSocketAddress> discoveredHostsInServerGroup) {
        List<EVCacheClient> clients = this.memcachedInstancesByServerGroup.get(serverGroup);
        if (clients == null) {
            return true;
        }
        for (int i = 0; i < clients.size(); ++i) {
            boolean hashingSizeDiff;
            int size = clients.size();
            EVCacheClient client = clients.get(i);
            EVCacheConnectionObserver connectionObserver = client.getConnectionObserver();
            int activeServerCount = connectionObserver.getActiveServerCount();
            int inActiveServerCount = connectionObserver.getInActiveServerCount();
            int sizeInDiscovery = discoveredHostsInServerGroup.size();
            int sizeInHashing = client.getNodeLocator().getAll().size();
            if (i == 0) {
                this.getConfigGauge("sizeInDiscovery", serverGroup).set((double)Long.valueOf(sizeInDiscovery).longValue());
            }
            if (log.isDebugEnabled()) {
                log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tActive Count : " + activeServerCount + "\n\tInactive Count : " + inActiveServerCount + "\n\tDiscovery Count : " + sizeInDiscovery + "\n\tsizeInHashing : " + sizeInHashing);
            }
            if (log.isDebugEnabled()) {
                log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tActive Count : " + activeServerCount + "\n\tInactive Count : " + inActiveServerCount + "\n\tDiscovery Count : " + sizeInDiscovery + "\n\tsizeInHashing : " + sizeInHashing);
            }
            long currentTime = System.currentTimeMillis();
            boolean reconcile = false;
            if (currentTime - this.lastReconcileTime > (long)((Integer)this.reconcileInterval.get()).intValue()) {
                reconcile = true;
                this.lastReconcileTime = currentTime;
                this.getConfigGauge("reconcile", serverGroup).set((double)Long.valueOf(1L).longValue());
            } else {
                this.getConfigGauge("reconcile", serverGroup).set((double)Long.valueOf(0L).longValue());
            }
            boolean bl = hashingSizeDiff = sizeInHashing != sizeInDiscovery && sizeInHashing != activeServerCount;
            if (reconcile || activeServerCount != sizeInDiscovery || inActiveServerCount > 0 || hashingSizeDiff) {
                if (log.isDebugEnabled()) {
                    log.debug("\n\t" + this._appName + " & " + serverGroup + " experienced an issue.\n\tActive Server Count : " + activeServerCount);
                }
                if (log.isDebugEnabled()) {
                    log.debug("\n\tInActive Server Count : " + inActiveServerCount + "\n\tDiscovered Instances : " + sizeInDiscovery);
                }
                for (InetSocketAddress inetSocketAddress : discoveredHostsInServerGroup) {
                    if (connectionObserver.getActiveServers().containsKey(inetSocketAddress) || connectionObserver.getInActiveServers().containsKey(inetSocketAddress)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + inetSocketAddress + " not found and will shutdown the client and init it again.");
                    }
                    this.getConfigGauge("asgChanged", serverGroup).set((double)Long.valueOf(1L).longValue());
                    return true;
                }
                for (Map.Entry entry : connectionObserver.getInActiveServers().entrySet()) {
                    if (currentTime - (Long)entry.getValue() <= 1200000L || discoveredHostsInServerGroup.contains(entry.getKey())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + entry.getKey() + " not found in discovery and will shutdown the client and init it again.");
                    }
                    this.getConfigGauge("asgChanged", serverGroup).set((double)Long.valueOf(2L).longValue());
                    return true;
                }
                Collection allNodes = client.getNodeLocator().getAll();
                for (MemcachedNode node : allNodes) {
                    EVCacheNode evcNode;
                    if (!(node instanceof EVCacheNode) || (evcNode = (EVCacheNode)node).isActive() || discoveredHostsInServerGroup.contains(evcNode.getSocketAddress())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; Node : " + node + " is not active. Will shutdown the client and init it again.");
                    }
                    this.getConfigGauge("asgChanged", serverGroup).set((double)Long.valueOf(3L).longValue());
                    return true;
                }
                if (hashingSizeDiff) {
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; PoolSize : " + size + "; ActiveConnections : " + activeServerCount + "; InactiveConnections : " + inActiveServerCount + "; InDiscovery : " + sizeInDiscovery + "; InHashing : " + sizeInHashing + "; hashingSizeDiff : " + hashingSizeDiff + ". Since there is a diff in hashing size will shutdown the client and init it again.");
                    }
                    this.getConfigGauge("asgChanged", serverGroup).set((double)Long.valueOf(4L).longValue());
                    return true;
                }
                for (InetSocketAddress instance : connectionObserver.getActiveServers().keySet()) {
                    if (discoveredHostsInServerGroup.contains(instance)) continue;
                    if (!this.evCacheDiscoveryConnectionLostSet.containsKey(instance)) {
                        this.evCacheDiscoveryConnectionLostSet.put(instance, currentTime);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + instance + " not found in discovery. We will add to our list and monitor it.");
                        continue;
                    }
                    long lostDur = currentTime - this.evCacheDiscoveryConnectionLostSet.get(instance);
                    if (lostDur >= 1200000L) {
                        if (log.isDebugEnabled()) {
                            log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + instance + " not found in discovery for the past 20 mins and will shutdown the client and init it again.");
                        }
                        this.getConfigGauge("asgChanged", serverGroup).set((double)Long.valueOf(5L).longValue());
                        this.evCacheDiscoveryConnectionLostSet.remove(instance);
                        return true;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; instance : " + instance + " not found in discovery for " + lostDur + " msec.");
                }
                if (sizeInDiscovery == 0 && (activeServerCount == 0 || inActiveServerCount > activeServerCount)) {
                    if (log.isDebugEnabled()) {
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; Will shutdown the client since there are no active servers and no servers for this ServerGroup in disocvery.");
                    }
                    this.getConfigGauge("asgChanged", serverGroup).set((double)Long.valueOf(9L).longValue());
                    return true;
                }
            }
            this.getConfigGauge("asgChanged", serverGroup).set((double)Long.valueOf(0L).longValue());
        }
        this.reportPoolConifg();
        return false;
    }

    private List<InetSocketAddress> getMemcachedSocketAddressList(Set<InetSocketAddress> discoveredHostsInZone) {
        ArrayList<InetSocketAddress> memcachedNodesInZone = new ArrayList<InetSocketAddress>();
        for (InetSocketAddress hostAddress : discoveredHostsInZone) {
            memcachedNodesInZone.add(hostAddress);
        }
        return memcachedNodesInZone;
    }

    private void shutdownClientsInZone(List<EVCacheClient> clients) {
        if (clients == null || clients.isEmpty()) {
            return;
        }
        for (EVCacheClient oldClient : clients) {
            try {
                boolean obsRemoved = oldClient.removeConnectionObserver();
                if (log.isDebugEnabled()) {
                    log.debug("Connection observer removed " + obsRemoved);
                }
                boolean status = oldClient.shutdown(60L, TimeUnit.SECONDS);
                if (!log.isDebugEnabled()) continue;
                log.debug("Shutting down -> Client {" + oldClient.toString() + "}; status : " + status);
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
    }

    private void setupNewClientsByServerGroup(ServerGroup serverGroup, List<EVCacheClient> newClients) {
        List<EVCacheClient> currentClients = this.memcachedInstancesByServerGroup.put(serverGroup, newClients);
        Property<Boolean> isZoneInWriteOnlyMode = this.writeOnlyFastPropertyMap.get(serverGroup);
        if (((Boolean)isZoneInWriteOnlyMode.get()).booleanValue()) {
            this.memcachedReadInstancesByServerGroup.remove(serverGroup);
        } else {
            this.memcachedReadInstancesByServerGroup.put(serverGroup, newClients);
        }
        this.memcachedWriteInstancesByServerGroup.put(serverGroup, newClients);
        this.setupAllEVCacheWriteClientsArray();
        if (currentClients == null || currentClients.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Replaced an existing Pool for ServerGroup : " + serverGroup + "; and app " + this._appName + " ;\n\tOldClients : " + currentClients + ";\n\tNewClients : " + newClients);
        }
        for (EVCacheClient client : currentClients) {
            if (client.isShutdown()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Shutting down in Fallback -> AppName : " + this._appName + "; ServerGroup : " + serverGroup + "; client {" + client + "};");
            }
            try {
                if (client.getConnectionObserver() != null) {
                    boolean obsRemoved = client.removeConnectionObserver();
                    if (log.isDebugEnabled()) {
                        log.debug("Connection observer removed " + obsRemoved);
                    }
                }
                boolean status = client.shutdown(5L, TimeUnit.SECONDS);
                if (!log.isDebugEnabled()) continue;
                log.debug("Shutting down {" + client + "} ; status : " + status);
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
        this.shutdownClientsInZone(currentClients);
    }

    private void updateMemcachedReadInstancesByZone() {
        for (ServerGroup serverGroup : this.memcachedInstancesByServerGroup.keySet()) {
            List<EVCacheClient> clients;
            Property<Boolean> isZoneInWriteOnlyMode = this.writeOnlyFastPropertyMap.get(serverGroup);
            if (((Boolean)isZoneInWriteOnlyMode.get()).booleanValue()) {
                if (this.memcachedReadInstancesByServerGroup.containsKey(serverGroup)) {
                    this.memcachedReadInstancesByServerGroup.remove(serverGroup);
                }
            } else if (!this.memcachedReadInstancesByServerGroup.containsKey(serverGroup)) {
                this.memcachedReadInstancesByServerGroup.put(serverGroup, this.memcachedInstancesByServerGroup.get(serverGroup));
            }
            if ((clients = this.memcachedReadInstancesByServerGroup.get(serverGroup)) != null && !clients.isEmpty()) {
                EVCacheConnectionObserver connectionObserver;
                EVCacheClient client = clients.get(0);
                if (client == null || (connectionObserver = client.getConnectionObserver()) == null) continue;
                int activeServerCount = connectionObserver.getActiveServerCount();
                int inActiveServerCount = connectionObserver.getInActiveServerCount();
                if (inActiveServerCount > activeServerCount) {
                    this.memcachedReadInstancesByServerGroup.remove(serverGroup);
                    this.getConfigGauge("asgStatus", serverGroup).set((double)Long.valueOf(1L).longValue());
                    continue;
                }
                this.getConfigGauge("asgStatus", serverGroup).set((double)Long.valueOf(2L).longValue());
                continue;
            }
            List<EVCacheClient> clientsWrite = this.memcachedInstancesByServerGroup.get(serverGroup);
            if (clientsWrite == null || clientsWrite.isEmpty()) continue;
            this.getConfigGauge("asgStatus", serverGroup).set((double)Long.valueOf(0L).longValue());
        }
        if (this.memcachedReadInstancesByServerGroup.size() != this.memcachedFallbackReadInstances.getSize()) {
            this.memcachedFallbackReadInstances = new ServerGroupCircularIterator(this.memcachedReadInstancesByServerGroup.keySet());
            ConcurrentHashMap<String, HashSet<ServerGroup>> readServerGroupByZoneMap = new ConcurrentHashMap<String, HashSet<ServerGroup>>();
            for (ServerGroup serverGroup : this.memcachedReadInstancesByServerGroup.keySet()) {
                HashSet<ServerGroup> serverGroupList = (HashSet<ServerGroup>)readServerGroupByZoneMap.get(serverGroup.getZone());
                if (serverGroupList == null) {
                    serverGroupList = new HashSet<ServerGroup>();
                    readServerGroupByZoneMap.put(serverGroup.getZone(), serverGroupList);
                }
                serverGroupList.add(serverGroup);
            }
            ConcurrentHashMap<String, ServerGroupCircularIterator> concurrentHashMap = new ConcurrentHashMap<String, ServerGroupCircularIterator>();
            for (Map.Entry readServerGroupByZoneEntry : readServerGroupByZoneMap.entrySet()) {
                concurrentHashMap.put((String)readServerGroupByZoneEntry.getKey(), new ServerGroupCircularIterator((Set)readServerGroupByZoneEntry.getValue()));
            }
            this.readServerGroupByZone = concurrentHashMap;
            this.localServerGroupIterator = this.readServerGroupByZone.get(this._zone);
        }
    }

    private void cleanupMemcachedInstances(boolean force) {
        this.pingServers();
        Iterator<Map.Entry<ServerGroup, List<EVCacheClient>>> it = this.memcachedInstancesByServerGroup.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ServerGroup, List<EVCacheClient>> serverGroupEntry = it.next();
            List<EVCacheClient> instancesInAServerGroup = serverGroupEntry.getValue();
            boolean removeEntry = false;
            for (EVCacheClient client : instancesInAServerGroup) {
                EVCacheConnectionObserver connectionObserver = client.getConnectionObserver();
                if (connectionObserver.getActiveServerCount() != 0 || connectionObserver.getInActiveServerCount() <= 0) continue;
                removeEntry = true;
            }
            if (!force && !removeEntry) continue;
            ServerGroup serverGroup = serverGroupEntry.getKey();
            this.memcachedReadInstancesByServerGroup.remove(serverGroup);
            this.memcachedWriteInstancesByServerGroup.remove(serverGroup);
            for (EVCacheClient client : instancesInAServerGroup) {
                if (log.isDebugEnabled()) {
                    log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + " has no active servers. Cleaning up this ServerGroup.");
                }
                client.shutdown(0L, TimeUnit.SECONDS);
                client.getConnectionObserver().shutdown();
            }
            it.remove();
            this.allEVCacheWriteClients = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refresh(boolean force) throws IOException {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("refresh APP : " + this._appName + "; force : " + force);
        }
        try {
            Map<ServerGroup, EVCacheServerGroupConfig> instances = this.provider.discoverInstances(this._appName);
            if (log.isDebugEnabled()) {
                log.debug("instances : " + instances);
            }
            if (instances == null || instances.isEmpty()) {
                if (!this.memcachedInstancesByServerGroup.isEmpty()) {
                    this.cleanupMemcachedInstances(false);
                }
                return;
            }
            boolean updateAllEVCacheWriteClients = false;
            for (Map.Entry<ServerGroup, EVCacheServerGroupConfig> serverGroupEntry : instances.entrySet()) {
                List<InetSocketAddress> memcachedSAInServerGroup;
                Set<Object> discoveredHostsInServerGroup;
                ServerGroup serverGroup = serverGroupEntry.getKey();
                EVCacheServerGroupConfig config = serverGroupEntry.getValue();
                Set<InetSocketAddress> discoverdInstanceInServerGroup = config.getInetSocketAddress();
                String zone = serverGroup.getZone();
                Set<Object> set = discoveredHostsInServerGroup = discoverdInstanceInServerGroup == null ? Collections.emptySet() : discoverdInstanceInServerGroup;
                if (log.isDebugEnabled()) {
                    log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tSize : " + discoveredHostsInServerGroup.size() + "\n\tInstances in ServerGroup : " + discoveredHostsInServerGroup);
                }
                if (discoveredHostsInServerGroup.size() == 0 && this.memcachedInstancesByServerGroup.containsKey(serverGroup)) {
                    if (log.isDebugEnabled()) {
                        log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + " has no active servers. Cleaning up this ServerGroup.");
                    }
                    List<EVCacheClient> clients = this.memcachedInstancesByServerGroup.remove(serverGroup);
                    this.memcachedReadInstancesByServerGroup.remove(serverGroup);
                    this.memcachedWriteInstancesByServerGroup.remove(serverGroup);
                    this.setupAllEVCacheWriteClientsArray();
                    for (EVCacheClient client : clients) {
                        if (log.isDebugEnabled()) {
                            log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tClient : " + client + " will be shutdown in 30 seconds.");
                        }
                        client.shutdown(30L, TimeUnit.SECONDS);
                        client.getConnectionObserver().shutdown();
                    }
                    continue;
                }
                boolean instanceChangeInServerGroup = force;
                if (instanceChangeInServerGroup) {
                    if (log.isWarnEnabled()) {
                        log.warn("FORCE REFRESH :: AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; Changed : " + instanceChangeInServerGroup);
                    }
                } else {
                    instanceChangeInServerGroup = this.haveInstancesInServerGroupChanged(serverGroup, discoveredHostsInServerGroup);
                    if (log.isDebugEnabled()) {
                        log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tinstanceChangeInServerGroup : " + instanceChangeInServerGroup);
                    }
                    if (!instanceChangeInServerGroup) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; Changed : " + instanceChangeInServerGroup);
                        continue;
                    }
                }
                if ((memcachedSAInServerGroup = this.getMemcachedSocketAddressList(discoveredHostsInServerGroup)).size() <= 0) continue;
                int poolSize = (Integer)this._poolSize.get();
                ArrayList<EVCacheClient> newClients = new ArrayList<EVCacheClient>(poolSize);
                for (int i = 0; i < poolSize; ++i) {
                    int maxQueueSize = (Integer)EVCacheConfig.getInstance().getPropertyRepository().get(this._appName + ".max.queue.length", Integer.class).orElse((Object)16384).get();
                    try {
                        EVCacheClient client = new EVCacheClient(this._appName, zone, i, config, memcachedSAInServerGroup, maxQueueSize, this._maxReadQueueSize, this._readTimeout, this._bulkReadTimeout, this._opQueueMaxBlockTime, this._operationTimeout, this, this.isDuet);
                        newClients.add(client);
                        int id = client.getId();
                        if (log.isDebugEnabled()) {
                            log.debug("AppName :" + this._appName + "; ServerGroup : " + serverGroup + "; intit : client.getId() : " + id);
                        }
                        this.lastReconcileTime = System.currentTimeMillis();
                        continue;
                    }
                    catch (Exception e) {
                        this.incrementFailure("internal.evc.client.init.error", config.getServerGroup());
                        log.error("Unable to create EVCacheClient for app - " + this._appName + " and Server Group - " + serverGroup.getName(), (Throwable)e);
                    }
                }
                if (newClients.size() <= 0) continue;
                this.setupNewClientsByServerGroup(serverGroup, newClients);
                updateAllEVCacheWriteClients = true;
            }
            if (updateAllEVCacheWriteClients) {
                this.setupAllEVCacheWriteClientsArray();
            }
            if (this.memcachedInstancesByServerGroup.size() > instances.size()) {
                if (log.isDebugEnabled()) {
                    log.debug("\n\tAppName :" + this._appName + ";\n\tServerGroup Discovered : " + instances.keySet() + ";\n\tCurrent ServerGroup in EVCache Client : " + this.memcachedInstancesByServerGroup.keySet());
                }
                this.cleanupMemcachedInstances(false);
            }
            this.updateMemcachedReadInstancesByZone();
            this.updateQueueStats();
            if (((Boolean)this._pingServers.get()).booleanValue()) {
                this.pingServers();
            }
        }
        catch (Throwable t) {
            log.error("Exception while refreshing the Server list", t);
        }
        finally {
            EVCacheMetricsFactory.getInstance().getPercentileTimer("internal.evc.client.pool.refresh", this.tagList, Duration.ofMillis(100L)).record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
        }
        if (log.isDebugEnabled()) {
            log.debug("refresh APP : " + this._appName + "; DONE");
        }
    }

    private void setupAllEVCacheWriteClientsArray() {
        ArrayList<EVCacheClient[]> newClients = new ArrayList<EVCacheClient[]>((Integer)this._poolSize.get());
        try {
            int serverGroupSize = this.memcachedWriteInstancesByServerGroup.size();
            for (int ind = 0; ind < (Integer)this._poolSize.get(); ++ind) {
                EVCacheClient[] clientArr = new EVCacheClient[serverGroupSize];
                int i = 0;
                for (ServerGroup serverGroup : this.memcachedWriteInstancesByServerGroup.keySet()) {
                    List<EVCacheClient> clients = this.memcachedWriteInstancesByServerGroup.get(serverGroup);
                    if (clients.size() > ind) {
                        clientArr[i++] = clients.get(ind);
                        continue;
                    }
                    log.warn("Incorrect pool size detected for AppName : " + this._appName + "; PoolSize " + this._poolSize.get() + "; serverGroup : " + serverGroup + "; ind : " + ind + "; i : " + i);
                    if (clients.size() <= 0) continue;
                    clientArr[i++] = clients.get(0);
                }
                newClients.add(clientArr);
            }
            this.allEVCacheWriteClients = new CircularIterator(newClients);
        }
        catch (Throwable t) {
            log.error("Exception trying to create an array of writable EVCache Instances for App : " + this._appName, t);
        }
    }

    private void updateQueueStats() {
        for (ServerGroup serverGroup : this.memcachedInstancesByServerGroup.keySet()) {
            List<EVCacheClient> clients = this.memcachedInstancesByServerGroup.get(serverGroup);
            for (EVCacheClient client : clients) {
                this.getStatsGauge("writeQueue", client).set((double)Long.valueOf(client.getWriteQueueLength()).longValue());
                this.getStatsGauge("readQueue", client).set((double)Long.valueOf(client.getReadQueueLength()).longValue());
                if (!((Boolean)this.refreshConnectionOnReadQueueFull.get()).booleanValue()) continue;
                Collection allNodes = client.getNodeLocator().getAll();
                for (MemcachedNode node : allNodes) {
                    EVCacheNode evcNode;
                    if (!(node instanceof EVCacheNode) || (evcNode = (EVCacheNode)node).getReadQueueSize() < (Integer)this.refreshConnectionOnReadQueueFullSize.get()) continue;
                    EVCacheMetricsFactory.getInstance().getCounter("refreshOnQueueFull", evcNode.getTags()).increment();
                    client.getEVCacheMemcachedClient().reconnectNode(evcNode);
                }
            }
        }
    }

    public void pingServers() {
        try {
            Map<ServerGroup, List<EVCacheClient>> allServers = this.getAllInstancesByZone();
            for (Map.Entry<ServerGroup, List<EVCacheClient>> entry : allServers.entrySet()) {
                List<EVCacheClient> listOfClients = entry.getValue();
                for (EVCacheClient client : listOfClients) {
                    Map<SocketAddress, String> versions = client.getVersions();
                    for (Map.Entry<SocketAddress, String> vEntry : versions.entrySet()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Host : " + vEntry.getKey() + " : " + vEntry.getValue());
                    }
                }
            }
            if (this.duetClientPool != null) {
                this.duetClientPool.pingServers();
            }
        }
        catch (Throwable t) {
            log.error("Error while pinging the servers", t);
        }
    }

    public void serverGroupDisabled(ServerGroup serverGroup) {
        if (this.memcachedInstancesByServerGroup.containsKey(serverGroup)) {
            if (log.isDebugEnabled()) {
                log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + " has no active servers. Cleaning up this ServerGroup.");
            }
            List<EVCacheClient> clients = this.memcachedInstancesByServerGroup.remove(serverGroup);
            this.memcachedReadInstancesByServerGroup.remove(serverGroup);
            this.memcachedWriteInstancesByServerGroup.remove(serverGroup);
            this.setupAllEVCacheWriteClientsArray();
            for (EVCacheClient client : clients) {
                if (log.isDebugEnabled()) {
                    log.debug("\n\tApp : " + this._appName + "\n\tServerGroup : " + serverGroup + "\n\tClient : " + client + " will be shutdown in 30 seconds.");
                }
                client.shutdown(30L, TimeUnit.SECONDS);
                client.getConnectionObserver().shutdown();
            }
        }
        if (this.duetClientPool != null) {
            this.duetClientPool.serverGroupDisabled(serverGroup);
        }
    }

    public void refreshAsync(MemcachedNode node) {
        if (log.isInfoEnabled()) {
            log.info("Pool is being refresh as the EVCacheNode is not available. " + node.toString());
        }
        if (!((Boolean)this._disableAsyncRefresh.get()).booleanValue()) {
            boolean force;
            if (node instanceof EVCacheNode) {
                EVCacheNode evcNode = (EVCacheNode)node;
                EVCacheMetricsFactory.getInstance().getCounter("refreshAsync", evcNode.getTags()).increment();
            }
            boolean bl = force = System.currentTimeMillis() - this.lastReconcileTime > (long)((Integer)this.manager.getDefaultRefreshInterval().get() * 1000);
            if (!force) {
                force = !node.isActive();
            }
            this.refreshPool(true, force);
        }
        if (this.duetClientPool != null) {
            this.duetClientPool.refreshAsync(node);
        }
    }

    @Override
    public void run() {
        block2: {
            try {
                this.refresh();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error Refreshing EVCache Instance list for " + this._appName, t);
            }
        }
    }

    void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug("EVCacheClientPool for App : " + this._appName + " and Zone : " + this._zone + " is being shutdown.");
        }
        this._shutdown = true;
        for (List<EVCacheClient> instancesInAZone : this.memcachedInstancesByServerGroup.values()) {
            for (EVCacheClient client : instancesInAZone) {
                client.shutdown(30L, TimeUnit.SECONDS);
                client.getConnectionObserver().shutdown();
            }
        }
        this.setupMonitoring();
    }

    private Gauge getConfigGauge(String metric, ServerGroup serverGroup) {
        String name = serverGroup == null ? metric : metric + serverGroup.getName() + this.isInWriteOnly(serverGroup);
        Gauge gauge = this.gaugeMap.get(name);
        if (gauge != null) {
            return gauge;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(5);
        EVCacheMetricsFactory.getInstance().addAppNameTags(tags, this._appName);
        tags.add((Tag)new BasicTag("evc.config", metric));
        if (serverGroup != null) {
            tags.add((Tag)new BasicTag("ipc.server.asg", serverGroup.getName()));
        }
        Id id = EVCacheMetricsFactory.getInstance().getId("internal.evc.client.pool.asg.config", tags);
        gauge = EVCacheMetricsFactory.getInstance().getRegistry().gauge(id);
        this.gaugeMap.put(name, gauge);
        return gauge;
    }

    private Gauge getStatsGauge(String metric, EVCacheClient client) {
        String name = metric + client.getServerGroupName();
        Gauge gauge = this.gaugeMap.get(name);
        if (gauge != null) {
            return gauge;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(4);
        EVCacheMetricsFactory.getInstance().addAppNameTags(tags, this._appName);
        tags.add((Tag)new BasicTag("evc.stat.name", metric));
        tags.add((Tag)new BasicTag("evc.connection.id", String.valueOf(client.getId())));
        tags.add((Tag)new BasicTag("ipc.server.asg", client.getServerGroupName()));
        Id id = EVCacheMetricsFactory.getInstance().getId("internal.evc.client.stats", tags);
        gauge = EVCacheMetricsFactory.getInstance().getRegistry().gauge(id);
        this.gaugeMap.put(name, gauge);
        return gauge;
    }

    private void incrementFailure(String metric, ServerGroup serverGroup) {
        ArrayList<Tag> tags = new ArrayList<Tag>(4);
        EVCacheMetricsFactory.getInstance().addAppNameTags(tags, this._appName);
        tags.add((Tag)new BasicTag("evc.config", metric));
        tags.add((Tag)new BasicTag("ipc.server.asg", serverGroup.getName()));
        EVCacheMetricsFactory.getInstance().increment("internal.evc.client.init.error", tags);
    }

    private void reportPoolConifg() {
        int size = this.getPoolSize();
        for (ServerGroup key : this.memcachedInstancesByServerGroup.keySet()) {
            List<EVCacheClient> writeClients;
            List<EVCacheClient> readClients;
            this.getConfigGauge("poolSize", key).set((double)this.memcachedInstancesByServerGroup.get(key).size());
            EVCacheClient client = this.memcachedInstancesByServerGroup.get(key).get(0);
            if (client == null) continue;
            this.getConfigGauge("readTimeout", key).set((double)((Integer)this.getReadTimeout().get()).intValue());
            this.getConfigGauge("bulkReadTimeout", key).set((double)((Integer)this.getBulkReadTimeout().get()).intValue());
            this.getConfigGauge("numberOfServerGoups", key).set((double)this.memcachedInstancesByServerGroup.size());
            this.getConfigGauge("maxReadQueueLength", key).set((double)((Integer)this._maxReadQueueSize.get()).intValue());
            this.getConfigGauge("instanceCount", key).set((double)client.getMemcachedNodesInZone().size());
            EVCacheConnectionObserver connectionObserver = client.getConnectionObserver();
            if (connectionObserver != null) {
                int activeServerCount = connectionObserver.getActiveServerCount();
                int inActiveServerCount = connectionObserver.getInActiveServerCount();
                int sizeInHashing = client.getNodeLocator().getAll().size();
                this.getConfigGauge("activeServerCount", key).set((double)Long.valueOf(activeServerCount).longValue());
                this.getConfigGauge("activeConnectionCount", key).set((double)Long.valueOf(activeServerCount * size).longValue());
                this.getConfigGauge("inActiveServerCount", key).set((double)Long.valueOf(inActiveServerCount).longValue());
                this.getConfigGauge("sizeInHashing", key).set((double)Long.valueOf(sizeInHashing).longValue());
            }
            if ((readClients = this.memcachedReadInstancesByServerGroup.get(key)) != null && readClients.size() > 0) {
                this.getConfigGauge("readInstances", key).set((double)Long.valueOf(readClients.get(0).getConnectionObserver().getActiveServerCount()).longValue());
            }
            if ((writeClients = this.memcachedWriteInstancesByServerGroup.get(key)) == null || writeClients.size() <= 0) continue;
            this.getConfigGauge("writeInstances", key).set((double)Long.valueOf(writeClients.get(0).getConnectionObserver().getActiveServerCount()).longValue());
        }
    }

    private void setupMonitoring() {
        block5: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this._appName + ",SubGroup=pool");
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                if (!this._shutdown) {
                    mbeanServer.registerMBean(this, mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception", (Throwable)e);
            }
        }
    }

    @Override
    public int getInstanceCount() {
        int instances = 0;
        for (ServerGroup serverGroup : this.memcachedInstancesByServerGroup.keySet()) {
            instances += this.memcachedInstancesByServerGroup.get(serverGroup).get(0).getConnectionObserver().getActiveServerCount();
        }
        if (this.duetClientPool != null) {
            instances += this.duetClientPool.getInstanceCount();
        }
        return instances;
    }

    @Override
    public Map<String, String> getInstancesByZone() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (ServerGroup zone : this.memcachedInstancesByServerGroup.keySet()) {
            List<EVCacheClient> instanceList = this.memcachedInstancesByServerGroup.get(zone);
            instanceMap.put(zone.toString(), instanceList.toString());
        }
        if (this.duetClientPool != null) {
            instanceMap.putAll(this.duetClientPool.getInstancesByZone());
        }
        return instanceMap;
    }

    @Override
    public Map<String, Integer> getInstanceCountByZone() {
        HashMap<String, Integer> instancesByZone = new HashMap<String, Integer>(this.memcachedInstancesByServerGroup.size() * 2);
        for (ServerGroup zone : this.memcachedInstancesByServerGroup.keySet()) {
            instancesByZone.put(zone.getName(), this.memcachedInstancesByServerGroup.get(zone).get(0).getConnectionObserver().getActiveServerCount());
        }
        if (this.duetClientPool != null) {
            instancesByZone.putAll(this.duetClientPool.getInstanceCountByZone());
        }
        return instancesByZone;
    }

    @Override
    public Map<String, String> getReadZones() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (ServerGroup key : this.memcachedReadInstancesByServerGroup.keySet()) {
            instanceMap.put(key.getName(), this.memcachedReadInstancesByServerGroup.get(key).toString());
        }
        if (this.duetClientPool != null) {
            instanceMap.putAll(this.duetClientPool.getReadZones());
        }
        return instanceMap;
    }

    @Override
    public Map<String, Integer> getReadInstanceCountByZone() {
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        for (ServerGroup key : this.memcachedReadInstancesByServerGroup.keySet()) {
            instanceMap.put(key.getName(), this.memcachedReadInstancesByServerGroup.get(key).get(0).getConnectionObserver().getActiveServerCount());
        }
        if (this.duetClientPool != null) {
            instanceMap.putAll(this.duetClientPool.getReadInstanceCountByZone());
        }
        return instanceMap;
    }

    @Override
    public Map<String, String> getWriteZones() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (ServerGroup key : this.memcachedWriteInstancesByServerGroup.keySet()) {
            instanceMap.put(key.toString(), this.memcachedWriteInstancesByServerGroup.get(key).toString());
        }
        if (this.duetClientPool != null) {
            instanceMap.putAll(this.duetClientPool.getWriteZones());
        }
        return instanceMap;
    }

    private Map<ServerGroup, List<EVCacheClient>> getAllInstancesByZoneInternal() {
        return Collections.unmodifiableMap(this.memcachedInstancesByServerGroup);
    }

    public Map<ServerGroup, List<EVCacheClient>> getAllInstancesByZone() {
        if (this.duetClientPool != null) {
            ConcurrentHashMap<ServerGroup, List<EVCacheClient>> allInstanceMap = new ConcurrentHashMap<ServerGroup, List<EVCacheClient>>();
            allInstanceMap.putAll(this.getAllInstancesByZoneInternal());
            allInstanceMap.putAll(this.duetClientPool.getAllInstancesByZone());
            return Collections.unmodifiableMap(allInstanceMap);
        }
        return this.getAllInstancesByZoneInternal();
    }

    Map<ServerGroup, List<EVCacheClient>> getAllInstancesByServerGroupInternal() {
        return this.memcachedInstancesByServerGroup;
    }

    public Map<ServerGroup, List<EVCacheClient>> getAllInstancesByServerGroup() {
        if (this.duetClientPool == null) {
            return this.getAllInstancesByServerGroupInternal();
        }
        ConcurrentHashMap<ServerGroup, List<EVCacheClient>> allInstancesByServerGroup = new ConcurrentHashMap<ServerGroup, List<EVCacheClient>>();
        allInstancesByServerGroup.putAll(this.getAllInstancesByServerGroupInternal());
        allInstancesByServerGroup.putAll(this.duetClientPool.getAllInstancesByServerGroup());
        return allInstancesByServerGroup;
    }

    private Map<String, Integer> getWriteInstanceCountByZoneInternal() {
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        for (ServerGroup key : this.memcachedWriteInstancesByServerGroup.keySet()) {
            instanceMap.put(key.toString(), this.memcachedWriteInstancesByServerGroup.get(key).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instanceMap;
    }

    @Override
    public Map<String, Integer> getWriteInstanceCountByZone() {
        Map<String, Integer> instanceMap = this.getWriteInstanceCountByZoneInternal();
        if (this.duetClientPool != null) {
            instanceMap.putAll(this.duetClientPool.getWriteInstanceCountByZone());
        }
        return instanceMap;
    }

    private Map<String, String> getReadServerGroupByZoneInternal() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (String key : this.readServerGroupByZone.keySet()) {
            instanceMap.put(key, this.readServerGroupByZone.get(key).toString());
        }
        return instanceMap;
    }

    @Override
    public Map<String, String> getReadServerGroupByZone() {
        Map<String, String> instanceMap = this.getReadServerGroupByZoneInternal();
        if (this.duetClientPool != null) {
            instanceMap.putAll(this.duetClientPool.getReadServerGroupByZone());
        }
        return instanceMap;
    }

    @Override
    public void refreshPool() {
        this.refreshPool(false, true);
        if (this.duetClientPool != null) {
            this.duetClientPool.refreshPool(false, true);
        }
    }

    public void refreshPool(boolean async, final boolean force) {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug("Refresh Pool : async : " + async + "; force : " + force);
            }
            try {
                if (async) {
                    this.asyncRefreshExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                EVCacheClientPool.this.refresh(force);
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                } else {
                    this.refresh(force);
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("Error Refreshing EVCache Instance list from MBean : " + this._appName, t);
            }
        }
        if (this.duetClientPool != null) {
            this.duetClientPool.refreshPool(async, force);
        }
    }

    @Override
    public String getFallbackServerGroup() {
        if (this.memcachedFallbackReadInstances.getSize() != 0 || this.duetClientPool == null) {
            return this.memcachedFallbackReadInstances.toString();
        }
        return this.duetClientPool.getFallbackServerGroup();
    }

    public boolean supportsFallback() {
        return this.memcachedFallbackReadInstances.getSize() > 1 || this.duetClientPool != null && this.duetClientPool.supportsFallback();
    }

    public boolean isLogEventEnabled() {
        return (Integer)this.logOperations.get() > 0;
    }

    public boolean shouldLogOperation(String key, String op) {
        if (!this.isLogEventEnabled()) {
            return false;
        }
        if (!((Set)this.logOperationCalls.get()).contains(op)) {
            return false;
        }
        return key.hashCode() % 1000 <= (Integer)this.logOperations.get();
    }

    @Override
    public String getLocalServerGroupCircularIterator() {
        return this.localServerGroupIterator == null ? (this.duetClientPool == null ? "NONE" : this.duetClientPool.getLocalServerGroupCircularIterator()) : this.localServerGroupIterator.toString();
    }

    @Override
    public String getEVCacheWriteClientsCircularIterator() {
        return this.allEVCacheWriteClients == null ? (this.duetClientPool == null ? "NONE" : this.duetClientPool.getEVCacheWriteClientsCircularIterator()) : this.allEVCacheWriteClients.toString();
    }

    @Override
    public String getPoolDetails() {
        return this.toString();
    }

    public String toString() {
        return "\nEVCacheClientPool [\n\t_appName=" + this._appName + ",\n\t_zone=" + this._zone + ",\n\tlocalServerGroupIterator=" + this.localServerGroupIterator + ",\n\t_poolSize=" + this._poolSize + ",\n\t_readTimeout=" + this._readTimeout + ",\n\t_bulkReadTimeout=" + this._bulkReadTimeout + ",\n\tlogOperations=" + this.logOperations + ",\n\t_opQueueMaxBlockTime=" + this._opQueueMaxBlockTime + ",\n\t_operationTimeout=" + this._operationTimeout + ",\n\t_maxReadQueueSize=" + this._maxReadQueueSize + ",\n\t_pingServers=" + this._pingServers + ",\n\twriteOnlyFastPropertyMap=" + this.writeOnlyFastPropertyMap + ",\n\tnumberOfModOps=" + this.numberOfModOps.get() + ",\n\t_shutdown=" + this._shutdown + ",\n\tmemcachedInstancesByServerGroup=" + this.memcachedInstancesByServerGroup + ",\n\tmemcachedReadInstancesByServerGroup=" + this.memcachedReadInstancesByServerGroup + ",\n\tmemcachedWriteInstancesByServerGroup=" + this.memcachedWriteInstancesByServerGroup + ",\n\treadServerGroupByZone=" + this.readServerGroupByZone + ",\n\tmemcachedFallbackReadInstances=" + this.memcachedFallbackReadInstances + "\n], \n\tallEVCacheWriteClients=" + this.allEVCacheWriteClients + "\n]" + (this.duetClientPool == null ? "" : this.duetClientPool.toString());
    }

    public int getPoolSize() {
        return (Integer)this._poolSize.get() + (this.duetClientPool == null ? 0 : this.duetClientPool.getPoolSize());
    }

    public Property<Integer> getLogOperations() {
        return this.logOperations;
    }

    public Property<Integer> getOpQueueMaxBlockTime() {
        return this._opQueueMaxBlockTime;
    }

    public Property<Integer> getOperationTimeout() {
        return this._operationTimeout;
    }

    public Property<Integer> getMaxReadQueueSize() {
        return this._maxReadQueueSize;
    }

    public Property<Boolean> getPingServers() {
        return this._pingServers;
    }

    public long getNumberOfModOps() {
        return this.numberOfModOps.get();
    }

    public boolean isShutdown() {
        return this._shutdown;
    }

    public String getZone() {
        return this._zone;
    }

    public String getAppName() {
        return this._appName;
    }

    public EVCacheClientPoolManager getEVCacheClientPoolManager() {
        return this.manager;
    }

    public Map<ServerGroup, Property<Boolean>> getWriteOnlyFastPropertyMap() {
        if (this.duetClientPool != null) {
            ConcurrentHashMap<ServerGroup, Property<Boolean>> allMap = new ConcurrentHashMap<ServerGroup, Property<Boolean>>();
            allMap.putAll(this.writeOnlyFastPropertyMap);
            allMap.putAll(this.duetClientPool.getWriteOnlyFastPropertyMap());
            return Collections.unmodifiableMap(allMap);
        }
        return Collections.unmodifiableMap(this.writeOnlyFastPropertyMap);
    }

    public Property<Integer> getReadTimeout() {
        return this._readTimeout;
    }

    public Property<Integer> getBulkReadTimeout() {
        return this._bulkReadTimeout;
    }

    public int join() {
        int size = 0;
        int counter = 0;
        do {
            for (List<EVCacheClient> clientList : this.getAllInstancesByServerGroup().values()) {
                for (EVCacheClient client : clientList) {
                    size += client.getWriteQueueLength();
                    size += client.getReadQueueLength();
                }
            }
            if (size <= 0) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                log.error("");
            }
        } while (counter++ <= 3000 && size > 0);
        return size;
    }

    public long getLastReconcileTime() {
        return this.lastReconcileTime;
    }

    public Property<Set<String>> getOperationToLog() {
        return this.logOperationCalls;
    }
}

