/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.event.throttle;

import com.netflix.archaius.api.Property;
import com.netflix.evcache.event.EVCacheEvent;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.util.EVCacheConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ThrottleListener
implements EVCacheEventListener {
    private static final Logger log = LoggerFactory.getLogger(ThrottleListener.class);
    private final Map<String, Property<Set<String>>> _ignoreOperationsMap;
    private final Property<Boolean> enableThrottleOperations;
    private final EVCacheClientPoolManager poolManager;

    @Inject
    public ThrottleListener(EVCacheClientPoolManager poolManager) {
        this.poolManager = poolManager;
        this._ignoreOperationsMap = new ConcurrentHashMap<String, Property<Set<String>>>();
        this.enableThrottleOperations = EVCacheConfig.getInstance().getPropertyRepository().get("EVCacheThrottler.throttle.operations", Boolean.class).orElse((Object)false);
        this.enableThrottleOperations.subscribe(i -> this.setupListener());
        if (((Boolean)this.enableThrottleOperations.get()).booleanValue()) {
            this.setupListener();
        }
    }

    private void setupListener() {
        if (((Boolean)this.enableThrottleOperations.get()).booleanValue()) {
            this.poolManager.addEVCacheEventListener(this);
        } else {
            this.poolManager.removeEVCacheEventListener(this);
        }
    }

    @Override
    public void onStart(EVCacheEvent e) {
    }

    @Override
    public boolean onThrottle(EVCacheEvent e) {
        if (!((Boolean)this.enableThrottleOperations.get()).booleanValue()) {
            return false;
        }
        String appName = e.getAppName();
        Property throttleCalls = this._ignoreOperationsMap.get(appName).orElse(Collections.emptySet());
        if (((Set)throttleCalls.get()).size() > 0 && ((Set)throttleCalls.get()).contains(e.getCall().name())) {
            if (log.isDebugEnabled()) {
                log.debug("Call : " + (Object)((Object)e.getCall()) + " is throttled");
            }
            return true;
        }
        return false;
    }

    @Override
    public void onComplete(EVCacheEvent e) {
    }

    @Override
    public void onError(EVCacheEvent e, Throwable t) {
    }
}

