/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.util;

import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyListener;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.evcache.config.EVCachePersistedProperties;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;

public class EVCacheConfig {
    private static EVCacheConfig INSTANCE;
    private static PropertyRepository propertyRepository;

    @Inject
    public EVCacheConfig(PropertyRepository repository) {
        PropertyRepository _propertyRepository = null;
        if (repository == null) {
            try {
                DefaultCompositeConfig applicationConfig = new DefaultCompositeConfig(true);
                DefaultCompositeConfig remoteLayer = new DefaultCompositeConfig(true);
                applicationConfig.addConfig("RUNTIME", (Config)new DefaultSettableConfig());
                applicationConfig.addConfig("REMOTE", (Config)remoteLayer);
                applicationConfig.addConfig("SYSTEM", (Config)SystemConfig.INSTANCE);
                applicationConfig.addConfig("ENVIRONMENT", (Config)EnvironmentConfig.INSTANCE);
                EVCachePersistedProperties remote = new EVCachePersistedProperties();
                remoteLayer.addConfig("remote-1", (Config)remote.getPollingDynamicConfig());
                _propertyRepository = new DefaultPropertyFactory((Config)applicationConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
                _propertyRepository = new DefaultPropertyFactory((Config)new DefaultCompositeConfig());
            }
        } else {
            _propertyRepository = repository;
        }
        propertyRepository = new EVCachePropertyRepository(_propertyRepository);
        INSTANCE = this;
    }

    private EVCacheConfig() {
        this(null);
    }

    public static EVCacheConfig getInstance() {
        if (INSTANCE == null) {
            new EVCacheConfig();
        }
        return INSTANCE;
    }

    public PropertyRepository getPropertyRepository() {
        return propertyRepository;
    }

    public static void setPropertyRepository(PropertyRepository repository) {
        propertyRepository = repository;
    }

    class EVCacheProperty<T>
    implements Property<T> {
        private final Property<T> property;

        EVCacheProperty(Property<T> prop) {
            this.property = prop;
        }

        public T get() {
            return (T)this.property.get();
        }

        public String getKey() {
            return this.property.getKey();
        }

        public void addListener(PropertyListener<T> listener) {
            this.property.addListener(listener);
        }

        public void removeListener(PropertyListener<T> listener) {
            this.property.removeListener(listener);
        }

        public Property.Subscription onChange(Consumer<T> consumer) {
            return this.property.onChange(consumer);
        }

        public Property.Subscription subscribe(Consumer<T> consumer) {
            return this.property.subscribe(consumer);
        }

        public Property<T> orElse(T defaultValue) {
            return new EVCacheProperty<T>(this.property.orElse(defaultValue));
        }

        public Property<T> orElseGet(String key) {
            return new EVCacheProperty<T>(this.property.orElseGet(key));
        }

        public <S> Property<S> map(Function<T, S> mapper) {
            return this.property.map(mapper);
        }

        public String toString() {
            return "EVCacheProperty [Key=" + this.getKey() + ",value=" + this.get() + "]";
        }
    }

    class EVCachePropertyRepository
    implements PropertyRepository {
        private final PropertyRepository delegate;

        EVCachePropertyRepository(PropertyRepository delegate) {
            this.delegate = delegate;
        }

        public <T> Property<T> get(String key, Class<T> type) {
            return new EVCacheProperty(this.delegate.get(key, type));
        }

        public <T> Property<T> get(String key, Type type) {
            return new EVCacheProperty(this.delegate.get(key, type));
        }
    }
}

