/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.pool.ChunkTranscoder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CachedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheClientUtil {
    private static final Logger log = LoggerFactory.getLogger(EVCacheClientUtil.class);
    private final ChunkTranscoder ct = new ChunkTranscoder();
    private final String _appName;
    private final EVCacheClientPool _pool;

    public EVCacheClientUtil(EVCacheClientPool pool) {
        this._pool = pool;
        this._appName = pool.getAppName();
    }

    public EVCacheLatch add(String canonicalKey, CachedData cd, int timeToLive, EVCacheLatch.Policy policy) throws Exception {
        if (cd == null) {
            return null;
        }
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        Boolean firstStatus = null;
        for (EVCacheClient client : clients) {
            boolean status;
            Future<Boolean> f = client.add(canonicalKey, timeToLive, cd, latch);
            if (log.isDebugEnabled()) {
                log.debug("ADD : Op Submitted : APP " + this._appName + ", key " + canonicalKey + "; future : " + f + "; client : " + client);
            }
            if (!(status = f.get().booleanValue())) {
                if (firstStatus == null) {
                    for (int i = 0; i < clients.length; ++i) {
                        latch.countDown();
                    }
                    return latch;
                }
                return this.fixup(client, clients, canonicalKey, timeToLive, policy);
            }
            if (firstStatus != null) continue;
            firstStatus = status;
        }
        return latch;
    }

    private EVCacheLatch fixup(EVCacheClient sourceClient, EVCacheClient[] destClients, String canonicalKey, int timeToLive, EVCacheLatch.Policy policy) {
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy, destClients.length, this._appName);
        try {
            CachedData readData = sourceClient.getAndTouch(canonicalKey, this.ct, timeToLive, false, false);
            if (readData != null) {
                for (EVCacheClient destClient : destClients) {
                    destClient.set(canonicalKey, readData, timeToLive, (EVCacheLatch)latch);
                }
            }
            latch.await(((Integer)this._pool.getOperationTimeout().get()).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("Error reading the data", (Throwable)e);
        }
        return latch;
    }
}

