/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.util;

import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.SystemConfig;
import javax.inject.Inject;

public class EVCacheConfig {
    private static EVCacheConfig INSTANCE;
    private static PropertyRepository propertyRepository;

    @Inject
    public EVCacheConfig(PropertyRepository repository) {
        if (repository == null) {
            try {
                DefaultCompositeConfig applicationConfig = new DefaultCompositeConfig();
                applicationConfig.addConfig("SYSTEM", (Config)SystemConfig.INSTANCE);
                applicationConfig.addConfig("ENVIRONMENT", (Config)EnvironmentConfig.INSTANCE);
                propertyRepository = new DefaultPropertyFactory((Config)applicationConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
                propertyRepository = new DefaultPropertyFactory((Config)new DefaultCompositeConfig());
            }
        } else {
            propertyRepository = repository;
        }
        INSTANCE = this;
    }

    private EVCacheConfig() {
        this(null);
    }

    public static EVCacheConfig getInstance() {
        if (INSTANCE == null) {
            new EVCacheConfig();
        }
        return INSTANCE;
    }

    public PropertyRepository getPropertyRepository() {
        return propertyRepository;
    }

    public static void setPropertyRepository(PropertyRepository repository) {
        propertyRepository = repository;
    }
}

