/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.event.throttle;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicStringSetProperty;
import com.netflix.evcache.event.EVCacheEvent;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.util.EVCacheConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ThrottleListener
implements EVCacheEventListener {
    private static final Logger log = LoggerFactory.getLogger(ThrottleListener.class);
    private final Map<String, DynamicStringSetProperty> _ignoreOperationsMap;
    private final DynamicBooleanProperty enableThrottleOperations;
    private final EVCacheClientPoolManager poolManager;

    @Inject
    public ThrottleListener(EVCacheClientPoolManager poolManager) {
        this.poolManager = poolManager;
        this._ignoreOperationsMap = new ConcurrentHashMap<String, DynamicStringSetProperty>();
        this.enableThrottleOperations = EVCacheConfig.getInstance().getDynamicBooleanProperty("EVCacheThrottler.throttle.operations", false);
        this.enableThrottleOperations.addCallback(new Runnable(){

            @Override
            public void run() {
                ThrottleListener.this.setupListener();
            }
        });
        if (this.enableThrottleOperations.get()) {
            this.setupListener();
        }
    }

    private void setupListener() {
        if (this.enableThrottleOperations.get()) {
            this.poolManager.addEVCacheEventListener(this);
        } else {
            this.poolManager.removeEVCacheEventListener(this);
        }
    }

    @Override
    public void onStart(EVCacheEvent e) {
    }

    @Override
    public boolean onThrottle(EVCacheEvent e) {
        if (!this.enableThrottleOperations.get()) {
            return false;
        }
        String appName = e.getAppName();
        DynamicStringSetProperty throttleCalls = this._ignoreOperationsMap.get(appName);
        if (throttleCalls == null) {
            throttleCalls = new DynamicStringSetProperty(appName + ".throttle.calls", "");
            this._ignoreOperationsMap.put(appName, throttleCalls);
        }
        if (throttleCalls.get().size() > 0 && throttleCalls.get().contains(e.getCall().name())) {
            if (log.isDebugEnabled()) {
                log.debug("Call : " + (Object)((Object)e.getCall()) + " is throttled");
            }
            return true;
        }
        return false;
    }

    @Override
    public void onComplete(EVCacheEvent e) {
    }

    @Override
    public void onError(EVCacheEvent e, Throwable t) {
    }
}

