/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.metrics;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.histogram.PercentileTimer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@SuppressFBWarnings(value={"NF_LOCAL_FAST_PROPERTY", "PMB_POSSIBLE_MEMORY_BLOAT"}, justification="Creates only when needed")
public final class EVCacheMetricsFactory {
    private final Map<String, Number> monitorMap = new ConcurrentHashMap<String, Number>();
    private final Map<String, Counter> counterMap = new ConcurrentHashMap<String, Counter>();
    private final Map<String, DistributionSummary> distributionSummaryMap = new ConcurrentHashMap<String, DistributionSummary>();
    private final Lock writeLock = new ReentrantReadWriteLock().writeLock();
    private final Map<String, Timer> timerMap = new HashMap<String, Timer>();
    private static final EVCacheMetricsFactory INSTANCE = new EVCacheMetricsFactory();

    private EVCacheMetricsFactory() {
    }

    public static EVCacheMetricsFactory getInstance() {
        return INSTANCE;
    }

    public Map<String, Counter> getAllCounters() {
        return this.counterMap;
    }

    public Map<String, Timer> getAllTimers() {
        return this.timerMap;
    }

    public Map<String, Number> getAllMonitor() {
        return this.monitorMap;
    }

    public Map<String, DistributionSummary> getAllDistributionSummaryMap() {
        return this.distributionSummaryMap;
    }

    public Registry getRegistry() {
        return Spectator.globalRegistry();
    }

    public AtomicLong getLongGauge(String name) {
        return this.getLongGauge(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicLong getLongGauge(String cName, Collection<Tag> tags) {
        String name = tags != null ? cName + tags.toString() : cName;
        AtomicLong gauge = (AtomicLong)this.monitorMap.get(name);
        if (gauge == null) {
            this.writeLock.lock();
            try {
                if (this.monitorMap.containsKey(name)) {
                    gauge = (AtomicLong)this.monitorMap.get(name);
                } else {
                    gauge = tags != null ? (AtomicLong)this.getRegistry().gauge(cName, tags, (Number)new AtomicLong()) : (AtomicLong)this.getRegistry().gauge(cName, (Number)new AtomicLong());
                    this.monitorMap.put(name, gauge);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return gauge;
    }

    public Id getId(String name, List<Tag> tags) {
        tags.add((Tag)new BasicTag("owner", "evcache"));
        return this.getRegistry().createId(name, tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter getCounter(String cName, List<Tag> tags) {
        String name = tags != null ? cName + tags.toString() : cName;
        Counter counter = this.counterMap.get(name);
        if (counter == null) {
            this.writeLock.lock();
            try {
                if (this.counterMap.containsKey(name)) {
                    counter = this.counterMap.get(name);
                } else {
                    if (tags == null) {
                        tags = new ArrayList<Tag>(1);
                    }
                    tags.add((Tag)new BasicTag("owner", "evcache"));
                    counter = this.getRegistry().counter(cName, tags);
                    this.counterMap.put(name, counter);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return counter;
    }

    public Counter getCounter(String name) {
        return this.getCounter(name, null);
    }

    public void increment(String name) {
        Counter counter = this.getCounter(name);
        counter.increment();
    }

    public void increment(String cName, List<Tag> tags) {
        Counter counter = this.getCounter(cName, tags);
        counter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getPercentileTimer(String metric, Collection<Tag> tags) {
        String name = tags != null ? metric + tags.toString() : metric;
        Timer duration = this.timerMap.get(name);
        if (duration != null) {
            return duration;
        }
        this.writeLock.lock();
        try {
            if (this.timerMap.containsKey(name)) {
                Timer timer = this.timerMap.get(name);
                return timer;
            }
            Id id = this.getRegistry().createId(metric);
            if (tags != null) {
                id = id.withTags(tags);
            }
            PercentileTimer _duration = PercentileTimer.get((Registry)this.getRegistry(), (Id)id);
            this.timerMap.put(name, (Timer)_duration);
            PercentileTimer percentileTimer = _duration;
            return percentileTimer;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public DistributionSummary getDistributionSummary(String name, Collection<Tag> tags) {
        String metricName = tags != null ? name + tags.toString() : name;
        DistributionSummary _ds = this.distributionSummaryMap.get(metricName);
        if (_ds != null) {
            return _ds;
        }
        CompositeRegistry registry = Spectator.globalRegistry();
        if (registry != null) {
            Id id = registry.createId(name);
            if (tags != null) {
                id = id.withTags(tags);
            }
            DistributionSummary ds = registry.distributionSummary(id);
            this.distributionSummaryMap.put(metricName, ds);
            return ds;
        }
        return null;
    }
}

