/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.evcache.EVCacheGetOperationListener;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheBulkGetFuture;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.CASValue;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.ListenableFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.ConcatenationType;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.protocol.binary.EVCacheNodeImpl;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "SIC_INNER_SHOULD_BE_STATIC_ANON"})
public class EVCacheMemcachedClient
extends MemcachedClient {
    private static final Logger log = LoggerFactory.getLogger(EVCacheMemcachedClient.class);
    private final String appName;
    private final ChainedDynamicProperty.IntProperty readTimeout;
    private final EVCacheClient client;
    private final Map<String, Timer> timerMap = new ConcurrentHashMap<String, Timer>();
    private final Map<String, DistributionSummary> distributionSummaryMap = new ConcurrentHashMap<String, DistributionSummary>();
    private DynamicLongProperty mutateOperationTimeout;
    private final ConnectionFactory connectionFactory;

    public EVCacheMemcachedClient(ConnectionFactory cf, List<InetSocketAddress> addrs, ChainedDynamicProperty.IntProperty readTimeout, EVCacheClient client) throws IOException {
        super(cf, addrs);
        this.connectionFactory = cf;
        this.readTimeout = readTimeout;
        this.client = client;
        this.appName = client.getAppName();
    }

    public NodeLocator getNodeLocator() {
        return this.mconn.getLocator();
    }

    public MemcachedNode getEVCacheNode(String key) {
        return this.mconn.getLocator().getPrimary(key);
    }

    public <T> GetFuture<T> asyncGet(String key, Transcoder<T> tc) {
        throw new UnsupportedOperationException("asyncGet");
    }

    public <T> EVCacheOperationFuture<T> asyncGet(final String key, final Transcoder<T> tc, EVCacheGetOperationListener<T> listener) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), ((Integer)this.readTimeout.get()).intValue(), this.executorService, this.client);
        GetOperation op = this.opFact.get(key, new GetOperation.Callback(){
            private Future<T> val = null;

            public void receivedStatus(OperationStatus status) {
                if (log.isDebugEnabled()) {
                    log.debug("Getting Key : " + key + "; Status : " + status.getStatusCode().name() + (log.isTraceEnabled() ? " Node : " + EVCacheMemcachedClient.this.getEVCacheNode(key) : "") + "; Message : " + status.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - rv.getStartTime()));
                }
                try {
                    if (this.val != null) {
                        if (log.isTraceEnabled() && EVCacheMemcachedClient.this.client.getPool().getEVCacheClientPoolManager().shouldLog(EVCacheMemcachedClient.this.appName)) {
                            log.trace("Key : " + key + "; val : " + this.val.get());
                        }
                        rv.set(this.val.get(), status);
                    } else {
                        if (log.isTraceEnabled() && EVCacheMemcachedClient.this.client.getPool().getEVCacheClientPoolManager().shouldLog(EVCacheMemcachedClient.this.appName)) {
                            log.trace("Key : " + key + "; val is null");
                        }
                        rv.set(null, status);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    rv.set(null, status);
                }
            }

            public void gotData(String k, int flags, byte[] data) {
                if (!key.equals(k)) {
                    log.error("Wrong key returned. Key - " + key + "; Returned Key " + k);
                    return;
                }
                if (log.isDebugEnabled() && EVCacheMemcachedClient.this.client.getPool().getEVCacheClientPoolManager().shouldLog(EVCacheMemcachedClient.this.appName)) {
                    log.debug("Read data : key " + key + "; flags : " + flags + "; data : " + data);
                }
                if (data != null) {
                    if (log.isDebugEnabled() && EVCacheMemcachedClient.this.client.getPool().getEVCacheClientPoolManager().shouldLog(EVCacheMemcachedClient.this.appName)) {
                        log.debug("Key : " + key + "; val size : " + data.length);
                    }
                    EVCacheMemcachedClient.this.getDataSizeDistributionSummary("GET", "read").record((long)data.length);
                    if (tc == null) {
                        if (EVCacheMemcachedClient.this.tcService == null) {
                            log.error("tcService is null, will not be able to decode");
                            throw new RuntimeException("TranscoderSevice is null. Not able to decode");
                        }
                        Transcoder t = EVCacheMemcachedClient.this.getTranscoder();
                        this.val = EVCacheMemcachedClient.this.tcService.decode(t, new CachedData(flags, data, t.getMaxSize()));
                    } else {
                        if (EVCacheMemcachedClient.this.tcService == null) {
                            log.error("tcService is null, will not be able to decode");
                            throw new RuntimeException("TranscoderSevice is null. Not able to decode");
                        }
                        this.val = EVCacheMemcachedClient.this.tcService.decode(tc, new CachedData(flags, data, tc.getMaxSize()));
                    }
                } else if (log.isDebugEnabled() && EVCacheMemcachedClient.this.client.getPool().getEVCacheClientPoolManager().shouldLog(EVCacheMemcachedClient.this.appName)) {
                    log.debug("Key : " + key + "; val is null");
                }
            }

            public void complete() {
                latch.countDown();
                String host = rv.getStatus().getStatusCode().equals((Object)StatusCode.TIMEDOUT) && rv.getOperation() != null ? rv.getOperation().getHandlingNode().getSocketAddress().toString() : null;
                EVCacheMemcachedClient.this.getTimer("GET", "read", rv.getStatus(), this.val != null ? "yes" : "no", host).record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (listener != null) {
            rv.addListener(listener);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> EVCacheBulkGetFuture<T> asyncGetBulk(final Collection<String> keys, final Transcoder<T> tc, EVCacheGetOperationListener<T> listener) {
        final ConcurrentHashMap m = new ConcurrentHashMap();
        HashMap<MemcachedNode, ArrayList<String>> chunks = new HashMap<MemcachedNode, ArrayList<String>>();
        NodeLocator locator = this.mconn.getLocator();
        for (String key : keys) {
            StringUtils.validateKey((String)key, (boolean)(this.opFact instanceof BinaryOperationFactory));
            MemcachedNode primaryNode = locator.getPrimary(key);
            if (!primaryNode.isActive()) continue;
            ArrayList<String> ks = (ArrayList<String>)chunks.get(primaryNode);
            if (ks == null) {
                ks = new ArrayList<String>();
                chunks.put(primaryNode, ks);
            }
            ks.add(key);
        }
        final AtomicInteger pendingChunks = new AtomicInteger(chunks.size());
        int initialLatchCount = chunks.isEmpty() ? 0 : 1;
        final CountDownLatch latch = new CountDownLatch(initialLatchCount);
        ArrayList<Operation> ops = new ArrayList<Operation>(chunks.size());
        final EVCacheBulkGetFuture rv = new EVCacheBulkGetFuture(m, ops, latch, this.executorService, this.client);
        GetOperation.Callback cb = new GetOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
                if (log.isDebugEnabled()) {
                    log.debug("GetBulk Keys : " + keys + "; Status : " + status.getStatusCode().name() + "; Message : " + status.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - rv.getStartTime()));
                }
                rv.setStatus(status);
            }

            public void gotData(String k, int flags, byte[] data) {
                if (data != null) {
                    EVCacheMemcachedClient.this.getDataSizeDistributionSummary("BULK", "read").record((long)data.length);
                }
                m.put(k, EVCacheMemcachedClient.this.tcService.decode(tc, new CachedData(flags, data, tc.getMaxSize())));
            }

            public void complete() {
                if (pendingChunks.decrementAndGet() <= 0) {
                    latch.countDown();
                    EVCacheMemcachedClient.this.getTimer("BULK", "read", rv.getStatus(), m.size() == keys.size() ? "yes" : "no", null).record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                    rv.signalComplete();
                }
            }
        };
        HashMap mops = new HashMap();
        for (Map.Entry me : chunks.entrySet()) {
            GetOperation op = this.opFact.get((Collection)me.getValue(), cb);
            mops.put(me.getKey(), op);
            ops.add((Operation)op);
        }
        assert (mops.size() == chunks.size());
        this.mconn.checkState();
        this.mconn.addOperations(mops);
        return rv;
    }

    public <T> EVCacheOperationFuture<CASValue<T>> asyncGetAndTouch(final String key, int exp, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.client);
        GetAndTouchOperation op = this.opFact.getAndTouch(key, exp, new GetAndTouchOperation.Callback(){
            private CASValue<T> val = null;

            public void receivedStatus(OperationStatus status) {
                if (log.isDebugEnabled()) {
                    log.debug("GetAndTouch Key : " + key + "; Status : " + status.getStatusCode().name() + (log.isTraceEnabled() ? " Node : " + EVCacheMemcachedClient.this.getEVCacheNode(key) : "") + "; Message : " + status.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - rv.getStartTime()));
                }
                rv.set(this.val, status);
            }

            public void complete() {
                latch.countDown();
                String host = rv.getStatus().getStatusCode().equals((Object)StatusCode.TIMEDOUT) && rv.getOperation() != null ? rv.getOperation().getHandlingNode().getSocketAddress().toString() : null;
                EVCacheMemcachedClient.this.getTimer("GET_AND_TOUCH", "read", rv.getStatus(), this.val != null ? "yes" : "no", host).record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                rv.signalComplete();
            }

            public void gotData(String k, int flags, long cas, byte[] data) {
                if (!key.equals(k)) {
                    log.warn("Wrong key returned. Key - " + key + "; Returned Key " + k);
                }
                if (data != null) {
                    EVCacheMemcachedClient.this.getDataSizeDistributionSummary("GET_AND_TOUCH", "read").record((long)data.length);
                }
                this.val = new CASValue(cas, tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> set(String key, int exp, T o, Transcoder<T> tc) {
        return this.asyncStore(StoreType.set, key, exp, o, tc, null);
    }

    public OperationFuture<Boolean> set(String key, int exp, Object o) {
        return this.asyncStore(StoreType.set, key, exp, o, this.transcoder, null);
    }

    public <T> OperationFuture<Boolean> set(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.set, key, exp, o, t, latch);
    }

    public <T> OperationFuture<Boolean> replace(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.replace, key, exp, o, t, latch);
    }

    public <T> OperationFuture<Boolean> add(String key, int exp, T o, Transcoder<T> tc) {
        return this.asyncStore(StoreType.add, key, exp, o, tc, null);
    }

    public OperationFuture<Boolean> delete(String key, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.client);
        DeleteOperation op = this.opFact.delete(key, new DeleteOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
                rv.set(Boolean.TRUE, status);
            }

            public void gotData(long cas) {
                rv.setCas(cas);
            }

            public void complete() {
                latch.countDown();
                String host = rv.getStatus().getStatusCode().equals((Object)StatusCode.TIMEDOUT) && rv.getOperation() != null ? rv.getOperation().getHandlingNode().getSocketAddress().toString() : null;
                EVCacheMemcachedClient.this.getTimer("DELETE", "write", rv.getStatus(), null, host).record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> touch(String key, int exp, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.client);
        KeyedOperation op = this.opFact.touch(key, exp, new OperationCallback(){

            public void receivedStatus(OperationStatus status) {
                rv.set(status.isSuccess(), status);
            }

            public void complete() {
                latch.countDown();
                String host = rv.getStatus().getStatusCode().equals((Object)StatusCode.TIMEDOUT) && rv.getOperation() != null ? rv.getOperation().getHandlingNode().getSocketAddress().toString() : null;
                EVCacheMemcachedClient.this.getTimer("TOUCH", "write", rv.getStatus(), null, host).record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> asyncAppendOrAdd(final String key, final int exp, final CachedData co, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.client);
        ConcatenationOperation opAppend = this.opFact.cat(ConcatenationType.append, 0L, key, co.getData(), new OperationCallback(){
            boolean appendSuccess = false;

            public void receivedStatus(OperationStatus val) {
                if (log.isDebugEnabled() && EVCacheMemcachedClient.this.client.getPool().getEVCacheClientPoolManager().shouldLog(EVCacheMemcachedClient.this.appName)) {
                    log.debug("AddOrAppend Key (Append Operation): " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - rv.getStartTime()));
                }
                if (val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    rv.set(Boolean.TRUE, val);
                    this.appendSuccess = true;
                }
            }

            public void complete() {
                if (this.appendSuccess) {
                    String host = rv.getStatus().getStatusCode().equals((Object)StatusCode.TIMEDOUT) && rv.getOperation() != null ? rv.getOperation().getHandlingNode().getSocketAddress().toString() : null;
                    EVCacheMemcachedClient.this.getTimer("APPEND_OR_ADD-APPEND", "write", rv.getStatus(), "yes", host);
                    latch.countDown();
                    rv.signalComplete();
                } else {
                    StoreOperation opAdd = EVCacheMemcachedClient.this.opFact.store(StoreType.add, key, co.getFlags(), exp, co.getData(), new StoreOperation.Callback(){

                        public void receivedStatus(OperationStatus addStatus) {
                            if (log.isDebugEnabled() && EVCacheMemcachedClient.this.client.getPool().getEVCacheClientPoolManager().shouldLog(EVCacheMemcachedClient.this.appName)) {
                                log.debug("AddOrAppend Key (Add Operation): " + key + "; Status : " + addStatus.getStatusCode().name() + "; Message : " + addStatus.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - rv.getStartTime()));
                            }
                            if (addStatus.isSuccess()) {
                                appendSuccess = true;
                                rv.set(addStatus.isSuccess(), addStatus);
                            } else {
                                ConcatenationOperation opReappend = EVCacheMemcachedClient.this.opFact.cat(ConcatenationType.append, 0L, key, co.getData(), new OperationCallback(){

                                    public void receivedStatus(OperationStatus retryAppendStatus) {
                                        if (retryAppendStatus.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                                            rv.set(Boolean.TRUE, retryAppendStatus);
                                            if (log.isDebugEnabled()) {
                                                log.debug("AddOrAppend Retry append Key (Append Operation): " + key + "; Status : " + retryAppendStatus.getStatusCode().name() + "; Message : " + retryAppendStatus.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - rv.getStartTime()));
                                            }
                                        } else {
                                            rv.set(Boolean.FALSE, retryAppendStatus);
                                        }
                                    }

                                    public void complete() {
                                        String host = rv.getStatus().getStatusCode().equals((Object)StatusCode.TIMEDOUT) && rv.getOperation() != null ? rv.getOperation().getHandlingNode().getSocketAddress().toString() : null;
                                        EVCacheMemcachedClient.this.getTimer("APPEND_OR_ADD-RETRY-APPEND", "write", rv.getStatus(), "yes", host).record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                                        latch.countDown();
                                        rv.signalComplete();
                                    }
                                });
                                rv.setOperation((Operation)opReappend);
                                EVCacheMemcachedClient.this.mconn.enqueueOperation(key, (Operation)opReappend);
                            }
                        }

                        public void gotData(String key, long cas) {
                            rv.setCas(cas);
                        }

                        public void complete() {
                            if (appendSuccess) {
                                String host = rv.getStatus().getStatusCode().equals((Object)StatusCode.TIMEDOUT) && rv.getOperation() != null ? rv.getOperation().getHandlingNode().getSocketAddress().toString() : null;
                                EVCacheMemcachedClient.this.getTimer("APPEND_OR_ADD-ADD", "write", rv.getStatus(), "yes", host).record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                                latch.countDown();
                                rv.signalComplete();
                            }
                        }
                    });
                    rv.setOperation((Operation)opAdd);
                    EVCacheMemcachedClient.this.mconn.enqueueOperation(key, (Operation)opAdd);
                }
            }
        });
        rv.setOperation((Operation)opAppend);
        this.mconn.enqueueOperation(key, (Operation)opAppend);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        return rv;
    }

    private Timer getTimer(String operation, String operationType, OperationStatus status, String hit, String host) {
        Timer timer;
        String name;
        String string = name = status != null ? operation + status.getMessage() : operation;
        if (hit != null) {
            name = name + hit;
        }
        if ((timer = this.timerMap.get(name)) != null) {
            return timer;
        }
        ArrayList<Tag> tagList = new ArrayList<Tag>(this.client.getTagList().size() + 4 + (host == null ? 0 : 1));
        tagList.addAll(this.client.getTagList());
        if (operation != null) {
            tagList.add((Tag)new BasicTag("evc.operation", operation));
        }
        if (operationType != null) {
            tagList.add((Tag)new BasicTag("evc.operationType", operationType));
        }
        if (status != null) {
            tagList.add((Tag)new BasicTag("evc.operationStatus", status.getMessage()));
        }
        if (hit != null) {
            tagList.add((Tag)new BasicTag("evc.cacheHit", hit));
        }
        if (host != null) {
            tagList.add((Tag)new BasicTag("evc.host", host));
        }
        timer = EVCacheMetricsFactory.getInstance().getPercentileTimer("internal-evc.client.call", tagList);
        this.timerMap.put(name, timer);
        return timer;
    }

    private DistributionSummary getDataSizeDistributionSummary(String operation, String type) {
        DistributionSummary distributionSummary = this.distributionSummaryMap.get(operation);
        if (distributionSummary != null) {
            return distributionSummary;
        }
        ArrayList<Tag> tagList = new ArrayList<Tag>(6);
        tagList.addAll(this.client.getTagList());
        tagList.add((Tag)new BasicTag("evc.operation", operation));
        tagList.add((Tag)new BasicTag("evc.operationType", type));
        distributionSummary = EVCacheMetricsFactory.getInstance().getDistributionSummary("internal-evc.client.datasize", tagList);
        this.distributionSummaryMap.put(operation, distributionSummary);
        return distributionSummary;
    }

    private <T> OperationFuture<Boolean> asyncStore(StoreType storeType, final String key, int exp, T value, Transcoder<T> tc, EVCacheLatch evcacheLatch) {
        CachedData co = value instanceof CachedData ? (CachedData)value : tc.encode(value);
        final CountDownLatch latch = new CountDownLatch(1);
        final String operationStr = storeType == StoreType.set ? "SET" : (storeType == StoreType.add ? "ADD" : "REPLACE");
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.client);
        StoreOperation op = this.opFact.store(storeType, key, co.getFlags(), exp, co.getData(), new StoreOperation.Callback(){

            public void receivedStatus(OperationStatus val) {
                if (log.isDebugEnabled()) {
                    log.debug("Storing Key : " + key + "; Status : " + val.getStatusCode().name() + (log.isTraceEnabled() ? " Node : " + EVCacheMemcachedClient.this.getEVCacheNode(key) : "") + "; Message : " + val.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - rv.getStartTime()));
                }
                rv.set(val.isSuccess(), val);
                if (log.isTraceEnabled() && !val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    log.trace(val.getStatusCode().name() + " storing Key : " + key, (Throwable)new Exception());
                }
            }

            public void gotData(String key2, long cas) {
                rv.setCas(cas);
            }

            public void complete() {
                latch.countDown();
                String host = rv.getStatus().getStatusCode().equals((Object)StatusCode.TIMEDOUT) && rv.getOperation() != null ? rv.getOperation().getHandlingNode().getSocketAddress().toString() : null;
                EVCacheMemcachedClient.this.getTimer(operationStr, "write", rv.getStatus(), null, host).record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public String toString() {
        return this.appName + "-" + this.client.getZone() + "-" + this.client.getId();
    }

    public <T> OperationFuture<Boolean> add(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.add, key, exp, o, t, latch);
    }

    public long incr(String key, long by, long def, int exp) {
        return this.mutate(Mutator.incr, key, by, def, exp);
    }

    public long decr(String key, long by, long def, int exp) {
        return this.mutate(Mutator.decr, key, by, def, exp);
    }

    public long mutate(Mutator m, String key, long by, long def, int exp) {
        final String operationStr = m.name();
        final long start = System.currentTimeMillis();
        final AtomicLong rv = new AtomicLong();
        final CountDownLatch latch = new CountDownLatch(1);
        MutatorOperation op = this.opFact.mutate(m, key, by, def, exp, new OperationCallback(){

            public void receivedStatus(OperationStatus s) {
                EVCacheMemcachedClient.this.getTimer(operationStr, "write", null, null, null).record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
                rv.set(new Long(s.isSuccess() ? s.getMessage() : "-1"));
            }

            public void complete() {
                latch.countDown();
            }
        });
        this.mconn.enqueueOperation(key, (Operation)op);
        long retVal = def;
        try {
            if (this.mutateOperationTimeout == null) {
                this.mutateOperationTimeout = EVCacheConfig.getInstance().getDynamicLongProperty(this.appName + ".mutate.timeout", this.connectionFactory.getOperationTimeout());
            }
            if (!latch.await(this.mutateOperationTimeout.get(), TimeUnit.MILLISECONDS)) {
                retVal = rv.get();
            }
        }
        catch (Exception e) {
            log.error("Exception on mutate operation : " + operationStr + " Key : " + key + "; by : " + by + "; default : " + def + "; exp : " + exp + "; val : " + retVal + "; Elapsed Time - " + (System.currentTimeMillis() - start), (Throwable)e);
        }
        if (log.isDebugEnabled() && this.client.getPool().getEVCacheClientPoolManager().shouldLog(this.appName)) {
            log.debug(operationStr + " Key : " + key + "; by : " + by + "; default : " + def + "; exp : " + exp + "; val : " + retVal + "; Elapsed Time - " + (System.currentTimeMillis() - start));
        }
        return retVal;
    }

    public void reconnectNode(EVCacheNodeImpl evcNode) {
        long upTime = System.currentTimeMillis() - evcNode.getCreateTime();
        if (log.isDebugEnabled()) {
            log.debug("Reconnecting node : " + evcNode + "; UpTime : " + upTime);
        }
        if (upTime > 30000L) {
            ArrayList<Tag> tagList = new ArrayList<Tag>(5);
            tagList.addAll(this.client.getTagList());
            tagList.add((Tag)new BasicTag("evc.config", "reconnect"));
            tagList.add((Tag)new BasicTag("evc.host", evcNode.getHostName()));
            EVCacheMetricsFactory.getInstance().increment("internal-evc.client.config", tagList);
            evcNode.setConnectTime(System.currentTimeMillis());
            this.mconn.queueReconnect((MemcachedNode)evcNode);
        }
    }
}

