/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheExecutorMBean;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheExecutor
extends ThreadPoolExecutor
implements EVCacheExecutorMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheExecutor.class);
    private final DynamicIntProperty maxAsyncPoolSize;
    private final DynamicIntProperty coreAsyncPoolSize;
    private final String name;
    private Id completedTaskCount;
    private Gauge currentQueueSize;

    public EVCacheExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EVCacheExecutor-" + name + "-%d").build());
        this.name = name;
        this.maxAsyncPoolSize = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheExecutor." + name + ".max.size", maximumPoolSize);
        this.setMaximumPoolSize(this.maxAsyncPoolSize.get());
        this.coreAsyncPoolSize = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheExecutor." + name + ".core.size", corePoolSize);
        this.setCorePoolSize(this.coreAsyncPoolSize.get());
        this.setKeepAliveTime(keepAliveTime, unit);
        this.maxAsyncPoolSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheExecutor.this.setMaximumPoolSize(EVCacheExecutor.this.maxAsyncPoolSize.get());
            }
        });
        this.coreAsyncPoolSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheExecutor.this.setCorePoolSize(EVCacheExecutor.this.coreAsyncPoolSize.get());
                EVCacheExecutor.this.prestartAllCoreThreads();
            }
        });
        this.setupMonitoring(name);
        this.completedTaskCount = EVCacheMetricsFactory.getInstance().getId("EVCacheExecutor.completedTaskCount", Collections.emptyList());
        EVCacheMetricsFactory.getInstance().getRegistry().gauge(this.completedTaskCount, (Object)this, EVCacheExecutor::reportMetrics);
        this.currentQueueSize = EVCacheMetricsFactory.getInstance().getRegistry().gauge(EVCacheMetricsFactory.getInstance().getId("EVCacheExecutor.currentQueueSize", Collections.emptyList()));
    }

    private long reportMetrics() {
        this.currentQueueSize.set((double)this.getQueueSize());
        return this.getCompletedTaskCount();
    }

    private void setupMonitoring(String name) {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                mbeanServer.registerMBean(this, mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception", (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() {
        block2: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + this.name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                mbeanServer.unregisterMBean(mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Exception", (Throwable)e);
            }
        }
        super.shutdown();
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }
}

