/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicStringProperty;
import com.netflix.evcache.EVCache;
import com.netflix.evcache.EVCacheConnectException;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheInMemoryCache;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.EVCacheReadQueueException;
import com.netflix.evcache.EVCacheTranscoder;
import com.netflix.evcache.event.EVCacheEvent;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheFuture;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.EVCacheClientUtil;
import com.netflix.evcache.pool.EVCacheValue;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.evcache.util.KeyHasher;
import com.netflix.evcache.util.Sneaky;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.CachedData;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.Single;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "WMI_WRONG_MAP_ITERATOR", "DB_DUPLICATE_BRANCHES", "REC_CATCH_EXCEPTION", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
public final class EVCacheImpl
implements EVCache {
    private static Logger log = LoggerFactory.getLogger(EVCacheImpl.class);
    private final String _appName;
    private final String _cacheName;
    private final String _metricPrefix;
    private final Transcoder<?> _transcoder;
    private final boolean _zoneFallback;
    private final boolean _throwException;
    private final int _timeToLive;
    private final EVCacheClientPool _pool;
    private final ChainedDynamicProperty.BooleanProperty _throwExceptionFP;
    private final ChainedDynamicProperty.BooleanProperty _zoneFallbackFP;
    private final ChainedDynamicProperty.BooleanProperty _useInMemoryCache;
    private final DynamicBooleanProperty _bulkZoneFallbackFP;
    private final DynamicBooleanProperty _bulkPartialZoneFallbackFP;
    private final List<Tag> tags;
    private EVCacheInMemoryCache<?> cache;
    private EVCacheClientUtil clientUtil = null;
    private final DynamicBooleanProperty hashKey;
    private final DynamicStringProperty hashingAlgo;
    private final EVCacheTranscoder evcacheValueTranscoder;
    private final EVCacheClientPoolManager _poolManager;
    private final ChainedDynamicProperty.BooleanProperty _eventsUsingLatchFP;
    private final Map<String, Timer> timerMap = new ConcurrentHashMap<String, Timer>();
    private final Map<String, Counter> counterMap = new ConcurrentHashMap<String, Counter>();

    EVCacheImpl(String appName, String cacheName, int timeToLive, Transcoder<?> transcoder, boolean enableZoneFallback, boolean throwException, EVCacheClientPoolManager poolManager) {
        this._appName = appName;
        this._cacheName = cacheName;
        this._timeToLive = timeToLive;
        this._transcoder = transcoder;
        this._zoneFallback = enableZoneFallback;
        this._throwException = throwException;
        this.tags = new ArrayList<Tag>(2);
        this.tags.add((Tag)new BasicTag("ipc.server.app", this._appName));
        if (this._cacheName != null && this._cacheName.length() > 0) {
            this.tags.add((Tag)new BasicTag("evc.prefix", this._cacheName));
        }
        String _metricName = this._cacheName == null ? this._appName : this._appName + "." + this._cacheName;
        this._metricPrefix = this._appName + "-";
        this._poolManager = poolManager;
        this._pool = poolManager.getEVCacheClientPool(this._appName);
        EVCacheConfig config = EVCacheConfig.getInstance();
        this._throwExceptionFP = config.getChainedBooleanProperty(_metricName + ".throw.exception", this._appName + ".throw.exception", Boolean.FALSE, null);
        this._zoneFallbackFP = config.getChainedBooleanProperty(_metricName + ".fallback.zone", this._appName + ".fallback.zone", Boolean.TRUE, null);
        this._bulkZoneFallbackFP = config.getDynamicBooleanProperty(this._appName + ".bulk.fallback.zone", Boolean.TRUE);
        this._bulkPartialZoneFallbackFP = config.getDynamicBooleanProperty(this._appName + ".bulk.partial.fallback.zone", Boolean.TRUE);
        this._useInMemoryCache = config.getChainedBooleanProperty(this._appName + ".use.inmemory.cache", "evcache.use.inmemory.cache", Boolean.FALSE, null);
        this._eventsUsingLatchFP = config.getChainedBooleanProperty(this._appName + ".events.using.latch", "evcache.events.using.latch", Boolean.FALSE, null);
        this.hashKey = config.getDynamicBooleanProperty(appName + ".hash.key", Boolean.FALSE);
        this.hashingAlgo = config.getDynamicStringProperty(appName + ".hash.algo", "MD5");
        this.evcacheValueTranscoder = new EVCacheTranscoder();
        this.evcacheValueTranscoder.setCompressionThreshold(Integer.MAX_VALUE);
        this._pool.pingServers();
    }

    private String getCanonicalizedKey(String key) {
        String cKey;
        if (key == null || key.length() == 0) {
            throw new NullPointerException("Key cannot be null or empty");
        }
        int keyLength = key.length();
        if (this._cacheName == null) {
            cKey = key;
        } else {
            keyLength = this._cacheName.length() + 1 + key.length();
            cKey = new StringBuilder(keyLength).append(this._cacheName).append(':').append(key).toString();
        }
        if (keyLength > 250) {
            throw new IllegalArgumentException("Key is too long (maxlen = 250)");
        }
        for (int i = 0; i < cKey.length(); ++i) {
            if (!Character.isWhitespace(cKey.charAt(i))) continue;
            throw new IllegalArgumentException("Key contains invalid characters:  ``" + key + "''");
        }
        if (this.hashKey.get()) {
            return KeyHasher.getHashedKey(cKey, this.hashingAlgo.get());
        }
        return cKey;
    }

    private String getKey(String canonicalizedKey) {
        if (canonicalizedKey == null) {
            return canonicalizedKey;
        }
        if (this._cacheName == null) {
            return canonicalizedKey;
        }
        String _cacheNameDelimited = this._cacheName + ':';
        return canonicalizedKey.replaceFirst(_cacheNameDelimited, "");
    }

    private boolean hasZoneFallbackForBulk() {
        if (!this._pool.supportsFallback()) {
            return false;
        }
        if (!this._bulkZoneFallbackFP.get()) {
            return false;
        }
        return this._zoneFallback;
    }

    private boolean hasZoneFallback() {
        if (!this._pool.supportsFallback()) {
            return false;
        }
        if (!((Boolean)this._zoneFallbackFP.get()).booleanValue()) {
            return false;
        }
        return this._zoneFallback;
    }

    private boolean shouldLog() {
        return this._poolManager.shouldLog(this._appName);
    }

    private boolean doThrowException() {
        return this._throwException || (Boolean)this._throwExceptionFP.get() != false;
    }

    private List<EVCacheEventListener> getEVCacheEventListeners() {
        return this._poolManager.getEVCacheEventListeners();
    }

    private EVCacheEvent createEVCacheEvent(Collection<EVCacheClient> clients, Collection<String> keys, EVCache.Call call) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        if (evcacheEventListenerList == null || evcacheEventListenerList.size() == 0) {
            return null;
        }
        EVCacheEvent event = new EVCacheEvent(call, this._appName, this._cacheName, this._pool);
        event.setKeys(keys);
        event.setClients(clients);
        return event;
    }

    private boolean shouldThrottle(EVCacheEvent event) throws EVCacheException {
        for (EVCacheEventListener evcacheEventListener : this.getEVCacheEventListeners()) {
            if (!evcacheEventListener.onThrottle(event)) continue;
            return true;
        }
        return false;
    }

    private void startEvent(EVCacheEvent event) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
            evcacheEventListener.onStart(event);
        }
    }

    private void endEvent(EVCacheEvent event) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
            evcacheEventListener.onComplete(event);
        }
    }

    private void eventError(EVCacheEvent event, Throwable t) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
            evcacheEventListener.onError(event, t);
        }
    }

    private <T> EVCacheInMemoryCache<T> getInMemoryCache(Transcoder<T> tc) {
        if (this.cache == null) {
            this.cache = this._poolManager.createInMemoryCache(this._appName, tc, this);
        }
        return this.cache;
    }

    @Override
    public <T> T get(String key) throws EVCacheException {
        return (T)this.get(key, this._transcoder);
    }

    private void incrementFastFail(String metric) {
        Counter counter = this.counterMap.get(metric);
        if (counter == null) {
            ArrayList<Tag> tagList = new ArrayList<Tag>(3);
            tagList.addAll(this.tags);
            tagList.add((Tag)new BasicTag("ipc.error.group", metric));
            counter = EVCacheMetricsFactory.getInstance().getCounter("internal-evc.client.fastfail", tagList);
            this.counterMap.put(metric, counter);
        }
        counter.increment();
    }

    private void increment(String serverGroup, String cachePrefix, String metric) {
        ArrayList<Object> tagList = new ArrayList<Object>(this.tags.size() + 1);
        tagList.addAll(this.tags);
        tagList.add(new BasicTag("ipc.server.asg", serverGroup));
        EVCacheMetricsFactory.getInstance().increment(metric);
    }

    @Override
    public <T> T get(String key, Transcoder<T> tc) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        if (((Boolean)this._useInMemoryCache.get()).booleanValue()) {
            T value;
            block9: {
                value = null;
                try {
                    value = this.getInMemoryCache(tc).get(canonicalKey);
                }
                catch (ExecutionException e) {
                    boolean throwExc = this.doThrowException();
                    if (!throwExc) break block9;
                    if (e.getCause() instanceof EVCacheInMemoryCache.DataNotFoundException) {
                        return null;
                    }
                    if (e.getCause() instanceof EVCacheException) {
                        if (log.isDebugEnabled() && this.shouldLog()) {
                            log.debug("ExecutionException while getting data from InMemory Cache", (Throwable)e);
                        }
                        throw (EVCacheException)e.getCause();
                    }
                    throw new EVCacheException("ExecutionException", e);
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Value retrieved from inmemory cache for APP " + this._appName + ", key : " + canonicalKey + (log.isTraceEnabled() ? "; value : " + value : ""));
            }
            if (value != null) {
                return value;
            }
        }
        return this.doGet(canonicalKey, tc);
    }

    <T> T doGet(String canonicalKey, Transcoder<T> tc) throws EVCacheException {
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get the data APP " + this._appName);
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), Collections.singletonList(canonicalKey), EVCache.Call.GET);
        if (event != null) {
            event.setCanonicalKeys(Arrays.asList(canonicalKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + canonicalKey);
                    }
                    return null;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        String cacheOperation = "yes";
        int tries = 1;
        try {
            List<EVCacheClient> fbClients;
            boolean hasZF = this.hasZoneFallback();
            boolean throwEx = hasZF ? false : throwExc;
            T data = this.getData(client, canonicalKey, tc, throwEx, hasZF);
            if (data == null && hasZF && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                for (int i = 0; i < fbClients.size(); ++i) {
                    EVCacheClient fbClient;
                    block39: {
                        fbClient = fbClients.get(i);
                        if (i >= fbClients.size() - 1) {
                            throwEx = throwExc;
                        }
                        if (event != null) {
                            T t;
                            try {
                                if (!this.shouldThrottle(event)) break block39;
                                status = "throttled";
                                if (throwExc) {
                                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + canonicalKey);
                                }
                                t = null;
                            }
                            catch (EVCacheException ex) {
                                if (throwExc) {
                                    throw ex;
                                }
                                status = "throttled";
                                T t2 = null;
                                return t2;
                            }
                            return t;
                        }
                    }
                    ++tries;
                    data = this.getData(fbClient, canonicalKey, tc, throwEx, i < fbClients.size() - 1);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("Retry for APP " + this._appName + ", key [" + canonicalKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + fbClient.getServerGroup());
                    }
                    if (data == null) continue;
                    client = fbClient;
                    break;
                }
            }
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "GHIT");
                }
            } else {
                cacheOperation = "no";
                if (event != null) {
                    event.setAttribute("status", "GMISS");
                }
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET : APP " + this._appName + " ; cache miss for key : " + canonicalKey);
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", key [" + canonicalKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
            }
            if (event != null) {
                this.endEvent(event);
            }
            T t = data;
            return t;
        }
        catch (CheckedOperationTimeoutException ex) {
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("CheckedOperationTimeoutException getting data for APP " + this._appName + ", key = " + canonicalKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("Exception getting data for APP " + this._appName + ", key = " + canonicalKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.GET.name(), "read", cacheOperation, status, tries).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", Took " + duration + " milliSec.");
            }
        }
    }

    @Override
    public <T> Single<T> get(String key, Scheduler scheduler) {
        return this.get(key, this._transcoder, scheduler);
    }

    @Override
    public <T> Single<T> get(String key, Transcoder<T> tc, Scheduler scheduler) {
        if (null == key) {
            return Single.error((Throwable)new IllegalArgumentException("Key cannot be null"));
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient");
            return Single.error((Throwable)new EVCacheException("Could not find a client to get the data APP " + this._appName));
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), Collections.singletonList(key), EVCache.Call.GET);
        if (event != null) {
            event.setCanonicalKeys(Arrays.asList(canonicalKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    return Single.error((Throwable)new EVCacheException("Request Throttled for app " + this._appName + " & key " + key));
                }
            }
            catch (EVCacheException ex2) {
                throw Sneaky.sneakyThrow(ex2);
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        boolean hasZF = this.hasZoneFallback();
        boolean throwEx = hasZF ? false : throwExc;
        return this.getData(client, canonicalKey, tc, throwEx, hasZF, scheduler).flatMap(data -> {
            List<EVCacheClient> fbClients;
            if (data == null && hasZF && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                return Observable.concat((Observable)Observable.from(fbClients).map(fbClient -> this.getData(fbClients.indexOf(fbClient), fbClients.size(), (EVCacheClient)fbClient, canonicalKey, tc, throwEx, throwExc, false, scheduler).toObservable())).firstOrDefault(null, fbData -> fbData != null).toSingle();
            }
            return Single.just((Object)data);
        }).map(data -> {
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "GHIT");
                }
            } else {
                if (event != null) {
                    event.setAttribute("status", "GMISS");
                }
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET : APP " + this._appName + " ; cache miss for key : " + canonicalKey);
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", key [" + canonicalKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
            }
            if (event != null) {
                this.endEvent(event);
            }
            return data;
        }).onErrorReturn(ex -> {
            if (ex instanceof CheckedOperationTimeoutException) {
                if (event != null) {
                    this.eventError(event, (Throwable)ex);
                }
                if (!throwExc) {
                    return null;
                }
                throw Sneaky.sneakyThrow(new EVCacheException("CheckedOperationTimeoutException getting data for APP " + this._appName + ", key = " + canonicalKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", (Throwable)ex));
            }
            if (event != null) {
                this.eventError(event, (Throwable)ex);
            }
            if (!throwExc) {
                return null;
            }
            throw Sneaky.sneakyThrow(new EVCacheException("Exception getting data for APP " + this._appName + ", key = " + canonicalKey, (Throwable)ex));
        }).doAfterTerminate(() -> {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.GET_AND_TOUCH.name(), "read", null, null, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", Took " + duration + " milliSec.");
            }
        });
    }

    private <T> T getData(EVCacheClient client, String canonicalKey, Transcoder<T> tc, boolean throwException, boolean hasZF) throws Exception {
        if (client == null) {
            return null;
        }
        try {
            if (this.hashKey.get()) {
                Object obj = client.get(canonicalKey, this.evcacheValueTranscoder, throwException, hasZF);
                if (obj != null && obj instanceof EVCacheValue) {
                    EVCacheValue val = (EVCacheValue)obj;
                    CachedData cd = new CachedData(val.getFlags(), val.getValue(), 0x1400000);
                    if (tc == null) {
                        return (T)client.getTranscoder().decode(cd);
                    }
                    return (T)tc.decode(cd);
                }
                return null;
            }
            if (tc == null && this._transcoder != null) {
                tc = this._transcoder;
            }
            return client.get(canonicalKey, tc, throwException, hasZF);
        }
        catch (EVCacheConnectException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheConnectException while getting data for APP " + this._appName + ", key : " + canonicalKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheReadQueueException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheReadQueueException while getting data for APP " + this._appName + ", key : " + canonicalKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheException while getting data for APP " + this._appName + ", key : " + canonicalKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
    }

    private <T> Single<T> getData(int index, int size, EVCacheClient client, String canonicalKey, Transcoder<T> tc, boolean throwEx, boolean throwExc, boolean hasZF, Scheduler scheduler) {
        if (index >= size - 1) {
            throwEx = throwExc;
        }
        return this.getData(client, canonicalKey, tc, throwEx, hasZF, scheduler);
    }

    private <T> Single<T> getData(EVCacheClient client, String canonicalKey, Transcoder<T> tc, boolean throwException, boolean hasZF, Scheduler scheduler) {
        if (client == null) {
            return Single.error((Throwable)new IllegalArgumentException("Client cannot be null"));
        }
        if (this.hashKey.get()) {
            return Single.error((Throwable)new IllegalArgumentException("Not supported"));
        }
        if (tc == null && this._transcoder != null) {
            tc = this._transcoder;
        }
        return client.get(canonicalKey, tc, throwException, hasZF, scheduler).onErrorReturn(ex -> {
            if (ex instanceof EVCacheReadQueueException) {
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("EVCacheReadQueueException while getting data for APP " + this._appName + ", key : " + canonicalKey + "; hasZF : " + hasZF, ex);
                }
                if (!throwException || hasZF) {
                    return null;
                }
                throw Sneaky.sneakyThrow(ex);
            }
            if (ex instanceof EVCacheException) {
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("EVCacheException while getting data for APP " + this._appName + ", key : " + canonicalKey + "; hasZF : " + hasZF, ex);
                }
                if (!throwException || hasZF) {
                    return null;
                }
                throw Sneaky.sneakyThrow(ex);
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting data for APP " + this._appName + ", key : " + canonicalKey, ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw Sneaky.sneakyThrow(ex);
        });
    }

    @Override
    public <T> T getAndTouch(String key, int timeToLive) throws EVCacheException {
        return (T)this.getAndTouch(key, timeToLive, this._transcoder);
    }

    @Override
    public <T> Single<T> getAndTouch(String key, int timeToLive, Scheduler scheduler) {
        return this.getAndTouch(key, timeToLive, this._transcoder, scheduler);
    }

    @Override
    public <T> Single<T> getAndTouch(String key, int timeToLive, Transcoder<T> tc, Scheduler scheduler) {
        if (null == key) {
            return Single.error((Throwable)new IllegalArgumentException("Key cannot be null"));
        }
        if (this.hashKey.get()) {
            return Single.error((Throwable)new IllegalArgumentException("Not supported"));
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient");
            return Single.error((Throwable)new EVCacheException("Could not find a client to get and touch the data for APP " + this._appName));
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), Collections.singletonList(key), EVCache.Call.GET_AND_TOUCH);
        if (event != null) {
            event.setCanonicalKeys(Arrays.asList(canonicalKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    return Single.error((Throwable)new EVCacheException("Request Throttled for app " + this._appName + " & key " + key));
                }
            }
            catch (EVCacheException ex2) {
                throw Sneaky.sneakyThrow(ex2);
            }
            event.setTTL(timeToLive);
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        boolean hasZF = this.hasZoneFallback();
        boolean throwEx = hasZF ? false : throwExc;
        return this.getData(client, canonicalKey, tc, throwEx, hasZF, scheduler).flatMap(data -> {
            List<EVCacheClient> fbClients;
            if (data == null && hasZF && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                return Observable.concat((Observable)Observable.from(fbClients).map(fbClient -> this.getData(fbClients.indexOf(fbClient), fbClients.size(), (EVCacheClient)fbClient, canonicalKey, tc, throwEx, throwExc, false, scheduler).doOnSuccess(fbData -> {}).toObservable())).firstOrDefault(null, fbData -> fbData != null).toSingle();
            }
            return Single.just((Object)data);
        }).map(data -> {
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "THIT");
                }
                try {
                    this.touchData(canonicalKey, key, timeToLive);
                }
                catch (Exception e) {
                    throw Sneaky.sneakyThrow(new EVCacheException("Exception performing touch for APP " + this._appName + ", key = " + canonicalKey, e));
                }
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("GET_AND_TOUCH : APP " + this._appName + ", key [" + canonicalKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
                }
            } else {
                if (event != null) {
                    event.setAttribute("status", "TMISS");
                }
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET_AND_TOUCH : APP " + this._appName + " ; cache miss for key : " + canonicalKey);
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            return data;
        }).onErrorReturn(ex -> {
            if (ex instanceof CheckedOperationTimeoutException) {
                if (event != null) {
                    this.eventError(event, (Throwable)ex);
                }
                if (!throwExc) {
                    return null;
                }
                throw Sneaky.sneakyThrow(new EVCacheException("CheckedOperationTimeoutException executing getAndTouch APP " + this._appName + ", key = " + canonicalKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", (Throwable)ex));
            }
            if (event != null) {
                this.eventError(event, (Throwable)ex);
            }
            if (!throwExc) {
                return null;
            }
            throw Sneaky.sneakyThrow(new EVCacheException("Exception executing getAndTouch APP " + this._appName + ", key = " + canonicalKey, (Throwable)ex));
        }).doAfterTerminate(() -> {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.GET_AND_TOUCH.name(), "read", null, null, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET_AND_TOUCH : APP " + this._appName + ", Took " + duration + " milliSec.");
            }
        });
    }

    @Override
    public <T> T getAndTouch(String key, int timeToLive, Transcoder<T> tc) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        if (((Boolean)this._useInMemoryCache.get()).booleanValue()) {
            T value;
            boolean throwExc;
            block10: {
                throwExc = this.doThrowException();
                value = null;
                try {
                    value = this.getInMemoryCache(tc).get(canonicalKey);
                }
                catch (ExecutionException e) {
                    if (!throwExc) break block10;
                    if (e.getCause() instanceof EVCacheInMemoryCache.DataNotFoundException) {
                        return null;
                    }
                    if (e.getCause() instanceof EVCacheException) {
                        if (log.isDebugEnabled() && this.shouldLog()) {
                            log.debug("ExecutionException while getting data from InMemory Cache", (Throwable)e);
                        }
                        throw (EVCacheException)e.getCause();
                    }
                    throw new EVCacheException("ExecutionException", e);
                }
            }
            if (value != null) {
                block11: {
                    try {
                        this.touchData(canonicalKey, key, timeToLive);
                    }
                    catch (Exception e) {
                        if (!throwExc) break block11;
                        throw new EVCacheException("Exception executing getAndTouch APP " + this._appName + ", key = " + canonicalKey, e);
                    }
                }
                return value;
            }
        }
        return this.doGetAndTouch(canonicalKey, key, timeToLive, tc);
    }

    <T> T doGetAndTouch(String canonicalKey, String key, int timeToLive, Transcoder<T> tc) throws EVCacheException {
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get and touch the data for App " + this._appName);
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), Collections.singletonList(canonicalKey), EVCache.Call.GET_AND_TOUCH);
        if (event != null) {
            event.setCanonicalKeys(Arrays.asList(canonicalKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + canonicalKey);
                    }
                    return null;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            event.setTTL(timeToLive);
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String cacheOperation = "yes";
        int tries = 1;
        String status = "success";
        try {
            boolean hasZF = this.hasZoneFallback();
            boolean throwEx = hasZF ? false : throwExc;
            T data = this.getData(client, canonicalKey, tc, throwEx, hasZF);
            if (data == null && hasZF) {
                List<EVCacheClient> fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup());
                for (int i = 0; i < fbClients.size(); ++i) {
                    EVCacheClient fbClient;
                    block41: {
                        fbClient = fbClients.get(i);
                        if (i >= fbClients.size() - 1) {
                            throwEx = throwExc;
                        }
                        if (event != null) {
                            T t;
                            try {
                                if (!this.shouldThrottle(event)) break block41;
                                status = "throttled";
                                if (throwExc) {
                                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + canonicalKey);
                                }
                                t = null;
                            }
                            catch (EVCacheException ex) {
                                if (throwExc) {
                                    throw ex;
                                }
                                status = "throttled";
                                T t2 = null;
                                return t2;
                            }
                            return t;
                        }
                    }
                    ++tries;
                    data = this.getData(fbClient, canonicalKey, tc, throwEx, i < fbClients.size() - 1);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("GetAndTouch Retry for APP " + this._appName + ", key [" + canonicalKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + fbClient.getServerGroup());
                    }
                    if (data == null) continue;
                    client = fbClient;
                    break;
                }
            }
            if (data != null) {
                if (event != null) {
                    event.setAttribute("status", "THIT");
                }
                this.touchData(canonicalKey, key, timeToLive);
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("GET_AND_TOUCH : APP " + this._appName + ", key [" + canonicalKey + (log.isTraceEnabled() ? "], Value [" + data : "") + "], ServerGroup : " + client.getServerGroup());
                }
            } else {
                cacheOperation = "no";
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET_AND_TOUCH : APP " + this._appName + " ; cache miss for key : " + canonicalKey);
                }
                if (event != null) {
                    event.setAttribute("status", "TMISS");
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            T t = data;
            return t;
        }
        catch (CheckedOperationTimeoutException ex) {
            status = "timeout";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("CheckedOperationTimeoutException executing getAndTouch APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("CheckedOperationTimeoutException executing getAndTouch APP " + this._appName + ", key  = " + canonicalKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception executing getAndTouch APP " + this._appName + ", key = " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("Exception executing getAndTouch APP " + this._appName + ", key = " + canonicalKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.GET_AND_TOUCH.name(), "read", cacheOperation, status, tries).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Took " + duration + " milliSec to get&Touch the value for APP " + this._appName + ", key " + canonicalKey);
            }
        }
    }

    @Override
    public Future<Boolean>[] touch(String key, int timeToLive) throws EVCacheException {
        EVCacheLatch latch = this.touch(key, timeToLive, null);
        if (latch == null) {
            return new EVCacheFuture[0];
        }
        List<Future<Boolean>> futures = latch.getAllFutures();
        if (futures == null || futures.isEmpty()) {
            return new EVCacheFuture[0];
        }
        EVCacheFuture[] eFutures = new EVCacheFuture[futures.size()];
        for (int i = 0; i < futures.size(); ++i) {
            Future<Boolean> future = futures.get(i);
            if (future instanceof EVCacheFuture) {
                eFutures[i] = (EVCacheFuture)future;
                continue;
            }
            if (future instanceof EVCacheOperationFuture) {
                EVCacheOperationFuture evfuture = (EVCacheOperationFuture)((Object)future);
                eFutures[i] = new EVCacheFuture(future, key, this._appName, evfuture.getServerGroup(), evfuture.getEVCacheClient());
                continue;
            }
            eFutures[i] = new EVCacheFuture(future, key, this._appName, null);
        }
        return eFutures;
    }

    @Override
    public <T> EVCacheLatch touch(String key, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.TOUCH);
        if (event != null) {
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String canonicalKey = this.getCanonicalizedKey(key);
        try {
            EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
            this.touchData(canonicalKey, key, timeToLive, clients, latch);
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setTTL(timeToLive);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception touching the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.TOUCH.name(), "write", null, null, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("TOUCH : APP " + this._appName + " for key : " + canonicalKey + " with ttl : " + timeToLive);
            }
        }
    }

    private EVCacheFuture[] touchData(String canonicalKey, String key, int timeToLive) throws Exception {
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        return this.touchData(canonicalKey, key, timeToLive, clients);
    }

    private EVCacheFuture[] touchData(String canonicalKey, String key, int timeToLive, EVCacheClient[] clients) throws Exception {
        return this.touchData(canonicalKey, key, timeToLive, clients, null);
    }

    private EVCacheFuture[] touchData(String canonicalKey, String key, int timeToLive, EVCacheClient[] clients, EVCacheLatch latch) throws Exception {
        EVCacheFuture[] futures = new EVCacheFuture[clients.length];
        int index = 0;
        for (EVCacheClient client : clients) {
            Future<Boolean> future = client.touch(canonicalKey, timeToLive, latch);
            futures[index++] = new EVCacheFuture(future, key, this._appName, client.getServerGroup(), client);
        }
        return futures;
    }

    @Override
    public <T> Future<T> getAsynchronous(String key) throws EVCacheException {
        return this.getAsynchronous(key, this._transcoder);
    }

    @Override
    public <T> Future<T> getAsynchronous(String key, final Transcoder<T> tc) throws EVCacheException {
        Future r;
        if (null == key) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        final EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to asynchronously get the data");
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), Collections.singletonList(key), EVCache.Call.ASYNC_GET);
        String canonicalKey = this.getCanonicalizedKey(key);
        if (event != null) {
            event.setCanonicalKeys(Arrays.asList(canonicalKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return null;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        try {
            if (this.hashKey.get()) {
                final Future objFuture = client.asyncGet(canonicalKey, this.evcacheValueTranscoder, throwExc, false);
                r = new Future<T>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return objFuture.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public boolean isCancelled() {
                        return objFuture.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return objFuture.isDone();
                    }

                    @Override
                    public T get() throws InterruptedException, ExecutionException {
                        return this.getFromObj(objFuture.get());
                    }

                    private T getFromObj(Object obj) {
                        if (obj != null && obj instanceof EVCacheValue) {
                            EVCacheValue val = (EVCacheValue)obj;
                            CachedData cd = new CachedData(val.getFlags(), val.getValue(), 0x1400000);
                            if (tc == null) {
                                if (EVCacheImpl.this._transcoder == null) {
                                    return client.getTranscoder().decode(cd);
                                }
                                return EVCacheImpl.this._transcoder.decode(cd);
                            }
                            return tc.decode(cd);
                        }
                        return null;
                    }

                    @Override
                    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return this.getFromObj(objFuture.get(timeout, unit));
                    }
                };
            } else {
                r = client.asyncGet(canonicalKey, tc == null ? this._transcoder : tc, throwExc, false);
            }
            if (event != null) {
                this.endEvent(event);
            }
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting data for keys Asynchronously APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                Future<T> future = null;
                return future;
            }
            throw new EVCacheException("Exception getting data for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.ASYNC_GET.name(), "read", null, null, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Took " + duration + " milliSec to execute AsyncGet the value for APP " + this._appName + ", key " + key);
            }
        }
        return r;
    }

    private <T> Map<String, T> getBulkData(EVCacheClient client, Collection<String> canonicalKeys, Transcoder<T> tc, boolean throwException, boolean hasZF) throws Exception {
        try {
            if (this.hashKey.get()) {
                Map objMap = client.getBulk(canonicalKeys, this.evcacheValueTranscoder, throwException, hasZF);
                HashMap<String, Object> retMap = new HashMap<String, Object>((int)((double)objMap.size() / 0.75) + 1);
                for (Map.Entry i : objMap.entrySet()) {
                    Object obj = i.getValue();
                    if (!(obj instanceof EVCacheValue)) continue;
                    EVCacheValue val = (EVCacheValue)obj;
                    CachedData cd = new CachedData(val.getFlags(), val.getValue(), 0x1400000);
                    Object tVal = tc == null ? client.getTranscoder().decode(cd) : tc.decode(cd);
                    retMap.put(val.getKey(), tVal);
                }
                return retMap;
            }
            if (tc == null && this._transcoder != null) {
                tc = this._transcoder;
            }
            return client.getBulk(canonicalKeys, tc, throwException, hasZF);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getBulk data for APP " + this._appName + ", key : " + canonicalKeys, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public <T> Map<String, T> getBulk(Collection<String> keys, Transcoder<T> tc) throws EVCacheException {
        return this.getBulk(keys, tc, false, 0);
    }

    @Override
    public <T> Map<String, T> getBulkAndTouch(Collection<String> keys, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        return this.getBulk(keys, tc, true, timeToLive);
    }

    private <T> Map<String, T> getBulk(Collection<String> keys, Transcoder<T> tc, boolean touch, int ttl) throws EVCacheException {
        if (null == keys) {
            throw new IllegalArgumentException();
        }
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get the data in bulk");
            }
            return Collections.emptyMap();
        }
        ArrayList<String> canonicalKeys = new ArrayList<String>();
        for (String k : keys) {
            String canonicalK = this.getCanonicalizedKey(k);
            canonicalKeys.add(canonicalK);
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), keys, EVCache.Call.BULK);
        if (event != null) {
            event.setCanonicalKeys(canonicalKeys);
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & keys " + keys);
                    }
                    return Collections.emptyMap();
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            event.setTTL(ttl);
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String cacheOperation = "yes";
        int tries = 1;
        String status = "success";
        try {
            boolean hasZF = this.hasZoneFallbackForBulk();
            boolean throwEx = hasZF ? false : throwExc;
            Map<String, T> retMap = this.getBulkData(client, canonicalKeys, tc, throwEx, hasZF);
            List<EVCacheClient> fbClients = null;
            if (hasZF) {
                if (retMap == null || retMap.isEmpty()) {
                    fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup());
                    if (fbClients != null && !fbClients.isEmpty()) {
                        for (int i = 0; i < fbClients.size(); ++i) {
                            EVCacheClient fbClient = fbClients.get(i);
                            if (i >= fbClients.size() - 1) {
                                throwEx = throwExc;
                            }
                            if (event != null) {
                                try {
                                    if (this.shouldThrottle(event)) {
                                        status = "throttled";
                                        if (throwExc) {
                                            throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + canonicalKeys);
                                        }
                                        Map<String, T> map = null;
                                        return map;
                                    }
                                }
                                catch (EVCacheException ex) {
                                    if (throwExc) {
                                        throw ex;
                                    }
                                    status = "throttled";
                                    Map<String, T> duration = null;
                                    return duration;
                                }
                            }
                            ++tries;
                            retMap = this.getBulkData(fbClient, canonicalKeys, tc, throwEx, i < fbClients.size() - 1);
                            if (log.isDebugEnabled() && this.shouldLog()) {
                                log.debug("Fallback for APP " + this._appName + ", key [" + canonicalKeys + (log.isTraceEnabled() ? "], Value [" + retMap : "") + "], zone : " + fbClient.getZone());
                            }
                            if (retMap == null || retMap.isEmpty()) {
                                continue;
                            }
                            break;
                        }
                    }
                } else if (retMap != null && keys.size() > retMap.size() && this._bulkPartialZoneFallbackFP.get()) {
                    int initRetrySize = keys.size() - retMap.size();
                    ArrayList<String> retryKeys = new ArrayList<String>(initRetrySize);
                    for (String key : canonicalKeys) {
                        if (retMap.containsKey(key)) continue;
                        retryKeys.add(key);
                    }
                    fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup());
                    if (fbClients != null && !fbClients.isEmpty()) {
                        for (int ind = 0; ind < fbClients.size(); ++ind) {
                            EVCacheClient fbClient = fbClients.get(ind);
                            if (event != null) {
                                try {
                                    if (this.shouldThrottle(event)) {
                                        status = "throttled";
                                        if (throwExc) {
                                            throw new EVCacheException("Request Throttled for app " + this._appName + " & keys " + retryKeys);
                                        }
                                        Map<String, T> duration = null;
                                        return duration;
                                    }
                                }
                                catch (EVCacheException ex) {
                                    status = "throttled";
                                    if (throwExc) {
                                        throw ex;
                                    }
                                    Iterator<Map.Entry<String, T>> duration = null;
                                    return duration;
                                }
                            }
                            ++tries;
                            Map<String, T> fbRetMap = this.getBulkData(fbClient, retryKeys, tc, false, hasZF);
                            if (log.isDebugEnabled() && this.shouldLog()) {
                                log.debug("Fallback for APP " + this._appName + ", key [" + retryKeys + "], Fallback Server Group : " + fbClient.getServerGroup().getName());
                            }
                            for (Map.Entry<String, T> i : fbRetMap.entrySet()) {
                                retMap.put(i.getKey(), i.getValue());
                                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                                log.debug("Fallback for APP " + this._appName + ", key [" + i.getKey() + (log.isTraceEnabled() ? "], Value [" + i.getValue() : "]"));
                            }
                            if (retryKeys.size() == fbRetMap.size()) break;
                            if (ind >= fbClients.size()) continue;
                            retryKeys = new ArrayList(keys.size() - retMap.size());
                            for (String key : canonicalKeys) {
                                if (retMap.containsKey(key)) continue;
                                retryKeys.add(key);
                            }
                        }
                    }
                    if (log.isDebugEnabled() && this.shouldLog() && retMap.size() == keys.size()) {
                        log.debug("Fallback SUCCESS for APP " + this._appName + ",  retMap [" + retMap + "]");
                    }
                }
            }
            if (retMap == null || retMap.isEmpty()) {
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("BULK : APP " + this._appName + " ; Full cache miss for keys : " + keys);
                }
                if (event != null) {
                    event.setAttribute("status", "BMISS_ALL");
                }
                if (retMap != null && retMap.isEmpty()) {
                    retMap = new HashMap<String, T>();
                    for (String k : keys) {
                        retMap.put(k, null);
                    }
                }
                cacheOperation = "no";
                if (event != null) {
                    this.endEvent(event);
                }
                Map<String, T> initRetrySize = retMap;
                return initRetrySize;
            }
            boolean partialHit = false;
            ArrayList<String> decanonicalHitKeys = new ArrayList<String>(retMap.size());
            HashMap<String, T> decanonicalR = new HashMap<String, T>(canonicalKeys.size() * 4 / 3 + 1);
            for (String key : canonicalKeys) {
                String deCanKey = this.getKey(key);
                T value = retMap.get(key);
                if (value != null) {
                    decanonicalR.put(deCanKey, value);
                    if (touch) {
                        this.touchData(key, deCanKey, ttl);
                    }
                    decanonicalHitKeys.add(deCanKey);
                    continue;
                }
                partialHit = true;
                decanonicalR.put(deCanKey, null);
            }
            if (!decanonicalR.isEmpty()) {
                if (!partialHit) {
                    if (event != null) {
                        event.setAttribute("status", "BHIT");
                    }
                } else {
                    if (event != null) {
                        event.setAttribute("status", "BHIT_PARTIAL");
                        event.setAttribute("BHIT_PARTIAL_KEYS", decanonicalHitKeys);
                    }
                    cacheOperation = "partial";
                    if (log.isInfoEnabled() && this.shouldLog()) {
                        log.info("BULK_HIT_PARTIAL for APP " + this._appName + ", keys in cache [" + decanonicalR + "], all keys [" + keys + "]");
                    }
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("APP " + this._appName + ", BULK : Data [" + decanonicalR + "]");
            }
            if (event != null) {
                this.endEvent(event);
            }
            HashMap<String, T> hashMap = decanonicalR;
            return hashMap;
        }
        catch (CheckedOperationTimeoutException ex) {
            status = "timeout";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("CheckedOperationTimeoutException getting bulk data for APP " + this._appName + ", keys : " + canonicalKeys, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                Map<String, T> map = null;
                return map;
            }
            throw new EVCacheException("CheckedOperationTimeoutException getting bulk data for APP " + this._appName + ", keys = " + canonicalKeys + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.bulkReadTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception getting bulk data for APP " + this._appName + ", keys = " + canonicalKeys, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                Map<String, T> map = null;
                return map;
            }
            throw new EVCacheException("Exception getting bulk data for APP " + this._appName + ", keys = " + canonicalKeys, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.BULK.name(), "read", cacheOperation, status, tries, keys.size()).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("BULK : APP " + this._appName + " Took " + duration + " milliSec to get the value for key " + canonicalKeys);
            }
        }
    }

    @Override
    public <T> Map<String, T> getBulk(Collection<String> keys) throws EVCacheException {
        return this.getBulk(keys, this._transcoder);
    }

    @Override
    public <T> Map<String, T> getBulk(String ... keys) throws EVCacheException {
        return this.getBulk(Arrays.asList(keys), this._transcoder);
    }

    @Override
    public <T> Map<String, T> getBulk(Transcoder<T> tc, String ... keys) throws EVCacheException {
        return this.getBulk(Arrays.asList(keys), tc);
    }

    public <T> EVCacheFuture[] set(String key, T value, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        EVCacheLatch latch = this.set(key, value, tc, timeToLive, null);
        if (latch == null) {
            return new EVCacheFuture[0];
        }
        List<Future<Boolean>> futures = latch.getAllFutures();
        if (futures == null || futures.isEmpty()) {
            return new EVCacheFuture[0];
        }
        EVCacheFuture[] eFutures = new EVCacheFuture[futures.size()];
        for (int i = 0; i < futures.size(); ++i) {
            Future<Boolean> future = futures.get(i);
            eFutures[i] = future instanceof EVCacheFuture ? (EVCacheFuture)future : (future instanceof EVCacheOperationFuture ? new EVCacheFuture(futures.get(i), key, this._appName, ((EVCacheOperationFuture)((Object)futures.get(i))).getServerGroup()) : new EVCacheFuture(future, key, this._appName, null));
        }
        return eFutures;
    }

    @Override
    public <T> EVCacheLatch set(String key, T value, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.set(key, value, this._transcoder, this._timeToLive, policy);
    }

    @Override
    public <T> EVCacheLatch set(String key, T value, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.set(key, value, this._transcoder, timeToLive, policy);
    }

    @Override
    public <T> EVCacheLatch set(String key, T value, Transcoder<T> tc, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.set(key, value, tc, this._timeToLive, policy);
    }

    @Override
    public <T> EVCacheLatch set(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.SET);
        if (event != null) {
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        try {
            CachedData cd = null;
            for (EVCacheClient client : clients) {
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : client.getTranscoder().encode(value));
                    if (this.hashKey.get()) {
                        EVCacheValue val = new EVCacheValue(key, cd.getData(), cd.getFlags(), timeToLive, System.currentTimeMillis());
                        cd = this.evcacheValueTranscoder.encode(val);
                    }
                }
                Future<Boolean> future = client.set(canonicalKey, cd, timeToLive, (EVCacheLatch)latch);
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("SET : APP " + this._appName + ", Future " + future + " for key : " + canonicalKey);
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception setting the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.endEvent(event);
            }
            status = "error";
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.SET.name(), "write", null, status, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("SET : APP " + this._appName + ", Took " + duration + " milliSec for key : " + canonicalKey);
            }
        }
    }

    public <T> EVCacheFuture[] append(String key, T value, int timeToLive) throws EVCacheException {
        return this.append(key, value, (Transcoder<T>)null, timeToLive);
    }

    public <T> EVCacheFuture[] append(String key, T value, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        if (this.hashKey.get()) {
            throw new EVCacheException("hashing of key is not supported for append operations");
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheFuture[0];
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.APPEND);
        if (event != null) {
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheFuture[0];
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        try {
            EVCacheFuture[] futures = new EVCacheFuture[clients.length];
            CachedData cd = null;
            int index = 0;
            for (EVCacheClient client : clients) {
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : client.getTranscoder().encode(value));
                }
                Future<Boolean> future = client.append(canonicalKey, cd);
                futures[index++] = new EVCacheFuture(future, key, this._appName, client.getServerGroup(), client);
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setCachedData(cd);
                event.setTTL(timeToLive);
                this.endEvent(event);
            }
            this.touchData(canonicalKey, key, timeToLive, clients);
            Object[] objectArray = futures;
            return objectArray;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception setting the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            status = "error";
            if (!throwExc) {
                EVCacheFuture[] eVCacheFutureArray = new EVCacheFuture[]{};
                return eVCacheFutureArray;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.APPEND.name(), "write", null, status, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("APPEND : APP " + this._appName + ", Took " + duration + " milliSec for key : " + canonicalKey);
            }
        }
    }

    public <T> EVCacheFuture[] set(String key, T value, Transcoder<T> tc) throws EVCacheException {
        return this.set(key, value, tc, this._timeToLive);
    }

    public <T> EVCacheFuture[] set(String key, T value, int timeToLive) throws EVCacheException {
        return this.set(key, value, (Transcoder<T>)this._transcoder, timeToLive);
    }

    public <T> EVCacheFuture[] set(String key, T value) throws EVCacheException {
        return this.set(key, value, (Transcoder<T>)this._transcoder, this._timeToLive);
    }

    public EVCacheFuture[] delete(String key) throws EVCacheException {
        EVCacheLatch latch = this.delete(key, null);
        if (latch == null) {
            return new EVCacheFuture[0];
        }
        List<Future<Boolean>> futures = latch.getAllFutures();
        if (futures == null || futures.isEmpty()) {
            return new EVCacheFuture[0];
        }
        EVCacheFuture[] eFutures = new EVCacheFuture[futures.size()];
        for (int i = 0; i < futures.size(); ++i) {
            Future<Boolean> future = futures.get(i);
            if (future instanceof EVCacheFuture) {
                eFutures[i] = (EVCacheFuture)future;
                continue;
            }
            if (future instanceof EVCacheOperationFuture) {
                EVCacheOperationFuture evfuture = (EVCacheOperationFuture)((Object)future);
                eFutures[i] = new EVCacheFuture(future, key, this._appName, evfuture.getServerGroup(), evfuture.getEVCacheClient());
                continue;
            }
            eFutures[i] = new EVCacheFuture(future, key, this._appName, null);
        }
        return eFutures;
    }

    @Override
    public <T> EVCacheLatch delete(String key, EVCacheLatch.Policy policy) throws EVCacheException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to delete the keyAPP " + this._appName + ", Key " + key);
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.DELETE);
        if (event != null) {
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        String status = "success";
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        try {
            for (int i = 0; i < clients.length; ++i) {
                Future<Boolean> future = clients[i].delete(canonicalKey, latch);
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("DELETE : APP " + this._appName + ", Future " + future + " for key : " + canonicalKey);
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl i = latch;
            return i;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while deleting the data for APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            status = "error";
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception while deleting the data for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.DELETE.name(), "write", null, status, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("DELETE : APP " + this._appName + " Took " + duration + " milliSec for key : " + key);
            }
        }
    }

    public int getDefaultTTL() {
        return this._timeToLive;
    }

    @Override
    public long incr(String key, long by, long defaultVal, int timeToLive) throws EVCacheException {
        if (null == key || by < 0L || defaultVal < 0L || timeToLive < 0) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient");
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("INCR : " + this._metricPrefix + ":NULL_CLIENT");
            }
            if (throwExc) {
                throw new EVCacheException("Could not find a client to incr the data");
            }
            return -1L;
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.INCR);
        if (event != null) {
            event.setCanonicalKeys(Arrays.asList(canonicalKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return -1L;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return -1L;
            }
            this.startEvent(event);
        }
        String status = "success";
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        try {
            long[] vals = new long[clients.length];
            int index = 0;
            long currentValue = -1L;
            for (EVCacheClient client : clients) {
                vals[index] = client.incr(canonicalKey, by, defaultVal, timeToLive);
                if (vals[index] != -1L && currentValue < vals[index]) {
                    currentValue = vals[index];
                }
                ++index;
            }
            if (currentValue != -1L) {
                CachedData cd = null;
                if (log.isDebugEnabled()) {
                    log.debug("INCR : APP " + this._appName + " current value = " + currentValue + " for key : " + key);
                }
                for (int i = 0; i < vals.length; ++i) {
                    if (vals[i] == -1L && currentValue > -1L) {
                        if (log.isDebugEnabled()) {
                            log.debug("INCR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value = -1 so setting it to current value = " + currentValue + " for key : " + key);
                        }
                        clients[i].incr(canonicalKey, 0L, currentValue, timeToLive);
                        continue;
                    }
                    if (vals[i] == currentValue) continue;
                    if (cd == null) {
                        cd = clients[i].getTranscoder().encode((Object)canonicalKey);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("INCR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value of " + vals[i] + " so setting it to current value = " + currentValue + " for key : " + key);
                    }
                    clients[i].set(canonicalKey, cd, timeToLive);
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            long l = currentValue;
            return l;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception incrementing the value for APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                long l = -1L;
                return l;
            }
            throw new EVCacheException("Exception incrementing value for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.INCR.name(), "write", null, status, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("INCR : APP " + this._appName + ", Took " + duration + " milliSec for key : " + key);
            }
        }
    }

    @Override
    public long decr(String key, long by, long defaultVal, int timeToLive) throws EVCacheException {
        if (null == key || by < 0L || defaultVal < 0L || timeToLive < 0) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient");
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("DECR : " + this._metricPrefix + ":NULL_CLIENT");
            }
            if (throwExc) {
                throw new EVCacheException("Could not find a client to decr the data");
            }
            return -1L;
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.DECR);
        if (event != null) {
            event.setCanonicalKeys(Arrays.asList(canonicalKey));
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return -1L;
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return -1L;
            }
            this.startEvent(event);
        }
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        try {
            long[] vals = new long[clients.length];
            int index = 0;
            long currentValue = -1L;
            for (EVCacheClient client : clients) {
                vals[index] = client.decr(canonicalKey, by, defaultVal, timeToLive);
                if (vals[index] != -1L && currentValue < vals[index]) {
                    currentValue = vals[index];
                }
                ++index;
            }
            if (currentValue != -1L) {
                CachedData cd = null;
                if (log.isDebugEnabled()) {
                    log.debug("DECR : APP " + this._appName + " current value = " + currentValue + " for key : " + key);
                }
                for (int i = 0; i < vals.length; ++i) {
                    if (vals[i] == -1L && currentValue > -1L) {
                        if (log.isDebugEnabled()) {
                            log.debug("DECR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value = -1 so setting it to current value = " + currentValue + " for key : " + key);
                        }
                        clients[i].decr(canonicalKey, 0L, currentValue, timeToLive);
                        continue;
                    }
                    if (vals[i] == currentValue) continue;
                    if (cd == null) {
                        cd = clients[i].getTranscoder().encode((Object)canonicalKey);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("DECR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value of " + vals[i] + " so setting it to current value = " + currentValue + " for key : " + key);
                    }
                    clients[i].set(canonicalKey, cd, timeToLive);
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            long l = currentValue;
            return l;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception decrementing the value for APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                long l = -1L;
                return l;
            }
            throw new EVCacheException("Exception decrementing value for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.DECR.name(), "write", null, status, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("DECR : APP " + this._appName + ", Took " + duration + " milliSec for key : " + key);
            }
        }
    }

    @Override
    public <T> EVCacheLatch replace(String key, T value, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.replace(key, value, this._transcoder, policy);
    }

    @Override
    public <T> EVCacheLatch replace(String key, T value, Transcoder<T> tc, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.replace(key, value, this._transcoder, this._timeToLive, policy);
    }

    public <T> EVCacheLatch replace(String key, T value, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.replace(key, value, this._transcoder, timeToLive, policy);
    }

    @Override
    public <T> EVCacheLatch replace(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.REPLACE);
        if (event != null) {
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        try {
            EVCacheFuture[] futures = new EVCacheFuture[clients.length];
            CachedData cd = null;
            int index = 0;
            for (EVCacheClient client : clients) {
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : client.getTranscoder().encode(value));
                }
                Future<Boolean> future = client.replace(canonicalKey, cd, timeToLive, (EVCacheLatch)latch);
                futures[index++] = new EVCacheFuture(future, key, this._appName, client.getServerGroup());
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception setting the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.REPLACE.name(), "write", null, status, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("REPLACE : APP " + this._appName + ", Took " + duration + " milliSec for key : " + canonicalKey);
            }
        }
    }

    @Override
    public String getCachePrefix() {
        return this._cacheName;
    }

    @Override
    public String getAppName() {
        return this._appName;
    }

    public String getCacheName() {
        return this._cacheName;
    }

    @Override
    public <T> EVCacheLatch appendOrAdd(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        if (this.hashKey.get()) {
            throw new EVCacheException("hashing of key is not supported for appendOrAdd operations");
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to appendOrAdd the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.APPEND_OR_ADD);
        if (event != null) {
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return null;
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length - this._pool.getWriteOnlyEVCacheClients().length, this._appName);
        String status = "success";
        try {
            CachedData cd = null;
            for (EVCacheClient client : clients) {
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : client.getTranscoder().encode(value));
                }
                Future<Boolean> future = client.appendOrAdd(canonicalKey, cd, timeToLive, latch);
                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                log.debug("APPEND_OR_ADD : APP " + this._appName + ", Future " + future + " for key : " + canonicalKey);
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    latch.scheduledFutureValidation();
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while appendOrAdd the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception while appendOrAdd data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.APPEND_OR_ADD.name(), "write", null, status, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("APPEND_OR_ADD : APP " + this._appName + ", Took " + duration + " milliSec for key : " + canonicalKey);
            }
        }
    }

    @Override
    public <T> Future<Boolean>[] appendOrAdd(String key, T value, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        EVCacheLatch latch = this.appendOrAdd(key, value, tc, timeToLive, EVCacheLatch.Policy.ALL_MINUS_1);
        if (latch != null) {
            return latch.getAllFutures().toArray(new Future[latch.getAllFutures().size()]);
        }
        return new EVCacheFuture[0];
    }

    @Override
    public <T> boolean add(String key, T value, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        EVCacheLatch latch = this.add(key, value, tc, timeToLive, EVCacheLatch.Policy.NONE);
        try {
            latch.await(this._pool.getOperationTimeout().get(), TimeUnit.MILLISECONDS);
            return latch.getSuccessCount() >= latch.getExpectedCompleteCount();
        }
        catch (InterruptedException e) {
            boolean throwExc;
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception adding the data for APP " + this._appName + ", key : " + key, (Throwable)e);
            }
            if (throwExc = this.doThrowException()) {
                throw new EVCacheException("Exception add data for APP " + this._appName + ", key : " + key, e);
            }
            return false;
        }
    }

    @Override
    public <T> EVCacheLatch add(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            this.incrementFastFail("nullClient");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to Add the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.ADD);
        if (event != null) {
            try {
                if (this.shouldThrottle(event)) {
                    this.incrementFastFail("throttled");
                    if (throwExc) {
                        throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                    }
                    return new EVCacheLatchImpl(policy, 0, this._appName);
                }
            }
            catch (EVCacheException ex) {
                if (throwExc) {
                    throw ex;
                }
                this.incrementFastFail("throttled");
                return new EVCacheLatchImpl(policy, 0, this._appName);
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        long start = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime();
        String status = "success";
        EVCacheLatch latch = null;
        try {
            CachedData cd = null;
            if (cd == null) {
                cd = tc != null ? tc.encode(value) : (this._transcoder != null ? this._transcoder.encode(value) : this._pool.getEVCacheClientForRead().getTranscoder().encode(value));
                if (this.hashKey.get()) {
                    EVCacheValue val = new EVCacheValue(key, cd.getData(), cd.getFlags(), timeToLive, System.currentTimeMillis());
                    cd = this.evcacheValueTranscoder.encode(val);
                }
            }
            if (this.clientUtil == null) {
                this.clientUtil = new EVCacheClientUtil(this._pool);
            }
            latch = this.clientUtil.add(canonicalKey, cd, timeToLive, policy);
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                if (((Boolean)this._eventsUsingLatchFP.get()).booleanValue()) {
                    latch.setEVCacheEvent(event);
                    if (latch instanceof EVCacheLatchImpl) {
                        ((EVCacheLatchImpl)latch).scheduledFutureValidation();
                    }
                } else {
                    this.endEvent(event);
                }
            }
            EVCacheLatch eVCacheLatch = latch;
            return eVCacheLatch;
        }
        catch (Exception ex) {
            status = "error";
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception adding the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception adding data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            long duration = EVCacheMetricsFactory.getInstance().getRegistry().clock().wallTime() - start;
            this.getTimer(EVCache.Call.ADD.name(), "write", null, status, 1).record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("ADD : APP " + this._appName + ", Took " + duration + " milliSec for key : " + canonicalKey);
            }
        }
    }

    private Timer getTimer(String operation, String operationType, String hit, String status, int tries) {
        return this.getTimer(operation, operationType, hit, status, tries, 0);
    }

    private Timer getTimer(String operation, String operationType, String hit, String status, int tries, int numOfKeys) {
        Timer timer;
        String name;
        String string = name = hit != null ? operation + hit : operation;
        if (status != null) {
            name = name + status;
        }
        if (tries >= 0) {
            name = name + tries;
        }
        if (numOfKeys >= 0) {
            name = name + numOfKeys;
        }
        if ((timer = this.timerMap.get(name)) != null) {
            return timer;
        }
        ArrayList<Tag> tagList = new ArrayList<Tag>(7);
        tagList.addAll(this.tags);
        if (operation != null) {
            tagList.add((Tag)new BasicTag("evc.operation", operation));
        }
        if (operationType != null) {
            tagList.add((Tag)new BasicTag("evc.operationType", operationType));
        }
        if (status != null) {
            tagList.add((Tag)new BasicTag("ipc.result", status));
        }
        if (hit != null) {
            tagList.add((Tag)new BasicTag("evc.cacheHit", hit));
        }
        if (tries >= 0) {
            tagList.add((Tag)new BasicTag("ipc.attempt", String.valueOf(tries)));
        }
        if (numOfKeys >= 1) {
            tagList.add((Tag)new BasicTag("evc.numberOfKeys", String.valueOf(numOfKeys)));
        }
        timer = EVCacheMetricsFactory.getInstance().getPercentileTimer("ipc.client.call", tagList);
        this.timerMap.put(name, timer);
        return timer;
    }

    protected CachedData getEVCacheValue(String key, CachedData cData, int timeToLive) {
        EVCacheValue val = new EVCacheValue(key, cData.getData(), cData.getFlags(), timeToLive, System.currentTimeMillis());
        return this.evcacheValueTranscoder.encode(val);
    }
}

