/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Tag;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.protocol.binary.BinaryMemcachedNodeImpl;
import net.spy.memcached.protocol.binary.EVCacheNodeImplMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL", "EXS_EXCEPTION_SOFTENING_NO_CHECKED", "REC_CATCH_EXCEPTION", "SCII_SPOILED_CHILD_INTERFACE_IMPLEMENTATOR"})
public class EVCacheNodeImpl
extends BinaryMemcachedNodeImpl
implements EVCacheNodeImplMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheNodeImpl.class);
    protected long stTime;
    protected final String hostName;
    protected final BlockingQueue<Operation> readQ;
    protected final BlockingQueue<Operation> inputQueue;
    protected final EVCacheClient client;
    protected final Counter operationsCounter;
    protected final Counter reconnectCounter;
    private long timeoutStartTime;

    public EVCacheNodeImpl(SocketAddress sa, SocketChannel c, int bufSize, BlockingQueue<Operation> rq, BlockingQueue<Operation> wq, BlockingQueue<Operation> iq, long opQueueMaxBlockTimeMillis, boolean waitForAuth, long dt, long at, ConnectionFactory fa, EVCacheClient client, long stTime) {
        super(sa, c, bufSize, rq, wq, iq, Long.valueOf(opQueueMaxBlockTimeMillis), waitForAuth, dt, at, fa);
        this.client = client;
        String appName = client.getAppName();
        this.readQ = rq;
        this.inputQueue = iq;
        this.hostName = ((InetSocketAddress)this.getSocketAddress()).getHostName();
        ArrayList<Tag> tagsCounter = new ArrayList<Tag>(5);
        tagsCounter.add((Tag)new BasicTag("evc.config", "evc.operation"));
        this.operationsCounter = EVCacheMetricsFactory.getInstance().getCounter("internal-evc.client.call", tagsCounter);
        ArrayList<Tag> tags = new ArrayList<Tag>(5);
        tags.add((Tag)new BasicTag("evc.host", this.hostName));
        tags.add((Tag)new BasicTag("evc.config", "reconnect"));
        this.reconnectCounter = EVCacheMetricsFactory.getInstance().getCounter("internal-evc.client.call", tags);
        this.setConnectTime(stTime);
        this.setupMonitoring(appName);
    }

    private String getMonitorName(String appName) {
        return "com.netflix.evcache:Group=" + appName + ",SubGroup=pool,SubSubGroup=" + this.client.getServerGroupName() + ",SubSubSubGroup=" + this.client.getId() + ",SubSubSubSubGroup=" + this.hostName + "_" + this.stTime;
    }

    private void setupMonitoring(String appName) {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance(this.getMonitorName(appName));
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                mbeanServer.registerMBean(this, mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception while setting up the monitoring.", (Throwable)e);
            }
        }
    }

    public boolean isAvailable() {
        return this.isActive();
    }

    @Override
    public int getWriteQueueSize() {
        return this.writeQ.size();
    }

    @Override
    public int getReadQueueSize() {
        return this.readQ.size();
    }

    @Override
    public int getInputQueueSize() {
        return this.inputQueue.size();
    }

    public long incrOps() {
        this.operationsCounter.increment();
        return this.operationsCounter.count();
    }

    @Override
    public long getNumOfOps() {
        return this.operationsCounter.count();
    }

    @Override
    public void flushInputQueue() {
        this.inputQueue.clear();
    }

    public long getStartTime() {
        return this.stTime;
    }

    public long getTimeoutStartTime() {
        return this.timeoutStartTime;
    }

    @Override
    public void removeMonitoring() {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance(this.getMonitorName(this.client.getAppName()));
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception while setting up the monitoring.", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.removeMonitoring();
        this.writeQ.clear();
        this.readQ.clear();
        this.inputQueue.clear();
        try {
            if (this.getRbuf() instanceof DirectBuffer) {
                Cleaner cleaner = ((DirectBuffer)((Object)this.getRbuf())).cleaner();
                if (cleaner != null) {
                    cleaner.clean();
                }
                if ((cleaner = ((DirectBuffer)((Object)this.getWbuf())).cleaner()) != null) {
                    cleaner.clean();
                }
            }
        }
        catch (Throwable t) {
            this.getLogger().error((Object)"Exception cleaning ByteBuffer.", t);
        }
    }

    public long getCreateTime() {
        return this.stTime;
    }

    public void setConnectTime(long cTime) {
        this.stTime = cTime;
        this.reconnectCounter.increment();
    }

    public String getAppName() {
        return this.client.getAppName();
    }

    public String getHostName() {
        return this.hostName;
    }

    public ServerGroup getServerGroup() {
        return this.client.getServerGroup();
    }

    public int getId() {
        return this.client.getId();
    }

    public List<Tag> getTags() {
        return this.client.getTagList();
    }

    public int getTotalReconnectCount() {
        return (int)this.reconnectCounter.count();
    }
}

