/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.pool.EVCacheScheduledExecutorMBean;
import com.netflix.evcache.util.EVCacheConfig;
import java.lang.management.ManagementFactory;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheScheduledExecutor
extends ScheduledThreadPoolExecutor
implements EVCacheScheduledExecutorMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheScheduledExecutor.class);
    private final DynamicIntProperty maxAsyncPoolSize;
    private final DynamicIntProperty coreAsyncPoolSize;
    private final String name;

    public EVCacheScheduledExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, handler);
        this.name = name;
        this.maxAsyncPoolSize = EVCacheConfig.getInstance().getDynamicIntProperty(name + ".executor.max.size", maximumPoolSize);
        this.setMaximumPoolSize(this.maxAsyncPoolSize.get());
        this.coreAsyncPoolSize = EVCacheConfig.getInstance().getDynamicIntProperty(name + ".executor.core.size", corePoolSize);
        this.setCorePoolSize(this.coreAsyncPoolSize.get());
        this.setKeepAliveTime(keepAliveTime, unit);
        ThreadFactory asyncFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EVCacheScheduledExecutor-" + name + "-%d").build();
        this.setThreadFactory(asyncFactory);
        this.maxAsyncPoolSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheScheduledExecutor.this.setMaximumPoolSize(EVCacheScheduledExecutor.this.maxAsyncPoolSize.get());
            }
        });
        this.coreAsyncPoolSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheScheduledExecutor.this.setCorePoolSize(EVCacheScheduledExecutor.this.coreAsyncPoolSize.get());
                EVCacheScheduledExecutor.this.prestartAllCoreThreads();
            }
        });
        this.setupMonitoring(name);
    }

    private void setupMonitoring(String name) {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                mbeanServer.registerMBean(this, mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception", (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() {
        block2: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + this.name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                mbeanServer.unregisterMBean(mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Exception", (Throwable)e);
            }
        }
        super.shutdown();
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }
}

