/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.util.EVCacheConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.EVCacheMemcachedNodeROImpl;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheNodeLocator
implements NodeLocator {
    private static Logger log = LoggerFactory.getLogger(EVCacheNodeLocator.class);
    private TreeMap<Long, MemcachedNode> ketamaNodes;
    protected final EVCacheClient client;
    private ChainedDynamicProperty.BooleanProperty partialStringHash;
    private ChainedDynamicProperty.StringProperty hashDelimiter;
    private final Collection<MemcachedNode> allNodes;
    private final HashAlgorithm hashingAlgorithm;
    private final KetamaNodeLocatorConfiguration config;

    public EVCacheNodeLocator(EVCacheClient client, List<MemcachedNode> nodes, HashAlgorithm alg, KetamaNodeLocatorConfiguration conf) {
        this.allNodes = nodes;
        this.hashingAlgorithm = alg;
        this.config = conf;
        this.client = client;
        this.partialStringHash = EVCacheConfig.getInstance().getChainedBooleanProperty("EVCacheNodeLocator." + client.getAppName() + "." + client.getServerGroupName() + ".hash.on.partial.key", "EVCacheNodeLocator." + client.getAppName() + ".hash.on.partial.key", Boolean.FALSE, null);
        this.hashDelimiter = EVCacheConfig.getInstance().getChainedStringProperty("EVCacheNodeLocator." + client.getAppName() + "." + client.getServerGroupName() + ".hash.delimiter", "EVCacheNodeLocator." + client.getAppName() + ".hash.delimiter", ":", null);
        this.setKetamaNodes(nodes);
    }

    private EVCacheNodeLocator(EVCacheClient client, TreeMap<Long, MemcachedNode> smn, Collection<MemcachedNode> an, HashAlgorithm alg, KetamaNodeLocatorConfiguration conf) {
        this.ketamaNodes = smn;
        this.allNodes = an;
        this.hashingAlgorithm = alg;
        this.config = conf;
        this.client = client;
        this.partialStringHash = EVCacheConfig.getInstance().getChainedBooleanProperty("EVCacheNodeLocator." + client.getAppName() + "." + client.getServerGroupName() + ".hash.on.partial.key", "EVCacheNodeLocator." + client.getAppName() + ".hash.on.partial.key", Boolean.FALSE, null);
        this.hashDelimiter = EVCacheConfig.getInstance().getChainedStringProperty("EVCacheNodeLocator." + client.getAppName() + "." + client.getServerGroupName() + ".hash.delimiter", "EVCacheNodeLocator." + client.getAppName() + ".hash.delimiter", ":", null);
    }

    public Collection<MemcachedNode> getAll() {
        return this.allNodes;
    }

    public MemcachedNode getPrimary(String k) {
        int index;
        if (((Boolean)this.partialStringHash.get()).booleanValue() && (index = k.indexOf((String)this.hashDelimiter.get())) > 0) {
            k = k.substring(0, index);
        }
        long _hash = this.hashingAlgorithm.hash(k);
        Long hash = _hash;
        if ((hash = this.ketamaNodes.ceilingKey(hash)) == null) {
            hash = this.ketamaNodes.firstKey();
        }
        return this.ketamaNodes.get(hash);
    }

    public long getMaxKey() {
        return this.getKetamaNodes().lastKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcachedNode getNodeForKey(long _hash) {
        long start = log.isDebugEnabled() ? System.nanoTime() : 0L;
        try {
            Long hash = _hash;
            hash = this.ketamaNodes.ceilingKey(hash);
            if (hash == null) {
                hash = this.ketamaNodes.firstKey();
            }
            MemcachedNode memcachedNode = this.ketamaNodes.get(hash);
            return memcachedNode;
        }
        finally {
            if (log.isDebugEnabled()) {
                long end = System.nanoTime();
                log.debug("getNodeForKey : \t" + (end - start) / 1000L);
            }
        }
    }

    public Iterator<MemcachedNode> getSequence(String k) {
        ArrayList<MemcachedNode> allKetamaNodes = new ArrayList<MemcachedNode>(this.getKetamaNodes().values());
        Collections.shuffle(allKetamaNodes);
        return allKetamaNodes.iterator();
    }

    public NodeLocator getReadonlyCopy() {
        TreeMap<Long, MemcachedNode> ketamaNaodes = new TreeMap<Long, MemcachedNode>((SortedMap<Long, MemcachedNode>)this.getKetamaNodes());
        ArrayList<MemcachedNode> aNodes = new ArrayList<MemcachedNode>(this.allNodes.size());
        for (Map.Entry<Long, MemcachedNode> me : ketamaNaodes.entrySet()) {
            me.setValue(new EVCacheMemcachedNodeROImpl(me.getValue()));
        }
        for (MemcachedNode n : this.allNodes) {
            aNodes.add(new EVCacheMemcachedNodeROImpl(n));
        }
        return new EVCacheNodeLocator(this.client, ketamaNaodes, aNodes, this.hashingAlgorithm, this.config);
    }

    protected TreeMap<Long, MemcachedNode> getKetamaNodes() {
        return this.ketamaNodes;
    }

    public Map<Long, MemcachedNode> getKetamaNodeMap() {
        return Collections.unmodifiableMap(this.ketamaNodes);
    }

    protected final void setKetamaNodes(List<MemcachedNode> nodes) {
        TreeMap<Long, MemcachedNode> newNodeMap = new TreeMap<Long, MemcachedNode>();
        int numReps = this.config.getNodeRepetitions();
        for (MemcachedNode node : nodes) {
            int i;
            if (this.hashingAlgorithm == DefaultHashAlgorithm.KETAMA_HASH) {
                for (i = 0; i < numReps / 4; ++i) {
                    String hashString = this.config.getKeyForNode(node, i);
                    byte[] digest = DefaultHashAlgorithm.computeMd5((String)hashString);
                    if (log.isDebugEnabled()) {
                        log.debug("digest : " + digest);
                    }
                    for (int h = 0; h < 4; ++h) {
                        long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
                        newNodeMap.put(k, node);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Key : " + hashString + " ; hash : " + k + "; node " + node);
                    }
                }
                continue;
            }
            for (i = 0; i < numReps; ++i) {
                Long hashL = this.hashingAlgorithm.hash(this.config.getKeyForNode(node, i));
                newNodeMap.put(hashL, node);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("NewNodeMapSize : " + newNodeMap.size() + "; MapSize : " + numReps * nodes.size());
        }
        if (log.isTraceEnabled()) {
            for (Long key : newNodeMap.keySet()) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Hash : " + key + "; Node : " + newNodeMap.get(key));
            }
        }
        this.ketamaNodes = newNodeMap;
    }

    public void updateLocator(List<MemcachedNode> nodes) {
        this.setKetamaNodes(nodes);
    }

    public String toString() {
        return "EVCacheNodeLocator [ketamaNodes=" + this.ketamaNodes + ", EVCacheClient=" + this.client + ", partialStringHash=" + this.partialStringHash + ", hashDelimiter=" + this.hashDelimiter + ", allNodes=" + this.allNodes + ", hashingAlgorithm=" + this.hashingAlgorithm + ", config=" + this.config + "]";
    }
}

