/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.util.EVCacheConfig;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.util.DefaultKetamaNodeLocatorConfiguration;

public class EVCacheKetamaNodeLocatorConfiguration
extends DefaultKetamaNodeLocatorConfiguration {
    protected final EVCacheClient client;
    protected final ChainedDynamicProperty.IntProperty bucketSize;
    protected final Map<MemcachedNode, String> socketAddresses = new HashMap<MemcachedNode, String>();

    public EVCacheKetamaNodeLocatorConfiguration(EVCacheClient client) {
        this.client = client;
        this.bucketSize = EVCacheConfig.getInstance().getChainedIntProperty(client.getAppName() + "." + client.getServerGroupName() + ".bucket.size", client.getAppName() + ".bucket.size", super.getNodeRepetitions(), null);
    }

    public int getNodeRepetitions() {
        return (Integer)this.bucketSize.get();
    }

    public String getKeyForNode(MemcachedNode node, int repetition) {
        String result = this.socketAddresses.get(node);
        if (result == null) {
            SocketAddress socketAddress = node.getSocketAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)socketAddress;
                result = isa.getHostName() + '/' + isa.getAddress().getHostAddress() + ":11211";
            } else {
                result = String.valueOf(socketAddress);
                if (result.startsWith("/")) {
                    result = result.substring(1);
                }
            }
            this.socketAddresses.put(node, result);
        }
        return result + "-" + repetition;
    }

    public String toString() {
        return "EVCacheKetamaNodeLocatorConfiguration [EVCacheClient=" + this.client + ", BucketSize=" + this.getNodeRepetitions() + "]";
    }
}

