/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.evcache.EVCacheGetOperationListener;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheBulkGetFuture;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.CASValue;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.ListenableFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.ConcatenationType;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.protocol.binary.EVCacheNodeImpl;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "SIC_INNER_SHOULD_BE_STATIC_ANON"})
public class EVCacheMemcachedClient
extends MemcachedClient {
    private static final Logger log = LoggerFactory.getLogger(EVCacheMemcachedClient.class);
    private final String appName;
    private final ChainedDynamicProperty.IntProperty readTimeout;
    private final EVCacheClient client;
    private DistributionSummary getDataSize;
    private DistributionSummary bulkDataSize;
    private DistributionSummary getAndTouchDataSize;
    private DynamicLongProperty mutateOperationTimeout;

    public EVCacheMemcachedClient(ConnectionFactory cf, List<InetSocketAddress> addrs, ChainedDynamicProperty.IntProperty readTimeout, EVCacheClient client) throws IOException {
        super(cf, addrs);
        this.readTimeout = readTimeout;
        this.client = client;
        this.appName = client.getAppName();
    }

    public NodeLocator getNodeLocator() {
        return this.mconn.getLocator();
    }

    public MemcachedNode getEVCacheNode(String key) {
        return this.mconn.getLocator().getPrimary(key);
    }

    public <T> GetFuture<T> asyncGet(String key, Transcoder<T> tc) {
        throw new UnsupportedOperationException("asyncGet");
    }

    public <T> EVCacheOperationFuture<T> asyncGet(final String key, final Transcoder<T> tc, EVCacheGetOperationListener<T> listener) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), ((Integer)this.readTimeout.get()).intValue(), this.executorService, this.client, "GetOperation");
        final Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-GetOperation", this.client.getTagList());
        GetOperation op = this.opFact.get(key, new GetOperation.Callback(){
            private Future<T> val = null;

            public void receivedStatus(OperationStatus status) {
                operationDuration.record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                try {
                    if (this.val != null) {
                        rv.set(this.val.get(), status);
                    } else {
                        rv.set(null, status);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    rv.set(null, status);
                }
            }

            public void gotData(String k, int flags, byte[] data) {
                if (data != null) {
                    if (EVCacheMemcachedClient.this.getDataSize == null) {
                        EVCacheMemcachedClient.this.getDataSize = EVCacheMetricsFactory.getInstance().getDistributionSummary(EVCacheMemcachedClient.this.appName + "-GetOperation-DataSize", EVCacheMemcachedClient.this.client.getTagList());
                    }
                    if (EVCacheMemcachedClient.this.getDataSize != null) {
                        EVCacheMemcachedClient.this.getDataSize.record((long)data.length);
                    }
                }
                if (!key.equals(k)) {
                    log.warn("Wrong key returned. Key - " + key + "; Returned Key " + k);
                }
                if (tc == null) {
                    if (EVCacheMemcachedClient.this.tcService == null) {
                        log.error("tcService is null, will not be able to decode");
                        throw new RuntimeException("TranscoderSevice is null. Not able to decode");
                    }
                    Transcoder t = EVCacheMemcachedClient.this.getTranscoder();
                    this.val = EVCacheMemcachedClient.this.tcService.decode(t, new CachedData(flags, data, t.getMaxSize()));
                } else {
                    if (EVCacheMemcachedClient.this.tcService == null) {
                        log.error("tcService is null, will not be able to decode");
                        throw new RuntimeException("TranscoderSevice is null. Not able to decode");
                    }
                    this.val = EVCacheMemcachedClient.this.tcService.decode(tc, new CachedData(flags, data, tc.getMaxSize()));
                }
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (listener != null) {
            rv.addListener(listener);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> EVCacheBulkGetFuture<T> asyncGetBulk(Collection<String> keys, final Transcoder<T> tc, EVCacheGetOperationListener<T> listener, String metricName) {
        final ConcurrentHashMap m = new ConcurrentHashMap();
        HashMap<MemcachedNode, ArrayList<String>> chunks = new HashMap<MemcachedNode, ArrayList<String>>();
        NodeLocator locator = this.mconn.getLocator();
        for (String key : keys) {
            StringUtils.validateKey((String)key, (boolean)(this.opFact instanceof BinaryOperationFactory));
            MemcachedNode primaryNode = locator.getPrimary(key);
            if (!primaryNode.isActive()) continue;
            ArrayList<String> ks = (ArrayList<String>)chunks.get(primaryNode);
            if (ks == null) {
                ks = new ArrayList<String>();
                chunks.put(primaryNode, ks);
            }
            ks.add(key);
        }
        final AtomicInteger pendingChunks = new AtomicInteger(chunks.size());
        int initialLatchCount = chunks.isEmpty() ? 0 : 1;
        final CountDownLatch latch = new CountDownLatch(initialLatchCount);
        ArrayList<Operation> ops = new ArrayList<Operation>(chunks.size());
        final EVCacheBulkGetFuture rv = new EVCacheBulkGetFuture(m, ops, latch, this.executorService, this.client, metricName);
        final Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-BulkOperation", this.client.getTagList());
        GetOperation.Callback cb = new GetOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
                operationDuration.record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                rv.setStatus(status);
            }

            public void gotData(String k, int flags, byte[] data) {
                if (data != null) {
                    if (EVCacheMemcachedClient.this.bulkDataSize == null) {
                        EVCacheMemcachedClient.this.bulkDataSize = EVCacheMetricsFactory.getInstance().getDistributionSummary(EVCacheMemcachedClient.this.appName + "-BulkOperation-DataSize", EVCacheMemcachedClient.this.client.getTagList());
                    }
                    if (EVCacheMemcachedClient.this.bulkDataSize != null) {
                        EVCacheMemcachedClient.this.bulkDataSize.record((long)data.length);
                    }
                }
                m.put(k, EVCacheMemcachedClient.this.tcService.decode(tc, new CachedData(flags, data, tc.getMaxSize())));
            }

            public void complete() {
                if (pendingChunks.decrementAndGet() <= 0) {
                    latch.countDown();
                    rv.signalComplete();
                }
            }
        };
        HashMap mops = new HashMap();
        for (Map.Entry me : chunks.entrySet()) {
            GetOperation op = this.opFact.get((Collection)me.getValue(), cb);
            mops.put(me.getKey(), op);
            ops.add((Operation)op);
        }
        assert (mops.size() == chunks.size());
        this.mconn.checkState();
        this.mconn.addOperations(mops);
        return rv;
    }

    public <T> EVCacheOperationFuture<CASValue<T>> asyncGetAndTouch(final String key, int exp, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.client, "GetAndTouchOperation");
        final Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-GetAndTouchOperation", this.client.getTagList());
        GetAndTouchOperation op = this.opFact.getAndTouch(key, exp, new GetAndTouchOperation.Callback(){
            private CASValue<T> val = null;

            public void receivedStatus(OperationStatus status) {
                operationDuration.record(System.currentTimeMillis() - rv.getStartTime(), TimeUnit.MILLISECONDS);
                rv.set(this.val, status);
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }

            public void gotData(String k, int flags, long cas, byte[] data) {
                if (!key.equals(k)) {
                    log.warn("Wrong key returned. Key - " + key + "; Returned Key " + k);
                }
                if (data != null) {
                    if (EVCacheMemcachedClient.this.getAndTouchDataSize == null) {
                        EVCacheMemcachedClient.this.getAndTouchDataSize = EVCacheMetricsFactory.getInstance().getDistributionSummary(EVCacheMemcachedClient.this.appName + "-GATOperation-DataSize", EVCacheMemcachedClient.this.client.getTagList());
                    }
                    if (EVCacheMemcachedClient.this.getAndTouchDataSize != null) {
                        EVCacheMemcachedClient.this.getAndTouchDataSize.record((long)data.length);
                    }
                }
                this.val = new CASValue(cas, tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> set(String key, int exp, T o, Transcoder<T> tc) {
        return this.asyncStore(StoreType.set, key, exp, o, tc, null);
    }

    public OperationFuture<Boolean> set(String key, int exp, Object o) {
        return this.asyncStore(StoreType.set, key, exp, o, this.transcoder, null);
    }

    public <T> OperationFuture<Boolean> set(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.set, key, exp, o, t, latch);
    }

    public <T> OperationFuture<Boolean> replace(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.replace, key, exp, o, t, latch);
    }

    public <T> OperationFuture<Boolean> add(String key, int exp, T o, Transcoder<T> tc) {
        return this.asyncStore(StoreType.add, key, exp, o, tc, null);
    }

    public OperationFuture<Boolean> delete(String key, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.operationTimeout, this.executorService);
        final long start = System.currentTimeMillis();
        final Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-DeleteOperation", this.client.getTagList());
        DeleteOperation.Callback callback = new DeleteOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
                operationDuration.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
                rv.set((Object)Boolean.TRUE, status);
                if (status.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMetricsFactory.getInstance().increment(EVCacheMemcachedClient.this.appName + "-DeleteOperation-SUCCESS", EVCacheMemcachedClient.this.client.getTagList());
                } else {
                    EVCacheMetricsFactory.getInstance().increment(EVCacheMemcachedClient.this.appName + "-DeleteOperation-" + status.getStatusCode().name(), EVCacheMemcachedClient.this.client.getTagList());
                }
            }

            public void gotData(long cas) {
                rv.setCas(cas);
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        };
        DeleteOperation op = this.opFact.delete(key, callback);
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> touch(String key, int exp, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.operationTimeout, this.executorService);
        final long start = System.currentTimeMillis();
        final Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-TouchOperation", this.client.getTagList());
        KeyedOperation op = this.opFact.touch(key, exp, new OperationCallback(){

            public void receivedStatus(OperationStatus status) {
                operationDuration.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
                rv.set((Object)status.isSuccess(), status);
                if (status.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-TouchOperation-SUCCESS", EVCacheMemcachedClient.this.client.getTagList()).increment();
                } else if (status.getStatusCode().equals((Object)StatusCode.ERR_NOT_FOUND)) {
                    EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-TouchOperation-" + status.getStatusCode().name(), EVCacheMemcachedClient.this.client.getTagList()).increment();
                } else {
                    EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-TouchOperation-" + status.getStatusCode().name(), EVCacheMemcachedClient.this.client.getTagList()).increment();
                }
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> asyncAppendOrAdd(final String key, final int exp, final CachedData co, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.client, "LatencyAoA");
        final Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-AoAOperation", this.client.getTagList());
        ConcatenationOperation op = this.opFact.cat(ConcatenationType.append, 0L, key, co.getData(), new OperationCallback(){
            boolean appendSuccess = false;

            public void receivedStatus(OperationStatus val) {
                if (val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    long duration = System.currentTimeMillis() - rv.getStartTime();
                    operationDuration.record(duration, TimeUnit.MILLISECONDS);
                    if (log.isDebugEnabled()) {
                        log.debug("AddOrAppend Key (Append Operation): " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - duration));
                    }
                    EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-AoA-AppendOperation-SUCCESS", EVCacheMemcachedClient.this.client.getTagList()).increment();
                    rv.set(val.isSuccess(), val);
                    this.appendSuccess = true;
                } else {
                    EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-AoA-AppendOperation-FAIL", EVCacheMemcachedClient.this.client.getTagList()).increment();
                    this.appendSuccess = false;
                }
            }

            public void complete() {
                if (this.appendSuccess) {
                    latch.countDown();
                    rv.signalComplete();
                } else {
                    StoreOperation op = EVCacheMemcachedClient.this.opFact.store(StoreType.add, key, co.getFlags(), exp, co.getData(), new StoreOperation.Callback(){

                        public void receivedStatus(OperationStatus val) {
                            final long duration = System.currentTimeMillis() - rv.getStartTime();
                            operationDuration.record(duration, TimeUnit.MILLISECONDS);
                            if (log.isDebugEnabled()) {
                                log.debug("AddOrAppend Key (Ad Operation): " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - duration));
                            }
                            rv.set(val.isSuccess(), val);
                            if (val.isSuccess()) {
                                appendSuccess = true;
                                EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-AoA-AddOperation-SUCCESS", EVCacheMemcachedClient.this.client.getTagList()).increment();
                            } else {
                                EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-AoA-AddOperation-FAIL", EVCacheMemcachedClient.this.client.getTagList()).increment();
                                ConcatenationOperation op = EVCacheMemcachedClient.this.opFact.cat(ConcatenationType.append, 0L, key, co.getData(), new OperationCallback(){

                                    public void receivedStatus(OperationStatus val) {
                                        if (val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                                            if (log.isDebugEnabled()) {
                                                log.debug("AddOrAppend Retry append Key (Append Operation): " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + duration);
                                            }
                                            EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-AoA-RetryAppendOperation-SUCCESS", EVCacheMemcachedClient.this.client.getTagList()).increment();
                                            rv.set(val.isSuccess(), val);
                                        } else {
                                            EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-AoA-RetryAppendOperation-FAIL", EVCacheMemcachedClient.this.client.getTagList()).increment();
                                        }
                                    }

                                    public void complete() {
                                        latch.countDown();
                                        rv.signalComplete();
                                    }
                                });
                                rv.setOperation((Operation)op);
                                EVCacheMemcachedClient.this.mconn.enqueueOperation(key, (Operation)op);
                            }
                        }

                        public void gotData(String key, long cas) {
                            rv.setCas(cas);
                        }

                        public void complete() {
                            if (appendSuccess) {
                                latch.countDown();
                                rv.signalComplete();
                            }
                        }
                    });
                    rv.setOperation((Operation)op);
                    EVCacheMemcachedClient.this.mconn.enqueueOperation(key, (Operation)op);
                }
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        return rv;
    }

    private <T> OperationFuture<Boolean> asyncStore(StoreType storeType, final String key, int exp, T value, Transcoder<T> tc, EVCacheLatch evcacheLatch) {
        CachedData co = value instanceof CachedData ? (CachedData)value : tc.encode(value);
        final CountDownLatch latch = new CountDownLatch(1);
        final String operationStr = storeType == StoreType.set ? "Set" : (storeType == StoreType.add ? "Add" : "Replace");
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.client, "Latency" + operationStr);
        StoreOperation op = this.opFact.store(storeType, key, co.getFlags(), exp, co.getData(), new StoreOperation.Callback(){
            final Timer operationDuration;
            {
                this.operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(EVCacheMemcachedClient.this.appName + "-" + operationStr + "Operation", EVCacheMemcachedClient.this.client.getTagList());
            }

            public void receivedStatus(OperationStatus val) {
                long duration = System.currentTimeMillis() - rv.getStartTime();
                this.operationDuration.record(duration, TimeUnit.MILLISECONDS);
                if (log.isDebugEnabled()) {
                    log.debug("Storing Key : " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + duration);
                }
                if (val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMetricsFactory.getInstance().increment(EVCacheMemcachedClient.this.appName + "-" + operationStr + "Operation-SUCCESS");
                } else if (val.getStatusCode().equals((Object)StatusCode.TIMEDOUT)) {
                    EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-" + operationStr + "Operation-TIMEDOUT", EVCacheMemcachedClient.this.client.getTagList()).increment();
                } else if (val.getStatusCode().equals((Object)StatusCode.ERR_NOT_FOUND) || val.getStatusCode().equals((Object)StatusCode.ERR_EXISTS)) {
                    EVCacheMetricsFactory.getInstance().increment(EVCacheMemcachedClient.this.appName + "-" + operationStr + "Operation-" + val.getStatusCode().name());
                } else {
                    EVCacheMetricsFactory.getInstance().getCounter(EVCacheMemcachedClient.this.appName + "-" + operationStr + "Operation-" + val.getStatusCode().name(), EVCacheMemcachedClient.this.client.getTagList()).increment();
                }
                rv.set(val.isSuccess(), val);
            }

            public void gotData(String key2, long cas) {
                rv.setCas(cas);
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public String toString() {
        return this.appName + "-" + this.client.getZone() + "-" + this.client.getId();
    }

    public <T> OperationFuture<Boolean> add(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.add, key, exp, o, t, latch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incr(String key, long by, long def, int exp) {
        long start = System.currentTimeMillis();
        Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-IncrOperation", this.client.getTagList());
        long val = 0L;
        try {
            val = this.mutate(Mutator.incr, key, by, def, exp);
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            operationDuration.record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug("Increment Key : " + key + "; by : " + by + "; default : " + def + "; exp : " + exp + "; val : " + val + "; Elapsed Time - " + duration);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decr(String key, long by, long def, int exp) {
        long start = System.currentTimeMillis();
        Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.appName + "-DecrOperation", this.client.getTagList());
        long val = 0L;
        try {
            val = super.decr(key, by, def, exp);
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            operationDuration.record(duration, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug("decrement Key : " + key + "; by : " + by + "; default : " + def + "; exp : " + exp + "; val : " + val + "; Elapsed Time - " + duration);
            }
        }
        return val;
    }

    public long mutate(Mutator m, String key, long by, long def, int exp) {
        final AtomicLong rv = new AtomicLong();
        final CountDownLatch latch = new CountDownLatch(1);
        this.mconn.enqueueOperation(key, (Operation)this.opFact.mutate(m, key, by, def, exp, new OperationCallback(){

            public void receivedStatus(OperationStatus s) {
                rv.set(new Long(s.isSuccess() ? s.getMessage() : "-1"));
            }

            public void complete() {
                latch.countDown();
            }
        }));
        try {
            if (this.mutateOperationTimeout == null) {
                this.mutateOperationTimeout = EVCacheConfig.getInstance().getDynamicLongProperty("evache.mutate.timeout", this.operationTimeout);
            }
            if (!latch.await(this.mutateOperationTimeout.get(), TimeUnit.MILLISECONDS)) {
                return rv.get();
            }
        }
        catch (InterruptedException e) {
            log.error("InterruptedException", (Throwable)e);
        }
        this.getLogger().debug((Object)("Mutation returned " + rv));
        return rv.get();
    }

    public void reconnectNode(EVCacheNodeImpl evcNode) {
        EVCacheMetricsFactory.getInstance().getCounter(this.appName + "-RECONNECT", evcNode.getTags()).increment();
        evcNode.setConnectTime(System.currentTimeMillis());
        this.mconn.queueReconnect((MemcachedNode)evcNode);
    }
}

