/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.util;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.DynamicStringSetProperty;
import com.netflix.config.Property;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EVCacheConfig {
    private static final EVCacheConfig INSTANCE = new EVCacheConfig();
    private final Map<String, Property<?>> fastPropMap = new ConcurrentHashMap();

    private EVCacheConfig() {
    }

    public static EVCacheConfig getInstance() {
        return INSTANCE;
    }

    public DynamicIntProperty getDynamicIntProperty(String name, int defaultValue) {
        DynamicIntProperty prop = (DynamicIntProperty)this.fastPropMap.get(name);
        if (prop != null) {
            return prop;
        }
        prop = DynamicPropertyFactory.getInstance().getIntProperty(name, defaultValue);
        this.fastPropMap.put(name, (Property<?>)prop);
        return prop;
    }

    public DynamicLongProperty getDynamicLongProperty(String name, long defaultValue) {
        DynamicLongProperty prop = (DynamicLongProperty)this.fastPropMap.get(name);
        if (prop != null) {
            return prop;
        }
        prop = DynamicPropertyFactory.getInstance().getLongProperty(name, defaultValue);
        this.fastPropMap.put(name, (Property<?>)prop);
        return prop;
    }

    public DynamicStringProperty getDynamicStringProperty(String name, String defaultValue) {
        DynamicStringProperty prop = (DynamicStringProperty)this.fastPropMap.get(name);
        if (prop != null) {
            return prop;
        }
        prop = DynamicPropertyFactory.getInstance().getStringProperty(name, defaultValue);
        this.fastPropMap.put(name, (Property<?>)prop);
        return prop;
    }

    public DynamicBooleanProperty getDynamicBooleanProperty(String name, Boolean defaultValue) {
        DynamicBooleanProperty prop = (DynamicBooleanProperty)this.fastPropMap.get(name);
        if (prop != null) {
            return prop;
        }
        prop = DynamicPropertyFactory.getInstance().getBooleanProperty(name, defaultValue.booleanValue());
        this.fastPropMap.put(name, (Property<?>)prop);
        return prop;
    }

    public DynamicStringSetProperty getDynamicStringSetProperty(String propertyName, String defaultValue) {
        DynamicStringSetProperty prop = (DynamicStringSetProperty)this.fastPropMap.get(propertyName);
        if (prop != null) {
            return prop;
        }
        prop = new DynamicStringSetProperty(propertyName, defaultValue);
        this.fastPropMap.put(propertyName, (Property<?>)prop);
        return prop;
    }

    public ChainedDynamicProperty.BooleanProperty getChainedBooleanProperty(String overrideKey, String primaryKey, Boolean defaultValue) {
        String mapKey = overrideKey + primaryKey;
        ChainedDynamicProperty.BooleanProperty prop = (ChainedDynamicProperty.BooleanProperty)this.fastPropMap.get(mapKey);
        if (prop != null) {
            return prop;
        }
        prop = new ChainedDynamicProperty.BooleanProperty(overrideKey, new ChainedDynamicProperty.DynamicBooleanPropertyThatSupportsNull(primaryKey, defaultValue));
        this.fastPropMap.put(mapKey, (Property<?>)prop);
        return prop;
    }

    public ChainedDynamicProperty.IntProperty getChainedIntProperty(String overrideKey, String primaryKey, int defaultValue) {
        String mapKey = overrideKey + primaryKey;
        ChainedDynamicProperty.IntProperty prop = (ChainedDynamicProperty.IntProperty)this.fastPropMap.get(mapKey);
        if (prop != null) {
            return prop;
        }
        prop = new ChainedDynamicProperty.IntProperty(overrideKey, new DynamicIntProperty(primaryKey, defaultValue));
        this.fastPropMap.put(mapKey, (Property<?>)prop);
        return prop;
    }

    public ChainedDynamicProperty.StringProperty getChainedStringProperty(String overrideKey, String primaryKey, String defaultValue) {
        String mapKey = overrideKey + primaryKey;
        ChainedDynamicProperty.StringProperty prop = (ChainedDynamicProperty.StringProperty)this.fastPropMap.get(mapKey);
        if (prop != null) {
            return prop;
        }
        prop = new ChainedDynamicProperty.StringProperty(overrideKey, new DynamicStringProperty(primaryKey, defaultValue));
        this.fastPropMap.put(mapKey, (Property<?>)prop);
        return prop;
    }
}

