/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.spectator.api.Timer;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.BulkGetFuture;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Single;

public class EVCacheBulkGetFuture<T>
extends BulkGetFuture<T> {
    private Logger log = LoggerFactory.getLogger(EVCacheBulkGetFuture.class);
    private final Map<String, Future<T>> rvMap;
    private final Collection<Operation> ops;
    private final CountDownLatch latch;
    private final long start;
    private final EVCacheClient client;
    private final String metricName;

    public EVCacheBulkGetFuture(Map<String, Future<T>> m, Collection<Operation> getOps, CountDownLatch l, ExecutorService service, EVCacheClient client, String metricName) {
        super(m, getOps, l, service);
        this.rvMap = m;
        this.ops = getOps;
        this.latch = l;
        this.metricName = metricName;
        this.start = System.currentTimeMillis();
        this.client = client;
    }

    public Map<String, T> getSome(long to, TimeUnit unit, boolean throwException, boolean hasZF) throws InterruptedException, ExecutionException {
        HashSet<Operation> timedoutOps = new HashSet<Operation>();
        Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.metricName, this.client.getTagList());
        long startTime = System.currentTimeMillis();
        boolean status = this.latch.await(to, unit);
        if (!status) {
            boolean gcPause = false;
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            long vmStartTime = runtimeBean.getStartTime();
            List<java.lang.management.GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (java.lang.management.GarbageCollectorMXBean gcMXBean : gcMXBeans) {
                long gcStartTime;
                GcInfo lastGcInfo;
                if (!(gcMXBean instanceof GarbageCollectorMXBean) || (lastGcInfo = ((GarbageCollectorMXBean)gcMXBean).getLastGcInfo()) == null || (gcStartTime = lastGcInfo.getStartTime() + vmStartTime) <= startTime) continue;
                gcPause = true;
                long gcDuration = lastGcInfo.getDuration();
                EVCacheMetricsFactory.getInstance().getCounter(this.client.getAppName() + "-DelayDueToGCPause", this.client.getTagList()).increment(gcDuration);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("Total duration due to gc event = " + gcDuration + " msec.");
                break;
            }
            if (gcPause) {
                status = this.latch.await(to, unit);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Retry status : " + status);
                }
                if (status) {
                    EVCacheMetricsFactory.getInstance().getCounter(this.client.getAppName() + "-DelayDueToGCPause-Success", this.client.getTagList()).increment();
                } else {
                    EVCacheMetricsFactory.getInstance().getCounter(this.client.getAppName() + "-DelayDueToGCPause-Fail", this.client.getTagList()).increment();
                }
            } else {
                long gcDuration = System.currentTimeMillis() - startTime;
                EVCacheMetricsFactory.getInstance().getCounter(this.client.getAppName() + "-UnknownPause", this.client.getTagList()).increment(gcDuration);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Total duration due to gc event = " + (System.currentTimeMillis() - startTime) + " msec.");
            }
        }
        for (Operation op : this.ops) {
            if (op.getState() != OperationState.COMPLETE) {
                if (!status) {
                    MemcachedConnection.opTimedOut((Operation)op);
                    timedoutOps.add(op);
                    continue;
                }
                MemcachedConnection.opSucceeded((Operation)op);
                continue;
            }
            MemcachedConnection.opSucceeded((Operation)op);
        }
        if (!status && !hasZF && timedoutOps.size() > 0) {
            EVCacheMetricsFactory.getInstance().getCounter(this.client.getAppName() + "-getSome-CheckedOperationTimeout", this.client.getTagList()).increment();
        }
        for (Operation op : this.ops) {
            if (op.isCancelled()) {
                if (hasZF) {
                    EVCacheMetricsFactory.getInstance().getCounter(this.client.getAppName() + "-getSome-Cancelled", this.client.getTagList()).increment();
                }
                if (throwException) {
                    throw new ExecutionException(new CancellationException("Cancelled"));
                }
            }
            if (!op.hasErrored() || !throwException) continue;
            throw new ExecutionException((Throwable)op.getException());
        }
        HashMap<String, T> m = new HashMap<String, T>();
        for (Map.Entry<String, Future<T>> me : this.rvMap.entrySet()) {
            m.put(me.getKey(), me.getValue().get());
        }
        operationDuration.record(System.currentTimeMillis() - startTime, TimeUnit.MILLISECONDS);
        return m;
    }

    public Single<Map<String, T>> observe() {
        return Single.create(subscriber -> this.addListener(future -> {
            try {
                subscriber.onSuccess((Object)this.get());
            }
            catch (Throwable e) {
                subscriber.onError(e);
            }
        }));
    }

    public Single<Map<String, T>> getSome(long to, TimeUnit units, boolean throwException, boolean hasZF, Scheduler scheduler) {
        Timer operationDuration = EVCacheMetricsFactory.getInstance().getPercentileTimer(this.metricName, this.client.getTagList());
        long startTime = System.currentTimeMillis();
        return this.observe().timeout(to, units, Single.create(subscriber -> {
            try {
                HashSet<Operation> timedoutOps = new HashSet<Operation>();
                for (Operation op : this.ops) {
                    if (op.getState() != OperationState.COMPLETE) {
                        MemcachedConnection.opTimedOut((Operation)op);
                        timedoutOps.add(op);
                        continue;
                    }
                    MemcachedConnection.opSucceeded((Operation)op);
                }
                if (!hasZF && timedoutOps.size() > 0) {
                    EVCacheMetricsFactory.getInstance().increment(this.client.getAppName() + "-getSome-CheckedOperationTimeout", this.client.getTagList());
                }
                for (Operation op : this.ops) {
                    if (op.isCancelled() && throwException) {
                        throw new ExecutionException(new CancellationException("Cancelled"));
                    }
                    if (!op.hasErrored() || !throwException) continue;
                    throw new ExecutionException((Throwable)op.getException());
                }
                HashMap<String, T> m = new HashMap<String, T>();
                for (Map.Entry<String, Future<T>> me : this.rvMap.entrySet()) {
                    m.put(me.getKey(), me.getValue().get());
                }
                subscriber.onSuccess(m);
            }
            catch (Throwable e) {
                subscriber.onError(e);
            }
        }), scheduler).doAfterTerminate(() -> operationDuration.record(System.currentTimeMillis() - startTime, TimeUnit.MILLISECONDS));
    }

    public String getZone() {
        return this.client.getServerGroupName();
    }

    public ServerGroup getServerGroup() {
        return this.client.getServerGroup();
    }

    public String getApp() {
        return this.client.getAppName();
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.rvMap.keySet());
    }

    public void signalComplete() {
        super.signalComplete();
    }

    public boolean cancel(boolean ign) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Operation cancelled", (Throwable)new Exception());
        }
        return super.cancel(ign);
    }

    public long getStartTime() {
        return this.start;
    }
}

