/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.connection;

import com.netflix.config.ConfigurationManager;
import com.netflix.evcache.connection.BaseConnectionFactory;
import com.netflix.evcache.connection.IConnectionBuilder;
import com.netflix.evcache.pool.EVCacheClient;
import net.spy.memcached.ConnectionFactory;

public class ConnectionFactoryBuilder
implements IConnectionBuilder {
    @Override
    public ConnectionFactory getConnectionFactory(EVCacheClient client) {
        String appName = client.getAppName();
        int maxQueueSize = ConfigurationManager.getConfigInstance().getInt(appName + ".max.queue.length", 16384);
        int operationTimeout = ConfigurationManager.getConfigInstance().getInt(appName + ".operation.timeout", 2500);
        int opQueueMaxBlockTime = ConfigurationManager.getConfigInstance().getInt(appName + ".operation.QueueMaxBlockTime", 10);
        return new BaseConnectionFactory(client, maxQueueSize, operationTimeout, opQueueMaxBlockTime);
    }
}

