/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.connection;

import com.netflix.archaius.api.Property;
import com.netflix.discovery.EurekaClient;
import com.netflix.evcache.connection.BaseAsciiConnectionFactory;
import com.netflix.evcache.pool.DIEVCacheKetamaNodeLocatorConfiguration;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheNodeLocator;
import java.util.List;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIAsciiConnectionFactory
extends BaseAsciiConnectionFactory {
    private static Logger log = LoggerFactory.getLogger(DIAsciiConnectionFactory.class);
    private final EurekaClient eurekaClient;

    DIAsciiConnectionFactory(EVCacheClient client, EurekaClient eurekaClient, int len, Property<Integer> operationTimeout, long opMaxBlockTime) {
        super(client, len, operationTimeout, opMaxBlockTime);
        client.addTag("evc.connection.type", "ASCII");
        this.eurekaClient = eurekaClient;
        if (log.isInfoEnabled()) {
            log.info("Using ASCII Connection Factory!!!");
        }
    }

    public NodeLocator createLocator(List<MemcachedNode> list) {
        this.locator = new EVCacheNodeLocator(this.client, list, (HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH, (KetamaNodeLocatorConfiguration)new DIEVCacheKetamaNodeLocatorConfiguration(this.client, this.eurekaClient));
        return this.locator;
    }
}

