/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.eureka;

import com.google.inject.Inject;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.SimpleNodeListProvider;
import com.netflix.evcache.pool.eureka.EurekaNodeListProvider;
import com.netflix.evcache.util.EVCacheConfig;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIEVCacheNodeListProvider
implements Provider<EVCacheNodeList> {
    private static Logger log = LoggerFactory.getLogger(DIEVCacheNodeListProvider.class);
    private final DiscoveryClient discoveryClient;
    private final ApplicationInfoManager applicationInfoManager;

    @Inject
    public DIEVCacheNodeListProvider(ApplicationInfoManager applicationInfoManager, DiscoveryClient discoveryClient) {
        this.applicationInfoManager = applicationInfoManager;
        this.discoveryClient = discoveryClient;
    }

    public EVCacheNodeList get() {
        Object provider = EVCacheConfig.getInstance().getDynamicBooleanProperty("evcache.use.simple.node.list.provider", Boolean.valueOf(false)).get() ? new SimpleNodeListProvider() : new EurekaNodeListProvider(this.applicationInfoManager, this.discoveryClient);
        if (log.isDebugEnabled()) {
            log.debug("EVCache Node List Provider : " + provider);
        }
        return provider;
    }
}

