/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicStringProperty;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.evcache.EVCacheImpl;
import com.netflix.evcache.EVCacheInMemoryCache;
import com.netflix.evcache.connection.DefaultFactoryProvider;
import com.netflix.evcache.connection.IConnectionFactoryProvider;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.pool.DiscoveryNodeListProvider;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.SimpleNodeListProvider;
import com.netflix.evcache.util.EVCacheConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "DM_CONVERT_CASE", "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
public class EVCacheClientPoolManager {
    private static final Logger log = LoggerFactory.getLogger(EVCacheClientPoolManager.class);
    private static final DynamicIntProperty defaultReadTimeout = EVCacheConfig.getInstance().getDynamicIntProperty("default.read.timeout", 20);
    private final DynamicIntProperty defaultRefreshInterval = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheClientPoolManager.refresh.interval", 60);
    private static final DynamicStringProperty logEnabledApps = EVCacheConfig.getInstance().getDynamicStringProperty("EVCacheClientPoolManager.log.apps", "*");
    @Deprecated
    private static volatile EVCacheClientPoolManager instance;
    private final Map<String, EVCacheClientPool> poolMap = new ConcurrentHashMap<String, EVCacheClientPool>();
    private final Map<EVCacheClientPool, ScheduledFuture<?>> scheduledTaskMap = new HashMap();
    private final ScheduledThreadPoolExecutor _scheduler;
    private final ThreadPoolExecutor refreshAsnycPool;
    private final DiscoveryClient discoveryClient;
    private final ApplicationInfoManager applicationInfoManager;
    private final List<EVCacheEventListener> evcacheEventListenerList;
    private final Provider<IConnectionFactoryProvider> connectionFactoryprovider;
    private ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
    private final Map<String, EVCacheInMemoryCache<?>> inMemoryMap = new ConcurrentHashMap();

    @Inject
    public EVCacheClientPoolManager(ApplicationInfoManager applicationInfoManager, DiscoveryClient discoveryClient, Provider<IConnectionFactoryProvider> connectionFactoryprovider) {
        instance = this;
        try {
            ConfigurationManager.loadCascadedPropertiesFromResources((String)"evcache");
        }
        catch (IOException e) {
            log.info("Default evcache configuration not loaded", (Throwable)e);
        }
        this.applicationInfoManager = applicationInfoManager;
        this.discoveryClient = discoveryClient;
        this.connectionFactoryprovider = connectionFactoryprovider;
        this.evcacheEventListenerList = new ArrayList<EVCacheEventListener>();
        int poolSize = EVCacheConfig.getInstance().getDynamicIntProperty("default.refresher.poolsize", 1).get();
        ThreadFactory asyncFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EVCacheClientPool-AsyncPoolRefresher-%d").build();
        this.refreshAsnycPool = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10), asyncFactory, new ThreadPoolExecutor.DiscardPolicy());
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EVCacheClientPoolManager-refresher-%d").build();
        this._scheduler = new ScheduledThreadPoolExecutor(poolSize, factory);
        this.defaultRefreshInterval.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheClientPoolManager.this.refreshScheduler();
            }
        });
        this.initAtStartup();
    }

    public IConnectionFactoryProvider getConnectionFactoryProvider() {
        return (IConnectionFactoryProvider)this.connectionFactoryprovider.get();
    }

    public void addEVCacheEventListener(EVCacheEventListener listener) {
        this.evcacheEventListenerList.add(listener);
    }

    public void removeEVCacheEventListener(EVCacheEventListener listener) {
        this.evcacheEventListenerList.remove(listener);
    }

    public List<EVCacheEventListener> getEVCacheEventListeners() {
        return this.evcacheEventListenerList;
    }

    private void refreshScheduler() {
        Iterator<EVCacheClientPool> itr = this.scheduledTaskMap.keySet().iterator();
        while (itr.hasNext()) {
            EVCacheClientPool pool = itr.next();
            ScheduledFuture<?> task = this.scheduledTaskMap.get(pool);
            itr.remove();
            task.cancel(true);
            this.scheduleRefresh(pool);
        }
    }

    @Deprecated
    public static EVCacheClientPoolManager getInstance() {
        if (instance == null) {
            new EVCacheClientPoolManager(null, null, new DefaultFactoryProvider());
            if (!EVCacheConfig.getInstance().getDynamicBooleanProperty("evcache.use.simple.node.list.provider", false).get()) {
                log.warn("Please make sure EVCacheClientPoolManager is injected first. This is not the appropriate way to init EVCacheClientPoolManager. If you are using simple node list provider please set evcache.use.simple.node.list.provider property to true.", (Throwable)new Exception());
            }
        }
        return instance;
    }

    public ApplicationInfoManager getApplicationInfoManager() {
        return this.applicationInfoManager;
    }

    public DiscoveryClient getDiscoveryClient() {
        DiscoveryClient client = this.discoveryClient;
        if (client == null) {
            client = DiscoveryManager.getInstance().getDiscoveryClient();
        }
        return client;
    }

    public void initAtStartup() {
        String appsToInit = EVCacheConfig.getInstance().getDynamicStringProperty("evcache.appsToInit", "").get();
        if (appsToInit != null && appsToInit.length() > 0) {
            StringTokenizer apps = new StringTokenizer(appsToInit, ",");
            while (apps.hasMoreTokens()) {
                String app = this.getAppName(apps.nextToken());
                if (log.isDebugEnabled()) {
                    log.debug("Initializing EVCache - " + app);
                }
                this.initEVCache(app);
            }
        }
    }

    public final synchronized void initEVCache(String app) {
        if (app == null || (app = app.trim()).length() == 0) {
            throw new IllegalArgumentException("param app name null or space");
        }
        String APP = this.getAppName(app);
        if (this.poolMap.containsKey(APP)) {
            return;
        }
        EVCacheNodeList provider = (Boolean)EVCacheConfig.getInstance().getChainedBooleanProperty(APP + ".use.simple.node.list.provider", "evcache.use.simple.node.list.provider", false).get() != false ? new SimpleNodeListProvider(APP + "-NODES") : new DiscoveryNodeListProvider(this.applicationInfoManager, this.discoveryClient, APP);
        EVCacheClientPool pool = new EVCacheClientPool(APP, provider, this.refreshAsnycPool, this);
        this.scheduleRefresh(pool);
        this.poolMap.put(APP, pool);
    }

    private void scheduleRefresh(EVCacheClientPool pool) {
        ScheduledFuture<?> task = this._scheduler.scheduleWithFixedDelay(pool, 30L, this.defaultRefreshInterval.get(), TimeUnit.SECONDS);
        this.scheduledTaskMap.put(pool, task);
    }

    public EVCacheClientPool getEVCacheClientPool(String _app) {
        String app = this.getAppName(_app);
        EVCacheClientPool evcacheClientPool = this.poolMap.get(app);
        if (evcacheClientPool != null) {
            return evcacheClientPool;
        }
        this.initEVCache(app);
        return this.poolMap.get(app);
    }

    public Map<String, EVCacheClientPool> getAllEVCacheClientPool() {
        return new HashMap<String, EVCacheClientPool>(this.poolMap);
    }

    @PreDestroy
    public void shutdown() {
        this._scheduler.shutdown();
        for (EVCacheClientPool pool : this.poolMap.values()) {
            pool.shutdown();
        }
    }

    public boolean shouldLog(String appName) {
        if ("*".equals(logEnabledApps.get())) {
            return true;
        }
        return logEnabledApps.get().indexOf(appName) != -1;
    }

    public static DynamicIntProperty getDefaultReadTimeout() {
        return defaultReadTimeout;
    }

    public DynamicIntProperty getDefaultRefreshInterval() {
        return this.defaultRefreshInterval;
    }

    private String getAppName(String _app) {
        _app = _app.toUpperCase();
        String app = ConfigurationManager.getConfigInstance().getString("EVCacheClientPoolManager." + _app + ".alias", _app).toUpperCase();
        if (log.isDebugEnabled()) {
            log.debug("Original App Name : " + _app + "; Alias App Name : " + app);
        }
        return app;
    }

    public <T> EVCacheInMemoryCache<T> createInMemoryCache(String appName, Transcoder<T> tc, EVCacheImpl impl) {
        EVCacheInMemoryCache<Object> cache = this.inMemoryMap.get(appName);
        if (cache == null) {
            this.writeLock.lock();
            cache = this.getInMemoryCache(appName);
            if (cache == null) {
                cache = new EVCacheInMemoryCache<T>(appName, tc, impl);
                this.inMemoryMap.put(appName, cache);
            }
            this.writeLock.unlock();
        }
        return cache;
    }

    public <T> EVCacheInMemoryCache<T> getInMemoryCache(String appName) {
        return this.inMemoryMap.get(appName);
    }
}

