/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.connection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.evcache.connection.ConnectionFactoryBuilder;
import com.netflix.evcache.connection.DIConnectionFactory;
import com.netflix.evcache.connection.IConnectionBuilder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.util.EVCacheConfig;
import net.spy.memcached.ConnectionFactory;

public class DIConnectionFactoryBuilderProvider
extends ConnectionFactoryBuilder
implements Provider<IConnectionBuilder> {
    private final DiscoveryClient discoveryClient;

    @Inject
    public DIConnectionFactoryBuilderProvider(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public ConnectionFactoryBuilder get() {
        return this;
    }

    public ConnectionFactory getConnectionFactory(EVCacheClient client) {
        String appName = client.getAppName();
        int maxQueueSize = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".max.queue.length", 16384).get();
        int operationTimeout = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".operation.timeout", 2500).get();
        int opQueueMaxBlockTime = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".operation.QueueMaxBlockTime", 10).get();
        return new DIConnectionFactory(client, this.discoveryClient, maxQueueSize, operationTimeout, opQueueMaxBlockTime);
    }
}

