/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheFuture
implements Future<Boolean> {
    private Logger log = LoggerFactory.getLogger(EVCacheFuture.class);
    private final Future<Boolean> future;
    private final String app;
    private final ServerGroup serverGroup;
    private final String key;
    private final EVCacheClient client;

    public EVCacheFuture(Future<Boolean> future, String key, String app, ServerGroup serverGroup) {
        this(future, key, app, serverGroup, null);
    }

    public EVCacheFuture(Future<Boolean> future, String key, String app, ServerGroup serverGroup, EVCacheClient client) {
        this.future = future;
        this.app = app;
        this.serverGroup = serverGroup;
        this.key = key;
        this.client = client;
    }

    public Future<Boolean> getFuture() {
        return this.future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Operation cancelled", (Throwable)new Exception());
        }
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public String getKey() {
        return this.key;
    }

    public String getApp() {
        return this.app;
    }

    public String getZone() {
        return this.serverGroup.getZone();
    }

    public String getServerGroupName() {
        return this.serverGroup.getName();
    }

    public EVCacheClient getEVCacheClient() {
        return this.client;
    }

    public String toString() {
        return "EVCacheFuture [future=" + this.future + ", app=" + this.app + ", ServerGroup=" + this.serverGroup + ", EVCacheClient=" + this.client + "]";
    }
}

