/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.metrics;

import com.netflix.evcache.EVCache;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.metrics.EVCacheMetricsMBean;
import com.netflix.evcache.metrics.Stats;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.StatsTimer;
import com.netflix.servo.monitor.StepCounter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
public class EVCacheMetrics
implements EVCacheMetricsMBean,
Stats {
    private static final Logger log = LoggerFactory.getLogger(EVCacheMetrics.class);
    private final String monitorName;
    private final String appName;
    private final String cacheName;
    private StepCounter getCallsCounter;
    private StepCounter bulkCallsCounter;
    private StepCounter bulkHitsCounter;
    private StepCounter getHitsCounter;
    private StepCounter setCallsCounter;
    private StepCounter replaceCallCounter;
    private StepCounter delCallsCounter;
    private StepCounter bulkMissCounter;
    private StepCounter getMissCounter;
    private StatsTimer getDuration;
    private StatsTimer bulkDuration;

    EVCacheMetrics(String appName, String _cacheName) {
        this.appName = appName;
        this.cacheName = _cacheName == null ? "" : _cacheName;
        this.monitorName = appName + "_" + this.cacheName;
        this.setupMonitoring(appName, this.cacheName);
    }

    private void register(Monitor<?> monitor) {
        MonitorRegistry registry = DefaultMonitorRegistry.getInstance();
        if (registry.isRegistered(monitor)) {
            registry.unregister(monitor);
        }
        registry.register(monitor);
    }

    @Override
    public void operationCompleted(EVCache.Call op, long duration) {
        if (op == EVCache.Call.GET || op == EVCache.Call.GET_AND_TOUCH) {
            this.getCallCounter().increment();
            this.getGetCallDuration().record(duration);
        } else if (op == EVCache.Call.SET) {
            this.getSetCallCounter().increment();
        } else if (op == EVCache.Call.REPLACE) {
            this.getReplaceCallCounter().increment();
        } else if (op == EVCache.Call.DELETE) {
            this.getDeleteCallCounter().increment();
        } else if (op == EVCache.Call.BULK) {
            this.getBulkCounter().increment();
            this.getBulkCallDuration().record(duration);
        }
    }

    private void setupMonitoring(String _appName, String _cacheName) {
        block6: {
            try {
                String mBeanName = "com.netflix.evcache:Group=" + _appName + ",SubGroup=AtlasStats";
                if (_cacheName != null) {
                    mBeanName = mBeanName + ",SubSubGroup=" + _cacheName;
                }
                ObjectName mBeanObj = ObjectName.getInstance(mBeanName);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanObj)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanObj + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanObj);
                }
                mbeanServer.registerMBean(this, mBeanObj);
                if (log.isDebugEnabled()) {
                    log.debug("MBEAN with name " + mBeanObj + " has been registered.");
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private StepCounter getCallCounter() {
        if (this.getCallsCounter != null) {
            return this.getCallsCounter;
        }
        this.getCallsCounter = EVCacheMetricsFactory.getStepCounter(this.appName, this.cacheName, "GetCall");
        this.getHitCounter();
        return this.getCallsCounter;
    }

    private StepCounter getHitCounter() {
        if (this.getHitsCounter != null) {
            return this.getHitsCounter;
        }
        this.getHitsCounter = EVCacheMetricsFactory.getStepCounter(this.appName, this.cacheName, "GetHit");
        if (this.getMissCounter == null) {
            this.getMissCounter = new StepCounter(EVCacheMetricsFactory.getMonitorConfig(this.appName, this.cacheName, "GetMiss")){

                public Number getValue() {
                    return EVCacheMetrics.this.getCacheMiss();
                }

                public Number getValue(int pollerIndex) {
                    return this.getValue();
                }
            };
            this.register((Monitor<?>)this.getMissCounter);
        }
        return this.getHitsCounter;
    }

    private StepCounter getBulkCounter() {
        if (this.bulkCallsCounter != null) {
            return this.bulkCallsCounter;
        }
        this.bulkCallsCounter = EVCacheMetricsFactory.getStepCounter(this.appName, this.cacheName, "BulkCall");
        return this.bulkCallsCounter;
    }

    private StepCounter getBulkHitCounter() {
        this.bulkHitsCounter = EVCacheMetricsFactory.getStepCounter(this.appName, this.cacheName, "BulkHit");
        if (this.bulkMissCounter == null) {
            this.bulkMissCounter = new StepCounter(EVCacheMetricsFactory.getMonitorConfig(this.appName, this.cacheName, "BulkMiss")){

                public Number getValue() {
                    return EVCacheMetrics.this.getBulkMiss();
                }

                public Number getValue(int pollerIndex) {
                    return this.getValue();
                }
            };
            this.register((Monitor<?>)this.bulkMissCounter);
        }
        return this.bulkHitsCounter;
    }

    private StepCounter getSetCallCounter() {
        if (this.setCallsCounter != null) {
            return this.setCallsCounter;
        }
        this.setCallsCounter = EVCacheMetricsFactory.getStepCounter(this.appName, this.cacheName, "SetCall");
        return this.setCallsCounter;
    }

    private StepCounter getReplaceCallCounter() {
        if (this.replaceCallCounter != null) {
            return this.replaceCallCounter;
        }
        this.replaceCallCounter = EVCacheMetricsFactory.getStepCounter(this.appName, this.cacheName, "ReplaceCall");
        return this.replaceCallCounter;
    }

    private StepCounter getDeleteCallCounter() {
        if (this.delCallsCounter != null) {
            return this.delCallsCounter;
        }
        this.delCallsCounter = EVCacheMetricsFactory.getStepCounter(this.appName, this.cacheName, "DeleteCall");
        return this.delCallsCounter;
    }

    private StatsTimer getGetCallDuration() {
        if (this.getDuration != null) {
            return this.getDuration;
        }
        this.getDuration = EVCacheMetricsFactory.getStatsTimer(this.appName, this.cacheName, "LatencyGet");
        return this.getDuration;
    }

    private StatsTimer getBulkCallDuration() {
        if (this.bulkDuration != null) {
            return this.bulkDuration;
        }
        this.bulkDuration = EVCacheMetricsFactory.getStatsTimer(this.appName, this.cacheName, "LatencyBulk");
        return this.bulkDuration;
    }

    @Override
    public long getGetCalls() {
        return ((Number)this.getCallCounter().getValue()).longValue();
    }

    @Override
    public long getCacheHits() {
        return ((Number)this.getHitCounter().getValue()).longValue();
    }

    @Override
    public long getCacheMiss() {
        return this.getGetCalls() - this.getCacheHits();
    }

    @Override
    public long getBulkCalls() {
        return ((Number)this.getBulkCounter().getValue()).longValue();
    }

    @Override
    public long getBulkHits() {
        return ((Number)this.getBulkHitCounter().getValue()).longValue();
    }

    @Override
    public long getBulkMiss() {
        return this.getBulkCalls() - this.getBulkHits();
    }

    @Override
    public long getSetCalls() {
        return ((Number)this.getSetCallCounter().getValue()).longValue();
    }

    @Override
    public void cacheHit(EVCache.Call call) {
        if (call == EVCache.Call.BULK) {
            this.getBulkHitCounter().increment();
        } else {
            this.getHitCounter().increment();
        }
    }

    @Override
    public void cacheMiss(EVCache.Call call) {
    }

    public long getGetDuration() {
        return this.getGetCallDuration().getValue();
    }

    public long getBulkDuration() {
        return this.getBulkCallDuration().getValue();
    }

    public String toString() {
        return "EVCacheMetrics [ Name=" + this.monitorName + ", getCalls=" + this.getCallCounter() + ", bulkCalls=" + this.getBulkCounter() + ", setCalls=" + this.getSetCallCounter() + ", cacheHits=" + this.getHitCounter() + ", bulkHits=" + this.getBulkHitCounter() + ", deleteCalls=" + this.getDeleteCallCounter() + ", getDuration=" + this.getGetCallDuration() + ", bulkDuration=" + this.getBulkCallDuration() + ", replaceCalls=" + this.getReplaceCallCounter() + "]";
    }

    @Override
    public double getHitRate() {
        return this.getCacheHits() / this.getGetCalls() * 100L;
    }

    @Override
    public double getBulkHitRate() {
        return this.getBulkHits() / this.getBulkCalls() * 100L;
    }
}

