/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.EVCacheGetOperationListener;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.servo.monitor.Stopwatch;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_HAS_CHECKED"})
public class EVCacheOperationFuture<T>
extends OperationFuture<T> {
    private Logger log = LoggerFactory.getLogger(EVCacheOperationFuture.class);
    private final CountDownLatch latch;
    private final AtomicReference<T> objRef;
    private Operation op;
    private final String appName;
    private final String zone;
    private final ServerGroup serverGroup;
    private final String key;
    private final Stopwatch operationDuration;

    public EVCacheOperationFuture(String k, CountDownLatch l, AtomicReference<T> oref, long opTimeout, ExecutorService service, String appName, String zone, ServerGroup serverGroup) {
        this(k, l, oref, opTimeout, service, appName, zone, serverGroup, null);
    }

    public EVCacheOperationFuture(String k, CountDownLatch l, AtomicReference<T> oref, long opTimeout, ExecutorService service, String appName, String zone, ServerGroup serverGroup, String metricName) {
        super(k, l, oref, opTimeout, service);
        this.latch = l;
        this.objRef = oref;
        this.appName = appName;
        this.serverGroup = serverGroup;
        this.zone = zone;
        this.key = k;
        this.operationDuration = metricName != null ? EVCacheMetricsFactory.getStatsTimer(appName, serverGroup, metricName).start() : null;
    }

    public Operation getOperation() {
        return this.op;
    }

    public void setOperation(Operation to) {
        this.op = to;
        super.setOperation(to);
    }

    public String getApp() {
        return this.appName;
    }

    public String getKey() {
        return this.key;
    }

    public String getZone() {
        return this.zone;
    }

    public ServerGroup getServerGroup() {
        return this.serverGroup;
    }

    public EVCacheOperationFuture<T> addListener(EVCacheGetOperationListener<T> listener) {
        super.addToListeners(listener);
        return this;
    }

    public EVCacheOperationFuture<T> removeListener(EVCacheGetOperationListener<T> listener) {
        super.removeFromListeners(listener);
        return this;
    }

    public T get(long duration, TimeUnit units, boolean throwException, boolean hasZF) throws InterruptedException, TimeoutException, ExecutionException {
        long startTime = System.currentTimeMillis();
        boolean status = this.latch.await(duration, units);
        if (!status) {
            boolean gcPause = false;
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            long vmStartTime = runtimeBean.getStartTime();
            List<java.lang.management.GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (java.lang.management.GarbageCollectorMXBean gcMXBean : gcMXBeans) {
                long gcStartTime;
                GcInfo lastGcInfo;
                if (!(gcMXBean instanceof GarbageCollectorMXBean) || (lastGcInfo = ((GarbageCollectorMXBean)gcMXBean).getLastGcInfo()) == null || (gcStartTime = lastGcInfo.getStartTime() + vmStartTime) <= startTime) continue;
                gcPause = true;
                long gcDuration = lastGcInfo.getDuration();
                EVCacheMetricsFactory.getCounter(this.appName + "-DelayDueToGCPause").increment(gcDuration);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("Total duration due to gc event = " + gcDuration + " msec.");
                break;
            }
            if (!gcPause) {
                long gcDuration = System.currentTimeMillis() - startTime;
                boolean bl = gcPause = gcDuration > units.toMillis(duration) + 10L;
                if (gcPause) {
                    EVCacheMetricsFactory.getLongGauge(this.appName + "-DelayProbablyDueToGCPause").set(Long.valueOf(gcDuration));
                } else {
                    EVCacheMetricsFactory.getLongGauge(this.appName + "-DelayProbablyDueToGCPause").set(Long.valueOf(0L));
                }
            }
            if (gcPause) {
                status = this.latch.await(duration, units);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Retry status : " + status);
                }
                if (status) {
                    EVCacheMetricsFactory.increment(this.appName + "-DelayDueToGCPause-Success");
                } else {
                    EVCacheMetricsFactory.increment(this.appName + "-DelayDueToGCPause-Fail");
                }
            }
        }
        if (!status) {
            MemcachedConnection.opTimedOut((Operation)this.op);
            if (this.op != null) {
                this.op.timeOut();
            }
            if (!hasZF) {
                EVCacheMetricsFactory.increment(this.appName + "-get-CheckedOperationTimeout");
            }
            if (throwException) {
                throw new CheckedOperationTimeoutException("Timed out waiting for operation", this.op);
            }
        } else {
            MemcachedConnection.opSucceeded((Operation)this.op);
        }
        if (this.op != null && this.op.hasErrored() && throwException) {
            throw new ExecutionException((Throwable)this.op.getException());
        }
        if (this.isCancelled()) {
            if (hasZF) {
                EVCacheMetricsFactory.increment(this.appName + "-Cancelled");
            }
            if (throwException) {
                throw new ExecutionException(new CancellationException("Cancelled"));
            }
        }
        if (this.op != null && this.op.isTimedOut() && throwException) {
            throw new ExecutionException(new CheckedOperationTimeoutException("Operation timed out.", this.op));
        }
        return this.objRef.get();
    }

    public void signalComplete() {
        if (this.operationDuration != null) {
            this.operationDuration.stop();
        }
        super.signalComplete();
    }
}

