/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.standalone;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.standalone.AbstractEVCacheClientPoolImpl;
import com.netflix.evcache.pool.standalone.ZoneClusteredEVCacheClientImpl;
import com.netflix.evcache.pool.standalone.ZoneClusteredEVCacheClientPoolImplMBean;
import com.netflix.evcache.util.ZoneFallbackIterator;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneClusteredEVCacheClientPoolImpl
extends AbstractEVCacheClientPoolImpl
implements ZoneClusteredEVCacheClientPoolImplMBean {
    private static Logger log = LoggerFactory.getLogger(ZoneClusteredEVCacheClientPoolImpl.class);
    private static final String GLOBAL = "GLOBAL";
    private String _zone;
    private DynamicStringProperty _zoneList;
    private Map<String, DynamicStringProperty> hostsByZoneFPMap;
    private AtomicLong numberOfReadOps = new AtomicLong(0L);
    private Map<String, List<ZoneClusteredEVCacheClientImpl>> memcachedInstancesByZone = new HashMap<String, List<ZoneClusteredEVCacheClientImpl>>();
    private Map<String, List<ZoneClusteredEVCacheClientImpl>> memcachedReadInstancesByZone = new ConcurrentHashMap<String, List<ZoneClusteredEVCacheClientImpl>>();
    private Map<String, List<ZoneClusteredEVCacheClientImpl>> memcachedWriteInstancesByZone = new ConcurrentHashMap<String, List<ZoneClusteredEVCacheClientImpl>>();
    private ZoneFallbackIterator memcachedFallbackReadInstances = new ZoneFallbackIterator(Collections.<String>emptySet());
    private Map<String, DynamicBooleanProperty> writeOnlyFastPropertyMap = new ConcurrentHashMap<String, DynamicBooleanProperty>(){

        @Override
        public DynamicBooleanProperty get(Object zone) {
            DynamicBooleanProperty isZoneInWriteOnlyMode = (DynamicBooleanProperty)super.get(zone.toString());
            if (isZoneInWriteOnlyMode != null) {
                return isZoneInWriteOnlyMode;
            }
            isZoneInWriteOnlyMode = DynamicPropertyFactory.getInstance().getBooleanProperty(ZoneClusteredEVCacheClientPoolImpl.this.getAppName() + "." + zone.toString() + ".EVCacheClientPool.writeOnly", false);
            this.put((String)zone, isZoneInWriteOnlyMode);
            return isZoneInWriteOnlyMode;
        }
    };

    @Override
    public void init(String appName) {
        super.init(appName);
        String ec2Zone = System.getenv("EC2_AVAILABILITY_ZONE");
        this._zone = ec2Zone == null ? GLOBAL : ec2Zone;
        this._zoneList = DynamicPropertyFactory.getInstance().getStringProperty(appName + ".EVCacheClientPool.zones", "");
        this._zoneList.addCallback((Runnable)this);
        this.hostsByZoneFPMap = new ConcurrentHashMap<String, DynamicStringProperty>();
        if (log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("EVCacheClientPool:init");
            sb.append("\n\tAPP - ").append(this.getAppName());
            sb.append("\n\tLocalZone - ").append(this._zone);
            sb.append("\n\tPoolSize - ").append(this.getPoolSize());
            sb.append("\n\tAllZones - ").append(this._zoneList);
            sb.append("\n\tReadTimeout - ").append(this.getReadTimeout());
            log.info(sb.toString());
        }
        this.run();
    }

    @Override
    public EVCacheClient getEVCacheClient() {
        if (this.memcachedReadInstancesByZone == null || this.memcachedReadInstancesByZone.isEmpty()) {
            return null;
        }
        try {
            List<ZoneClusteredEVCacheClientImpl> clients = this.memcachedReadInstancesByZone.get(this._zone);
            if (clients == null) {
                String fallbackZone = this.memcachedFallbackReadInstances.next();
                if (fallbackZone == null) {
                    return null;
                }
                clients = this.memcachedReadInstancesByZone.get(fallbackZone);
            }
            if (clients == null) {
                return null;
            }
            if (clients.size() == 1) {
                return clients.get(0);
            }
            long currentVal = this.numberOfReadOps.incrementAndGet();
            int index = (int)currentVal % clients.size();
            return clients.get(index);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for zone " + this._zone, t);
            return null;
        }
    }

    @Override
    public EVCacheClient getEVCacheClientExcludeZone(String zone) {
        if (this.memcachedReadInstancesByZone == null || this.memcachedReadInstancesByZone.isEmpty()) {
            return null;
        }
        if (zone == null || zone.length() == 0) {
            return this.getEVCacheClient();
        }
        try {
            String fallbackZone = this.memcachedFallbackReadInstances.next();
            if (fallbackZone.equals(zone)) {
                fallbackZone = this.memcachedFallbackReadInstances.next();
            }
            if (fallbackZone == null || fallbackZone.equals(zone)) {
                return null;
            }
            List<ZoneClusteredEVCacheClientImpl> clients = this.memcachedReadInstancesByZone.get(fallbackZone);
            if (clients == null) {
                return null;
            }
            if (clients.size() == 1) {
                return clients.get(0);
            }
            long currentVal = this.numberOfReadOps.incrementAndGet();
            int index = (int)currentVal % clients.size();
            return clients.get(index);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instances for zone " + this._zone, t);
            return null;
        }
    }

    @Override
    public EVCacheClient[] getAllEVCacheClients() {
        try {
            EVCacheClient[] clientArr = new EVCacheClient[this.memcachedWriteInstancesByZone.size()];
            int i = 0;
            for (String zone : this.memcachedWriteInstancesByZone.keySet()) {
                List<ZoneClusteredEVCacheClientImpl> clients = this.memcachedWriteInstancesByZone.get(zone);
                if (clients.size() == 1) {
                    clientArr[i++] = clients.get(0);
                    continue;
                }
                long currentVal = this.numberOfReadOps.incrementAndGet();
                int index = (int)currentVal % clients.size();
                clientArr[i++] = clients.get(index);
            }
            return clientArr;
        }
        catch (Throwable t) {
            log.error("Exception trying to get an array of writable EVCache Instances", t);
            return new EVCacheClient[0];
        }
    }

    private void refresh() throws IOException {
        this.refresh(false);
    }

    private boolean haveInstancesInZoneChanged(String zone, List<String> discoveredHostsInZone) {
        List<ZoneClusteredEVCacheClientImpl> clients = this.memcachedInstancesByZone.get(zone);
        if (clients == null) {
            return true;
        }
        for (ZoneClusteredEVCacheClientImpl client : clients) {
            int actSrvCnt = client.getConnectionObserver().getActiveServerCount();
            int inActSrvCnt = client.getConnectionObserver().getInActiveServerCount();
            int sizeInDiscovery = discoveredHostsInZone.size();
            if (log.isDebugEnabled()) {
                log.debug("\n\tApp : " + this.getAppName() + "\n\tActive Count : " + actSrvCnt + "\n\tInactive Count : " + inActSrvCnt + "\n\tDiscovery Count : " + sizeInDiscovery);
            }
            if (actSrvCnt == sizeInDiscovery && inActSrvCnt <= 0) continue;
            if (log.isInfoEnabled()) {
                log.info("\n\t" + this.getAppName() + " & " + zone + " experienced an issue.\n\tActive Server Count : " + actSrvCnt);
                log.info("\n\tInActive Server Count : " + inActSrvCnt + "\n\tDiscovered Instances : " + sizeInDiscovery);
            }
            for (String instance : discoveredHostsInZone) {
                String hostname = instance.substring(0, instance.indexOf(58));
                if (client.getConnectionObserver().getActiveServerInfo().containsKey(hostname) || client.getConnectionObserver().getInActiveServerInfo().containsKey(hostname)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("AppName :" + this.getAppName() + "; Zone : " + zone + "; instance : " + instance + " not found and will shutdown the client and init it again.");
                }
                return true;
            }
        }
        return false;
    }

    private List<InetSocketAddress> getMemcachedSocketAddressList(List<String> discoveredHostsInZone) {
        ArrayList<InetSocketAddress> memcachedNodesInZone = new ArrayList<InetSocketAddress>();
        for (String hostAddress : discoveredHostsInZone) {
            int colonIndex = hostAddress.lastIndexOf(58);
            String hostName = hostAddress.substring(0, colonIndex);
            String portNum = hostAddress.substring(colonIndex + 1);
            memcachedNodesInZone.add(new InetSocketAddress(hostName, Integer.parseInt(portNum)));
        }
        return memcachedNodesInZone;
    }

    private void shutdownClientsInZone(List<ZoneClusteredEVCacheClientImpl> clients) {
        if (clients == null || clients.isEmpty()) {
            return;
        }
        for (ZoneClusteredEVCacheClientImpl oldClient : clients) {
            try {
                boolean obsRemoved = oldClient.removeConnectionObserver();
                if (log.isDebugEnabled()) {
                    log.debug("Connection observer removed " + obsRemoved);
                }
                boolean status = oldClient.shutdown(60L, TimeUnit.SECONDS);
                if (!log.isDebugEnabled()) continue;
                log.debug("Shutting down -> Client {" + ((Object)oldClient).toString() + "}; status : " + status);
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
    }

    private void setupNewClientsByZone(String zone, List<ZoneClusteredEVCacheClientImpl> newClients) {
        List<ZoneClusteredEVCacheClientImpl> currentClients = this.memcachedInstancesByZone.put(zone, newClients);
        DynamicBooleanProperty isZoneInWriteOnlyMode = this.writeOnlyFastPropertyMap.get(zone);
        if (isZoneInWriteOnlyMode.get()) {
            this.memcachedReadInstancesByZone.remove(zone);
        } else {
            this.memcachedReadInstancesByZone.put(zone, newClients);
        }
        this.memcachedWriteInstancesByZone.put(zone, newClients);
        if (currentClients == null || currentClients.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Replaced an existing Pool for zone : " + zone + "; and app " + this.getAppName() + " ;\n\tOldClients : " + currentClients + ";\n\tNewClients : " + newClients);
        }
        for (ZoneClusteredEVCacheClientImpl client : currentClients) {
            if (client.isShutdown()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Shutting down in Fallback -> AppName : " + this.getAppName() + "; Zone : " + zone + "; client {" + client + "};");
            }
            try {
                if (client.getConnectionObserver() != null) {
                    boolean obsRemoved = client.removeConnectionObserver();
                    if (log.isDebugEnabled()) {
                        log.debug("Connection observer removed " + obsRemoved);
                    }
                }
                boolean status = client.shutdown(60L, TimeUnit.SECONDS);
                if (!log.isDebugEnabled()) continue;
                log.debug("Shutting down {" + client + "} ; status : " + status);
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
        this.shutdownClientsInZone(currentClients);
    }

    private void updateMemcachedReadInstancesByZone() {
        for (String zone : this.memcachedInstancesByZone.keySet()) {
            DynamicBooleanProperty isZoneInWriteOnlyMode = this.writeOnlyFastPropertyMap.get(zone);
            if (isZoneInWriteOnlyMode.get()) {
                if (!this.memcachedReadInstancesByZone.containsKey(zone)) continue;
                this.memcachedReadInstancesByZone.remove(zone);
                continue;
            }
            if (this.memcachedReadInstancesByZone.containsKey(zone)) continue;
            this.memcachedReadInstancesByZone.put(zone, this.memcachedInstancesByZone.get(zone));
        }
        if (this.memcachedReadInstancesByZone.size() != this.memcachedFallbackReadInstances.getSize()) {
            this.memcachedFallbackReadInstances = new ZoneFallbackIterator(this.memcachedReadInstancesByZone.keySet());
        }
    }

    private synchronized void refresh(boolean force) throws IOException {
        try {
            Map<String, List<String>> instances = this.discoverInstances();
            if (instances == null || instances.isEmpty()) {
                return;
            }
            for (Map.Entry<String, List<String>> zoneEntry : instances.entrySet()) {
                boolean instanceChangeInZone;
                List<String> discoveredHostsInZone;
                String zone = zoneEntry.getKey();
                List<String> disInstanceInZone = zoneEntry.getValue();
                List<Object> list = discoveredHostsInZone = disInstanceInZone == null ? Collections.emptyList() : disInstanceInZone;
                if (log.isDebugEnabled()) {
                    log.debug("\n\tApp : " + this.getAppName() + "\n\tZone : " + zone + "\n\tSize : " + discoveredHostsInZone.size() + "\n\tInstances in zone : " + discoveredHostsInZone);
                }
                if (instanceChangeInZone = force) {
                    if (log.isWarnEnabled()) {
                        log.warn("FORCE REFRESH :: AppName :" + this.getAppName() + "; Zone : " + zone + "; Changed : " + instanceChangeInZone);
                    }
                } else {
                    instanceChangeInZone = this.haveInstancesInZoneChanged(zone, discoveredHostsInZone);
                    if (!instanceChangeInZone) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("AppName :" + this.getAppName() + "; Zone : " + zone + "; Changed : " + instanceChangeInZone);
                        continue;
                    }
                }
                List<InetSocketAddress> memcachedSAInZone = this.getMemcachedSocketAddressList(discoveredHostsInZone);
                int poolSize = this.getPoolSize().get();
                ArrayList<ZoneClusteredEVCacheClientImpl> newClients = new ArrayList<ZoneClusteredEVCacheClientImpl>(poolSize);
                for (int i = 0; i < poolSize; ++i) {
                    int maxQueueSize = ConfigurationManager.getConfigInstance().getInt(this.getAppName() + ".max.queue.length", 16384);
                    ZoneClusteredEVCacheClientImpl client = new ZoneClusteredEVCacheClientImpl(this.getAppName(), zone, i, maxQueueSize, this.getReadTimeout(), memcachedSAInZone);
                    newClients.add(client);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("AppName :" + this.getAppName() + "; Zone : " + zone + "; intit : client.getId() : " + client.getId());
                }
                this.setupNewClientsByZone(zone, newClients);
            }
            this.updateMemcachedReadInstancesByZone();
        }
        catch (Throwable t) {
            log.error("Exception while refreshing the Server list", t);
        }
    }

    private DynamicStringProperty getHostsFastProperty(String zone) {
        DynamicStringProperty hostsInZone = this.hostsByZoneFPMap.get(zone);
        if (hostsInZone != null) {
            return hostsInZone;
        }
        hostsInZone = DynamicPropertyFactory.getInstance().getStringProperty(this.getAppName() + "." + zone + ".EVCacheClientPool.hosts", "");
        hostsInZone.addCallback((Runnable)this);
        this.hostsByZoneFPMap.put(zone, hostsInZone);
        return hostsInZone;
    }

    private Map<String, List<String>> discoverInstances() throws IOException {
        if (this.isShutdown()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> instancesByZoneMap = new HashMap<String, List<String>>();
        StringTokenizer zoneListTokenizer = new StringTokenizer(this._zoneList.get(), ",");
        while (zoneListTokenizer.hasMoreTokens()) {
            String zone = zoneListTokenizer.nextToken();
            DynamicStringProperty hostsInZoneFP = this.getHostsFastProperty(zone);
            StringTokenizer hostListTokenizer = new StringTokenizer(hostsInZoneFP.get(), ",");
            while (hostListTokenizer.hasMoreTokens()) {
                String memcachedPort;
                String memcachedHost;
                String token = hostListTokenizer.nextToken();
                int index = token.indexOf(":");
                if (index == -1) {
                    memcachedHost = token;
                    memcachedPort = "11211";
                } else {
                    memcachedHost = token.substring(0, index);
                    memcachedPort = token.substring(index + 1);
                }
                if (!instancesByZoneMap.containsKey(zone)) {
                    instancesByZoneMap.put(zone, new ArrayList());
                }
                List instancesInZone = (List)instancesByZoneMap.get(zone);
                instancesInZone.add(memcachedHost + ":" + memcachedPort);
            }
        }
        return instancesByZoneMap;
    }

    @Override
    public void run() {
        block2: {
            try {
                this.refresh();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error Refreshing EVCache Instance list for " + this.getAppName(), t);
            }
        }
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info("EVCacheClientPool for App : " + this.getAppName() + " and Zone : " + this._zone + " is being shutdown.");
        }
        super.shutdown();
        for (List<ZoneClusteredEVCacheClientImpl> instancesInAZone : this.memcachedInstancesByZone.values()) {
            for (ZoneClusteredEVCacheClientImpl client : instancesInAZone) {
                this.shutdownClient(client);
            }
        }
    }

    @Override
    @Monitor(name="Instances", type=DataSourceType.COUNTER)
    public int getInstanceCount() {
        int instances = 0;
        for (String zone : this.memcachedInstancesByZone.keySet()) {
            instances += this.memcachedInstancesByZone.get(zone).get(0).getConnectionObserver().getActiveServerCount();
        }
        return instances;
    }

    @Override
    public Map<String, String> getInstancesByZone() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (String zone : this.memcachedInstancesByZone.keySet()) {
            List<ZoneClusteredEVCacheClientImpl> instanceList = this.memcachedInstancesByZone.get(zone);
            instanceMap.put(zone, instanceList.toString());
        }
        return instanceMap;
    }

    @Override
    @Monitor(name="InstanceCountByZone", type=DataSourceType.INFORMATIONAL)
    public Map<String, Integer> getInstanceCountByZone() {
        HashMap<String, Integer> instancesByZone = new HashMap<String, Integer>(this.memcachedInstancesByZone.size() * 2);
        for (String zone : this.memcachedInstancesByZone.keySet()) {
            instancesByZone.put(zone, this.memcachedInstancesByZone.get(zone).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instancesByZone;
    }

    @Override
    public Map<String, String> getReadZones() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (String key : this.memcachedReadInstancesByZone.keySet()) {
            instanceMap.put(key, this.memcachedReadInstancesByZone.get(key).toString());
        }
        return instanceMap;
    }

    @Override
    @Monitor(name="ReadInstanceCountByZone", type=DataSourceType.INFORMATIONAL)
    public Map<String, Integer> getReadInstanceCountByZone() {
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        for (String key : this.memcachedReadInstancesByZone.keySet()) {
            instanceMap.put(key, this.memcachedReadInstancesByZone.get(key).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instanceMap;
    }

    @Override
    public Map<String, String> getWriteZones() {
        HashMap<String, String> instanceMap = new HashMap<String, String>();
        for (String key : this.memcachedWriteInstancesByZone.keySet()) {
            instanceMap.put(key, this.memcachedWriteInstancesByZone.get(key).toString());
        }
        return instanceMap;
    }

    public Map<String, List<ZoneClusteredEVCacheClientImpl>> getAllInstancesByZone() {
        return Collections.unmodifiableMap(this.memcachedInstancesByZone);
    }

    @Override
    @Monitor(name="WriteInstanceCountByZone", type=DataSourceType.INFORMATIONAL)
    public Map<String, Integer> getWriteInstanceCountByZone() {
        HashMap<String, Integer> instanceMap = new HashMap<String, Integer>();
        for (String key : this.memcachedWriteInstancesByZone.keySet()) {
            instanceMap.put(key, this.memcachedWriteInstancesByZone.get(key).get(0).getConnectionObserver().getActiveServerCount());
        }
        return instanceMap;
    }

    @Override
    public boolean supportsFallback() {
        return this.memcachedFallbackReadInstances.getSize() > 1;
    }

    @Override
    public int getClusterSize() {
        return this.memcachedInstancesByZone.size();
    }

    @Override
    public void refreshPool() {
        block2: {
            try {
                this.refresh(true);
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error Refreshing EVCache Instance list from MBean : " + this.getAppName(), t);
            }
        }
    }

    @Override
    public String toString() {
        return "ZoneClusteredEVCacheClientPoolImpl [" + super.toString() + ", memcachedInstancesByZone=" + this.memcachedInstancesByZone + ", memcachedReadInstancesByZone=" + this.memcachedReadInstancesByZone + ", memcachedWriteInstancesByZone=" + this.memcachedWriteInstancesByZone + ", memcachedFallbackReadInstances=" + this.memcachedFallbackReadInstances + "]";
    }
}

