/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.eureka;

import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.pool.AbstractEVCacheClientImpl;
import com.netflix.evcache.pool.eureka.connection.EVCacheConnectionFactory;
import com.netflix.evcache.pool.observer.EVCacheConnectionObserver;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.MemcachedClient;

public class EVCacheClientImpl
extends AbstractEVCacheClientImpl {
    private EVCacheConnectionObserver connectionObserver = null;

    EVCacheClientImpl(String appName, String zone, int id, int maxQueueSize, DynamicIntProperty readTimeout, List<InetSocketAddress> memcachedNodesInZone) throws IOException {
        super(appName, zone, id, readTimeout, (ConnectionFactory)new EVCacheConnectionFactory(appName, zone, id, maxQueueSize));
        this.client = new MemcachedClient(this.connectionFactory, memcachedNodesInZone);
        this.connectionObserver = new EVCacheConnectionObserver(appName, zone, id);
        this.client.addObserver((ConnectionObserver)this.connectionObserver);
    }

    @Override
    public boolean removeConnectionObserver() {
        try {
            boolean removed = this.client.removeObserver((ConnectionObserver)this.connectionObserver);
            if (removed) {
                this.connectionObserver = null;
            }
            return removed;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public EVCacheConnectionObserver getConnectionObserver() {
        return this.connectionObserver;
    }

    @Override
    public String toString() {
        return "EVCacheClientImpl [" + super.toString() + "]";
    }
}

