/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.config.ConfigurationManager;
import com.netflix.evcache.pool.EVCacheClientPool;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EVCacheClientPoolManager {
    private static final Logger log = LoggerFactory.getLogger(EVCacheClientPoolManager.class);
    private static final EVCacheClientPoolManager instance = new EVCacheClientPoolManager();
    private final Map<String, EVCacheClientPool> poolMap = new ConcurrentHashMap<String, EVCacheClientPool>();
    private final ReentrantLock lock = new ReentrantLock();
    private final String evcachePoolProvider;

    private EVCacheClientPoolManager() {
        try {
            String poolProvider = "com.netflix.evcache.pool.eureka.EVCacheClientPoolImpl";
            this.evcachePoolProvider = ConfigurationManager.getConfigInstance().getString("evcache.pool.provider", "com.netflix.evcache.pool.eureka.EVCacheClientPoolImpl");
            this.init();
        }
        catch (ConfigurationException e) {
            log.error("Could not load the config file. Will not be able to init EVCaches!!!!", (Throwable)e);
            throw new IllegalStateException("Could not load the config file. Will not be able to init EVCaches!!!!", e);
        }
        catch (IOException e) {
            log.error("Unable to init EVCaches!!!!", (Throwable)e);
            throw new IllegalStateException("Could not find the config file. Will not be able to init EVCaches!!!!", e);
        }
    }

    public static EVCacheClientPoolManager getInstance() {
        return instance;
    }

    private void init() throws ConfigurationException, IOException {
        String appsToInit = ConfigurationManager.getConfigInstance().getString("evcache.appsToInit");
        if (appsToInit == null) {
            return;
        }
        StringTokenizer apps = new StringTokenizer(appsToInit, ",");
        while (apps.hasMoreTokens()) {
            String app = apps.nextToken().toUpperCase();
            if (log.isInfoEnabled()) {
                log.info("Initializing EVCache - " + app);
            }
            this.initEVCache(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initEVCache(String _appName) {
        String appName = _appName.toUpperCase();
        if (this.poolMap.containsKey(appName)) {
            return;
        }
        this.lock.lock();
        try {
            if (this.poolMap.containsKey(appName)) {
                return;
            }
            EVCacheClientPool pool = (EVCacheClientPool)Class.forName(this.evcachePoolProvider).newInstance();
            pool.init(appName);
            this.poolMap.put(appName, pool);
        }
        catch (Exception ex) {
            log.error("Exception initialzing " + this.evcachePoolProvider + " for app " + appName, (Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    public EVCacheClientPool getEVCacheClientPool(String app) {
        EVCacheClientPool evcacheClientPool = this.poolMap.get(app);
        if (evcacheClientPool != null) {
            return evcacheClientPool;
        }
        this.initEVCache(app);
        return this.poolMap.get(app);
    }

    public Map<String, EVCacheClientPool> getAllEVCacheClientPool() {
        return Collections.unmodifiableMap(this.poolMap);
    }

    public void shutdown() {
        for (EVCacheClientPool pool : this.poolMap.values()) {
            pool.shutdown();
        }
    }
}

