/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.evcache.EVCache;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheTranscoder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EVCacheImpl
implements EVCache {
    private static final Logger log = LoggerFactory.getLogger(EVCacheImpl.class);
    private final String _appName;
    private final String _cacheName;
    private final EVCacheTranscoder<?> _defaultTranscoder;
    private final boolean _zoneFallback;
    private final int _timeToLive;
    private final EVCacheClientPool _pool;
    private final DynamicBooleanProperty _throwException;
    private final DynamicBooleanProperty _zoneFallbackFP;
    private final Counter HIT_COUNTER;
    private final Counter MISS_COUNTER;
    private final Counter BULK_HIT_COUNTER;
    private final Counter BULK_MISS_COUNTER;
    private final Counter NULL_CLIENT_COUNTER;
    private final Counter FALLBACK_HIT_COUNTER;
    private final Counter FALLBACK_MISS_COUNTER;

    EVCacheImpl(String appName, String cacheName, int timeToLive, EVCacheTranscoder<?> transcoder, boolean enableZoneFallback) {
        this._appName = appName;
        this._cacheName = cacheName;
        this._timeToLive = timeToLive;
        this._defaultTranscoder = transcoder;
        this._zoneFallback = enableZoneFallback;
        String _metricName = cacheName == null ? appName : appName + "." + cacheName;
        this.NULL_CLIENT_COUNTER = Monitors.newCounter((String)(_metricName + ":NULL_CLIENT"));
        this.FALLBACK_HIT_COUNTER = Monitors.newCounter((String)(_metricName + ":FALLBACK:HIT"));
        this.FALLBACK_MISS_COUNTER = Monitors.newCounter((String)(_metricName + ":FALLBACK:MISS"));
        this.HIT_COUNTER = Monitors.newCounter((String)(_metricName + ":HIT"));
        this.MISS_COUNTER = Monitors.newCounter((String)(_metricName + ":MISS"));
        this.BULK_HIT_COUNTER = Monitors.newCounter((String)(_metricName + ":BULK:HIT"));
        this.BULK_MISS_COUNTER = Monitors.newCounter((String)(_metricName + "BULK::MISS"));
        this._pool = EVCacheClientPoolManager.getInstance().getEVCacheClientPool(appName);
        this._throwException = DynamicPropertyFactory.getInstance().getBooleanProperty(_metricName + ".throw.exception", false);
        this._zoneFallbackFP = DynamicPropertyFactory.getInstance().getBooleanProperty(_metricName + ".fallback.zone", true);
    }

    protected String getCanonicalizedKey(String key) {
        if (this._cacheName == null || this._cacheName.length() == 0) {
            return key;
        }
        return this._cacheName + ':' + key;
    }

    protected String getKey(String canonicalizedKey) {
        if (canonicalizedKey == null) {
            return canonicalizedKey;
        }
        return this._cacheName == null || this._cacheName.length() == 0 || canonicalizedKey.indexOf(58) == -1 ? canonicalizedKey : canonicalizedKey.substring(canonicalizedKey.indexOf(58) + 1);
    }

    protected boolean isInZoneFallback() {
        if (!this._pool.supportsFallback()) {
            return false;
        }
        if (this._zoneFallbackFP.get()) {
            return true;
        }
        return this._zoneFallback;
    }

    @Override
    public <T> T get(String key) throws EVCacheException {
        return (T)this.get(key, this._defaultTranscoder);
    }

    @Override
    public <T> T get(String key, EVCacheTranscoder<T> tc) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        EVCacheClient client = this._pool.getEVCacheClient();
        if (client == null) {
            this.NULL_CLIENT_COUNTER.increment();
            if (this._throwException.get()) {
                throw new EVCacheException("Couldn't find an Client to get the data for key : " + key);
            }
            return null;
        }
        try {
            String canonicalKey = this.getCanonicalizedKey(key);
            T data = client.get(canonicalKey, tc);
            if (data == null && this.isInZoneFallback()) {
                EVCacheClient fbClient = this._pool.getEVCacheClientExcludeZone(client.getZone());
                if (fbClient == null) {
                    return null;
                }
                data = fbClient.get(canonicalKey, tc);
                if (data == null) {
                    this.FALLBACK_MISS_COUNTER.increment();
                } else {
                    this.FALLBACK_HIT_COUNTER.increment();
                }
            }
            if (data != null) {
                this.HIT_COUNTER.increment();
            } else {
                this.MISS_COUNTER.increment();
            }
            if (log.isDebugEnabled()) {
                log.debug("GET : key [" + key + "], Value [" + data + "]");
            }
            return data;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Exception while getting data for key : " + key, (Throwable)ex);
            }
            if (!this._throwException.get()) {
                return null;
            }
            throw new EVCacheException("Exception getting data for key : " + key, ex);
        }
    }

    @Override
    public <T> T getAndTouch(String key, int timeToLive) throws EVCacheException {
        return (T)this.getAndTouch(key, timeToLive, this._defaultTranscoder);
    }

    @Override
    public <T> T getAndTouch(String key, int timeToLive, EVCacheTranscoder<T> tc) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        EVCacheClient[] clients = this._pool.getAllEVCacheClients();
        if (clients == null || clients.length == 0) {
            this.NULL_CLIENT_COUNTER.increment();
            if (this._throwException.get()) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return null;
        }
        try {
            Future[] futures = new Future[clients.length];
            String canonicalKey = this.getCanonicalizedKey(key);
            int index = 0;
            int timeout = 0;
            for (EVCacheClient client : clients) {
                futures[index++] = client.asyncGetAndTouch(canonicalKey, tc, timeToLive);
                if (timeout != 0) continue;
                timeout = client.getReadTimeout();
            }
            if (log.isDebugEnabled()) {
                log.debug("GETnTOUCH : key [" + key + "], Status [" + futures.length + "]");
            }
            Object data = null;
            for (Future dataFuture : futures) {
                Object t = ((CASValue)dataFuture.get(timeout, TimeUnit.MILLISECONDS)).getValue();
                if (data != null) continue;
                data = t;
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug("GETnTOUCH : key [" + key + "], Value [" + data + "]");
            }
            if (data != null) {
                this.HIT_COUNTER.increment();
            } else {
                this.MISS_COUNTER.increment();
            }
            return (T)data;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Exception executing getAndTouch key : " + key, (Throwable)ex);
            }
            if (!this._throwException.get()) {
                return null;
            }
            throw new EVCacheException("Exception executing getAndTouch key : " + key, ex);
        }
    }

    @Override
    public <T> Future<T> getAsynchronous(String key) throws EVCacheException {
        return this.getAsynchronous(key, this._defaultTranscoder);
    }

    @Override
    public <T> Future<T> getAsynchronous(String key, EVCacheTranscoder<T> tc) throws EVCacheException {
        Future<T> r;
        if (null == key) {
            throw new IllegalArgumentException();
        }
        EVCacheClient client = this._pool.getEVCacheClient();
        if (client == null) {
            this.NULL_CLIENT_COUNTER.increment();
            if (this._throwException.get()) {
                throw new EVCacheException("Could not find a client to asynchronously get the data");
            }
            return null;
        }
        try {
            String canonicalKey = this.getCanonicalizedKey(key);
            r = client.asyncGet(canonicalKey, tc);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Exception while getting data for keys Asynchronously key : " + key, (Throwable)ex);
            }
            if (!this._throwException.get()) {
                return null;
            }
            throw new EVCacheException("Exception getting data for key : " + key, ex);
        }
        return r;
    }

    @Override
    public <T> Map<String, T> getBulk(Collection<String> keys, EVCacheTranscoder<T> tc) throws EVCacheException {
        if (null == keys) {
            throw new IllegalArgumentException();
        }
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        EVCacheClient client = this._pool.getEVCacheClient();
        if (client == null) {
            this.NULL_CLIENT_COUNTER.increment();
            if (this._throwException.get()) {
                throw new EVCacheException("Could not find a client to get the data in bulk");
            }
            return null;
        }
        ArrayList<String> canonicalKeys = new ArrayList<String>();
        for (String k : keys) {
            String canonicalK = this.getCanonicalizedKey(k);
            canonicalKeys.add(canonicalK);
        }
        try {
            Map<String, T> retMap = client.getBulk(canonicalKeys, tc);
            if (retMap == null || retMap.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, T> decanonicalR = new HashMap<String, T>(retMap.size() * 2);
            for (Map.Entry<String, T> i : retMap.entrySet()) {
                String deCanKey = this.getKey(i.getKey());
                if (deCanKey == null) continue;
                decanonicalR.put(deCanKey, i.getValue());
            }
            if (!decanonicalR.isEmpty()) {
                this.BULK_HIT_COUNTER.increment();
            } else {
                this.BULK_MISS_COUNTER.increment();
            }
            if (log.isDebugEnabled()) {
                log.debug("BULK : Data [" + decanonicalR + "]");
            }
            return decanonicalR;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Exception getting bulk data for keys : " + keys, (Throwable)ex);
            }
            if (!this._throwException.get()) {
                return null;
            }
            throw new EVCacheException("Exception getting bulk data for keys : " + keys, ex);
        }
    }

    @Override
    public <T> Map<String, T> getBulk(Collection<String> keys) throws EVCacheException {
        return this.getBulk(keys, this._defaultTranscoder);
    }

    @Override
    public <T> Map<String, T> getBulk(String ... keys) throws EVCacheException {
        return this.getBulk(Arrays.asList(keys), this._defaultTranscoder);
    }

    @Override
    public <T> Map<String, T> getBulk(EVCacheTranscoder<T> tc, String ... keys) throws EVCacheException {
        return this.getBulk(Arrays.asList(keys), tc);
    }

    @Override
    public <T> Future<Boolean>[] set(String key, T value, EVCacheTranscoder<T> tc, int timeToLive) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        EVCacheClient[] clients = this._pool.getAllEVCacheClients();
        if (clients == null || clients.length == 0) {
            this.NULL_CLIENT_COUNTER.increment();
            if (this._throwException.get()) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new Future[0];
        }
        try {
            Future[] futures = new Future[clients.length];
            String canonicalKey = this.getCanonicalizedKey(key);
            int index = 0;
            for (EVCacheClient client : clients) {
                futures[index++] = client.set(canonicalKey, tc, value, timeToLive);
            }
            if (log.isDebugEnabled()) {
                log.debug("SET : key [" + key + "], Status [" + futures.length + "]");
            }
            return futures;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Exception setting the data for key : " + key, (Throwable)ex);
            }
            if (!this._throwException.get()) {
                return null;
            }
            throw new EVCacheException("Exception setting data for key : " + key, ex);
        }
    }

    @Override
    public <T> Future<Boolean>[] set(String key, T value, EVCacheTranscoder<T> tc) throws EVCacheException {
        return this.set(key, value, tc, this._timeToLive);
    }

    @Override
    public <T> Future<Boolean>[] set(String key, T value, int timeToLive) throws EVCacheException {
        return this.set(key, value, this._defaultTranscoder, timeToLive);
    }

    @Override
    public <T> Future<Boolean>[] set(String key, T value) throws EVCacheException {
        return this.set(key, value, this._defaultTranscoder, this._timeToLive);
    }

    @Override
    public Future<Boolean>[] delete(String key) throws EVCacheException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        EVCacheClient[] clients = this._pool.getAllEVCacheClients();
        if (clients == null || clients.length == 0) {
            this.NULL_CLIENT_COUNTER.increment();
            if (this._throwException.get()) {
                throw new EVCacheException("Could not find a client to delete the key");
            }
            return new Future[0];
        }
        try {
            Future[] futures = new Future[clients.length];
            String canonicalKey = this.getCanonicalizedKey(key);
            for (int i = 0; i < clients.length; ++i) {
                futures[i] = clients[i].delete(canonicalKey);
            }
            return futures;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Exception while deleting the data for key : " + key, (Throwable)ex);
            }
            if (!this._throwException.get()) {
                return null;
            }
            throw new EVCacheException("Exception while deleting the data for key : " + key, ex);
        }
    }

    public int getDefaultTTL() {
        return this._timeToLive;
    }

    public String getAppName() {
        return this._appName;
    }

    public String getCacheName() {
        return this._cacheName;
    }

    public String toString() {
        return "EVCacheImpl [App Name=" + this._appName + ", Cache Name=" + this._cacheName + ", Default Transcoder=" + this._defaultTranscoder + ", Zone Fallback=" + this.isInZoneFallback() + ", Default TTL=" + this.getDefaultTTL() + ", EVCache Pool=" + this._pool + ", throw Exception=" + this._throwException.get() + "]";
    }
}

