/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.ChangeAction;
import com.amazonaws.services.route53.model.ChangeBatch;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.HostedZone;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.RRType;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.aws.AwsBinder;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Route53Binder
implements AwsBinder {
    private static final Logger logger = LoggerFactory.getLogger(Route53Binder.class);
    public static final String NULL_DOMAIN = "null";
    private final EurekaServerConfig serverConfig;
    private final EurekaClientConfig clientConfig;
    private final ApplicationInfoManager applicationInfoManager;
    private final String registrationHostname;
    private final Timer timer;
    private final AmazonRoute53Client amazonRoute53Client;

    @Inject
    public Route53Binder(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ApplicationInfoManager applicationInfoManager) {
        this(Route53Binder.getRegistrationHostnameFromAmazonDataCenterInfo(applicationInfoManager), serverConfig, clientConfig, applicationInfoManager);
    }

    public Route53Binder(String registrationHostname, EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ApplicationInfoManager applicationInfoManager) {
        this.registrationHostname = registrationHostname;
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
        this.applicationInfoManager = applicationInfoManager;
        this.timer = new Timer("Eureka-Route53Binder", true);
        this.amazonRoute53Client = this.getAmazonRoute53Client(serverConfig);
    }

    private static String getRegistrationHostnameFromAmazonDataCenterInfo(ApplicationInfoManager applicationInfoManager) {
        InstanceInfo myInfo = applicationInfoManager.getInfo();
        AmazonInfo dataCenterInfo = (AmazonInfo)myInfo.getDataCenterInfo();
        String ip = dataCenterInfo.get(AmazonInfo.MetaDataKey.publicHostname);
        if (ip == null || ip.length() == 0) {
            return dataCenterInfo.get(AmazonInfo.MetaDataKey.localHostname);
        }
        return ip;
    }

    @Override
    @PostConstruct
    public void start() {
        try {
            this.doBind();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        Route53Binder.this.doBind();
                    }
                    catch (Throwable e) {
                        logger.error("Could not bind to Route53", e);
                    }
                }
            }, this.serverConfig.getRoute53BindingRetryIntervalMs(), (long)this.serverConfig.getRoute53BindingRetryIntervalMs());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void doBind() throws InterruptedException {
        ArrayList<ResourceRecordSetWithHostedZone> freeDomains = new ArrayList<ResourceRecordSetWithHostedZone>();
        List<String> domains = this.getDeclaredDomains();
        for (String domain : domains) {
            ResourceRecordSetWithHostedZone rrs = this.getResourceRecordSetWithHostedZone(domain);
            if (rrs == null) continue;
            if (rrs.getResourceRecordSet() == null) {
                ResourceRecordSet resourceRecordSet = new ResourceRecordSet();
                resourceRecordSet.setName(domain);
                resourceRecordSet.setType(RRType.CNAME);
                resourceRecordSet.setTTL(Long.valueOf(this.serverConfig.getRoute53DomainTTL()));
                freeDomains.add(new ResourceRecordSetWithHostedZone(rrs.getHostedZone(), resourceRecordSet));
            } else if (NULL_DOMAIN.equals(((ResourceRecord)rrs.getResourceRecordSet().getResourceRecords().get(0)).getValue())) {
                freeDomains.add(rrs);
            }
            if (!this.hasValue(rrs, this.registrationHostname)) continue;
            return;
        }
        for (ResourceRecordSetWithHostedZone rrs : freeDomains) {
            if (!this.createResourceRecordSet(rrs)) continue;
            logger.info("Bind {} to {}", (Object)this.registrationHostname, (Object)rrs.getResourceRecordSet().getName());
            return;
        }
        logger.warn("Unable to find free domain in {}", domains);
    }

    private boolean createResourceRecordSet(ResourceRecordSetWithHostedZone rrs) throws InterruptedException {
        rrs.getResourceRecordSet().setResourceRecords(Arrays.asList(new ResourceRecord(this.registrationHostname)));
        Change change = new Change(ChangeAction.UPSERT, rrs.getResourceRecordSet());
        if (this.executeChangeWithRetry(change, rrs.getHostedZone())) {
            Thread.sleep(1000L);
            ResourceRecordSet resourceRecordSet = this.getResourceRecordSet(rrs.getResourceRecordSet().getName(), rrs.getHostedZone());
            if (resourceRecordSet != null) {
                return resourceRecordSet.getResourceRecords().equals(rrs.getResourceRecordSet().getResourceRecords());
            }
        }
        return false;
    }

    private List<String> toDomains(List<String> ec2Urls) {
        ArrayList<String> domains = new ArrayList<String>(ec2Urls.size());
        for (String url : ec2Urls) {
            try {
                domains.add(this.extractDomain(url));
            }
            catch (MalformedURLException e) {
                logger.error("Invalid url {}", (Object)url, (Object)e);
            }
        }
        return domains;
    }

    private String getMyZone() {
        String zone;
        InstanceInfo info = this.applicationInfoManager.getInfo();
        AmazonInfo amazonInfo = info != null ? (AmazonInfo)info.getDataCenterInfo() : null;
        String string = zone = amazonInfo != null ? amazonInfo.get(AmazonInfo.MetaDataKey.availabilityZone) : null;
        if (zone == null) {
            throw new RuntimeException("Cannot extract availabilityZone");
        }
        return zone;
    }

    private List<String> getDeclaredDomains() {
        String myZone = this.getMyZone();
        List ec2Urls = this.clientConfig.getEurekaServerServiceUrls(myZone);
        return this.toDomains(ec2Urls);
    }

    private boolean executeChangeWithRetry(Change change, HostedZone hostedZone) throws InterruptedException {
        Throwable firstError = null;
        for (int i = 0; i < this.serverConfig.getRoute53BindRebindRetries(); ++i) {
            try {
                this.executeChange(change, hostedZone);
                return true;
            }
            catch (Throwable e) {
                if (firstError == null) {
                    firstError = e;
                }
                Thread.sleep(1000L);
                continue;
            }
        }
        if (firstError != null) {
            logger.error("Cannot execute change {} {}", new Object[]{change, firstError, firstError});
        }
        return false;
    }

    private void executeChange(Change change, HostedZone hostedZone) {
        logger.info("Execute change {} ", (Object)change);
        ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest = new ChangeResourceRecordSetsRequest();
        changeResourceRecordSetsRequest.setHostedZoneId(hostedZone.getId());
        ChangeBatch changeBatch = new ChangeBatch();
        changeBatch.withChanges(new Change[]{change});
        changeResourceRecordSetsRequest.setChangeBatch(changeBatch);
        this.amazonRoute53Client.changeResourceRecordSets(changeResourceRecordSetsRequest);
    }

    private ResourceRecordSetWithHostedZone getResourceRecordSetWithHostedZone(String domain) {
        HostedZone hostedZone = this.getHostedZone(domain);
        if (hostedZone != null) {
            return new ResourceRecordSetWithHostedZone(hostedZone, this.getResourceRecordSet(domain, hostedZone));
        }
        return null;
    }

    private ResourceRecordSet getResourceRecordSet(String domain, HostedZone hostedZone) {
        ListResourceRecordSetsRequest request = new ListResourceRecordSetsRequest();
        request.setMaxItems(String.valueOf(Integer.MAX_VALUE));
        request.setHostedZoneId(hostedZone.getId());
        ListResourceRecordSetsResult listResourceRecordSetsResult = this.amazonRoute53Client.listResourceRecordSets(request);
        for (ResourceRecordSet rrs : listResourceRecordSetsResult.getResourceRecordSets()) {
            if (!rrs.getName().equals(domain)) continue;
            return rrs;
        }
        return null;
    }

    private HostedZone getHostedZone(String domain) {
        ListHostedZonesRequest listHostedZoneRequest = new ListHostedZonesRequest();
        listHostedZoneRequest.setMaxItems(String.valueOf(Integer.MAX_VALUE));
        ListHostedZonesResult listHostedZonesResult = this.amazonRoute53Client.listHostedZones(listHostedZoneRequest);
        for (HostedZone hostedZone : listHostedZonesResult.getHostedZones()) {
            if (!domain.endsWith(hostedZone.getName())) continue;
            return hostedZone;
        }
        return null;
    }

    private void unbindFromDomain(String domain) throws InterruptedException {
        ResourceRecordSetWithHostedZone resourceRecordSetWithHostedZone = this.getResourceRecordSetWithHostedZone(domain);
        if (this.hasValue(resourceRecordSetWithHostedZone, this.registrationHostname)) {
            ((ResourceRecord)resourceRecordSetWithHostedZone.getResourceRecordSet().getResourceRecords().get(0)).setValue(NULL_DOMAIN);
            this.executeChangeWithRetry(new Change(ChangeAction.UPSERT, resourceRecordSetWithHostedZone.getResourceRecordSet()), resourceRecordSetWithHostedZone.getHostedZone());
        }
    }

    private String extractDomain(String url) throws MalformedURLException {
        return new URL(url).getHost() + ".";
    }

    @Override
    @PreDestroy
    public void shutdown() {
        this.timer.cancel();
        for (String domain : this.getDeclaredDomains()) {
            try {
                this.unbindFromDomain(domain);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.amazonRoute53Client.shutdown();
    }

    private AmazonRoute53Client getAmazonRoute53Client(EurekaServerConfig serverConfig) {
        String aWSAccessId = serverConfig.getAWSAccessId();
        String aWSSecretKey = serverConfig.getAWSSecretKey();
        ClientConfiguration clientConfiguration = new ClientConfiguration().withConnectionTimeout(serverConfig.getASGQueryTimeoutMs());
        if (null != aWSAccessId && !"".equals(aWSAccessId) && null != aWSSecretKey && !"".equals(aWSSecretKey)) {
            return new AmazonRoute53Client((AWSCredentials)new BasicAWSCredentials(aWSAccessId, aWSSecretKey), clientConfiguration);
        }
        return new AmazonRoute53Client((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(), clientConfiguration);
    }

    private boolean hasValue(ResourceRecordSetWithHostedZone resourceRecordSetWithHostedZone, String ip) {
        if (resourceRecordSetWithHostedZone != null && resourceRecordSetWithHostedZone.getResourceRecordSet() != null) {
            for (ResourceRecord rr : resourceRecordSetWithHostedZone.getResourceRecordSet().getResourceRecords()) {
                if (!ip.equals(rr.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private class ResourceRecordSetWithHostedZone {
        private final HostedZone hostedZone;
        private final ResourceRecordSet resourceRecordSet;

        public ResourceRecordSetWithHostedZone(HostedZone hostedZone, ResourceRecordSet resourceRecordSet) {
            this.hostedZone = hostedZone;
            this.resourceRecordSet = resourceRecordSet;
        }

        public HostedZone getHostedZone() {
            return this.hostedZone;
        }

        public ResourceRecordSet getResourceRecordSet() {
            return this.resourceRecordSet;
        }
    }
}

