/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.eureka.AbstractInstanceRegistry;
import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.Version;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCache {
    private static final Logger logger = LoggerFactory.getLogger(ResponseCache.class);
    public static final String ALL_APPS = "ALL_APPS";
    public static final String ALL_APPS_DELTA = "ALL_APPS_DELTA";
    private static final AtomicLong versionDelta = new AtomicLong(0L);
    private static final AtomicLong versionDeltaWithRegions = new AtomicLong(0L);
    private static final String EMPTY_PAYLOAD = "";
    private static final java.util.Timer timer = new java.util.Timer("Eureka -CacheFillTimer", true);
    private final Timer serializeAllAppsTimer = Monitors.newTimer((String)"serialize-all");
    private final Timer serializeDeltaAppsTimer = Monitors.newTimer((String)"serialize-all-delta");
    private final Timer serializeAllAppsWithRemoteRegionTimer = Monitors.newTimer((String)"serialize-all_remote_region");
    private final Timer serializeDeltaAppsWithRemoteRegionTimer = Monitors.newTimer((String)"serialize-all-delta_remote_region");
    private final Timer serializeOneApptimer = Monitors.newTimer((String)"serialize-one");
    private final Timer serializeViptimer = Monitors.newTimer((String)"serialize-one-vip");
    private final Timer compressPayloadTimer = Monitors.newTimer((String)"compress-payload");
    private final EurekaServerConfig eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private final Multimap<Key, Key> regionSpecificKeys = Multimaps.newListMultimap(new ConcurrentHashMap(), (Supplier)new Supplier<List<Key>>(){

        public List<Key> get() {
            return new CopyOnWriteArrayList<Key>();
        }
    });
    private final ConcurrentMap<Key, Value> readOnlyCacheMap = new ConcurrentHashMap<Key, Value>();
    private final LoadingCache<Key, Value> readWriteCacheMap = CacheBuilder.newBuilder().initialCapacity(1000).expireAfterWrite(this.eurekaConfig.getResponseCacheAutoExpirationInSeconds(), TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<Key, Value>(){

        public void onRemoval(RemovalNotification<Key, Value> notification) {
            Key removedKey = (Key)notification.getKey();
            if (removedKey.hasRegions()) {
                Key cloneWithNoRegions = removedKey.cloneWithoutRegions();
                ResponseCache.this.regionSpecificKeys.remove((Object)cloneWithNoRegions, (Object)removedKey);
            }
        }
    }).build((CacheLoader)new CacheLoader<Key, Value>(){

        public Value load(Key key) throws Exception {
            if (key.hasRegions()) {
                Key cloneWithNoRegions = key.cloneWithoutRegions();
                ResponseCache.this.regionSpecificKeys.put((Object)cloneWithNoRegions, (Object)key);
            }
            Value value = ResponseCache.this.generatePayload(key);
            return value;
        }
    });
    private final boolean shouldUseReadOnlyResponseCache;
    private final AbstractInstanceRegistry registry;
    private final ServerCodecs serverCodecs;
    private static final ResponseCache s_instance = new ResponseCache();

    private ResponseCache() {
        this(PeerAwareInstanceRegistryImpl.getInstance());
    }

    ResponseCache(AbstractInstanceRegistry registry) {
        long responseCacheUpdateIntervalMs = this.eurekaConfig.getResponseCacheUpdateIntervalMs();
        this.shouldUseReadOnlyResponseCache = this.eurekaConfig.shouldUseReadOnlyResponseCache();
        if (this.shouldUseReadOnlyResponseCache) {
            timer.schedule(this.getCacheUpdateTask(), new Date(System.currentTimeMillis() / responseCacheUpdateIntervalMs * responseCacheUpdateIntervalMs + responseCacheUpdateIntervalMs), responseCacheUpdateIntervalMs);
        }
        this.registry = registry;
        this.serverCodecs = new ServerCodecs(this.eurekaConfig);
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry :", e);
        }
    }

    private TimerTask getCacheUpdateTask() {
        return new TimerTask(){

            @Override
            public void run() {
                logger.debug("Updating the client cache from response cache");
                for (Key key : ResponseCache.this.readOnlyCacheMap.keySet()) {
                    if (logger.isDebugEnabled()) {
                        Object[] args = new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType()};
                        logger.debug("Updating the client cache from response cache for key : {} {} {} {}", args);
                    }
                    try {
                        Value currentCacheValue;
                        CurrentRequestVersion.set(key.getVersion());
                        Value cacheValue = (Value)ResponseCache.this.readWriteCacheMap.get((Object)key);
                        if (cacheValue == (currentCacheValue = (Value)ResponseCache.this.readOnlyCacheMap.get(key))) continue;
                        ResponseCache.this.readOnlyCacheMap.put(key, cacheValue);
                    }
                    catch (Throwable th) {
                        logger.error("Error while updating the client cache from response cache", th);
                    }
                }
            }
        };
    }

    public static ResponseCache getInstance() {
        return s_instance;
    }

    public String get(Key key) {
        return this.get(key, this.shouldUseReadOnlyResponseCache);
    }

    @VisibleForTesting
    String get(Key key, boolean useReadOnlyCache) {
        Value payload = this.getValue(key, useReadOnlyCache);
        if (payload == null || payload.getPayload() == EMPTY_PAYLOAD) {
            return null;
        }
        return payload.getPayload();
    }

    public byte[] getGZIP(Key key) {
        Value payload = this.getValue(key, this.shouldUseReadOnlyResponseCache);
        if (payload == null) {
            return null;
        }
        return payload.getGzipped();
    }

    public void invalidate(String appName, @Nullable String vipAddress, @Nullable String secureVipAddress) {
        for (KeyType type : KeyType.values()) {
            for (Version v : Version.values()) {
                this.invalidate(new Key(Key.EntityType.Application, appName, type, v, EurekaAccept.full), new Key(Key.EntityType.Application, appName, type, v, EurekaAccept.compact), new Key(Key.EntityType.Application, ALL_APPS, type, v, EurekaAccept.full), new Key(Key.EntityType.Application, ALL_APPS, type, v, EurekaAccept.compact), new Key(Key.EntityType.Application, ALL_APPS_DELTA, type, v, EurekaAccept.full), new Key(Key.EntityType.Application, ALL_APPS_DELTA, type, v, EurekaAccept.compact));
                if (null != vipAddress) {
                    this.invalidate(new Key(Key.EntityType.VIP, vipAddress, type, v, EurekaAccept.full));
                }
                if (null == secureVipAddress) continue;
                this.invalidate(new Key(Key.EntityType.SVIP, secureVipAddress, type, v, EurekaAccept.full));
            }
        }
    }

    public void invalidate(Key ... keys) {
        for (Key key : keys) {
            logger.debug("Invalidating the response cache key : {} {} {} {}, {}", new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType(), key.getEurekaAccept()});
            this.readWriteCacheMap.invalidate((Object)key);
            Collection keysWithRegions = this.regionSpecificKeys.get((Object)key);
            if (null == keysWithRegions || keysWithRegions.isEmpty()) continue;
            for (Key keysWithRegion : keysWithRegions) {
                logger.debug("Invalidating the response cache key : {} {} {} {}, {}", new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType(), key.getEurekaAccept()});
                this.readWriteCacheMap.invalidate((Object)keysWithRegion);
            }
        }
    }

    public static AtomicLong getVersionDelta() {
        return versionDelta;
    }

    public static AtomicLong getVersionDeltaWithRegions() {
        return versionDeltaWithRegions;
    }

    @Monitor(name="responseCacheSize", type=DataSourceType.GAUGE)
    public int getCurrentSize() {
        return this.readWriteCacheMap.asMap().size();
    }

    @VisibleForTesting
    Value getValue(Key key, boolean useReadOnlyCache) {
        Value payload = null;
        try {
            if (useReadOnlyCache) {
                Value currentPayload = (Value)this.readOnlyCacheMap.get(key);
                if (currentPayload != null) {
                    payload = currentPayload;
                } else {
                    payload = (Value)this.readWriteCacheMap.get((Object)key);
                    this.readOnlyCacheMap.put(key, payload);
                }
            } else {
                payload = (Value)this.readWriteCacheMap.get((Object)key);
            }
        }
        catch (Throwable t) {
            logger.error("Cannot get value for key :" + key, t);
        }
        return payload;
    }

    private String getPayLoad(Key key, Applications apps) {
        String result;
        EncoderWrapper encoderWrapper = this.serverCodecs.getEncoder(key.getType(), key.getEurekaAccept());
        try {
            result = encoderWrapper.encode((Object)apps);
        }
        catch (Exception e) {
            logger.error("Failed to encode the payload for all apps", (Throwable)e);
            return EMPTY_PAYLOAD;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("New application cache entry {} with apps hashcode {}", (Object)key.toStringCompact(), (Object)apps.getAppsHashCode());
        }
        return result;
    }

    private String getPayLoad(Key key, Application app) {
        if (app == null) {
            return EMPTY_PAYLOAD;
        }
        EncoderWrapper encoderWrapper = this.serverCodecs.getEncoder(key.getType(), key.getEurekaAccept());
        try {
            return encoderWrapper.encode((Object)app);
        }
        catch (Exception e) {
            logger.error("Failed to encode the payload for application {}", (Object)app.getName(), (Object)e);
            return EMPTY_PAYLOAD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value generatePayload(Key key) {
        Stopwatch tracer = null;
        try {
            String payload;
            switch (key.getEntityType()) {
                case Application: {
                    boolean isRemoteRegionRequested = key.hasRegions();
                    if (ALL_APPS.equals(key.getName())) {
                        if (isRemoteRegionRequested) {
                            tracer = this.serializeAllAppsWithRemoteRegionTimer.start();
                            payload = this.getPayLoad(key, this.registry.getApplicationsFromMultipleRegions(key.getRegions()));
                            break;
                        }
                        tracer = this.serializeAllAppsTimer.start();
                        payload = this.getPayLoad(key, this.registry.getApplications());
                        break;
                    }
                    if (ALL_APPS_DELTA.equals(key.getName())) {
                        if (isRemoteRegionRequested) {
                            tracer = this.serializeDeltaAppsWithRemoteRegionTimer.start();
                            versionDeltaWithRegions.incrementAndGet();
                            payload = this.getPayLoad(key, this.registry.getApplicationDeltasFromMultipleRegions(key.getRegions()));
                            break;
                        }
                        tracer = this.serializeDeltaAppsTimer.start();
                        versionDelta.incrementAndGet();
                        payload = this.getPayLoad(key, this.registry.getApplicationDeltas());
                        break;
                    }
                    tracer = this.serializeOneApptimer.start();
                    payload = this.getPayLoad(key, this.registry.getApplication(key.getName()));
                    break;
                }
                case VIP: 
                case SVIP: {
                    tracer = this.serializeViptimer.start();
                    payload = this.getPayLoad(key, ResponseCache.getApplicationsForVip(key, this.registry));
                    break;
                }
                default: {
                    logger.error("Unidentified entity type: " + (Object)((Object)key.getEntityType()) + " found in the cache key.");
                    payload = EMPTY_PAYLOAD;
                }
            }
            Value value = new Value(payload);
            return value;
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
    }

    private static Applications getApplicationsForVip(Key key, AbstractInstanceRegistry registry) {
        Object[] args = new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType()};
        logger.debug("Retrieving applications from registry for key : {} {} {} {}", args);
        Applications toReturn = new Applications();
        Applications applications = registry.getApplications();
        for (Application application : applications.getRegisteredApplications()) {
            Application appToAdd = null;
            for (InstanceInfo instanceInfo : application.getInstances()) {
                String vipAddress;
                if (Key.EntityType.VIP.equals((Object)key.getEntityType())) {
                    vipAddress = instanceInfo.getVIPAddress();
                } else {
                    if (!Key.EntityType.SVIP.equals((Object)key.getEntityType())) continue;
                    vipAddress = instanceInfo.getSecureVipAddress();
                }
                if (null == vipAddress) continue;
                Object[] vipAddresses = vipAddress.split(",");
                Arrays.sort(vipAddresses);
                if (Arrays.binarySearch(vipAddresses, key.getName()) < 0) continue;
                if (null == appToAdd) {
                    appToAdd = new Application(application.getName());
                    toReturn.addApplication(appToAdd);
                }
                appToAdd.addInstance(instanceInfo);
            }
        }
        toReturn.setAppsHashCode(toReturn.getReconcileHashCode());
        args = new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType(), toReturn.getReconcileHashCode()};
        logger.debug("Retrieved applications from registry for key : {} {} {} {}, reconcile hashcode: {}", args);
        return toReturn;
    }

    public class Value {
        private final String payload;
        private byte[] gzipped;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value(String payload) {
            this.payload = payload;
            if (payload != ResponseCache.EMPTY_PAYLOAD) {
                Stopwatch tracer = ResponseCache.this.compressPayloadTimer.start();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    GZIPOutputStream out = new GZIPOutputStream(bos);
                    byte[] rawBytes = payload.getBytes();
                    out.write(rawBytes);
                    out.finish();
                    out.close();
                    bos.close();
                    this.gzipped = bos.toByteArray();
                }
                catch (IOException e) {
                    this.gzipped = null;
                }
                finally {
                    if (tracer != null) {
                        tracer.stop();
                    }
                }
            } else {
                this.gzipped = null;
            }
        }

        public String getPayload() {
            return this.payload;
        }

        public byte[] getGzipped() {
            return this.gzipped;
        }
    }

    public static class Key {
        private final String entityName;
        private final String[] regions;
        private final KeyType requestType;
        private final Version requestVersion;
        private final String hashKey;
        private final EntityType entityType;
        private final EurekaAccept eurekaAccept;

        public Key(EntityType entityType, String entityName, KeyType type, Version v, EurekaAccept eurekaAccept) {
            this(entityType, entityName, type, v, eurekaAccept, null);
        }

        public Key(EntityType entityType, String entityName, KeyType type, Version v, EurekaAccept eurekaAccept, @Nullable String[] regions) {
            this.regions = regions;
            this.entityType = entityType;
            this.entityName = entityName;
            this.requestType = type;
            this.requestVersion = v;
            this.eurekaAccept = eurekaAccept;
            this.hashKey = (Object)((Object)this.entityType) + this.entityName + (null != this.regions ? Arrays.toString(this.regions) : ResponseCache.EMPTY_PAYLOAD) + this.requestType.name() + this.requestVersion.name() + this.eurekaAccept.name();
        }

        public String getName() {
            return this.entityName;
        }

        public String getHashKey() {
            return this.hashKey;
        }

        public KeyType getType() {
            return this.requestType;
        }

        public Version getVersion() {
            return this.requestVersion;
        }

        public EurekaAccept getEurekaAccept() {
            return this.eurekaAccept;
        }

        public EntityType getEntityType() {
            return this.entityType;
        }

        public boolean hasRegions() {
            return null != this.regions && this.regions.length != 0;
        }

        public String[] getRegions() {
            return this.regions;
        }

        public Key cloneWithoutRegions() {
            return new Key(this.entityType, this.entityName, this.requestType, this.requestVersion, this.eurekaAccept);
        }

        public int hashCode() {
            String hashKey = this.getHashKey();
            return hashKey.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Key) {
                return this.getHashKey().equals(((Key)other).getHashKey());
            }
            return false;
        }

        public String toStringCompact() {
            StringBuilder sb = new StringBuilder();
            sb.append("{name=").append(this.entityName).append(", type=").append((Object)this.entityType).append(", format=").append((Object)this.requestType);
            if (this.regions != null) {
                sb.append(", regions=").append(Arrays.toString(this.regions));
            }
            sb.append('}');
            return sb.toString();
        }

        public static enum EntityType {
            Application,
            VIP,
            SVIP;

        }
    }

    public static enum KeyType {
        JSON,
        XML;

    }
}

