/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.discovery.shared.EurekaHttpClient;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ReplicationTask {
    private static final Logger logger = LoggerFactory.getLogger(ReplicationTask.class);
    protected final long submitTime = System.currentTimeMillis();
    protected final String peerNodeName;
    protected final PeerAwareInstanceRegistryImpl.Action action;
    private final AtomicReference<ProcessingState> processingState = new AtomicReference<ProcessingState>(ProcessingState.Pending);

    ReplicationTask(String peerNodeName, PeerAwareInstanceRegistryImpl.Action action) {
        this.peerNodeName = peerNodeName;
        this.action = action;
    }

    public abstract String getTaskName();

    public PeerAwareInstanceRegistryImpl.Action getAction() {
        return this.action;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public abstract boolean isBatchingSupported();

    public abstract EurekaHttpClient.HttpResponse<?> execute() throws Throwable;

    public void handleSuccess() {
        this.processingState.compareAndSet(ProcessingState.Pending, ProcessingState.Finished);
    }

    public void handleFailure(int statusCode, Object responseEntity) throws Throwable {
        this.processingState.compareAndSet(ProcessingState.Pending, ProcessingState.Failed);
        logger.warn("The replication of task {} failed with response code {}", (Object)this.getTaskName(), (Object)statusCode);
    }

    public void cancel() {
        this.processingState.compareAndSet(ProcessingState.Pending, ProcessingState.Cancelled);
    }

    public ProcessingState getProcessingState() {
        return this.processingState.get();
    }

    public static enum ProcessingState {
        Pending,
        Finished,
        Failed,
        Cancelled;

    }
}

