/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaIdentityHeaderFilter;
import com.netflix.discovery.shared.EurekaHttpClient;
import com.netflix.discovery.shared.EurekaJerseyClient;
import com.netflix.discovery.shared.JerseyEurekaHttpClient;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerIdentity;
import com.netflix.eureka.cluster.DynamicGZIPContentEncodingFilter;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.protocol.ReplicationList;
import com.netflix.eureka.cluster.protocol.ReplicationListResponse;
import com.netflix.eureka.resources.ASGResource;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyReplicationClient
extends JerseyEurekaHttpClient
implements HttpReplicationClient {
    private static final Logger logger = LoggerFactory.getLogger(JerseyReplicationClient.class);
    private final EurekaJerseyClient jerseyClient;
    private final ApacheHttpClient4 jerseyApacheClient;

    public JerseyReplicationClient(EurekaServerConfig config, String serviceUrl) {
        super(serviceUrl);
        String name = this.getClass().getSimpleName() + ": " + serviceUrl + "apps/: ";
        try {
            String hostname;
            try {
                hostname = new URL(serviceUrl).getHost();
            }
            catch (MalformedURLException e) {
                hostname = serviceUrl;
            }
            String jerseyClientName = "Discovery-PeerNodeClient-" + hostname;
            EurekaJerseyClient.EurekaJerseyClientBuilder clientBuilder = new EurekaJerseyClient.EurekaJerseyClientBuilder().withClientName(jerseyClientName).withUserAgent("Java EurekaClient (replication)").withConnectionTimeout(config.getPeerNodeConnectTimeoutMs()).withReadTimeout(config.getPeerNodeReadTimeoutMs()).withMaxConnectionsPerHost(config.getPeerNodeTotalConnectionsPerHost()).withMaxTotalConnections(config.getPeerNodeTotalConnections()).withConnectionIdleTimeout(config.getPeerNodeConnectionIdleTimeoutSeconds());
            if (serviceUrl.startsWith("https://") && "true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
                clientBuilder.withSystemSSLConfiguration();
            }
            this.jerseyClient = clientBuilder.build();
            this.jerseyApacheClient = this.jerseyClient.getClient();
            this.jerseyApacheClient.addFilter((ClientFilter)new DynamicGZIPContentEncodingFilter(config));
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot Create new Replica Node :" + name, e);
        }
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warn("Cannot find localhost ip", (Throwable)e);
        }
        EurekaServerIdentity identity = new EurekaServerIdentity(ip);
        this.jerseyApacheClient.addFilter((ClientFilter)new EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
    }

    protected ApacheHttpClient4 getJerseyApacheClient() {
        return this.jerseyApacheClient;
    }

    protected void addExtraHeaders(WebResource.Builder webResource) {
        webResource.header("x-netflix-discovery-replication", (Object)"true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EurekaHttpClient.HttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        EurekaHttpClient.HttpResponse httpResponse;
        String urlPath = "apps/" + appName + '/' + id;
        ClientResponse response = null;
        try {
            WebResource webResource = this.getJerseyApacheClient().resource(this.serviceUrl).path(urlPath).queryParam("status", info.getStatus().toString()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString());
            if (overriddenStatus != null) {
                webResource = webResource.queryParam("overriddenstatus", overriddenStatus.name());
            }
            WebResource.Builder requestBuilder = webResource.getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)((WebResource.Builder)requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).put(ClientResponse.class);
            InstanceInfo infoFromPeer = null;
            if (response.getStatus() == Response.Status.CONFLICT.getStatusCode() && response.hasEntity()) {
                infoFromPeer = (InstanceInfo)response.getEntity(InstanceInfo.class);
            }
            httpResponse = EurekaHttpClient.HttpResponse.responseWith((int)response.getStatus(), infoFromPeer);
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[heartbeat] Jersey HTTP PUT {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[heartbeat] Jersey HTTP PUT {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
        }
        if (response != null) {
            response.close();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<Void> statusUpdate(String asgName, ASGResource.ASGStatus newStatus) {
        try (ClientResponse response = null;){
            String urlPath = "asg/" + asgName + "/status";
            response = (ClientResponse)this.jerseyApacheClient.resource(this.serviceUrl).path(urlPath).queryParam("value", newStatus.name()).header("x-netflix-discovery-replication", (Object)"true").put(ClientResponse.class);
            EurekaHttpClient.HttpResponse httpResponse = EurekaHttpClient.HttpResponse.responseWith((int)response.getStatus());
            return httpResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<ReplicationListResponse> submitBatchUpdates(ReplicationList replicationList) {
        try (ClientResponse response = null;){
            response = (ClientResponse)((WebResource.Builder)this.jerseyApacheClient.resource(this.serviceUrl).path("peerreplication/batch/").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)replicationList);
            if (!JerseyReplicationClient.isSuccess(response.getStatus())) {
                EurekaHttpClient.HttpResponse httpResponse = EurekaHttpClient.HttpResponse.responseWith((int)response.getStatus());
                return httpResponse;
            }
            ReplicationListResponse batchResponse = (ReplicationListResponse)response.getEntity(ReplicationListResponse.class);
            EurekaHttpClient.HttpResponse httpResponse = EurekaHttpClient.HttpResponse.responseWith((int)response.getStatus(), (Object)batchResponse);
            return httpResponse;
        }
    }

    public void shutdown() {
        super.shutdown();
        this.jerseyClient.destroyResources();
    }

    private static boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

