/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.Version;
import com.netflix.eureka.resources.InstanceResource;
import com.netflix.eureka.resources.ResponseCache;
import com.netflix.eureka.util.EurekaMonitors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/xml", "application/json"})
public class ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationResource.class);
    private final PeerAwareInstanceRegistryImpl registry = PeerAwareInstanceRegistryImpl.getInstance();
    String appName;

    public ApplicationResource(String appName) {
        this.appName = appName.toUpperCase();
    }

    @GET
    public Response getApplication(@PathParam(value="version") String version, @HeaderParam(value="Accept") String acceptHeader) {
        if (!PeerAwareInstanceRegistryImpl.getInstance().shouldAllowAccess(false)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        EurekaMonitors.GET_APPLICATION.increment();
        CurrentRequestVersion.set(Version.toEnum(version));
        ResponseCache.KeyType keyType = ResponseCache.KeyType.JSON;
        if (acceptHeader == null || !acceptHeader.contains("json")) {
            keyType = ResponseCache.KeyType.XML;
        }
        ResponseCache.Key cacheKey = new ResponseCache.Key(ResponseCache.Key.EntityType.Application, this.appName, keyType, CurrentRequestVersion.get());
        String payLoad = ResponseCache.getInstance().get(cacheKey);
        if (payLoad != null) {
            logger.debug("Found: {}", (Object)this.appName);
            return Response.ok((Object)payLoad).build();
        }
        logger.debug("Not Found: {}", (Object)this.appName);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="{id}")
    public InstanceResource getInstanceInfo(@PathParam(value="id") String id) {
        return new InstanceResource(this, id);
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public void addInstance(InstanceInfo info, @HeaderParam(value="x-netflix-discovery-replication") String isReplication) {
        logger.debug("Registering instance {} (replication={})", (Object)info.getId(), (Object)isReplication);
        this.registry.register(info, "true".equals(isReplication));
    }

    String getName() {
        return this.appName;
    }
}

