/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.util.AwsAsgUtil;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{version}/asg")
@Produces(value={"application/xml", "application/json"})
public class ASGResource {
    private static final Logger logger = LoggerFactory.getLogger(ASGResource.class);

    @PUT
    @Path(value="{asgName}/status")
    public Response statusUpdate(@PathParam(value="asgName") String asgName, @QueryParam(value="value") String newStatus, @HeaderParam(value="x-netflix-discovery-replication") String isReplication) {
        try {
            logger.info("Trying to update ASG Status for ASG {} to {}", (Object)asgName, (Object)newStatus);
            ASGStatus asgStatus = ASGStatus.valueOf(newStatus.toUpperCase());
            AwsAsgUtil.getInstance().setStatus(asgName, !ASGStatus.DISABLED.equals((Object)asgStatus));
            PeerAwareInstanceRegistryImpl.getInstance().statusUpdate(asgName, asgStatus, Boolean.valueOf(isReplication));
            logger.debug("Updated ASG Status for ASG {} to {}", (Object)asgName, (Object)asgStatus);
        }
        catch (Throwable e) {
            logger.error("Cannot update the status" + newStatus + " for the ASG " + asgName, e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    public static enum ASGStatus {
        ENABLED,
        DISABLED;


        public static ASGStatus toEnum(String s) {
            for (ASGStatus e : ASGStatus.values()) {
                if (!e.name().equalsIgnoreCase(s)) continue;
                return e;
            }
            throw new RuntimeException("Cannot find ASG enum for the given string " + s);
        }
    }
}

