/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.EurekaHttpClient;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.cluster.AsgReplicationTask;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.InstanceReplicationTask;
import com.netflix.eureka.cluster.ReplicationTaskProcessor;
import com.netflix.eureka.resources.ASGResource;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerEurekaNode {
    private static final int RETRY_SLEEP_TIME_MS = 100;
    private static final long SERVER_UNAVAILABLE_SLEEP_TIME_MS = 1000L;
    private static final long MAX_PROCESSING_DELAY_MS = 500L;
    private static final Logger logger = LoggerFactory.getLogger(PeerEurekaNode.class);
    public static final String BATCH_URL_PATH = "peerreplication/batch/";
    public static final String HEADER_REPLICATION = "x-netflix-discovery-replication";
    private final String serviceUrl;
    private final EurekaServerConfig config;
    private final PeerAwareInstanceRegistry registry;
    private final String name;
    private final HttpReplicationClient replicationClient;
    private final ReplicationTaskProcessor heartBeatProcessor;
    private final ReplicationTaskProcessor statusProcessor;
    private final ReplicationTaskProcessor registerProcessor;
    private final ReplicationTaskProcessor cancelProcessor;
    private final ReplicationTaskProcessor asgStatusProcessor;

    public PeerEurekaNode(PeerAwareInstanceRegistry registry, String name, String serviceUrl, HttpReplicationClient replicationClient, EurekaServerConfig config) {
        this(registry, name, serviceUrl, replicationClient, config, 500L, 100L, 1000L);
    }

    PeerEurekaNode(PeerAwareInstanceRegistry registry, String name, String serviceUrl, HttpReplicationClient replicationClient, EurekaServerConfig config, long maxProcessingDelayMs, long retrySleepTimeMs, long serverUnavailableSleepTimeMs) {
        this.registry = registry;
        this.name = name;
        this.replicationClient = replicationClient;
        this.serviceUrl = serviceUrl;
        this.config = config;
        String batcherName = this.getBatcherName();
        this.heartBeatProcessor = new ReplicationTaskProcessor(name, batcherName, PeerAwareInstanceRegistryImpl.Action.Heartbeat.name(), replicationClient, config, maxProcessingDelayMs, retrySleepTimeMs, serverUnavailableSleepTimeMs);
        this.statusProcessor = new ReplicationTaskProcessor(name, batcherName, PeerAwareInstanceRegistryImpl.Action.StatusUpdate.name(), replicationClient, config, maxProcessingDelayMs, retrySleepTimeMs, serverUnavailableSleepTimeMs);
        this.asgStatusProcessor = new ReplicationTaskProcessor(name, batcherName, "ASG_" + PeerAwareInstanceRegistryImpl.Action.StatusUpdate.name(), replicationClient, config, maxProcessingDelayMs, retrySleepTimeMs, serverUnavailableSleepTimeMs);
        this.registerProcessor = new ReplicationTaskProcessor(name, batcherName, PeerAwareInstanceRegistryImpl.Action.Register.name(), replicationClient, config, maxProcessingDelayMs, retrySleepTimeMs, serverUnavailableSleepTimeMs);
        this.cancelProcessor = new ReplicationTaskProcessor(name, batcherName, PeerAwareInstanceRegistryImpl.Action.Cancel.name(), replicationClient, config, maxProcessingDelayMs, retrySleepTimeMs, serverUnavailableSleepTimeMs);
    }

    public void register(final InstanceInfo info) throws Exception {
        this.registerProcessor.process(new InstanceReplicationTask(this.name, PeerAwareInstanceRegistryImpl.Action.Register, info, null, true){

            public EurekaHttpClient.HttpResponse<Void> execute() {
                return PeerEurekaNode.this.replicationClient.register(info);
            }
        });
    }

    public void cancel(final String appName, final String id) throws Exception {
        this.cancelProcessor.process(new InstanceReplicationTask(this.name, PeerAwareInstanceRegistryImpl.Action.Cancel, appName, id){

            public EurekaHttpClient.HttpResponse<Void> execute() {
                return PeerEurekaNode.this.replicationClient.cancel(appName, id);
            }

            @Override
            public void handleFailure(int statusCode, Object responseEntity) throws Throwable {
                super.handleFailure(statusCode, responseEntity);
                if (statusCode == 404) {
                    logger.warn("{}: missing entry.", (Object)this.getTaskName());
                }
            }
        });
    }

    public void heartbeat(final String appName, final String id, final InstanceInfo info, final InstanceInfo.InstanceStatus overriddenStatus, boolean primeConnection) throws Throwable {
        if (primeConnection) {
            this.replicationClient.sendHeartBeat(appName, id, info, overriddenStatus);
            return;
        }
        InstanceReplicationTask replicationTask = new InstanceReplicationTask(this.name, PeerAwareInstanceRegistryImpl.Action.Heartbeat, info, overriddenStatus, false){

            public EurekaHttpClient.HttpResponse<InstanceInfo> execute() throws Throwable {
                return PeerEurekaNode.this.replicationClient.sendHeartBeat(appName, id, info, overriddenStatus);
            }

            @Override
            public void handleFailure(int statusCode, Object responseEntity) throws Throwable {
                InstanceInfo peerInstanceInfo;
                super.handleFailure(statusCode, responseEntity);
                if (statusCode == 404) {
                    logger.warn("{}: missing entry.", (Object)this.getTaskName());
                    if (info != null) {
                        logger.warn("{}: cannot find instance id {} and hence replicating the instance with status {}", new Object[]{this.getTaskName(), info.getId(), info.getStatus()});
                        PeerEurekaNode.this.register(info);
                    }
                } else if (PeerEurekaNode.this.config.shouldSyncWhenTimestampDiffers() && (peerInstanceInfo = (InstanceInfo)responseEntity) != null) {
                    PeerEurekaNode.this.syncInstancesIfTimestampDiffers(appName, id, info, peerInstanceInfo);
                }
            }
        };
        this.heartBeatProcessor.process(replicationTask);
    }

    public void statusUpdate(final String asgName, final ASGResource.ASGStatus newStatus) {
        this.asgStatusProcessor.process(new AsgReplicationTask(this.name, PeerAwareInstanceRegistryImpl.Action.StatusUpdate, asgName, newStatus){

            @Override
            public EurekaHttpClient.HttpResponse<?> execute() {
                return PeerEurekaNode.this.replicationClient.statusUpdate(asgName, newStatus);
            }
        });
    }

    public void statusUpdate(final String appName, final String id, final InstanceInfo.InstanceStatus newStatus, final InstanceInfo info) {
        this.statusProcessor.process(new InstanceReplicationTask(this.name, PeerAwareInstanceRegistryImpl.Action.StatusUpdate, info, null, false){

            public EurekaHttpClient.HttpResponse<Void> execute() {
                return PeerEurekaNode.this.replicationClient.statusUpdate(appName, id, newStatus, info);
            }
        });
    }

    public void deleteStatusOverride(final String appName, final String id, final InstanceInfo info) {
        this.statusProcessor.process(new InstanceReplicationTask(this.name, PeerAwareInstanceRegistryImpl.Action.DeleteStatusOverride, info, null, false){

            public EurekaHttpClient.HttpResponse<Void> execute() {
                return PeerEurekaNode.this.replicationClient.deleteStatusOverride(appName, id, info);
            }
        });
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceUrl == null ? 0 : this.serviceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerEurekaNode other = (PeerEurekaNode)obj;
        return !(this.serviceUrl == null ? other.serviceUrl != null : !this.serviceUrl.equals(other.serviceUrl));
    }

    public void shutDown() {
        this.heartBeatProcessor.shutdown();
        this.registerProcessor.shutdown();
        this.cancelProcessor.shutdown();
        this.statusProcessor.shutdown();
        this.asgStatusProcessor.shutdown();
    }

    private void syncInstancesIfTimestampDiffers(String appName, String id, InstanceInfo info, InstanceInfo infoFromPeer) {
        try {
            if (infoFromPeer != null) {
                logger.warn("Peer wants us to take the instance information from it, since the timestamp differs,Id : {} My Timestamp : {}, Peer's timestamp: {}", new Object[]{id, info.getLastDirtyTimestamp(), infoFromPeer.getLastDirtyTimestamp()});
                if (infoFromPeer.getOverriddenStatus() != null && !InstanceInfo.InstanceStatus.UNKNOWN.equals((Object)infoFromPeer.getOverriddenStatus())) {
                    logger.warn("Overridden Status info -id {}, mine {}, peer's {}", new Object[]{id, info.getOverriddenStatus(), infoFromPeer.getOverriddenStatus()});
                    this.registry.storeOverriddenStatusIfRequired(appName, id, infoFromPeer.getOverriddenStatus());
                }
                this.registry.register(infoFromPeer, true);
            }
        }
        catch (Throwable e) {
            logger.warn("Exception when trying to set information from peer :", e);
        }
    }

    public String getBatcherName() {
        String batcherName;
        try {
            batcherName = new URL(this.serviceUrl).getHost();
        }
        catch (MalformedURLException e1) {
            batcherName = this.serviceUrl;
        }
        return batcherName;
    }
}

