/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SpectatorUtil {
    private SpectatorUtil() {
    }

    public static long time() {
        return Spectator.globalRegistry().clock().monotonicTime();
    }

    public static long time(@Nonnull Timer timer) {
        return timer.clock().monotonicTime();
    }

    public static void record(@Nonnull Timer timer, long startTime) {
        timer.record(SpectatorUtil.time(timer) - startTime, TimeUnit.NANOSECONDS);
    }

    public static <T> T monitoredValue(@Nonnull String name, @Nonnull T obj, @Nonnull ToDoubleFunction<T> f) {
        return SpectatorUtil.monitoredValue(name, null, obj, f);
    }

    public static <T> T monitoredValue(@Nonnull String name, @Nullable String id, @Nonnull T obj, @Nonnull ToDoubleFunction<T> f) {
        return (T)((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)Spectator.globalRegistry()).withName(name)).withTags(SpectatorUtil.tags(id, obj.getClass()))).monitorValue(obj, f);
    }

    public static <T extends Number> T monitoredNumber(@Nonnull String name, @Nonnull Class<?> clazz, T number) {
        return SpectatorUtil.monitoredNumber(name, null, clazz, number);
    }

    public static <T extends Number> T monitoredNumber(@Nonnull String name, @Nullable String id, @Nonnull Class<?> clazz, T number) {
        PolledMeter.Builder builder = (PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)Spectator.globalRegistry()).withName(name)).withTag(SpectatorUtil.classTag(clazz));
        if (id != null) {
            builder.withTag("id", id);
        }
        return (T)builder.monitorValue(number);
    }

    public static Counter counter(@Nonnull String name, @Nonnull Class<?> clazz) {
        return Spectator.globalRegistry().counter(name, SpectatorUtil.tags(null, clazz));
    }

    public static Counter counter(@Nonnull String name, @Nullable String id, @Nonnull Class<?> clazz) {
        return Spectator.globalRegistry().counter(name, SpectatorUtil.tags(id, clazz));
    }

    public static Counter counter(@Nonnull String name, @Nullable String id, @Nonnull Class<?> clazz, Collection<Tag> extraTags) {
        return Spectator.globalRegistry().counter(name, SpectatorUtil.tags(id, clazz, extraTags));
    }

    public static Timer timer(@Nonnull String name, @Nonnull Class<?> clazz) {
        return Spectator.globalRegistry().timer(name, SpectatorUtil.tags(null, clazz));
    }

    public static Timer timer(@Nonnull String name, @Nullable String id, @Nonnull Class<?> clazz) {
        return Spectator.globalRegistry().timer(name, SpectatorUtil.tags(id, clazz));
    }

    public static List<Tag> tags(@Nullable String id, @Nullable Class<?> clazz, @Nullable Collection<Tag> extraTags) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (clazz != null) {
            tags.add(SpectatorUtil.classTag(clazz));
        }
        if (id != null) {
            tags.add((Tag)new BasicTag("id", id));
        }
        if (extraTags != null) {
            tags.addAll(extraTags);
        }
        return tags;
    }

    public static List<Tag> tags(@Nonnull Class<?> clazz) {
        return SpectatorUtil.tags(null, clazz, null);
    }

    public static List<Tag> tags(@Nullable String id, @Nonnull Class<?> clazz) {
        return SpectatorUtil.tags(id, clazz, null);
    }

    public static AtomicLong monitoredLong(@Nonnull String name, String id, @Nonnull Class<?> clazz) {
        return SpectatorUtil.monitoredNumber(name, id, clazz, new AtomicLong());
    }

    public static AtomicLong monitoredLong(@Nonnull String name, @Nonnull Class<?> clazz) {
        return SpectatorUtil.monitoredNumber(name, null, clazz, new AtomicLong());
    }

    public static Tag classTag(Class<?> c) {
        return new BasicTag("class", SpectatorUtil.className(c));
    }

    private static String className(Class<?> c) {
        String simpleName = c.getSimpleName();
        return simpleName.isEmpty() ? SpectatorUtil.className(c.getEnclosingClass()) : simpleName;
    }
}

