/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver.aws;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.ResolverUtils;
import com.netflix.discovery.shared.resolver.aws.AwsEndpoint;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationsResolver
implements ClusterResolver<AwsEndpoint> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationsResolver.class);
    private final EurekaClientConfig clientConfig;
    private final EurekaTransportConfig transportConfig;
    private final ApplicationsSource applicationsSource;

    public ApplicationsResolver(EurekaClientConfig clientConfig, EurekaTransportConfig transportConfig, ApplicationsSource applicationsSource) {
        this.clientConfig = clientConfig;
        this.transportConfig = transportConfig;
        this.applicationsSource = applicationsSource;
    }

    @Override
    public String getRegion() {
        return null;
    }

    @Override
    public List<AwsEndpoint> getClusterEndpoints() {
        ArrayList<AwsEndpoint> result = new ArrayList<AwsEndpoint>();
        Applications applications = this.applicationsSource.getApplications(this.transportConfig.getApplicationsResolverDataStalenessThresholdSeconds(), TimeUnit.SECONDS);
        String vipAddress = this.transportConfig.getReadClusterVip();
        if (applications != null && vipAddress != null) {
            List<InstanceInfo> validInstanceInfos = applications.getInstancesByVirtualHostName(vipAddress);
            for (InstanceInfo instanceInfo : validInstanceInfos) {
                if (instanceInfo.getStatus() != InstanceInfo.InstanceStatus.UP) continue;
                result.add(ResolverUtils.instanceInfoToEndpoint(this.clientConfig, instanceInfo));
            }
        }
        logger.debug("Retrieved endpoint list {}", result);
        return result;
    }

    public static interface ApplicationsSource {
        public Applications getApplications(int var1, TimeUnit var2);
    }
}

