/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver;

import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultEndpoint
implements EurekaEndpoint {
    protected final String hostName;
    protected final int port;
    protected final boolean isSecure;
    protected final String relativeUri;
    protected final String serviceUrl;

    public DefaultEndpoint(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        try {
            URL url = new URL(serviceUrl);
            this.hostName = url.getHost();
            this.port = url.getPort();
            this.isSecure = "https".equals(url.getProtocol());
            this.relativeUri = url.getPath();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed serviceUrl: " + serviceUrl);
        }
    }

    public DefaultEndpoint(String hostName, int port, boolean isSecure, String relativeUri) {
        this.hostName = hostName;
        this.port = port;
        this.isSecure = isSecure;
        this.relativeUri = relativeUri;
        StringBuilder sb = new StringBuilder().append(isSecure ? "https" : "http").append("://").append(hostName).append(':').append(port);
        if (relativeUri != null) {
            if (!relativeUri.startsWith("/")) {
                sb.append('/');
            }
            sb.append(relativeUri);
        }
        this.serviceUrl = sb.toString();
    }

    @Override
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public String getRelativeUri() {
        return this.relativeUri;
    }

    public static List<EurekaEndpoint> createForServerList(List<String> hostNames, int port, boolean isSecure, String relativeUri) {
        if (hostNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EurekaEndpoint> eurekaEndpoints = new ArrayList<EurekaEndpoint>(hostNames.size());
        for (String hostName : hostNames) {
            eurekaEndpoints.add(new DefaultEndpoint(hostName, port, isSecure, relativeUri));
        }
        return eurekaEndpoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultEndpoint)) {
            return false;
        }
        DefaultEndpoint that = (DefaultEndpoint)o;
        if (this.isSecure != that.isSecure) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) {
            return false;
        }
        if (this.relativeUri != null ? !this.relativeUri.equals(that.relativeUri) : that.relativeUri != null) {
            return false;
        }
        return !(this.serviceUrl != null ? !this.serviceUrl.equals(that.serviceUrl) : that.serviceUrl != null);
    }

    public int hashCode() {
        int result = this.hostName != null ? this.hostName.hashCode() : 0;
        result = 31 * result + this.port;
        result = 31 * result + (this.isSecure ? 1 : 0);
        result = 31 * result + (this.relativeUri != null ? this.relativeUri.hashCode() : 0);
        result = 31 * result + (this.serviceUrl != null ? this.serviceUrl.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Object that) {
        return this.serviceUrl.compareTo(((DefaultEndpoint)that).getServiceUrl());
    }

    public String toString() {
        return "DefaultEndpoint{ serviceUrl='" + this.serviceUrl + '}';
    }
}

