/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaUpStatusResolver;
import com.netflix.governator.annotations.binding.DownStatus;
import com.netflix.governator.annotations.binding.UpStatus;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class InternalEurekaStatusModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Boolean>>(){}).annotatedWith(UpStatus.class).toProvider(UpStatusProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Boolean>>(){}).annotatedWith(DownStatus.class).toProvider(DownStatusProvider.class);
    }

    @Singleton
    public static class DownStatusProvider
    implements Provider<Supplier<Boolean>> {
        @Inject
        private Provider<EurekaUpStatusResolver> upStatus;

        public Supplier<Boolean> get() {
            final EurekaUpStatusResolver resolver = (EurekaUpStatusResolver)this.upStatus.get();
            return new Supplier<Boolean>(){

                public Boolean get() {
                    return !resolver.getStatus().equals((Object)InstanceInfo.InstanceStatus.UP);
                }
            };
        }
    }

    @Singleton
    public static class UpStatusProvider
    implements Provider<Supplier<Boolean>> {
        @Inject
        private Provider<EurekaUpStatusResolver> upStatus;

        public Supplier<Boolean> get() {
            final EurekaUpStatusResolver resolver = (EurekaUpStatusResolver)this.upStatus.get();
            return new Supplier<Boolean>(){

                public Boolean get() {
                    return resolver.getStatus().equals((Object)InstanceInfo.InstanceStatus.UP);
                }
            };
        }
    }
}

