/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.util.StringUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJerseyEurekaHttpClient
implements EurekaHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJerseyEurekaHttpClient.class);
    protected final Client jerseyClient;
    protected final String serviceUrl;

    protected AbstractJerseyEurekaHttpClient(Client jerseyClient, String serviceUrl) {
        this.jerseyClient = jerseyClient;
        this.serviceUrl = serviceUrl;
        logger.debug("Created client for url: {}", (Object)serviceUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpResponse<Void> register(InstanceInfo info) {
        EurekaHttpResponse<Void> eurekaHttpResponse;
        String urlPath = "apps/" + info.getAppName();
        ClientResponse response = null;
        try {
            WebResource.Builder resourceBuilder = this.jerseyClient.resource(this.serviceUrl).path(urlPath).getRequestBuilder();
            this.addExtraHeaders(resourceBuilder);
            response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resourceBuilder.header("Accept-Encoding", (Object)"gzip")).type(MediaType.APPLICATION_JSON_TYPE)).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)info);
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse(response.getStatus()).headers(AbstractJerseyEurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey HTTP POST {}/{} with instance {}; statusCode={}", new Object[]{this.serviceUrl, urlPath, info.getId(), response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey HTTP POST {}/{} with instance {}; statusCode={}", new Object[]{this.serviceUrl, urlPath, info.getId(), response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpResponse<Void> cancel(String appName, String id) {
        EurekaHttpResponse<Void> eurekaHttpResponse;
        String urlPath = "apps/" + appName + '/' + id;
        ClientResponse response = null;
        try {
            WebResource.Builder resourceBuilder = this.jerseyClient.resource(this.serviceUrl).path(urlPath).getRequestBuilder();
            this.addExtraHeaders(resourceBuilder);
            response = (ClientResponse)resourceBuilder.delete(ClientResponse.class);
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse(response.getStatus()).headers(AbstractJerseyEurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey HTTP DELETE {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey HTTP DELETE {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        EurekaHttpResponse<Class<InstanceInfo>> eurekaHttpResponse;
        String urlPath = "apps/" + appName + '/' + id;
        ClientResponse response = null;
        try {
            WebResource webResource = this.jerseyClient.resource(this.serviceUrl).path(urlPath).queryParam("status", info.getStatus().toString()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString());
            if (overriddenStatus != null) {
                webResource = webResource.queryParam("overriddenstatus", overriddenStatus.name());
            }
            WebResource.Builder requestBuilder = webResource.getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)requestBuilder.put(ClientResponse.class);
            EurekaHttpResponse.EurekaHttpResponseBuilder<Class<InstanceInfo>> eurekaResponseBuilder = EurekaHttpResponse.anEurekaHttpResponse(response.getStatus(), InstanceInfo.class).headers(AbstractJerseyEurekaHttpClient.headersOf(response));
            if (response.hasEntity()) {
                eurekaResponseBuilder.entity((Class<InstanceInfo>)response.getEntity(InstanceInfo.class));
            }
            eurekaHttpResponse = eurekaResponseBuilder.build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey HTTP PUT {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey HTTP PUT {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        EurekaHttpResponse<Void> eurekaHttpResponse;
        String urlPath = "apps/" + appName + '/' + id + "/status";
        ClientResponse response = null;
        try {
            WebResource.Builder requestBuilder = this.jerseyClient.resource(this.serviceUrl).path(urlPath).queryParam("value", newStatus.name()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString()).getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)requestBuilder.put(ClientResponse.class);
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse(response.getStatus()).headers(AbstractJerseyEurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey HTTP PUT {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey HTTP PUT {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        EurekaHttpResponse<Void> eurekaHttpResponse;
        String urlPath = "apps/" + appName + '/' + id + "/status";
        ClientResponse response = null;
        try {
            WebResource.Builder requestBuilder = this.jerseyClient.resource(this.serviceUrl).path(urlPath).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString()).getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)requestBuilder.delete(ClientResponse.class);
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse(response.getStatus()).headers(AbstractJerseyEurekaHttpClient.headersOf(response)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey HTTP DELETE {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey HTTP DELETE {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    @Override
    public EurekaHttpResponse<Applications> getApplications(String ... regions) {
        return this.getApplicationsInternal("apps/", regions);
    }

    @Override
    public EurekaHttpResponse<Applications> getDelta(String ... regions) {
        return this.getApplicationsInternal("apps/delta", regions);
    }

    @Override
    public EurekaHttpResponse<Applications> getVip(String vipAddress, String ... regions) {
        return this.getApplicationsInternal("vips/" + vipAddress, regions);
    }

    @Override
    public EurekaHttpResponse<Applications> getSecureVip(String secureVipAddress, String ... regions) {
        return this.getApplicationsInternal("svips/" + secureVipAddress, regions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EurekaHttpResponse<Applications> getApplicationsInternal(String urlPath, String[] regions) {
        EurekaHttpResponse<Class<Applications>> eurekaHttpResponse;
        ClientResponse response = null;
        try {
            WebResource webResource = this.jerseyClient.resource(this.serviceUrl).path(urlPath);
            if (regions != null && regions.length > 0) {
                webResource = webResource.queryParam("regions", StringUtil.join(regions));
            }
            WebResource.Builder requestBuilder = webResource.getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)((WebResource.Builder)requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).get(ClientResponse.class);
            Applications applications = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                applications = (Applications)response.getEntity(Applications.class);
            }
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse(response.getStatus(), Applications.class).headers(AbstractJerseyEurekaHttpClient.headersOf(response)).entity((Class<Applications>)((Object)applications)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpResponse<Application> getApplication(String appName) {
        EurekaHttpResponse<Class<Application>> eurekaHttpResponse;
        String urlPath = "apps/" + appName;
        ClientResponse response = null;
        try {
            WebResource.Builder requestBuilder = this.jerseyClient.resource(this.serviceUrl).path(urlPath).getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)((WebResource.Builder)requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).get(ClientResponse.class);
            Application application = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                application = (Application)response.getEntity(Application.class);
            }
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse(response.getStatus(), Application.class).headers(AbstractJerseyEurekaHttpClient.headersOf(response)).entity((Class<Application>)((Object)application)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    @Override
    public EurekaHttpResponse<InstanceInfo> getInstance(String id) {
        return this.getInstanceInternal("instances/" + id);
    }

    @Override
    public EurekaHttpResponse<InstanceInfo> getInstance(String appName, String id) {
        return this.getInstanceInternal("apps/" + appName + '/' + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EurekaHttpResponse<InstanceInfo> getInstanceInternal(String urlPath) {
        EurekaHttpResponse<Class<InstanceInfo>> eurekaHttpResponse;
        ClientResponse response = null;
        try {
            WebResource.Builder requestBuilder = this.jerseyClient.resource(this.serviceUrl).path(urlPath).getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)((WebResource.Builder)requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).get(ClientResponse.class);
            InstanceInfo infoFromPeer = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                infoFromPeer = (InstanceInfo)response.getEntity(InstanceInfo.class);
            }
            eurekaHttpResponse = EurekaHttpResponse.anEurekaHttpResponse(response.getStatus(), InstanceInfo.class).headers(AbstractJerseyEurekaHttpClient.headersOf(response)).entity((Class<InstanceInfo>)((Object)infoFromPeer)).build();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Jersey HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Jersey HTTP GET {}/{}; statusCode={}", new Object[]{this.serviceUrl, urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return eurekaHttpResponse;
    }

    @Override
    public void shutdown() {
    }

    protected abstract void addExtraHeaders(WebResource.Builder var1);

    private static Map<String, String> headersOf(ClientResponse response) {
        MultivaluedMap jerseyHeaders = response.getHeaders();
        if (jerseyHeaders == null || jerseyHeaders.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry entry : jerseyHeaders.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            headers.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        return headers;
    }
}

