/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.EurekaClientIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaIdentityHeaderFilter;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaClientFactoryBuilder;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import com.netflix.discovery.shared.transport.jersey.JerseyApplicationClient;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;

public class JerseyEurekaHttpClientFactory
implements TransportClientFactory {
    private final EurekaJerseyClient jerseyClient;
    private final boolean allowRedirects;

    public JerseyEurekaHttpClientFactory(EurekaJerseyClient jerseyClient, boolean allowRedirects) {
        this.jerseyClient = jerseyClient;
        this.allowRedirects = allowRedirects;
    }

    public JerseyEurekaHttpClientFactory(JerseyEurekaHttpClientFactory delegate) {
        this(delegate.jerseyClient, delegate.allowRedirects);
    }

    @Override
    public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
        return new JerseyApplicationClient((Client)this.jerseyClient.getClient(), endpoint.getServiceUrl(), this.allowRedirects);
    }

    @Override
    public void shutdown() {
        if (this.jerseyClient != null) {
            this.jerseyClient.destroyResources();
        }
    }

    public static JerseyEurekaHttpClientFactory create(EurekaClientConfig clientConfig, InstanceInfo myInstanceInfo, AbstractEurekaIdentity clientIdentity) {
        JerseyEurekaHttpClientFactoryBuilder clientBuilder = (JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)((JerseyEurekaHttpClientFactoryBuilder)JerseyEurekaHttpClientFactory.newBuilder().withMyInstanceInfo(myInstanceInfo)).withUserAgent("Java-EurekaClient")).withAllowRedirect(clientConfig.allowRedirects())).withConnectionTimeout(clientConfig.getEurekaServerConnectTimeoutSeconds() * 1000)).withReadTimeout(clientConfig.getEurekaServerReadTimeoutSeconds() * 1000)).withMaxConnectionsPerHost(clientConfig.getEurekaServerTotalConnectionsPerHost())).withMaxTotalConnections(clientConfig.getEurekaServerTotalConnections())).withConnectionIdleTimeout(clientConfig.getEurekaConnectionIdleTimeoutSeconds())).withEncoder(clientConfig.getEncoderName())).withDecoder(clientConfig.getDecoderName(), clientConfig.getClientDataAccept())).withClientIdentity(clientIdentity);
        if ("true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
            ((JerseyEurekaHttpClientFactoryBuilder)clientBuilder.withClientName("DiscoveryClient-HTTPClient-System")).withSystemSSLConfiguration();
        } else if (clientConfig.getProxyHost() != null && clientConfig.getProxyPort() != null) {
            ((JerseyEurekaHttpClientFactoryBuilder)clientBuilder.withClientName("Proxy-DiscoveryClient-HTTPClient")).withProxy(clientConfig.getProxyHost(), Integer.parseInt(clientConfig.getProxyPort()), clientConfig.getProxyUserName(), clientConfig.getProxyPassword());
        } else {
            clientBuilder.withClientName("DiscoveryClient-HTTPClient");
        }
        return clientBuilder.build();
    }

    public static JerseyEurekaHttpClientFactory create(EurekaClientConfig clientConfig, InstanceInfo myInstanceInfo) {
        return JerseyEurekaHttpClientFactory.create(clientConfig, myInstanceInfo, new EurekaClientIdentity(myInstanceInfo.getIPAddr()));
    }

    public static JerseyEurekaHttpClientFactoryBuilder newBuilder() {
        return new JerseyEurekaHttpClientFactoryBuilder();
    }

    public static class JerseyEurekaHttpClientFactoryBuilder
    extends EurekaClientFactoryBuilder<JerseyEurekaHttpClientFactory, JerseyEurekaHttpClientFactoryBuilder> {
        @Override
        public JerseyEurekaHttpClientFactory build() {
            EurekaJerseyClientImpl.EurekaJerseyClientBuilder clientBuilder = new EurekaJerseyClientImpl.EurekaJerseyClientBuilder().withClientName(this.clientName).withUserAgent("Java-EurekaClient").withConnectionTimeout(this.connectionTimeout).withReadTimeout(this.readTimeout).withMaxConnectionsPerHost(this.maxConnectionsPerHost).withMaxTotalConnections(this.maxTotalConnections).withConnectionIdleTimeout(this.connectionIdleTimeout).withEncoderWrapper(this.encoderWrapper).withDecoderWrapper(this.decoderWrapper);
            EurekaJerseyClient jerseyClient = clientBuilder.build();
            ApacheHttpClient4 discoveryApacheClient = jerseyClient.getClient();
            discoveryApacheClient.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
            String ip = this.myInstanceInfo == null ? null : this.myInstanceInfo.getIPAddr();
            AbstractEurekaIdentity identity = this.clientIdentity == null ? new EurekaClientIdentity(ip) : this.clientIdentity;
            discoveryApacheClient.addFilter((ClientFilter)new EurekaIdentityHeaderFilter(identity));
            return new JerseyEurekaHttpClientFactory(jerseyClient, this.allowRedirect);
        }
    }
}

